/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.multiverse.CodeInsightContext;
import com.intellij.codeInsight.multiverse.CodeInsightContexts;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextEditorHighlightingPass
implements HighlightingPass {
    private static final Logger LOG = Logger.getInstance(TextEditorHighlightingPass.class);
    public static final TextEditorHighlightingPass[] EMPTY_ARRAY = new TextEditorHighlightingPass[0];
    @NotNull
    protected final Document myDocument;
    @NotNull
    protected final Project myProject;
    private final boolean myRunIntentionPassAfter;
    private final long myInitialDocStamp;
    private final long myInitialPsiStamp;
    private volatile int[] myCompletionPredecessorIds;
    private volatile int[] myStartingPredecessorIds;
    private volatile int myId;
    private volatile boolean myDumb;
    private EditorColorsScheme myColorsScheme;
    private volatile CodeInsightContext myContext;

    protected TextEditorHighlightingPass(@NotNull Project project, @NotNull Document document, boolean runIntentionPassAfter) {
        if (project == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(1);
        }
        this.myCompletionPredecessorIds = ArrayUtilRt.EMPTY_INT_ARRAY;
        this.myStartingPredecessorIds = ArrayUtilRt.EMPTY_INT_ARRAY;
        this.myDocument = document;
        this.myProject = project;
        this.myRunIntentionPassAfter = runIntentionPassAfter;
        this.myInitialDocStamp = document.getModificationStamp();
        this.myInitialPsiStamp = PsiModificationTracker.getInstance((Project)project).getModificationCount();
        ThreadingAssertions.assertBackgroundThread();
    }

    protected TextEditorHighlightingPass(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(2);
        }
        if (document == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(3);
        }
        this(project, document, true);
    }

    public final void collectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(4);
        }
        if (!this.isValid()) {
            return;
        }
        GlobalInspectionContextBase.assertUnderDaemonProgress();
        this.myDumb = DumbService.getInstance((Project)this.myProject).isDumb();
        this.doCollectInformation(progress);
    }

    @Nullable
    public EditorColorsScheme getColorsScheme() {
        return this.myColorsScheme;
    }

    public void setColorsScheme(@Nullable EditorColorsScheme colorsScheme) {
        this.myColorsScheme = colorsScheme;
    }

    protected boolean isDumbMode() {
        return this.myDumb;
    }

    @NotNull
    public Condition<?> getExpiredCondition() {
        Condition condition = o -> (Boolean)ReadAction.compute(() -> !this.isValid());
        if (condition == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(5);
        }
        return condition;
    }

    protected boolean isValid() {
        PsiElement context;
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (!DumbService.getInstance((Project)this.myProject).isUsableInCurrentContext((Object)this)) {
            return false;
        }
        if (PsiModificationTracker.getInstance((Project)this.myProject).getModificationCount() != this.myInitialPsiStamp) {
            return false;
        }
        if (this.myDocument.getModificationStamp() != this.myInitialDocStamp) {
            return false;
        }
        CodeInsightContext codeInsightContext = this.getContext();
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument, codeInsightContext);
        return file != null && file.isValid() && ((context = file.getContext()) == null || context == file || context.isValid());
    }

    public final void applyInformationToEditor() {
        if (!this.isValid()) {
            return;
        }
        if (DumbService.getInstance((Project)this.myProject).isUsableInCurrentContext((Object)this)) {
            this.doApplyInformationToEditor();
        }
    }

    @ApiStatus.Internal
    public void markUpToDateIfStillValid(@NotNull DaemonProgressIndicator updateProgress) {
        if (updateProgress == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isValid()) {
            FileStatusMap statusMap = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap();
            statusMap.markFileUpToDate(this.getDocument(), this.getContext(), this.getId(), (ProgressIndicator)updateProgress);
        }
    }

    public abstract void doCollectInformation(@NotNull ProgressIndicator var1);

    public abstract void doApplyInformationToEditor();

    public final int getId() {
        return this.myId;
    }

    public final void setId(int id) {
        this.myId = id;
    }

    @NotNull
    public List<HighlightInfo> getInfos() {
        List<HighlightInfo> list = Collections.emptyList();
        if (list == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(7);
        }
        return list;
    }

    public final int @NotNull [] getCompletionPredecessorIds() {
        if (this.myCompletionPredecessorIds == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(8);
        }
        return this.myCompletionPredecessorIds;
    }

    public final void setCompletionPredecessorIds(int @NotNull [] completionPredecessorIds) {
        if (completionPredecessorIds == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(9);
        }
        this.myCompletionPredecessorIds = completionPredecessorIds;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(10);
        }
        return document;
    }

    @ApiStatus.Internal
    public void setContext(@NotNull CodeInsightContext context) {
        if (context == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(11);
        }
        LOG.assertTrue(this.myContext == null || this.myContext == CodeInsightContexts.anyContext(), (Object)("context is already assigned for highlighting pass " + String.valueOf(this)));
        this.myContext = context;
    }

    @ApiStatus.Experimental
    @NotNull
    public CodeInsightContext getContext() {
        if (this.myContext == null) {
            LOG.error("context was not set to highlighting pass " + String.valueOf(this));
            this.myContext = CodeInsightContexts.anyContext();
        }
        CodeInsightContext codeInsightContext = this.myContext;
        if (codeInsightContext == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(12);
        }
        return codeInsightContext;
    }

    public final int @NotNull [] getStartingPredecessorIds() {
        if (this.myStartingPredecessorIds == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(13);
        }
        return this.myStartingPredecessorIds;
    }

    public final void setStartingPredecessorIds(int @NotNull [] startingPredecessorIds) {
        if (startingPredecessorIds == null) {
            TextEditorHighlightingPass.$$$reportNull$$$0(14);
        }
        this.myStartingPredecessorIds = startingPredecessorIds;
    }

    @NonNls
    public String toString() {
        return (this.getClass().isAnonymousClass() ? this.getClass().getSuperclass() : this.getClass()).getSimpleName() + ": id=" + this.getId();
    }

    public boolean isRunIntentionPassAfter() {
        return this.myRunIntentionPassAfter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8, 10, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeHighlighting/TextEditorHighlightingPass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateProgress";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionPredecessorIds";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startingPredecessorIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeHighlighting/TextEditorHighlightingPass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpiredCondition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionPredecessorIds";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartingPredecessorIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "markUpToDateIfStillValid";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionPredecessorIds";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setContext";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setStartingPredecessorIds";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8, 10, 12, 13 -> new IllegalStateException(string);
        };
    }
}

