/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.completion.CompletionFinalSorter;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.completion.CompletionPreselectSkipper;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.LookupElementListPresenter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.TopPriorityLookupElement;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.util.CodeCompletionKt;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import io.opentelemetry.api.trace.SpanBuilder;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseCompletionLookupArranger
extends LookupArranger
implements CompletionLookupArranger {
    private static final Logger LOG = Logger.getInstance(BaseCompletionLookupArranger.class);
    private static final Key<LookupElementPresentation> DEFAULT_PRESENTATION = Key.create((String)"PRESENTATION_INVARIANT");
    private static final Comparator<LookupElementPresentation> PRESENTATION_COMPARATOR = Comparator.comparing(LookupElementPresentation::getItemText, NaturalComparator.INSTANCE).thenComparing(p -> StringUtil.notNullize((String)p.getTailText()).length()).thenComparing(LookupElementPresentation::getTailText, NaturalComparator.INSTANCE).thenComparing(LookupElementPresentation::getTypeText, NaturalComparator.INSTANCE);
    private static final Comparator<LookupElement> BY_PRESENTATION_COMPARATOR = Comparator.comparing(arg_0 -> DEFAULT_PRESENTATION.get(arg_0), PRESENTATION_COMPARATOR);
    @ApiStatus.Internal
    public static final int MAX_PREFERRED_COUNT = 5;
    public static final Key<Object> FORCE_MIDDLE_MATCH = Key.create((String)"FORCE_MIDDLE_MATCH");
    private final List<LookupElement> myFrozenItems;
    private final int myLimit;
    private boolean myOverflow;
    private volatile CompletionLocation myLocation;
    @NotNull
    protected final CompletionProcessEx myProcess;
    private final Map<CompletionSorterImpl, Classifier<LookupElement>> myClassifiers;
    private final Key<CompletionSorterImpl> mySorterKey;
    private final CompletionFinalSorter myFinalSorter;
    private volatile int myPrefixChanges;
    @Nullable
    private String myLastLookupPrefix;
    private final CompletionPreselectSkipper[] mySkippers;
    private final Set<LookupElement> mySkippedItems;
    private final ThreadLocal<Boolean> isInBatchUpdate;
    private final List<Pair<LookupElement, LookupElementPresentation>> batchItems;

    public BaseCompletionLookupArranger(@NotNull CompletionProcessEx process) {
        if (process == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(0);
        }
        this.myFrozenItems = new ArrayList<LookupElement>();
        this.myLimit = Registry.intValue((String)"ide.completion.variant.limit");
        this.myClassifiers = Collections.synchronizedMap(new LinkedHashMap());
        this.mySorterKey = Key.create((String)"SORTER_KEY");
        this.myFinalSorter = CompletionFinalSorter.newSorter();
        this.mySkippers = (CompletionPreselectSkipper[])CompletionPreselectSkipper.EP_NAME.getExtensions();
        this.mySkippedItems = Collections.newSetFromMap(new IdentityHashMap());
        this.isInBatchUpdate = new ThreadLocal();
        this.batchItems = new ArrayList<Pair<LookupElement, LookupElementPresentation>>();
        this.myProcess = process;
    }

    @ApiStatus.Internal
    protected final MultiMap<CompletionSorterImpl, LookupElement> groupItemsBySorter(@NotNull Iterable<? extends LookupElement> source) {
        if (source == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(1);
        }
        MultiMap inputBySorter = MultiMap.createLinked();
        for (LookupElement lookupElement : source) {
            inputBySorter.putValue((Object)this.obtainSorter(lookupElement), (Object)lookupElement);
        }
        for (CompletionSorterImpl completionSorterImpl : inputBySorter.keySet()) {
            inputBySorter.put((Object)completionSorterImpl, this.sortByPresentation(inputBySorter.get((Object)completionSorterImpl)));
        }
        return inputBySorter;
    }

    @NotNull
    private CompletionSorterImpl obtainSorter(@NotNull LookupElement element) {
        if (element == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(2);
        }
        CompletionSorterImpl completionSorterImpl = (CompletionSorterImpl)((Object)element.getUserData(this.mySorterKey));
        if (completionSorterImpl == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(3);
        }
        return completionSorterImpl;
    }

    @NotNull
    public synchronized Map<LookupElement, List<Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<? extends LookupElement> items, boolean hideSingleValued) {
        if (items == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(4);
        }
        IdentityHashMap<LookupElement, SmartList> map = new IdentityHashMap<LookupElement, SmartList>();
        MultiMap<CompletionSorterImpl, LookupElement> inputBySorter = this.groupItemsBySorter(items);
        int sorterNumber = 0;
        for (CompletionSorterImpl sorter : inputBySorter.keySet()) {
            ++sorterNumber;
            Collection thisSorterItems = inputBySorter.get((Object)sorter);
            for (LookupElement element : thisSorterItems) {
                map.put(element, new SmartList((Object[])new Pair[]{new Pair((Object)"frozen", (Object)this.myFrozenItems.contains(element)), new Pair((Object)"sorter", (Object)sorterNumber)}));
            }
            ProcessingContext processingContext = this.createContext();
            for (Classifier<LookupElement> classifier = this.myClassifiers.get((Object)sorter); classifier != null; classifier = classifier.getNext()) {
                ReferenceOpenHashSet itemSet = new ReferenceOpenHashSet(thisSorterItems);
                List unsortedItems = ContainerUtil.filter((Collection)this.myItems, ((Set)itemSet)::contains);
                List<Pair<LookupElement, Object>> pairs = classifier.getSortingWeights(unsortedItems, processingContext);
                if (hideSingleValued && BaseCompletionLookupArranger.haveSameWeights(pairs)) continue;
                for (Pair<LookupElement, Object> pair : pairs) {
                    ((List)map.get(pair.first)).add(Pair.create((Object)classifier.getPresentableName(), (Object)pair.second));
                }
            }
        }
        Reference2ObjectLinkedOpenHashMap result = new Reference2ObjectLinkedOpenHashMap();
        Map<LookupElement, List<Pair<String, Object>>> additional = this.myFinalSorter.getRelevanceObjects(items);
        for (LookupElement lookupElement : items) {
            List mainRelevance = (List)map.get(lookupElement);
            List<Pair<String, Object>> additionalRelevance = additional.get(lookupElement);
            result.put(lookupElement, additionalRelevance == null ? mainRelevance : ContainerUtil.concat((List)mainRelevance, additionalRelevance));
        }
        Reference2ObjectLinkedOpenHashMap reference2ObjectLinkedOpenHashMap = result;
        if (reference2ObjectLinkedOpenHashMap == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(5);
        }
        return reference2ObjectLinkedOpenHashMap;
    }

    @ApiStatus.Internal
    public void associateSorter(@NotNull LookupElement element, @NotNull CompletionSorterImpl sorter) {
        if (element == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(6);
        }
        if (sorter == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(7);
        }
        element.putUserData(this.mySorterKey, (Object)sorter);
    }

    private static boolean haveSameWeights(@NotNull List<? extends Pair<LookupElement, Object>> pairs) {
        if (pairs == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(8);
        }
        if (pairs.isEmpty()) {
            return true;
        }
        for (int i = 1; i < pairs.size(); ++i) {
            if (Comparing.equal((Object)pairs.get((int)i).second, (Object)pairs.getFirst().second)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addElement(@NotNull LookupElement element, @NotNull CompletionSorter sorter, @NotNull PrefixMatcher prefixMatcher, @NotNull LookupElementPresentation presentation) {
        if (element == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(9);
        }
        if (sorter == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(10);
        }
        if (prefixMatcher == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(11);
        }
        if (presentation == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(12);
        }
        this.registerMatcher(element, prefixMatcher);
        this.associateSorter(element, (CompletionSorterImpl)sorter);
        this.addElement(element, presentation);
    }

    @Override
    public void addElement(@NotNull CompletionResult result) {
        if (result == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(13);
        }
        LookupElementPresentation presentation = new LookupElementPresentation();
        result.getLookupElement().renderElement(presentation);
        this.addElement(result.getLookupElement(), result.getSorter(), result.getPrefixMatcher(), presentation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(@NotNull LookupElement element, @NotNull LookupElementPresentation presentation) {
        if (element == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(14);
        }
        if (presentation == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(15);
        }
        boolean shouldSkip = this.shouldSkip(element);
        presentation.freeze();
        element.putUserData(DEFAULT_PRESENTATION, (Object)presentation);
        CompletionSorterImpl sorter = this.obtainSorter(element);
        ProcessingContext context = this.createContext();
        Classifier classifier = this.myClassifiers.computeIfAbsent(sorter, s -> s.buildClassifier(new EmptyClassifier()));
        classifier.addElement(element, context);
        boolean batchUpdate = Boolean.TRUE.equals(this.isInBatchUpdate.get());
        if (batchUpdate) {
            BaseCompletionLookupArranger baseCompletionLookupArranger = this;
            synchronized (baseCompletionLookupArranger) {
                if (shouldSkip) {
                    this.mySkippedItems.add(element);
                }
                this.batchItems.add((Pair<LookupElement, LookupElementPresentation>)new Pair((Object)element, (Object)presentation));
            }
        }
        BaseCompletionLookupArranger baseCompletionLookupArranger = this;
        synchronized (baseCompletionLookupArranger) {
            if (shouldSkip) {
                this.mySkippedItems.add(element);
            }
            super.addElement(element, presentation);
        }
        this.trimToLimit(context);
    }

    @ApiStatus.Internal
    public void batchUpdate(@NotNull Runnable runnable) {
        if (runnable == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(16);
        }
        if (Boolean.TRUE.equals(this.isInBatchUpdate.get())) {
            runnable.run();
        } else {
            this.isInBatchUpdate.set(true);
            try {
                runnable.run();
            }
            finally {
                this.isInBatchUpdate.remove();
            }
            if (!this.batchItems.isEmpty()) {
                this.flushBatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBatch() {
        BaseCompletionLookupArranger baseCompletionLookupArranger = this;
        synchronized (baseCompletionLookupArranger) {
            for (Pair<LookupElement, LookupElementPresentation> pair : this.batchItems) {
                super.addElement((LookupElement)pair.first, (LookupElementPresentation)pair.second);
            }
            this.batchItems.clear();
        }
        this.trimToLimit(this.createContext());
    }

    public synchronized void prefixReplaced(@NotNull Lookup lookup, @NotNull String newPrefix) {
        if (lookup == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(17);
        }
        if (newPrefix == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(18);
        }
        super.prefixReplaced(lookup, newPrefix);
    }

    public void itemSelected(@Nullable LookupElement lookupItem, char completionChar) {
        this.myProcess.itemSelected(lookupItem, completionChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToLimit(@NotNull ProcessingContext context) {
        List removed;
        if (context == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(19);
        }
        BaseCompletionLookupArranger baseCompletionLookupArranger = this;
        synchronized (baseCompletionLookupArranger) {
            if (this.myItems.size() < this.myLimit) {
                return;
            }
            List items = this.getMatchingItems();
            Iterator<LookupElement> iterator = this.sortByRelevance(this.groupItemsBySorter(items)).iterator();
            ReferenceOpenHashSet retainedSet = new ReferenceOpenHashSet();
            retainedSet.addAll(this.getTopPriorityItems());
            retainedSet.addAll(this.getPrefixItems(true));
            retainedSet.addAll(this.getPrefixItems(false));
            retainedSet.addAll(this.myFrozenItems);
            while (retainedSet.size() < this.myLimit / 2 && iterator.hasNext()) {
                retainedSet.add(iterator.next());
            }
            if (!iterator.hasNext()) {
                return;
            }
            removed = this.retainItems((Set)retainedSet);
            if (!this.myOverflow) {
                this.myOverflow = true;
                this.myProcess.addAdvertisement(AnalysisBundle.message((String)"completion.not.all.variants.are.shown", (Object[])new Object[0]), null);
                this.myProcess.addWatchedPrefix(0, (ElementPattern<String>)StandardPatterns.string());
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    this.printTestWarning();
                }
            }
        }
        for (LookupElement element : removed) {
            this.removeItem(element, context);
        }
    }

    private void printTestWarning() {
        System.err.println("Your test might miss some lookup items, because only " + this.myLimit / 2 + " most relevant items are guaranteed to be shown in the lookup. You can:");
        System.err.println("1. Make the prefix used for completion longer, so that there are less suggestions.");
        System.err.println("2. Increase 'ide.completion.variant.limit' (using RegistryValue#setValue with a test root disposable).");
        System.err.println("3. Ignore this warning.");
    }

    protected void removeItem(@NotNull LookupElement element, @NotNull ProcessingContext context) {
        CompletionSorterImpl sorter;
        Classifier<LookupElement> classifier;
        if (element == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(20);
        }
        if (context == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(21);
        }
        if ((classifier = this.myClassifiers.get((Object)(sorter = this.obtainSorter(element)))) != null) {
            classifier.removeElement(element, context);
        }
    }

    @NotNull
    private List<LookupElement> sortByPresentation(@NotNull Iterable<? extends LookupElement> source) {
        if (source == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(22);
        }
        ArrayList<LookupElement> startMatches = new ArrayList<LookupElement>();
        ArrayList middleMatches = new ArrayList();
        for (LookupElement lookupElement : source) {
            (this.itemMatcher(lookupElement).isStartMatch(lookupElement) ? startMatches : middleMatches).add(lookupElement);
        }
        ContainerUtil.sort(startMatches, BY_PRESENTATION_COMPARATOR);
        ContainerUtil.sort(middleMatches, BY_PRESENTATION_COMPARATOR);
        startMatches.addAll(middleMatches);
        ArrayList<LookupElement> arrayList = startMatches;
        if (arrayList == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    protected boolean isAlphaSorted() {
        return false;
    }

    @Override
    public Pair<List<LookupElement>, Integer> arrangeItems() {
        LookupElementListPresenter dummyListPresenter = new LookupElementListPresenter(this){

            @NotNull
            public String getAdditionalPrefix() {
                return "";
            }

            public LookupElement getCurrentItem() {
                return null;
            }

            public LookupElement getCurrentItemOrEmpty() {
                return null;
            }

            public boolean isSelectionTouched() {
                return false;
            }

            public int getSelectedIndex() {
                return 0;
            }

            public int getLastVisibleIndex() {
                return 0;
            }

            @NotNull
            public LookupFocusDegree getLookupFocusDegree() {
                LookupFocusDegree lookupFocusDegree = LookupFocusDegree.FOCUSED;
                if (lookupFocusDegree == null) {
                    1.$$$reportNull$$$0(0);
                }
                return lookupFocusDegree;
            }

            public boolean isShown() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/BaseCompletionLookupArranger$1", "getLookupFocusDegree"));
            }
        };
        return this.doArrangeItems(dummyListPresenter, false);
    }

    @NotNull
    public Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup lookup, boolean onExplicitAction) {
        if (lookup == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(24);
        }
        AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-347942, EA-661843");
        Pair<List<LookupElement>, Integer> pair = this.doArrangeItems((LookupElementListPresenter)lookup, onExplicitAction);
        Pair<List<LookupElement>, Integer> pair2 = pair;
        if (pair2 == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(25);
        }
        return pair2;
        finally {
            if (ignore != null) {
                ignore.close();
            }
        }
    }

    @NotNull
    private synchronized Pair<List<LookupElement>, Integer> doArrangeItems(@NotNull LookupElementListPresenter lookup, boolean onExplicitAction) {
        if (lookup == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(26);
        }
        Pair pair = (Pair)TraceKt.use((SpanBuilder)TelemetryManager.getInstance().getTracer(CodeCompletionKt.CodeCompletion).spanBuilder("arrangeItems"), span -> {
            List items = this.getMatchingItems();
            List filteredIterableItems = !this.hasCustomElements() ? items : JBIterable.from((Iterable)items).filter(item -> !this.isCustomElements((LookupElement)item));
            Iterable<LookupElement> sortedByRelevance = this.sortByRelevance(this.groupItemsBySorter(filteredIterableItems));
            sortedByRelevance = this.applyFinalSorter(sortedByRelevance);
            sortedByRelevance = this.combineCustomElements(sortedByRelevance);
            LookupElement relevantSelection = this.findMostRelevantItem(sortedByRelevance);
            List<LookupElement> listModel = this.isAlphaSorted() ? this.sortByPresentation(items) : this.fillModelByRelevance(lookup, (Set<? extends LookupElement>)new ReferenceOpenHashSet((Collection)items), sortedByRelevance, relevantSelection);
            this.customizeListModel(listModel);
            int toSelect = this.getItemToSelect(lookup, listModel, onExplicitAction, relevantSelection);
            LOG.assertTrue(toSelect >= 0);
            return new Pair(listModel, (Object)toSelect);
        });
        if (pair == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(27);
        }
        return pair;
    }

    @ApiStatus.Internal
    protected void customizeListModel(@NotNull List<LookupElement> model) {
        if (model == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(28);
        }
    }

    @ApiStatus.Internal
    @NotNull
    protected Iterable<? extends LookupElement> combineCustomElements(@NotNull Iterable<? extends LookupElement> main) {
        if (main == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(29);
        }
        Iterable<? extends LookupElement> iterable = main;
        if (iterable == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(30);
        }
        return iterable;
    }

    @ApiStatus.Internal
    protected boolean hasCustomElements() {
        return false;
    }

    @ApiStatus.Internal
    protected boolean isCustomElements(@NotNull LookupElement item) {
        if (item == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(31);
        }
        return false;
    }

    @NotNull
    protected Iterable<? extends LookupElement> applyFinalSorter(Iterable<? extends LookupElement> sortedByRelevance) {
        if (sortedByRelevance.iterator().hasNext()) {
            Iterable<? extends LookupElement> iterable = this.myFinalSorter.sort(sortedByRelevance, Objects.requireNonNull(this.myProcess.getParameters()));
            if (iterable == null) {
                BaseCompletionLookupArranger.$$$reportNull$$$0(32);
            }
            return iterable;
        }
        Iterable<? extends LookupElement> iterable = sortedByRelevance;
        if (iterable == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(33);
        }
        return iterable;
    }

    @NotNull
    private List<LookupElement> fillModelByRelevance(@NotNull LookupElementListPresenter lookup, @NotNull Set<? extends LookupElement> items, @NotNull Iterable<? extends LookupElement> sortedElements, @Nullable LookupElement relevantSelection) {
        if (lookup == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(34);
        }
        if (items == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(35);
        }
        if (sortedElements == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(36);
        }
        Iterator<? extends LookupElement> byRelevance = sortedElements.iterator();
        LinkedHashSet model = new LinkedHashSet();
        this.addTopPriorityItems(model);
        this.addPrefixItems(model);
        this.addFrozenItems(items, model);
        if (model.size() < 5) {
            BaseCompletionLookupArranger.addSomeItems(model, byRelevance, lastAdded -> model.size() >= 5);
        }
        this.addCurrentlySelectedItemToTop(lookup, items, model);
        this.freezeTopItems(lookup, model);
        BaseCompletionLookupArranger.ensureItemAdded(items, model, byRelevance, lookup.getCurrentItem());
        BaseCompletionLookupArranger.ensureItemAdded(items, model, byRelevance, relevantSelection);
        ContainerUtil.addAll(model, byRelevance);
        return new ArrayList<LookupElement>(model);
    }

    private static void ensureItemAdded(@NotNull Set<? extends LookupElement> items, @NotNull LinkedHashSet<? super LookupElement> model, @NotNull Iterator<? extends LookupElement> byRelevance, @Nullable LookupElement item) {
        if (items == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(37);
        }
        if (model == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(38);
        }
        if (byRelevance == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(39);
        }
        if (item != null && items.contains(item) && !model.contains(item)) {
            BaseCompletionLookupArranger.addSomeItems(model, byRelevance, lastAdded -> lastAdded == item);
        }
    }

    @ApiStatus.Internal
    protected final boolean isTopPriorityItem(@Nullable LookupElement item) {
        return item != null && Boolean.TRUE.equals(item.getUserData(TopPriorityLookupElement.TOP_PRIORITY_ITEM));
    }

    private boolean isNeverAutoselectedTopPriorityItem(@Nullable LookupElement item) {
        if (item == null || !this.isTopPriorityItem(item)) {
            return false;
        }
        return Boolean.TRUE.equals(item.getUserData(TopPriorityLookupElement.NEVER_AUTOSELECT_TOP_PRIORITY_ITEM));
    }

    private void freezeTopItems(@NotNull LookupElementListPresenter lookup, @NotNull LinkedHashSet<? extends LookupElement> model) {
        if (lookup == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(40);
        }
        if (model == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(41);
        }
        this.myFrozenItems.clear();
        if (lookup.isShown()) {
            this.myFrozenItems.addAll(model);
        }
    }

    private void addFrozenItems(@NotNull Set<? extends LookupElement> items, @NotNull LinkedHashSet<? super LookupElement> model) {
        if (items == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(42);
        }
        if (model == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(43);
        }
        this.myFrozenItems.removeIf(element -> !element.isValid() || !items.contains(element));
        model.addAll(this.myFrozenItems);
    }

    private void addTopPriorityItems(@NotNull LinkedHashSet<? super LookupElement> model) {
        List priorityItems;
        if (model == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(44);
        }
        if ((priorityItems = this.getTopPriorityItems()).isEmpty()) {
            return;
        }
        ContainerUtil.addAll(model, this.sortByRelevance(this.groupItemsBySorter(priorityItems)));
    }

    private void addPrefixItems(@NotNull LinkedHashSet<? super LookupElement> model) {
        if (model == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(45);
        }
        ContainerUtil.addAll(model, this.sortByRelevance(this.groupItemsBySorter(this.getPrefixItems(true))));
        ContainerUtil.addAll(model, this.sortByRelevance(this.groupItemsBySorter(this.getPrefixItems(false))));
    }

    private void addCurrentlySelectedItemToTop(@NotNull LookupElementListPresenter lookup, @NotNull Set<? extends LookupElement> items, @NotNull LinkedHashSet<? super LookupElement> model) {
        LookupElement lastSelection;
        if (lookup == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(46);
        }
        if (items == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(47);
        }
        if (model == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(48);
        }
        if (!lookup.isSelectionTouched() && items.contains(lastSelection = lookup.getCurrentItem()) && lastSelection != null && !this.isCustomElements(lastSelection)) {
            model.add((LookupElement)lastSelection);
        }
    }

    private static void addSomeItems(@NotNull Set<? super LookupElement> model, @NotNull Iterator<? extends LookupElement> iterator, @NotNull Predicate<? super LookupElement> stopWhen) {
        if (model == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(49);
        }
        if (iterator == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(50);
        }
        if (stopWhen == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(51);
        }
        while (iterator.hasNext()) {
            LookupElement item = iterator.next();
            model.add((LookupElement)item);
            if (!stopWhen.test((LookupElement)item)) continue;
            break;
        }
    }

    @ApiStatus.Internal
    @NotNull
    protected Iterable<LookupElement> sortByRelevance(@NotNull MultiMap<CompletionSorterImpl, LookupElement> inputBySorter) {
        if (inputBySorter == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(52);
        }
        if (inputBySorter.isEmpty()) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                BaseCompletionLookupArranger.$$$reportNull$$$0(53);
            }
            return list;
        }
        ArrayList<Map.Entry<CompletionSorterImpl, Classifier<LookupElement>>> entries = new ArrayList<Map.Entry<CompletionSorterImpl, Classifier<LookupElement>>>(this.myClassifiers.entrySet());
        List list = EntryStream.of(entries.iterator()).mapKeyValue((sorter, classifier) -> classifier.classify(inputBySorter.get((Object)sorter), this.createContext())).flatMap(iterable -> StreamEx.of(iterable.iterator())).toList();
        if (list == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(54);
        }
        return list;
    }

    @NotNull
    private ProcessingContext createContext() {
        ProcessingContext context = new ProcessingContext();
        context.put(PREFIX_CHANGES, (Object)this.myPrefixChanges);
        context.put(WEIGHING_CONTEXT, (Object)this);
        ProcessingContext processingContext = context;
        if (processingContext == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(55);
        }
        return processingContext;
    }

    @ApiStatus.Internal
    public void setLastLookupPrefix(@NotNull String lookupPrefix) {
        if (lookupPrefix == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(56);
        }
        this.myLastLookupPrefix = lookupPrefix;
    }

    @Nullable
    public String getLastLookupPrefix() {
        return this.myLastLookupPrefix;
    }

    @NotNull
    public LookupArranger createEmptyCopy() {
        return new BaseCompletionLookupArranger(this.myProcess);
    }

    private int getItemToSelect(@NotNull LookupElementListPresenter lookup, @NotNull List<? extends LookupElement> items, boolean onExplicitAction, @Nullable LookupElement mostRelevant) {
        LookupElement exactMatch;
        if (lookup == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(57);
        }
        if (items == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(58);
        }
        if (items.isEmpty() || lookup.getLookupFocusDegree() == LookupFocusDegree.UNFOCUSED) {
            return 0;
        }
        if (lookup.isSelectionTouched() || !onExplicitAction) {
            int index;
            EmptyLookupItem emptyLookupItem;
            LookupElement lastSelection = lookup.getCurrentItem();
            int old = ContainerUtil.indexOfIdentity(items, (Object)lastSelection);
            if (old >= 0) {
                return old;
            }
            LookupElement selectedValue = lookup.getCurrentItemOrEmpty();
            if (selectedValue instanceof EmptyLookupItem && (emptyLookupItem = (EmptyLookupItem)selectedValue).isLoading() && (index = lookup.getSelectedIndex()) >= 0 && index < items.size()) {
                return index;
            }
            for (int i = 0; i < items.size(); ++i) {
                LookupElementPresentation p2;
                LookupElementPresentation p1 = BaseCompletionLookupArranger.getDefaultPresentation(items.get(i));
                LookupElementPresentation lookupElementPresentation = p2 = lastSelection == null ? null : BaseCompletionLookupArranger.getDefaultPresentation(lastSelection);
                if (p1 == null || p2 == null || PRESENTATION_COMPARATOR.compare(p1, p2) != 0) continue;
                return i;
            }
        }
        return Math.max(0, ContainerUtil.indexOfIdentity(items, (Object)((exactMatch = this.getBestExactMatch(items)) != null ? exactMatch : mostRelevant)));
    }

    @ApiStatus.Internal
    public static LookupElementPresentation getDefaultPresentation(@NotNull LookupElement item) {
        if (item == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(59);
        }
        return (LookupElementPresentation)item.getUserData(DEFAULT_PRESENTATION);
    }

    @NotNull
    protected List<LookupElement> getExactMatches(@NotNull List<? extends LookupElement> items) {
        if (items == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(60);
        }
        Editor editor = InjectedLanguageEditorUtil.getTopLevelEditor((Editor)this.myProcess.getParameters().getEditor());
        String selectedText = editor.getSelectionModel().getSelectedText();
        SmartList exactMatches = new SmartList();
        for (LookupElement lookupElement : items) {
            if (!this.isPrefixItem(lookupElement, true) && !lookupElement.getLookupString().equals(selectedText)) continue;
            exactMatches.add(lookupElement);
        }
        SmartList smartList = exactMatches;
        if (smartList == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(61);
        }
        return smartList;
    }

    @Nullable
    private LookupElement getBestExactMatch(@NotNull List<? extends LookupElement> items) {
        List<LookupElement> exactMatches;
        if (items == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(62);
        }
        if ((exactMatches = this.getExactMatches(items)).isEmpty()) {
            return null;
        }
        if (exactMatches.size() == 1) {
            return exactMatches.getFirst();
        }
        return this.sortByRelevance(this.groupItemsBySorter(exactMatches)).iterator().next();
    }

    @Nullable
    private LookupElement findMostRelevantItem(@NotNull Iterable<? extends LookupElement> sorted) {
        if (sorted == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(63);
        }
        LookupElement candidate = null;
        for (LookupElement lookupElement : sorted) {
            if (this.mySkippedItems.contains(lookupElement)) continue;
            if (!this.isNeverAutoselectedTopPriorityItem(lookupElement)) {
                return lookupElement;
            }
            if (candidate != null) continue;
            candidate = lookupElement;
        }
        return candidate;
    }

    private boolean shouldSkip(@NotNull LookupElement element) {
        if (element == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(64);
        }
        CompletionLocation location = this.getLocation();
        for (CompletionPreselectSkipper skipper : this.mySkippers) {
            if (!skipper.skipElement(element, location)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipped element " + String.valueOf(element) + " by " + String.valueOf(skipper));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CompletionLocation getLocation() {
        if (this.myLocation == null) {
            BaseCompletionLookupArranger baseCompletionLookupArranger = this;
            synchronized (baseCompletionLookupArranger) {
                if (this.myLocation == null) {
                    this.myLocation = new CompletionLocation(Objects.requireNonNull(this.myProcess.getParameters()));
                }
            }
        }
        CompletionLocation completionLocation = this.myLocation;
        if (completionLocation == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(65);
        }
        return completionLocation;
    }

    @ApiStatus.Internal
    public synchronized void prefixChanged(@NotNull String newAdditionalPrefix) {
        if (newAdditionalPrefix == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(66);
        }
        ++this.myPrefixChanges;
        this.myFrozenItems.clear();
        super.prefixChanged(newAdditionalPrefix);
    }

    public void prefixTruncated(@NotNull LookupEx lookup, int hideOffset) {
        if (lookup == null) {
            BaseCompletionLookupArranger.$$$reportNull$$$0(67);
        }
        if (hideOffset < lookup.getEditor().getCaretModel().getOffset()) {
            this.myProcess.scheduleRestart();
            return;
        }
        this.myProcess.prefixUpdated();
        lookup.hideLookup(false);
    }

    public boolean isCompletion() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 23, 25, 27, 30, 32, 33, 53, 54, 55, 61, 65 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 14: 
            case 20: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 53: 
            case 54: 
            case 55: 
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/BaseCompletionLookupArranger";
                break;
            }
            case 4: 
            case 35: 
            case 37: 
            case 42: 
            case 47: 
            case 58: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pairs";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMatcher";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 17: 
            case 24: 
            case 26: 
            case 34: 
            case 40: 
            case 46: 
            case 57: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookup";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPrefix";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 28: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "main";
                break;
            }
            case 31: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortedElements";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byRelevance";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopWhen";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputBySorter";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupPrefix";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorted";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAdditionalPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/BaseCompletionLookupArranger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainSorter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevanceObjects";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "sortByPresentation";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "arrangeItems";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "doArrangeItems";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "combineCustomElements";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "applyFinalSorter";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "sortByRelevance";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getExactMatches";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "groupItemsBySorter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "obtainSorter";
                break;
            }
            case 3: 
            case 5: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 53: 
            case 54: 
            case 55: 
            case 61: 
            case 65: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRelevanceObjects";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "associateSorter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "haveSameWeights";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "batchUpdate";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "prefixReplaced";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "trimToLimit";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeItem";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sortByPresentation";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "arrangeItems";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doArrangeItems";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "customizeListModel";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "combineCustomElements";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isCustomElements";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "fillModelByRelevance";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "ensureItemAdded";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "freezeTopItems";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addFrozenItems";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addTopPriorityItems";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addPrefixItems";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addCurrentlySelectedItemToTop";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addSomeItems";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "sortByRelevance";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "setLastLookupPrefix";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getItemToSelect";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPresentation";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getExactMatches";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getBestExactMatch";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findMostRelevantItem";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkip";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "prefixChanged";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "prefixTruncated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 23, 25, 27, 30, 32, 33, 53, 54, 55, 61, 65 -> new IllegalStateException(string);
        };
    }

    private static final class EmptyClassifier
    extends Classifier<LookupElement> {
        private EmptyClassifier() {
            super(null, "empty");
        }

        @Override
        @NotNull
        public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<? extends LookupElement> items, @NotNull ProcessingContext context) {
            if (items == null) {
                EmptyClassifier.$$$reportNull$$$0(0);
            }
            if (context == null) {
                EmptyClassifier.$$$reportNull$$$0(1);
            }
            List<Pair<LookupElement, Object>> list = Collections.emptyList();
            if (list == null) {
                EmptyClassifier.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        @NotNull
        public Iterable<LookupElement> classify(@NotNull Iterable<? extends LookupElement> source, @NotNull ProcessingContext context) {
            if (source == null) {
                EmptyClassifier.$$$reportNull$$$0(3);
            }
            if (context == null) {
                EmptyClassifier.$$$reportNull$$$0(4);
            }
            Iterable<LookupElement> iterable = source;
            if (iterable == null) {
                EmptyClassifier.$$$reportNull$$$0(5);
            }
            return iterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/BaseCompletionLookupArranger$EmptyClassifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/BaseCompletionLookupArranger$EmptyClassifier";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortingWeights";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classify";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortingWeights";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "classify";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5 -> new IllegalStateException(string);
            };
        }
    }
}

