/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.action;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GotoDeclarationUtil {
    private static final Logger LOG = Logger.getInstance(GotoDeclarationUtil.class);

    public static @NotNull PsiElement @Nullable [] findTargetElementsFromProviders(@NotNull Editor editor, int offset, PsiFile file) {
        if (editor == null) {
            GotoDeclarationUtil.$$$reportNull$$$0(0);
        }
        PsiElement elementAt = file.findElementAt(TargetElementUtilBase.adjustOffset(file, editor.getDocument(), offset));
        return GotoDeclarationUtil.findTargetElementsFromProviders(elementAt, offset, editor);
    }

    public static @NotNull PsiElement @Nullable [] findTargetElementsFromProviders(@Nullable PsiElement elementAt, int offset, @NotNull Editor editor) {
        if (editor == null) {
            GotoDeclarationUtil.$$$reportNull$$$0(1);
        }
        for (GotoDeclarationHandler handler : GotoDeclarationHandler.EP_NAME.getExtensionList()) {
            PsiElement[] result = handler.getGotoDeclarationTargets(elementAt, offset, editor);
            if (result == null || result.length <= 0) continue;
            return GotoDeclarationUtil.assertNotNullElements(result, handler.getClass()) ? result : null;
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static boolean assertNotNullElements(PsiElement @NotNull [] result, Class<?> clazz) {
        if (result == null) {
            GotoDeclarationUtil.$$$reportNull$$$0(2);
        }
        for (PsiElement element : result) {
            if (element != null) continue;
            PluginException.logPluginError((Logger)LOG, (String)("Null target element is returned by 'getGotoDeclarationTargets' in " + clazz.getName()), null, clazz);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/navigation/action/GotoDeclarationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetElementsFromProviders";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "assertNotNullElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

