/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.blobstorage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IntRef;
import com.intellij.platform.util.io.storages.blobstorage.RecordAlreadyDeletedException;
import com.intellij.platform.util.io.storages.blobstorage.RecordLayout;
import com.intellij.platform.util.io.storages.blobstorage.StreamlinedBlobStorageHelper;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorage;
import com.intellij.util.BitUtil;
import com.intellij.util.io.ClosedStorageException;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.blobstorage.ByteBufferReader;
import com.intellij.util.io.blobstorage.ByteBufferWriter;
import com.intellij.util.io.blobstorage.SpaceAllocationStrategy;
import com.intellij.util.io.blobstorage.StreamlinedBlobStorage;
import io.opentelemetry.api.metrics.BatchCallback;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StreamlinedBlobStorageOverMMappedFile
extends StreamlinedBlobStorageHelper
implements StreamlinedBlobStorage {
    private static final Logger LOG = Logger.getInstance(StreamlinedBlobStorageOverMMappedFile.class);
    public static final int STORAGE_VERSION_CURRENT = 1;
    private static final VarHandle INT_HANDLE = MethodHandles.byteBufferViewVarHandle(int[].class, ByteOrder.nativeOrder()).withInvokeExactBehavior();
    @NotNull
    private final MMappedFileStorage storage;
    private transient MMappedFileStorage.Page headerPage;
    private final BatchCallback openTelemetryCallback;

    public StreamlinedBlobStorageOverMMappedFile(@NotNull MMappedFileStorage storage, @NotNull SpaceAllocationStrategy allocationStrategy) throws IOException {
        int fileStatusBitmask;
        if (storage == null) {
            StreamlinedBlobStorageOverMMappedFile.$$$reportNull$$$0(0);
        }
        if (allocationStrategy == null) {
            StreamlinedBlobStorageOverMMappedFile.$$$reportNull$$$0(1);
        }
        super(allocationStrategy, storage.pageSize(), storage.byteOrder());
        this.storage = storage;
        long length = storage.actualFileSize();
        if (length > 0x3FFFFFFF8L) {
            throw new IOException("Can't read file[" + String.valueOf(storage) + "]: too big, " + length + " > Integer.MAX_VALUE * 8");
        }
        this.headerPage = storage.pageByOffset(0L);
        if (length == 0L) {
            this.putHeaderInt(0, MAGIC_WORD);
            this.putHeaderInt(4, 1);
            this.putHeaderInt(8, this.pageSize);
            this.updateNextRecordId(this.offsetToId(this.recordsStartOffset()));
            this.wasClosedProperly = true;
            this.wasAlwaysClosedProperly = true;
            fileStatusBitmask = 3;
        } else {
            boolean wasClosedProperlyLastTime;
            int magicWord = this.readHeaderInt(0);
            if (magicWord != MAGIC_WORD) {
                throw new IOException("[" + String.valueOf(storage.storagePath()) + "] is of incorrect type: .magicWord(=" + magicWord + ", '" + IOUtil.magicWordToASCII((int)magicWord) + "') != " + MAGIC_WORD + " expected");
            }
            int version = this.readHeaderInt(4);
            if (version != 1) {
                throw new IOException("[" + String.valueOf(storage.storagePath()) + "]: file version(" + version + ") != current impl version (1)");
            }
            int filePageSize = this.readHeaderInt(8);
            if (this.pageSize != filePageSize) {
                throw new IOException("[" + String.valueOf(storage.storagePath()) + "]: file created with pageSize=" + filePageSize + " but current storage.pageSize=" + this.pageSize);
            }
            this.recordsAllocated.set(this.readHeaderInt(20));
            this.recordsRelocated.set(this.readHeaderInt(24));
            this.recordsDeleted.set(this.readHeaderInt(28));
            this.totalLiveRecordsPayloadBytes.set(this.readHeaderLong(32));
            this.totalLiveRecordsCapacityBytes.set(this.readHeaderLong(40));
            fileStatusBitmask = this.readHeaderInt(12);
            this.wasClosedProperly = wasClosedProperlyLastTime = BitUtil.isSet((int)fileStatusBitmask, (int)1);
            this.wasAlwaysClosedProperly = wasClosedProperlyLastTime && BitUtil.isSet((int)fileStatusBitmask, (int)2);
            fileStatusBitmask = BitUtil.set((int)fileStatusBitmask, (int)2, (boolean)this.wasAlwaysClosedProperly);
        }
        fileStatusBitmask = BitUtil.set((int)fileStatusBitmask, (int)1, (boolean)false);
        this.putHeaderInt(12, fileStatusBitmask);
        storage.fsync();
        this.openTelemetryCallback = StreamlinedBlobStorageOverMMappedFile.setupReportingToOpenTelemetry(storage.storagePath().getFileName(), this);
    }

    public int getStorageVersion() throws IOException {
        return this.readHeaderInt(4);
    }

    public int getDataFormatVersion() throws IOException {
        return this.readHeaderInt(48);
    }

    public void setDataFormatVersion(int expectedVersion) throws IOException {
        this.putHeaderInt(48, expectedVersion);
    }

    public boolean hasRecord(int recordId, @Nullable IntRef redirectToIdRef) throws IOException {
        if (recordId == 0) {
            return false;
        }
        StreamlinedBlobStorageOverMMappedFile.checkRecordIdValid(recordId);
        if (!this.isRecordIdAllocated(recordId)) {
            return false;
        }
        int currentRecordId = recordId;
        for (int i = 0; i < 256; ++i) {
            int redirectToId;
            long recordOffset = this.idToOffset(currentRecordId);
            MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffset);
            int offsetOnPage = this.storage.toOffsetInPage(recordOffset);
            ByteBuffer buffer = page.rawPageBuffer();
            RecordLayout recordLayout = RecordLayout.recordLayout(buffer, offsetOnPage);
            byte recordType = recordLayout.recordType();
            if (redirectToIdRef != null) {
                redirectToIdRef.set(currentRecordId);
            }
            if (recordType == 0) {
                return true;
            }
            if (recordType == 64) {
                redirectToId = recordLayout.redirectToId(buffer, offsetOnPage);
                if (redirectToId == 0) {
                    return false;
                }
            } else {
                throw new AssertionError((Object)("RecordType(" + recordType + ") should not appear in the chain: it is either not implemented yet, or all wrong"));
            }
            this.checkRedirectToId(recordId, currentRecordId, redirectToId);
            currentRecordId = redirectToId;
        }
        throw new IOException("record[" + recordId + "].redirectTo chain is too long (>=256): circular reference?");
    }

    public <Out> Out readRecord(int recordId, @NotNull ByteBufferReader<Out> reader, @Nullable IntRef redirectToIdRef) throws IOException {
        if (reader == null) {
            StreamlinedBlobStorageOverMMappedFile.$$$reportNull$$$0(2);
        }
        this.checkRecordIdExists(recordId);
        int currentRecordId = recordId;
        for (int i = 0; i < 256; ++i) {
            long recordOffsetInFile = this.idToOffset(currentRecordId);
            int offsetOnPage = this.storage.toOffsetInPage(recordOffsetInFile);
            MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
            ByteBuffer buffer = page.rawPageBuffer();
            RecordLayout recordLayout = RecordLayout.recordLayout(buffer, offsetOnPage);
            byte recordType = recordLayout.recordType();
            if (redirectToIdRef != null) {
                redirectToIdRef.set(currentRecordId);
            }
            if (recordType == 0) {
                int recordPayloadLength = recordLayout.length(buffer, offsetOnPage);
                ByteBuffer slice = buffer.slice(offsetOnPage + recordLayout.headerSize(), recordPayloadLength).asReadOnlyBuffer().order(buffer.order());
                return (Out)reader.read(slice);
            }
            if (recordType != 64) {
                throw new AssertionError((Object)("RecordType(" + recordType + ") should not appear in the chain: it is either not implemented yet, or all wrong"));
            }
            int redirectToId = recordLayout.redirectToId(buffer, offsetOnPage);
            this.checkRedirectToId(recordId, currentRecordId, redirectToId);
            currentRecordId = redirectToId;
        }
        throw new IOException("record[" + recordId + "].redirectTo chain is too long (>=256): circular reference?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int writeToRecord(int recordId, @NotNull ByteBufferWriter writer, int expectedRecordSizeHint, boolean leaveRedirectOnRecordRelocation) throws IOException {
        byte recordType;
        RecordLayout recordLayout;
        ByteBuffer buffer;
        int offsetOnPage;
        int currentRecordId;
        block15: {
            if (writer == null) {
                StreamlinedBlobStorageOverMMappedFile.$$$reportNull$$$0(3);
            }
            if (!StreamlinedBlobStorageOverMMappedFile.isValidRecordId(recordId)) {
                ByteBuffer temp = this.acquireTemporaryBuffer(expectedRecordSizeHint);
                try {
                    ByteBuffer bufferWithData = writer.write(temp);
                    bufferWithData.flip();
                    int recordLength = bufferWithData.limit();
                    StreamlinedBlobStorageOverMMappedFile.checkLengthHardLimit(recordLength);
                    if (recordLength > this.maxCapacityForPageSize) {
                        throw new IllegalStateException("recordLength(=" + recordLength + ") > maxCapacityForPageSize(=" + this.maxCapacityForPageSize + ") -- can't fit");
                    }
                    int capacity = bufferWithData.capacity();
                    int requestedRecordCapacity = this.allocationStrategy.capacity(recordLength, capacity);
                    if (requestedRecordCapacity < recordLength) {
                        throw new IllegalStateException("Allocation strategy " + String.valueOf(this.allocationStrategy) + "(" + recordLength + ", " + capacity + ") returns " + requestedRecordCapacity + " < length(=" + recordLength + ")");
                    }
                    int n = this.writeToNewlyAllocatedRecord(bufferWithData, requestedRecordCapacity);
                    return n;
                }
                finally {
                    this.releaseTemporaryBuffer(temp);
                }
            }
            currentRecordId = recordId;
            int i = 0;
            while (i < 256) {
                long recordOffset = this.idToOffset(currentRecordId);
                offsetOnPage = this.storage.toOffsetInPage(recordOffset);
                MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffset);
                buffer = page.rawPageBuffer();
                recordLayout = RecordLayout.recordLayout(buffer, offsetOnPage);
                recordType = recordLayout.recordType();
                if (recordType == 64) {
                    int redirectToId = recordLayout.redirectToId(buffer, offsetOnPage);
                    this.checkRedirectToId(recordId, currentRecordId, redirectToId);
                    currentRecordId = redirectToId;
                    ++i;
                    continue;
                }
                break block15;
            }
            throw new IOException("record[" + recordId + "].redirectTo chain is too long (>=256): circular reference?");
        }
        if (recordType != 0) {
            throw new AssertionError((Object)("RecordType(" + recordType + ") should not appear in the chain: it is either not implemented yet, or all wrong"));
        }
        int recordCapacity = recordLayout.capacity(buffer, offsetOnPage);
        int recordActualLength = recordLayout.length(buffer, offsetOnPage);
        int recordPayloadOffset = offsetOnPage + recordLayout.headerSize();
        ByteBuffer recordContent = buffer.slice(recordPayloadOffset, recordCapacity).limit(recordActualLength).order(buffer.order());
        ByteBuffer newRecordContent = writer.write(recordContent);
        if (newRecordContent == null) {
            return currentRecordId;
        }
        if (newRecordContent != recordContent) {
            newRecordContent.flip();
            int newRecordLength = newRecordContent.remaining();
            if (newRecordLength <= recordCapacity) {
                recordLayout.putRecord(buffer, offsetOnPage, recordCapacity, newRecordLength, 0, newRecordContent);
                this.totalLiveRecordsPayloadBytes.addAndGet(newRecordLength - recordActualLength);
                return currentRecordId;
            }
            int newRecordCapacity = this.allocationStrategy.capacity(newRecordLength, newRecordContent.capacity());
            int newRecordId = this.writeToNewlyAllocatedRecord(newRecordContent, newRecordCapacity);
            RecordLayout.MovedRecord movedRecordLayout = RecordLayout.MovedRecord.INSTANCE;
            int redirectToId = leaveRedirectOnRecordRelocation ? newRecordId : 0;
            int movedRecordCapacity = recordLayout.fullRecordSize(recordCapacity) - movedRecordLayout.headerSize();
            movedRecordLayout.putRecord(buffer, offsetOnPage, movedRecordCapacity, 0, redirectToId, null);
            this.totalLiveRecordsPayloadBytes.addAndGet(-recordActualLength);
            this.totalLiveRecordsCapacityBytes.addAndGet(-recordCapacity);
            if (leaveRedirectOnRecordRelocation) {
                this.recordsRelocated.incrementAndGet();
                return newRecordId;
            }
            this.recordsDeleted.incrementAndGet();
            return newRecordId;
        }
        recordContent.flip();
        int newRecordLength = recordContent.remaining();
        assert (newRecordLength <= recordCapacity) : newRecordLength + " > " + recordCapacity + ": can't be, since recordContent.capacity()==recordCapacity!";
        recordLayout.putLength(buffer, offsetOnPage, newRecordLength);
        this.totalLiveRecordsPayloadBytes.addAndGet(newRecordLength - recordActualLength);
        return currentRecordId;
    }

    public void deleteRecord(int recordId) throws IOException {
        this.checkRecordIdExists(recordId);
        long recordOffset = this.idToOffset(recordId);
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffset);
        int offsetOnPage = this.storage.toOffsetInPage(recordOffset);
        ByteBuffer buffer = page.rawPageBuffer();
        RecordLayout recordLayout = RecordLayout.recordLayout(buffer, offsetOnPage);
        int recordCapacity = recordLayout.capacity(buffer, offsetOnPage);
        int recordActualLength = recordLayout.length(buffer, offsetOnPage);
        byte recordType = recordLayout.recordType();
        switch (recordType) {
            case 64: {
                int redirectToId = recordLayout.redirectToId(buffer, offsetOnPage);
                if (redirectToId == 0) {
                    throw new RecordAlreadyDeletedException("Can't delete record[" + recordId + "]: it was already deleted, (wasClosedProperly: " + this.wasClosedProperly() + ", wasAlwaysClosedProperly: " + this.wasAlwaysClosedProperly() + ")");
                }
                ((RecordLayout.MovedRecord)recordLayout).putRedirectTo(buffer, offsetOnPage, 0);
                break;
            }
            case 0: {
                RecordLayout.MovedRecord movedRecordLayout = RecordLayout.MovedRecord.INSTANCE;
                int deletedRecordCapacity = recordLayout.fullRecordSize(recordCapacity) - movedRecordLayout.headerSize();
                movedRecordLayout.putRecord(buffer, offsetOnPage, deletedRecordCapacity, 0, 0, null);
                break;
            }
            default: {
                throw new AssertionError((Object)("RecordType(" + recordType + ") should not appear in the chain: it is either not implemented yet, or all wrong"));
            }
        }
        this.recordsDeleted.incrementAndGet();
        this.totalLiveRecordsPayloadBytes.addAndGet(-recordActualLength);
        this.totalLiveRecordsCapacityBytes.addAndGet(-recordCapacity);
    }

    public <E extends Exception> int forEach(@NotNull StreamlinedBlobStorage.Processor<E> processor) throws IOException, E {
        if (processor == null) {
            StreamlinedBlobStorageOverMMappedFile.$$$reportNull$$$0(4);
        }
        long storageLength = this.actualLength();
        int currentId = this.offsetToId(this.recordsStartOffset());
        int recordNo = 0;
        while (true) {
            long recordOffset = this.idToOffset(currentId);
            MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffset);
            int offsetOnPage = this.storage.toOffsetInPage(recordOffset);
            ByteBuffer buffer = page.rawPageBuffer();
            RecordLayout recordLayout = RecordLayout.recordLayout(buffer, offsetOnPage);
            byte recordType = recordLayout.recordType();
            int recordCapacity = recordLayout.capacity(buffer, offsetOnPage);
            switch (recordType) {
                case 0: 
                case 64: {
                    int headerSize = recordLayout.headerSize();
                    boolean isActual = recordType == 0;
                    int recordActualLength = isActual ? recordLayout.length(buffer, offsetOnPage) : -1;
                    ByteBuffer slice = isActual ? buffer.slice(offsetOnPage + headerSize, recordActualLength).asReadOnlyBuffer().order(buffer.order()) : buffer.slice(offsetOnPage + headerSize, 0).asReadOnlyBuffer().order(buffer.order());
                    boolean ok = processor.processRecord(currentId, recordCapacity, recordActualLength, slice);
                    if (ok) break;
                    return recordNo + 1;
                }
            }
            long nextRecordOffset = this.nextRecordOffset(recordOffset, recordLayout, recordCapacity);
            if (nextRecordOffset >= storageLength) {
                return recordNo;
            }
            currentId = this.offsetToId(nextRecordOffset);
            ++recordNo;
        }
    }

    public long sizeInBytes() throws IOException {
        return this.actualLength();
    }

    public boolean isDirty() {
        return false;
    }

    public void force() throws IOException {
        this.checkNotClosed();
        this.putHeaderInt(20, this.recordsAllocated.get());
        this.putHeaderInt(24, this.recordsRelocated.get());
        this.putHeaderInt(28, this.recordsDeleted.get());
        this.putHeaderLong(32, this.totalLiveRecordsPayloadBytes.get());
        this.putHeaderLong(40, this.totalLiveRecordsCapacityBytes.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed.get()) {
            StreamlinedBlobStorageOverMMappedFile streamlinedBlobStorageOverMMappedFile = this;
            synchronized (streamlinedBlobStorageOverMMappedFile) {
                if (!this.closed.get()) {
                    int fileStatusMask = BitUtil.set((int)1, (int)2, (boolean)this.wasAlwaysClosedProperly);
                    this.putHeaderInt(12, fileStatusMask);
                    this.force();
                    this.closed.set(true);
                    this.openTelemetryCallback.close();
                    this.headerPage = null;
                    this.storage.close();
                }
            }
        }
    }

    @Override
    public void closeAndClean() throws IOException {
        this.close();
        this.storage.closeAndClean();
    }

    @Override
    @NotNull
    protected Path storagePath() {
        Path path = this.storage.storagePath();
        if (path == null) {
            StreamlinedBlobStorageOverMMappedFile.$$$reportNull$$$0(5);
        }
        return path;
    }

    private int readHeaderInt(int offset) throws IOException {
        assert (0 <= offset && offset <= 60) : "header offset(=" + offset + ") must be in [0,60]";
        return this.headerPage().rawPageBuffer().getInt(offset);
    }

    private void putHeaderInt(int offset, int value) throws IOException {
        assert (0 <= offset && offset <= 60) : "header offset(=" + offset + ") must be in [0,60]";
        this.headerPage().rawPageBuffer().putInt(offset, value);
    }

    private long readHeaderLong(int offset) throws IOException {
        assert (0 <= offset && offset <= 56) : "header offset(=" + offset + ") must be in [0,56]";
        return this.headerPage().rawPageBuffer().getLong(offset);
    }

    private void putHeaderLong(int offset, long value) throws IOException {
        assert (0 <= offset && offset <= 56) : "header offset(=" + offset + ") must be in [0,56]";
        this.headerPage().rawPageBuffer().putLong(offset, value);
    }

    private long actualLength() throws IOException {
        return this.idToOffset(this.nextRecordId());
    }

    @Override
    protected int nextRecordId() throws IOException {
        MMappedFileStorage.Page headerPage = this.headerPage();
        ByteBuffer headerBuffer = headerPage.rawPageBuffer();
        return INT_HANDLE.getVolatile(headerBuffer, 16);
    }

    @Override
    protected void updateNextRecordId(int nextRecordId) throws IOException {
        if (nextRecordId <= 0) {
            throw new IllegalArgumentException("nextRecordId(=" + nextRecordId + ") must be >0");
        }
        MMappedFileStorage.Page headerPage = this.headerPage();
        ByteBuffer headerBuffer = headerPage.rawPageBuffer();
        INT_HANDLE.setVolatile(headerBuffer, 16, nextRecordId);
    }

    @NotNull
    private MMappedFileStorage.Page headerPage() throws ClosedStorageException {
        MMappedFileStorage.Page _headerPage = this.headerPage;
        if (_headerPage == null) {
            throw new ClosedStorageException("Storage is closed");
        }
        MMappedFileStorage.Page page = _headerPage;
        if (page == null) {
            StreamlinedBlobStorageOverMMappedFile.$$$reportNull$$$0(6);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeToNewlyAllocatedRecord(ByteBuffer content, int requestedRecordCapacity) throws IOException {
        int pageSize = this.storage.pageSize();
        int recordLength = content.limit();
        if (recordLength > this.maxCapacityForPageSize) {
            throw new IllegalStateException("recordLength(=" + recordLength + ") > maxCapacityForPageSize(=" + this.maxCapacityForPageSize + ") -- can't fit");
        }
        int implementableCapacity = Math.min(requestedRecordCapacity, this.maxCapacityForPageSize);
        StreamlinedBlobStorageOverMMappedFile.checkCapacityHardLimit(implementableCapacity);
        byte recordSizeType = RecordLayout.ActualRecords.recordSizeTypeByCapacity(implementableCapacity);
        RecordLayout recordLayout = RecordLayout.ActualRecords.recordLayoutForType(recordSizeType);
        int fullRecordSize = recordLayout.fullRecordSize(implementableCapacity);
        if (fullRecordSize > pageSize) {
            throw new IllegalArgumentException("record size(header:" + recordLayout.headerSize() + " + capacity:" + implementableCapacity + ") should be <= pageSize(=" + pageSize + ")");
        }
        IntRef actualRecordSizeRef = new IntRef();
        int newRecordId = this.allocateSlotForRecord(pageSize, fullRecordSize, actualRecordSizeRef);
        long newRecordOffset = this.idToOffset(newRecordId);
        int actualRecordSize = actualRecordSizeRef.get();
        int actualRecordCapacity = actualRecordSize - recordLayout.headerSize();
        int newRecordLength = content.remaining();
        StreamlinedBlobStorageOverMMappedFile.checkCapacityHardLimit(actualRecordCapacity);
        StreamlinedBlobStorageOverMMappedFile.checkLengthHardLimit(newRecordLength);
        int offsetOnPage = this.storage.toOffsetInPage(newRecordOffset);
        try {
            MMappedFileStorage.Page page = this.storage.pageByOffset(newRecordOffset);
            recordLayout.putRecord(page.rawPageBuffer(), offsetOnPage, actualRecordCapacity, newRecordLength, 0, content);
            int n = newRecordId;
            return n;
        }
        finally {
            this.recordsAllocated.incrementAndGet();
            this.totalLiveRecordsCapacityBytes.addAndGet(actualRecordCapacity);
            this.totalLiveRecordsPayloadBytes.addAndGet(newRecordLength);
        }
    }

    @Override
    protected void putSpaceFillerRecord(long recordOffset, int pageSize) throws IOException {
        RecordLayout.PaddingRecord paddingRecord = RecordLayout.PaddingRecord.INSTANCE;
        int offsetInPage = this.storage.toOffsetInPage(recordOffset);
        int remainingOnPage = pageSize - offsetInPage;
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffset);
        int capacity = remainingOnPage - paddingRecord.headerSize();
        paddingRecord.putRecord(page.rawPageBuffer(), offsetInPage, capacity, 0, 0, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocationStrategy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/util/io/storages/blobstorage/StreamlinedBlobStorageOverMMappedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/util/io/storages/blobstorage/StreamlinedBlobStorageOverMMappedFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "storagePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "headerPage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readRecord";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeToRecord";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

