/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.ASTNode;
import com.intellij.model.search.LeafOccurrence;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.search.LeafOccurrenceData;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001*\u00020\u0005H\u0000\u001aX\u0010\f\u001a!\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0007j\u0002`\r*'\u0012#\u0012!\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0007j\u0002`\r0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001aA\u0010\u0011\u001a\u00020\u000b*'\u0012#\u0012!\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0007j\u0002`\r0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0005H\u0000\u001aO\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102%\u0010\u0017\u001a!\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0007j\u0002`\rH\u0000\u001aO\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042%\u0010\u0017\u001a!\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0007j\u0002`\rH\u0002*B\b\u0000\u0010\u0006\"\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u00072\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0007\u00a8\u0006\u001d"}, d2={"elementsUp", "", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiElement;", "", "Lcom/intellij/model/search/LeafOccurrence;", "OccurrenceProcessor", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "occurrence", "", "compound", "Lcom/intellij/psi/impl/search/OccurrenceProcessor;", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "runProcessors", "processOffsets", "scope", "offsetsInScope", "", "patternLength", "processor", "processOffset", "scopeNode", "Lcom/intellij/lang/ASTNode;", "node", "offsetInNode", "intellij.platform.indexing.impl"})
public final class LowLevelSearchUtilKt {
    @NotNull
    public static final Iterator<Pair<PsiElement, Integer>> elementsUp(@NotNull LeafOccurrence $this$elementsUp) {
        Intrinsics.checkNotNullParameter((Object)$this$elementsUp, (String)"<this>");
        return PsiTreeUtilKt.walkUp((PsiElement)$this$elementsUp.getStart(), (int)$this$elementsUp.getOffsetInStart(), (PsiElement)$this$elementsUp.getScope());
    }

    @NotNull
    public static final Function1<LeafOccurrence, Boolean> compound(@NotNull Collection<? extends Function1<? super LeafOccurrence, Boolean>> $this$compound, @NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter($this$compound, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Function1 function1 = (Function1)CollectionsKt.singleOrNull((Iterable)$this$compound);
        if (function1 != null) {
            Function1 it = function1;
            boolean bl = false;
            return it;
        }
        return arg_0 -> LowLevelSearchUtilKt.compound$lambda$1($this$compound, progress, arg_0);
    }

    public static final boolean runProcessors(@NotNull Collection<? extends Function1<? super LeafOccurrence, Boolean>> $this$runProcessors, @NotNull ProgressIndicator progress, @NotNull LeafOccurrence occurrence) {
        Intrinsics.checkNotNullParameter($this$runProcessors, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
        for (Function1<? super LeafOccurrence, Boolean> function1 : $this$runProcessors) {
            progress.checkCanceled();
            if (((Boolean)function1.invoke((Object)occurrence)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static final boolean processOffsets(@NotNull PsiElement scope, @NotNull int[] offsetsInScope, int patternLength, @NotNull ProgressIndicator progress, @NotNull Function1<? super LeafOccurrence, Boolean> processor) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)offsetsInScope, (String)"offsetsInScope");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        if (offsetsInScope.length == 0) {
            return true;
        }
        ASTNode aSTNode = scope.getNode();
        if (aSTNode == null) {
            boolean bl = false;
            String string = "Scope doesn't have node, can't scan: " + scope + "; containingFile: " + scope.getContainingFile();
            throw new IllegalArgumentException(string.toString());
        }
        ASTNode scopeNode = aSTNode;
        return LowLevelSearchUtil.processOffsets(scopeNode, offsetsInScope, progress, (arg_0, arg_1) -> LowLevelSearchUtilKt.processOffsets$lambda$1(scopeNode, patternLength, processor, arg_0, arg_1));
    }

    private static final boolean processOffset(ASTNode scopeNode, ASTNode node, int offsetInNode, int patternLength, Function1<? super LeafOccurrence, Boolean> processor) {
        ASTNode currentNode = node;
        int currentOffset = offsetInNode;
        while (true) {
            if (currentNode.getTextLength() >= currentOffset + patternLength) {
                PsiElement psiElement = scopeNode.getPsi();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
                PsiElement psiElement2 = currentNode.getPsi();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPsi(...)");
                return (Boolean)processor.invoke((Object)new LeafOccurrenceData(psiElement, psiElement2, currentOffset));
            }
            if (currentNode == scopeNode) {
                return true;
            }
            currentOffset += currentNode.getStartOffsetInParent();
            if (currentNode.getTreeParent() != null) continue;
            return true;
        }
    }

    private static final boolean compound$lambda$1(Collection $this_compound, ProgressIndicator $progress, LeafOccurrence occurrence) {
        Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
        return LowLevelSearchUtilKt.runProcessors($this_compound, $progress, occurrence);
    }

    private static final boolean processOffsets$lambda$1(ASTNode $scopeNode, int $patternLength, Function1 $processor, ASTNode node, int offsetInNode) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return LowLevelSearchUtilKt.processOffset($scopeNode, node, offsetInNode, $patternLength, (Function1<? super LeafOccurrence, Boolean>)$processor);
    }
}

