/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.flavor.FileIndexingFlavorProvider;
import com.intellij.util.indexing.flavor.HashBuilder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IndexedHashesSupport {
    private static final boolean SKIP_CONTENT_DEPENDENT_CHARSETS = SystemProperties.getBooleanProperty((String)"idea.index.hash.skip.content.dependent.charset", (boolean)true);
    private static final HashFunction INDEXED_FILE_CONTENT_HASHER = Hashing.sha1();
    public static final int HASH_SIZE_IN_BYTES = INDEXED_FILE_CONTENT_HASHER.bits() / 8;

    public static int getVersion() {
        return 3 + (SKIP_CONTENT_DEPENDENT_CHARSETS ? 1 : 0);
    }

    public static byte @NotNull [] getOrInitIndexedHash(@NotNull FileContentImpl content) {
        byte[] hash;
        if (content == null) {
            IndexedHashesSupport.$$$reportNull$$$0(0);
        }
        if ((hash = content.getIndexedFileHash()) != null) {
            if (hash == null) {
                IndexedHashesSupport.$$$reportNull$$$0(1);
            }
            return hash;
        }
        byte[] contentHash = IndexedHashesSupport.getBinaryContentHash(content.getContent());
        hash = IndexedHashesSupport.calculateIndexedHash((IndexedFile)content, contentHash);
        content.setIndexedFileHash(hash);
        if (hash == null) {
            IndexedHashesSupport.$$$reportNull$$$0(2);
        }
        return hash;
    }

    public static byte @NotNull [] getBinaryContentHash(byte @NotNull [] content) {
        if (content == null) {
            IndexedHashesSupport.$$$reportNull$$$0(3);
        }
        byte[] byArray = INDEXED_FILE_CONTENT_HASHER.hashBytes(content).asBytes();
        if (byArray == null) {
            IndexedHashesSupport.$$$reportNull$$$0(4);
        }
        return byArray;
    }

    public static byte @NotNull [] calculateIndexedHash(@NotNull IndexedFile indexedFile, byte @NotNull [] contentHash) {
        if (indexedFile == null) {
            IndexedHashesSupport.$$$reportNull$$$0(5);
        }
        if (contentHash == null) {
            IndexedHashesSupport.$$$reportNull$$$0(6);
        }
        final Hasher hasher = INDEXED_FILE_CONTENT_HASHER.newHasher();
        hasher.putBytes(contentHash);
        if (!FileContentImpl.getFileTypeWithoutSubstitution((IndexedFile)indexedFile).isBinary()) {
            if (!SKIP_CONTENT_DEPENDENT_CHARSETS) {
                charset = IndexedHashesSupport.getCharsetFromIndexedFile(indexedFile);
                hasher.putString((CharSequence)charset.name(), StandardCharsets.UTF_8);
            } else {
                charset = EncodingRegistry.getInstance().getEncoding(indexedFile.getFile(), true);
                if (charset != null) {
                    hasher.putString((CharSequence)charset.name(), StandardCharsets.UTF_8);
                }
            }
        }
        hasher.putString((CharSequence)indexedFile.getFileName(), StandardCharsets.UTF_8);
        FileType fileType = indexedFile.getFileType();
        hasher.putString((CharSequence)fileType.getName(), StandardCharsets.UTF_8);
        @Nullable FileIndexingFlavorProvider provider = (FileIndexingFlavorProvider)FileIndexingFlavorProvider.INSTANCE.forFileType(fileType);
        if (provider != null) {
            IndexedHashesSupport.buildFlavorHash(indexedFile, provider, new HashBuilder(){

                @NotNull
                public HashBuilder putInt(int val) {
                    hasher.putInt(val);
                    1 v0 = this;
                    if (v0 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return v0;
                }

                @NotNull
                public HashBuilder putBoolean(boolean val) {
                    hasher.putBoolean(val);
                    1 v0 = this;
                    if (v0 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return v0;
                }

                @NotNull
                public HashBuilder putString(@NotNull CharSequence charSequence) {
                    if (charSequence == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    hasher.putString(charSequence, StandardCharsets.UTF_8);
                    1 v0 = this;
                    if (v0 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return v0;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 2 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/util/indexing/IndexedHashesSupport$1";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "charSequence";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "putInt";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "putBoolean";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/util/indexing/IndexedHashesSupport$1";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "putString";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "putString";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 2 -> new IllegalArgumentException(string);
                    };
                }
            });
        }
        byte[] byArray = hasher.hash().asBytes();
        if (byArray == null) {
            IndexedHashesSupport.$$$reportNull$$$0(7);
        }
        return byArray;
    }

    @NotNull
    private static Charset getCharsetFromIndexedFile(@NotNull IndexedFile indexedFile) {
        if (indexedFile == null) {
            IndexedHashesSupport.$$$reportNull$$$0(8);
        }
        Charset charset = indexedFile instanceof FileContentImpl ? ((FileContentImpl)indexedFile).getCharset() : indexedFile.getFile().getCharset();
        if (charset == null) {
            IndexedHashesSupport.$$$reportNull$$$0(9);
        }
        return charset;
    }

    private static <F> void buildFlavorHash(@NotNull IndexedFile indexedFile, @NotNull FileIndexingFlavorProvider<F> flavorProvider, @NotNull HashBuilder hashBuilder) {
        if (indexedFile == null) {
            IndexedHashesSupport.$$$reportNull$$$0(10);
        }
        if (flavorProvider == null) {
            IndexedHashesSupport.$$$reportNull$$$0(11);
        }
        if (hashBuilder == null) {
            IndexedHashesSupport.$$$reportNull$$$0(12);
        }
        Object flavor = flavorProvider.getFlavor(indexedFile);
        hashBuilder.putString((CharSequence)flavorProvider.getId());
        hashBuilder.putInt(flavorProvider.getVersion());
        if (flavor != null) {
            flavorProvider.buildHash(flavor, hashBuilder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexedHashesSupport";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentHash";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavorProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexedHashesSupport";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrInitIndexedHash";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryContentHash";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateIndexedHash";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharsetFromIndexedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrInitIndexedHash";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryContentHash";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateIndexedHash";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCharsetFromIndexedFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildFlavorHash";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 7, 9 -> new IllegalStateException(string);
        };
    }
}

