/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.configurationStore;

import com.intellij.configurationStore.DataWriterFilter;
import com.intellij.configurationStore.DirectoryBasedStorage;
import com.intellij.configurationStore.ExternalStorageWithInternalPart;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.openapi.externalSystem.configurationStore.ExternalProjectFilteringStorage;
import com.intellij.openapi.externalSystem.configurationStore.ExternalProjectStorage;
import com.intellij.openapi.externalSystem.configurationStore.ExternalStorageSaveSessionProducer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000C\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0011\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/externalSystem/configurationStore/ExternalProjectFilteringStorage;", "Lcom/intellij/openapi/externalSystem/configurationStore/ExternalProjectStorage;", "Lcom/intellij/configurationStore/ExternalStorageWithInternalPart;", "fileSpec", "", "project", "Lcom/intellij/openapi/project/Project;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "componentName", "internalStorage", "Lcom/intellij/configurationStore/DirectoryBasedStorage;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/configurationStore/StateStorageManager;Ljava/lang/String;Lcom/intellij/configurationStore/DirectoryBasedStorage;)V", "getInternalStorage", "()Lcom/intellij/configurationStore/DirectoryBasedStorage;", "filter", "com/intellij/openapi/externalSystem/configurationStore/ExternalProjectFilteringStorage$filter$1", "Lcom/intellij/openapi/externalSystem/configurationStore/ExternalProjectFilteringStorage$filter$1;", "loadLocalData", "Lorg/jdom/Element;", "createSaveSession", "Lcom/intellij/configurationStore/SaveSessionProducer;", "states", "Lcom/intellij/configurationStore/StateMap;", "intellij.platform.externalSystem.impl"})
public final class ExternalProjectFilteringStorage
extends ExternalProjectStorage
implements ExternalStorageWithInternalPart {
    @NotNull
    private final String componentName;
    @NotNull
    private final DirectoryBasedStorage internalStorage;
    @NotNull
    private final filter.1 filter;

    public ExternalProjectFilteringStorage(@NotNull String fileSpec, @NotNull Project project, @NotNull StateStorageManager storageManager, @NotNull String componentName, @NotNull DirectoryBasedStorage internalStorage) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)internalStorage, (String)"internalStorage");
        super(fileSpec, project, storageManager, null);
        this.componentName = componentName;
        this.internalStorage = internalStorage;
        this.filter = new DataWriterFilter(){
            private final JDOMUtil.ElementOutputFilter elementOutputFilter;
            {
                this.elementOutputFilter = filter.1::elementOutputFilter$lambda$0;
            }

            public JDOMUtil.ElementOutputFilter toElementFilter() {
                return this.elementOutputFilter;
            }

            public boolean hasData(Element element) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    List list = element.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            Element it = (Element)element$iv;
                            boolean bl2 = false;
                            if (!this.elementOutputFilter.accept(it, 1)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            private static final boolean elementOutputFilter$lambda$0(Element childElement, int level) {
                Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
                return level != DataWriterFilter.ElementLevel.FIRST.ordinal() || childElement.getAttribute("__external-system-id") != null;
            }
        };
    }

    @NotNull
    public DirectoryBasedStorage getInternalStorage() {
        return this.internalStorage;
    }

    @Override
    @Nullable
    protected Element loadLocalData() {
        return JDOMUtil.merge((Element)super.loadLocalData(), (Element)this.getInternalStorage().getSerializedState(this.getInternalStorage().loadData(), null, this.componentName, true));
    }

    @Override
    @NotNull
    protected SaveSessionProducer createSaveSession(@NotNull StateMap states) {
        Intrinsics.checkNotNullParameter((Object)states, (String)"states");
        return (SaveSessionProducer)new ExternalStorageSaveSessionProducer(states, this, this.getManager$intellij_platform_externalSystem_impl().getFileStorage(), this.fileSpec, this.filter);
    }
}

