/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.EventQueueImpl;
import com.jetbrains.jdi.EventSetImpl;
import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.Packet;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.InternalException;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.spi.Connection;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TargetVM {
    private final Map<Integer, Packet> waitingQueue = new HashMap<Integer, Packet>(32, 0.75f);
    private volatile boolean shouldListen = true;
    private final List<EventQueue> eventQueues = Collections.synchronizedList(new ArrayList(2));
    private final VirtualMachineImpl vm;
    private final Connection connection;
    private final Thread readerThread;
    private EventController eventController = null;
    private boolean eventsHeld = false;
    private CompletableFuture<Long> latencyRequest = null;
    final ExecutorService asyncExecutor;
    private static final int OVERLOADED_QUEUE = 10000;
    private static final int UNDERLOADED_QUEUE = 100;

    TargetVM(VirtualMachineImpl vm, Connection connection) {
        this.vm = vm;
        this.connection = connection;
        this.readerThread = new ReaderThread();
        this.asyncExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread thread = new Thread(vm.threadGroupForJDI(), r, "JDI Target Async Processor");
            thread.setDaemon(true);
            return thread;
        }, (r, executor) -> {
            throw new VMDisconnectedException();
        });
    }

    void start() {
        this.readerThread.start();
    }

    private void dumpPacket(Packet packet, boolean sending) {
        String direction;
        String string = direction = sending ? "Sending" : "Receiving";
        if (sending) {
            this.vm.printTrace(direction + " Command. id=" + packet.id + ", length=" + packet.data.length + ", commandSet=" + packet.cmdSet + ", command=" + packet.cmd + ", flags=" + packet.flags);
        } else {
            String type = (packet.flags & 0x80) != 0 ? "Reply" : "Event";
            this.vm.printTrace(direction + " " + type + ". id=" + packet.id + ", length=" + packet.data.length + ", errorCode=" + packet.errorCode + ", flags=" + packet.flags);
        }
        StringBuilder line = new StringBuilder(80);
        line.append("0000: ");
        for (int i = 0; i < packet.data.length; ++i) {
            int val;
            String str;
            if (i > 0 && i % 16 == 0) {
                this.vm.printTrace(line.toString());
                line.setLength(0);
                line.append(i);
                line.append(": ");
                int len = line.length();
                for (int j = 0; j < 6 - len; ++j) {
                    line.insert(0, '0');
                }
            }
            if ((str = Integer.toHexString(val = 0xFF & packet.data[i])).length() == 1) {
                line.append('0');
            }
            line.append(str);
            line.append(' ');
        }
        if (line.length() > 6) {
            this.vm.printTrace(line.toString());
        }
    }

    protected void handleVMCommand(Packet p) {
        switch (p.cmdSet) {
            case 64: {
                this.handleEventCmdSet(p);
                break;
            }
            default: {
                System.err.println("Ignoring cmd " + p.id + "/" + p.cmdSet + "/" + p.cmd + " from the VM");
            }
        }
    }

    protected void handleEventCmdSet(Packet p) {
        EventSetImpl eventSet = new EventSetImpl((VirtualMachine)this.vm, p);
        this.queueEventSet(eventSet);
    }

    private EventController eventController() {
        if (this.eventController == null) {
            this.eventController = new EventController();
        }
        return this.eventController;
    }

    private synchronized void controlEventFlow(int maxQueueSize) {
        if (!this.eventsHeld && maxQueueSize > 10000) {
            this.eventController().hold();
            this.eventsHeld = true;
        } else if (this.eventsHeld && maxQueueSize < 100) {
            this.eventController().release();
            this.eventsHeld = false;
        }
    }

    void notifyDequeueEventSet() {
        this.controlEventFlow(this.getMaxQueueSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaxQueueSize() {
        int maxQueueSize = 0;
        List<EventQueue> list = this.eventQueues;
        synchronized (list) {
            for (EventQueue eventQueue : this.eventQueues) {
                maxQueueSize = Math.max(maxQueueSize, ((EventQueueImpl)eventQueue).size());
            }
        }
        return maxQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isIdle() {
        Map<Integer, Packet> map2 = this.waitingQueue;
        synchronized (map2) {
            if (!this.waitingQueue.isEmpty()) {
                return false;
            }
        }
        return this.getMaxQueueSize() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueEventSet(EventSet eventSet) {
        int maxQueueSize = 0;
        List<EventQueue> list = this.eventQueues;
        synchronized (list) {
            for (EventQueue eventQueue : this.eventQueues) {
                EventQueueImpl queue = (EventQueueImpl)eventQueue;
                queue.enqueue(eventSet);
                maxQueueSize = Math.max(maxQueueSize, queue.size());
            }
        }
        this.controlEventFlow(maxQueueSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(Packet packet) {
        Map<Integer, Packet> map2 = this.waitingQueue;
        synchronized (map2) {
            this.waitingQueue.put(packet.id, packet);
            CompletableFuture<Long> request = this.latencyRequest;
            if (request != null) {
                this.latencyRequest = null;
                long start = System.currentTimeMillis();
                packet.reply.thenRun(() -> request.complete(System.currentTimeMillis() - start));
            }
        }
        if ((this.vm.traceFlags & 0x1000000) != 0) {
            this.dumpPacket(packet, true);
        }
        try {
            this.connection.writePacket(packet.toByteArray());
        }
        catch (IOException e) {
            throw new VMDisconnectedException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForReply(Packet packet) {
        if (Thread.currentThread() == this.readerThread) {
            throw new InternalException("waitForReply in reader thread");
        }
        Packet packet2 = packet;
        synchronized (packet2) {
            while (!packet.replied && this.shouldListen) {
                try {
                    packet.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!packet.replied) {
                throw new VMDisconnectedException();
            }
        }
    }

    void addEventQueue(EventQueueImpl queue) {
        if ((this.vm.traceFlags & 4) != 0) {
            this.vm.printTrace("New event queue added");
        }
        this.eventQueues.add(queue);
    }

    void stopListening() {
        if ((this.vm.traceFlags & 4) != 0) {
            this.vm.printTrace("Target VM i/f closing event queues");
        }
        this.shouldListen = false;
        try {
            this.connection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Long> measureLatency() {
        Map<Integer, Packet> map2 = this.waitingQueue;
        synchronized (map2) {
            if (this.latencyRequest == null) {
                this.latencyRequest = new CompletableFuture();
            }
            return this.latencyRequest;
        }
    }

    private class EventController
    extends Thread {
        int controlRequest;

        EventController() {
            super(TargetVM.this.vm.threadGroupForJDI(), "JDI Event Control Thread");
            this.controlRequest = 0;
            this.setDaemon(true);
            this.setPriority(7);
            super.start();
        }

        synchronized void hold() {
            ++this.controlRequest;
            this.notifyAll();
        }

        synchronized void release() {
            --this.controlRequest;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                int currentRequest;
                EventController eventController = this;
                synchronized (eventController) {
                    while (this.controlRequest == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (TargetVM.this.shouldListen) continue;
                        return;
                    }
                    currentRequest = this.controlRequest;
                    this.controlRequest = 0;
                }
                try {
                    if (currentRequest > 0) {
                        JDWP.VirtualMachine.HoldEvents.process(TargetVM.this.vm);
                        continue;
                    }
                    JDWP.VirtualMachine.ReleaseEvents.process(TargetVM.this.vm);
                    continue;
                }
                catch (JDWPException e) {
                    e.toJDIException().printStackTrace(System.err);
                    continue;
                }
                break;
            }
        }
    }

    class ReaderThread
    extends Thread {
        public ReaderThread() {
            super(TargetVM.this.vm.threadGroupForJDI(), "JDI Target VM Interface");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if ((TargetVM.this.vm.traceFlags & 1) != 0) {
                TargetVM.this.vm.printTrace("Target VM interface thread running");
            }
            Packet p = null;
            while (TargetVM.this.shouldListen) {
                Packet p2;
                boolean done = false;
                try {
                    byte[] b = TargetVM.this.connection.readPacket();
                    if (b.length == 0) {
                        done = true;
                    } else {
                        p = Packet.fromByteArray(b);
                    }
                }
                catch (IOException e) {
                    done = true;
                }
                if (done) {
                    TargetVM.this.shouldListen = false;
                    try {
                        TargetVM.this.connection.close();
                    }
                    catch (IOException iOException) {}
                    break;
                }
                if ((TargetVM.this.vm.traceFlags & 0x2000000) != 0) {
                    TargetVM.this.dumpPacket(p, false);
                }
                if ((p.flags & 0x80) == 0) {
                    TargetVM.this.handleVMCommand(p);
                    continue;
                }
                TargetVM.this.vm.state().notifyCommandComplete(p.id);
                Map<Integer, Packet> map2 = TargetVM.this.waitingQueue;
                synchronized (map2) {
                    p2 = TargetVM.this.waitingQueue.get(p.id);
                }
                if (p2 == null) {
                    System.err.println("Received reply 0x" + Integer.toHexString(p.id) + " with no sender!");
                    continue;
                }
                p2.errorCode = p.errorCode;
                p2.data = p.data;
                p2.replied = true;
                p2.notifyReplied();
                map2 = TargetVM.this.waitingQueue;
                synchronized (map2) {
                    TargetVM.this.waitingQueue.remove(p.id);
                }
            }
            TargetVM.this.vm.vmManager.disposeVirtualMachine(TargetVM.this.vm);
            if (TargetVM.this.eventController != null) {
                TargetVM.this.eventController.release();
            }
            Object object = TargetVM.this.eventQueues;
            synchronized (object) {
                for (EventQueue eventQueue : TargetVM.this.eventQueues) {
                    ((EventQueueImpl)eventQueue).close();
                }
            }
            object = TargetVM.this.waitingQueue;
            synchronized (object) {
                TargetVM.this.waitingQueue.values().forEach(Packet::notifyReplied);
                TargetVM.this.waitingQueue.clear();
            }
            if (TargetVM.this.asyncExecutor != null) {
                TargetVM.this.asyncExecutor.shutdown();
            }
            if ((TargetVM.this.vm.traceFlags & 1) != 0) {
                TargetVM.this.vm.printTrace("Target VM interface thread exiting");
            }
        }
    }
}

