/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.RootEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ClassicOrderRootComputer;
import com.intellij.openapi.roots.impl.MutliverseOrderRootComputer;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

class OrderRootsEnumeratorImpl
implements OrderRootsEnumerator {
    private static final Logger LOG = Logger.getInstance(OrderRootsEnumeratorImpl.class);
    private final OrderEnumeratorBase myOrderEnumerator;
    private final OrderRootType myRootType;
    private final NotNullFunction<? super OrderEntry, ? extends OrderRootType> myRootTypeProvider;
    private boolean myUsingCache;
    private NotNullFunction<? super JdkOrderEntry, VirtualFile[]> myCustomSdkRootProvider;
    private boolean myWithoutSelfModuleOutput;

    OrderRootsEnumeratorImpl(@NotNull OrderEnumeratorBase orderEnumerator, @NotNull OrderRootType rootType) {
        if (orderEnumerator == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(0);
        }
        if (rootType == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(1);
        }
        this.myOrderEnumerator = orderEnumerator;
        this.myRootType = rootType;
        this.myRootTypeProvider = null;
    }

    OrderRootsEnumeratorImpl(@NotNull OrderEnumeratorBase orderEnumerator, @NotNull NotNullFunction<? super OrderEntry, ? extends OrderRootType> rootTypeProvider) {
        if (orderEnumerator == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(2);
        }
        if (rootTypeProvider == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(3);
        }
        this.myOrderEnumerator = orderEnumerator;
        this.myRootType = null;
        this.myRootTypeProvider = rootTypeProvider;
    }

    public VirtualFile @NotNull [] getRoots() {
        if (this.myUsingCache) {
            this.checkCanUseCache();
            OrderRootsCache cache = this.myOrderEnumerator.getCache();
            int flags = this.myOrderEnumerator.getFlags();
            VirtualFile[] virtualFileArray = cache.getOrComputeRoots(this.myRootType, flags, this::computeRootsUrls);
            if (virtualFileArray == null) {
                OrderRootsEnumeratorImpl.$$$reportNull$$$0(4);
            }
            return virtualFileArray;
        }
        ClassicOrderRootComputer computer = new ClassicOrderRootComputer(this.myOrderEnumerator, this::getRootType, this.myCustomSdkRootProvider, this.myWithoutSelfModuleOutput);
        Collection roots = computer.computeRoots();
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(roots);
        if (virtualFileArray == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(5);
        }
        return virtualFileArray;
    }

    @NotNull
    public Collection<RootEntry> getRootEntries() {
        Collection<RootEntry> entries;
        MutliverseOrderRootComputer computer = new MutliverseOrderRootComputer(this.myOrderEnumerator, this::getRootType, this.myCustomSdkRootProvider, this.myWithoutSelfModuleOutput);
        Collection<RootEntry> collection = entries = computer.computeRoots();
        if (collection == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public String @NotNull [] getUrls() {
        if (this.myUsingCache) {
            this.checkCanUseCache();
            OrderRootsCache cache = this.myOrderEnumerator.getCache();
            int flags = this.myOrderEnumerator.getFlags();
            String[] stringArray = cache.getOrComputeUrls(this.myRootType, flags, this::computeRootsUrls);
            if (stringArray == null) {
                OrderRootsEnumeratorImpl.$$$reportNull$$$0(7);
            }
            return stringArray;
        }
        String[] stringArray = ArrayUtilRt.toStringArray(this.computeRootsUrls());
        if (stringArray == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    private void checkCanUseCache() {
        LOG.assertTrue(this.myRootTypeProvider == null, (Object)"Caching not supported for OrderRootsEnumerator with root type provider");
        LOG.assertTrue(this.myCustomSdkRootProvider == null, (Object)"Caching not supported for OrderRootsEnumerator with 'usingCustomSdkRootProvider' option");
        LOG.assertTrue(!this.myWithoutSelfModuleOutput, (Object)"Caching not supported for OrderRootsEnumerator with 'withoutSelfModuleOutput' option");
    }

    @NotNull
    private Collection<String> computeRootsUrls() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.myOrderEnumerator.forEach((PairProcessor<? super OrderEntry, ? super List<? extends OrderEnumerationHandler>>)((PairProcessor)(orderEntry, customHandlers) -> {
            OrderRootType type = this.getRootType((OrderEntry)orderEntry);
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                ModuleRootModel rootModel = ((ModuleSourceOrderEntry)orderEntry).getRootModel();
                boolean includeTests = !this.myOrderEnumerator.isProductionOnly() && (OrderEnumeratorBase.shouldIncludeTestsFromDependentModulesToTestClasspath(customHandlers) || this.myOrderEnumerator.isRootModuleModel(rootModel));
                this.collectModuleRootsUrls(type, rootModel, (Collection<String>)result, true, includeTests, (List<? extends OrderEnumerationHandler>)customHandlers);
            } else if (orderEntry instanceof ModuleOrderEntry) {
                ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                Module module = moduleOrderEntry.getModule();
                if (module != null) {
                    ModuleRootModel rootModel = this.myOrderEnumerator.getRootModel(module);
                    boolean productionOnTests = ((ModuleOrderEntry)orderEntry).isProductionOnTestDependency();
                    boolean includeTests = !this.myOrderEnumerator.isProductionOnly() && OrderEnumeratorBase.shouldIncludeTestsFromDependentModulesToTestClasspath(customHandlers) || productionOnTests;
                    this.collectModuleRootsUrls(type, rootModel, (Collection<String>)result, !productionOnTests, includeTests, (List<? extends OrderEnumerationHandler>)customHandlers);
                }
            } else if (orderEntry instanceof LibraryOrSdkOrderEntry) {
                if (OrderEnumeratorBase.addCustomRootUrlsForLibraryOrSdk((LibraryOrSdkOrderEntry)orderEntry, type, result, customHandlers)) {
                    return true;
                }
                Collections.addAll(result, ((LibraryOrSdkOrderEntry)orderEntry).getRootUrls(type));
            } else {
                LOG.error("Unexpected implementation of OrderEntry: " + orderEntry.getClass().getName());
            }
            return true;
        }));
        LinkedHashSet<String> linkedHashSet = result;
        if (linkedHashSet == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(9);
        }
        return linkedHashSet;
    }

    @NotNull
    public PathsList getPathsList() {
        PathsList list = new PathsList();
        this.collectPaths(list);
        PathsList pathsList = list;
        if (pathsList == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(10);
        }
        return pathsList;
    }

    public void collectPaths(@NotNull PathsList list) {
        if (list == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(11);
        }
        list.addVirtualFiles(this.getRoots());
    }

    @NotNull
    public OrderRootsEnumerator usingCache() {
        this.myUsingCache = true;
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = this;
        if (orderRootsEnumeratorImpl == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(12);
        }
        return orderRootsEnumeratorImpl;
    }

    @NotNull
    public OrderRootsEnumerator withoutSelfModuleOutput() {
        this.myWithoutSelfModuleOutput = true;
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = this;
        if (orderRootsEnumeratorImpl == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(13);
        }
        return orderRootsEnumeratorImpl;
    }

    @NotNull
    public OrderRootsEnumerator usingCustomSdkRootProvider(@NotNull NotNullFunction<? super JdkOrderEntry, VirtualFile[]> provider) {
        if (provider == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(14);
        }
        this.myCustomSdkRootProvider = provider;
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = this;
        if (orderRootsEnumeratorImpl == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(15);
        }
        return orderRootsEnumeratorImpl;
    }

    private void collectModuleRootsUrls(@NotNull OrderRootType type, @NotNull ModuleRootModel rootModel, @NotNull Collection<String> result, boolean includeProduction, boolean includeTests, @NotNull List<? extends OrderEnumerationHandler> customHandlers) {
        if (type == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(16);
        }
        if (rootModel == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(17);
        }
        if (result == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(18);
        }
        if (customHandlers == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(19);
        }
        if (type.equals((Object)OrderRootType.SOURCES)) {
            if (includeProduction) {
                Collections.addAll(result, rootModel.getSourceRootUrls(includeTests));
            } else {
                for (ContentEntry entry : rootModel.getContentEntries()) {
                    for (SourceFolder folder : entry.getSourceFolders(JavaModuleSourceRootTypes.TESTS)) {
                        result.add(folder.getUrl());
                    }
                }
            }
        } else if (type.equals((Object)OrderRootType.CLASSES)) {
            boolean hasTests = false;
            boolean hasProduction = false;
            for (ContentEntry contentEntry : rootModel.getContentEntries()) {
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                    if (sourceFolder.isTestSource()) {
                        hasTests = true;
                        continue;
                    }
                    hasProduction = true;
                }
            }
            includeTests &= hasTests;
            includeProduction &= hasProduction;
            CompilerModuleExtension extension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class);
            if (extension != null) {
                if (this.myWithoutSelfModuleOutput && this.myOrderEnumerator.isRootModuleModel(rootModel)) {
                    if (includeTests && includeProduction) {
                        Collections.addAll(result, extension.getOutputRootUrls(false));
                    }
                } else if (includeProduction) {
                    Collections.addAll(result, extension.getOutputRootUrls(includeTests));
                } else if (includeTests) {
                    ContainerUtil.addIfNotNull(result, (Object)extension.getCompilerOutputUrlForTests());
                }
            }
        }
        OrderEnumeratorBase.addCustomRootsUrlsForModule(type, rootModel, result, includeProduction, includeTests, customHandlers);
    }

    @NotNull
    private OrderRootType getRootType(@NotNull OrderEntry e) {
        if (e == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(20);
        }
        OrderRootType orderRootType = this.myRootType != null ? this.myRootType : (OrderRootType)this.myRootTypeProvider.fun((Object)e);
        if (orderRootType == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(21);
        }
        return orderRootType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 10, 12, 13, 15, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEnumerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypeProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customHandlers";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootEntries";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootsUrls";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "usingCache";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutSelfModuleOutput";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "usingCustomSdkRootProvider";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 21: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectPaths";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "usingCustomSdkRootProvider";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectModuleRootsUrls";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getRootType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 10, 12, 13, 15, 21 -> new IllegalStateException(string);
        };
    }
}

