/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class RootFileValidityChecker {
    private static final Logger LOG = Logger.getInstance(RootFileValidityChecker.class);

    public static boolean ensureValid(@NotNull VirtualFile file, @NotNull Object container, @Nullable Object containerProvider) {
        if (file == null) {
            RootFileValidityChecker.$$$reportNull$$$0(0);
        }
        if (container == null) {
            RootFileValidityChecker.$$$reportNull$$$0(1);
        }
        if (!file.isValid()) {
            if (containerProvider != null) {
                Class<?> providerClass = containerProvider.getClass();
                PluginException.logPluginError((Logger)LOG, (String)("Invalid root " + String.valueOf(file) + " in " + String.valueOf(container) + " provided by " + String.valueOf(providerClass)), null, providerClass);
            } else {
                LOG.error("Invalid root " + String.valueOf(file) + " in " + String.valueOf(container));
            }
            return false;
        }
        return true;
    }

    @Nullable
    public static VirtualFile correctRoot(@NotNull VirtualFile file, @NotNull Object container, @Nullable Object containerProvider) {
        if (file == null) {
            RootFileValidityChecker.$$$reportNull$$$0(2);
        }
        if (container == null) {
            RootFileValidityChecker.$$$reportNull$$$0(3);
        }
        if (!RootFileValidityChecker.ensureValid(file, container, containerProvider)) {
            return null;
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/impl/RootFileValidityChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureValid";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "correctRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

