/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.platform.workspace.storage.impl.url.VirtualFileUrlImpl;
import com.intellij.platform.workspace.storage.impl.url.VirtualFileUrlManagerImpl;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u00020\u0012H\u0096\u0080\u0004J\u0014\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0082\u0004J\n\u0010\u0016\u001a\u00020\u0004H\u0096\u0080\u0004J\n\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0002R\"\u0010\t\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/workspaceModel/ide/impl/VirtualFileUrlBridge;", "Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlImpl;", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "id", "", "manager", "Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl;", "<init>", "(ILcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl;)V", "cachedFile", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "getFile", "isValid", "", "toString", "", "equals", "other", "", "hashCode", "findVirtualFile", "intellij.platform.projectModel.impl"})
@ApiStatus.Internal
public final class VirtualFileUrlBridge
extends VirtualFileUrlImpl
implements VirtualFilePointer {
    @NotNull
    private final AtomicReference<Pair<VirtualFile, Long>> cachedFile;

    public VirtualFileUrlBridge(int id, @NotNull VirtualFileUrlManagerImpl manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        super(id, manager);
        this.cachedFile = new AtomicReference<Pair>(new Pair(null, (Object)-1L));
    }

    @Nullable
    public VirtualFile getFile() {
        return this.findVirtualFile();
    }

    public boolean isValid() {
        return this.findVirtualFile() != null;
    }

    @NotNull
    public String toString() {
        return this.getUrl();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.VirtualFileUrlBridge");
        VirtualFileUrlBridge cfr_ignored_0 = (VirtualFileUrlBridge)((Object)object2);
        return this.getId() == ((VirtualFileUrlBridge)((Object)other)).getId();
    }

    public int hashCode() {
        return this.getId();
    }

    private final VirtualFile findVirtualFile() {
        VirtualFile virtualFile;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFileManager fileManager = virtualFileManager;
        Pair<VirtualFile, Long> cached = this.cachedFile.get();
        long timestamp = ((Number)cached.getSecond()).longValue();
        VirtualFile cachedResults = (VirtualFile)cached.getFirst();
        if (timestamp == fileManager.getModificationCount()) {
            virtualFile = cachedResults;
        } else {
            long modCounterBefore = fileManager.getModificationCount();
            VirtualFile file = fileManager.findFileByUrl(this.getUrl());
            long modCounterAfter = fileManager.getModificationCount();
            if (modCounterBefore == modCounterAfter) {
                this.cachedFile.set((Pair<VirtualFile, Long>)new Pair((Object)file, (Object)modCounterAfter));
            }
            virtualFile = file;
        }
        return virtualFile;
    }
}

