/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.attach.dialog.items.cells;

import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.impl.ui.attach.dialog.AttachDialogUtilsKt;
import com.intellij.xdebugger.impl.ui.attach.dialog.items.columns.AttachDialogColumnsLayout;
import java.awt.FontMetrics;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0003H%J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\rH\u0016J&\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u001b\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/cells/AttachTableCell;", "", "columnKey", "", "columnsLayout", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/columns/AttachDialogColumnsLayout;", "<init>", "(Ljava/lang/String;Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/columns/AttachDialogColumnsLayout;)V", "getColumnKey", "()Ljava/lang/String;", "getColumnsLayout", "()Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/columns/AttachDialogColumnsLayout;", "myLastKnownWidth", "", "myLastKnownDisplayText", "getTextToDisplay", "getIcon", "Ljavax/swing/Icon;", "getTag", "getTextStartOffset", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "getTextAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "getAlignment", "getPresentation", "Lkotlin/Pair;", "offset", "Companion", "intellij.platform.debugger.impl"})
public abstract class AttachTableCell {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String columnKey;
    @NotNull
    private final AttachDialogColumnsLayout columnsLayout;
    private int myLastKnownWidth;
    @NotNull
    private String myLastKnownDisplayText;

    public AttachTableCell(@NotNull String columnKey, @NotNull AttachDialogColumnsLayout columnsLayout) {
        Intrinsics.checkNotNullParameter((Object)columnKey, (String)"columnKey");
        Intrinsics.checkNotNullParameter((Object)columnsLayout, (String)"columnsLayout");
        this.columnKey = columnKey;
        this.columnsLayout = columnsLayout;
        this.myLastKnownWidth = -1;
        this.myLastKnownDisplayText = "";
    }

    @NotNull
    public final String getColumnKey() {
        return this.columnKey;
    }

    @NotNull
    public final AttachDialogColumnsLayout getColumnsLayout() {
        return this.columnsLayout;
    }

    @Nls
    @NotNull
    protected abstract String getTextToDisplay();

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    public Object getTag() {
        return null;
    }

    public int getTextStartOffset(@NotNull SimpleColoredComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return 0;
    }

    @NotNull
    public SimpleTextAttributes getTextAttributes() {
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SIMPLE_CELL_ATTRIBUTES");
        return simpleTextAttributes;
    }

    public int getAlignment() {
        return 2;
    }

    @NotNull
    public final Pair<String, String> getPresentation(@NotNull SimpleColoredComponent component, int offset) {
        String string;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        int width = this.columnsLayout.getColumnWidth(this.columnKey) - this.getTextStartOffset(component) - Companion.getIGNORE_EXPAND_HANDLER_GAP();
        String text = this.getTextToDisplay();
        if (this.myLastKnownWidth != width) {
            FontMetrics fontMetrics = component.getFontMetrics(AttachDialogUtilsKt.getComponentFont((JComponent)component));
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
            this.myLastKnownDisplayText = AttachDialogUtilsKt.getProcessName(text, fontMetrics, width - offset);
        }
        if (!Intrinsics.areEqual((Object)text, (Object)this.myLastKnownDisplayText)) {
            HtmlChunk[] htmlChunkArray = new HtmlChunk[]{HtmlChunk.div((String)"font-weight:bold;").child(HtmlChunk.text((String)this.columnsLayout.getColumnName(this.columnKey))), HtmlChunk.br(), HtmlChunk.text((String)text)};
            string = HtmlChunk.html().children(htmlChunkArray).toString();
        } else {
            string = null;
        }
        return new Pair((Object)this.myLastKnownDisplayText, string);
    }

    public static /* synthetic */ Pair getPresentation$default(AttachTableCell attachTableCell, SimpleColoredComponent simpleColoredComponent, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPresentation");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return attachTableCell.getPresentation(simpleColoredComponent, n);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/cells/AttachTableCell$Companion;", "", "<init>", "()V", "IGNORE_EXPAND_HANDLER_GAP", "", "getIGNORE_EXPAND_HANDLER_GAP", "()I", "intellij.platform.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final int getIGNORE_EXPAND_HANDLER_GAP() {
            return JBUI.scale((int)10);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

