/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLoweringKt;
import org.jetbrains.kotlin.backend.common.phaser.PhasePrerequisites;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;

@PhasePrerequisites(value={LocalDeclarationsLowering.class})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationPopupLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "shouldPopUp", "", "declaration", "currentScope", "Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "ExtractedLocalDeclaration", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nLocalDeclarationPopupLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDeclarationPopupLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LocalDeclarationPopupLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public class LocalDeclarationPopupLowering
implements BodyLoweringPass {
    @NotNull
    private final LoweringContext context;

    public LocalDeclarationPopupLowering(@NotNull LoweringContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final LoweringContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        LowerKt.runOnFilePostfix(this, irFile, true);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        ArrayList<ExtractedLocalDeclaration> extractedLocalDeclarations = new ArrayList<ExtractedLocalDeclaration>();
        irBody.transform((IrTransformer)new IrElementTransformerVoidWithContext(container, this, extractedLocalDeclarations){
            final /* synthetic */ IrDeclaration $container;
            final /* synthetic */ LocalDeclarationPopupLowering this$0;
            final /* synthetic */ ArrayList<ExtractedLocalDeclaration> $extractedLocalDeclarations;
            {
                this.$container = $container;
                this.this$0 = $receiver;
                this.$extractedLocalDeclarations = $extractedLocalDeclarations;
            }

            public IrStatement visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration) {
                IrVariable delegate;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                IrElementsKt.transformStatement(declaration.getGetter(), this);
                IrSimpleFunction irSimpleFunction = declaration.getSetter();
                if (irSimpleFunction != null) {
                    IrElementsKt.transformStatement(irSimpleFunction, this);
                }
                if ((delegate = declaration.getDelegate()) == null) {
                    boolean bl = false;
                    String string = "Local delegated property " + RenderIrElementKt.render$default(declaration, null, 1, null) + " has no delegate";
                    throw new IllegalArgumentException(string.toString());
                }
                return IrElementsKt.transformStatement(delegate, this);
            }

            public IrExpression visitRichFunctionReference(IrRichFunctionReference expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                TransformKt.transformInPlace(expression.getBoundValues(), (IrTransformer)this, null);
                this.transformChildrenVoid(expression.getInvokeFunction());
                return expression;
            }

            public IrStatement visitClassNew(IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                return this.visitClassOrFunction(declaration);
            }

            public IrStatement visitSimpleFunction(IrSimpleFunction declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                return this.visitClassOrFunction(declaration);
            }

            private final IrStatement visitClassOrFunction(IrDeclaration declaration) {
                ScopeWithIr currentScope;
                ScopeWithIr scopeWithIr;
                if (this.getAllScopes().size() > 1) {
                    scopeWithIr = this.getAllScopes().get(CollectionsKt.getLastIndex(this.getAllScopes()) - 1);
                } else {
                    IrDeclaration irDeclaration = this.$container;
                    Intrinsics.checkNotNull((Object)irDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
                    scopeWithIr = currentScope = this.createScope(irDeclaration);
                }
                if (!this.this$0.shouldPopUp(declaration, currentScope)) {
                    return declaration;
                }
                IrStatement extractedUnder = declaration;
                IrDeclarationParent newContainer = null;
                newContainer = declaration.getParent();
                while (newContainer instanceof IrDeclaration && !(newContainer instanceof IrClass) && !(newContainer instanceof IrScript)) {
                    extractedUnder = (IrStatement)((Object)newContainer);
                    newContainer = ((IrDeclaration)((Object)newContainer)).getParent();
                }
                IrDeclarationParent irDeclarationParent = newContainer;
                if (irDeclarationParent instanceof IrStatementContainer) {
                    if (Intrinsics.areEqual((Object)extractedUnder, (Object)declaration)) {
                        IrStatement irStatement;
                        Integer n;
                        Integer n2 = ((IrStatementContainer)((Object)newContainer)).getStatements().indexOf(extractedUnder) + 1;
                        int it = ((Number)n2).intValue();
                        boolean bl = false;
                        Integer n3 = n = it > 0 && it < ((IrStatementContainer)((Object)newContainer)).getStatements().size() ? n2 : null;
                        if (n != null) {
                            it = ((Number)n).intValue();
                            boolean bl2 = false;
                            irStatement = ((IrStatementContainer)((Object)newContainer)).getStatements().get(it);
                        } else {
                            irStatement = null;
                        }
                        extractedUnder = irStatement;
                    }
                    ((Collection)this.$extractedLocalDeclarations).add(new ExtractedLocalDeclaration(declaration, newContainer, extractedUnder));
                } else if (irDeclarationParent instanceof IrDeclarationContainer) {
                    ((Collection)this.$extractedLocalDeclarations).add(new ExtractedLocalDeclaration(declaration, newContainer, extractedUnder));
                } else {
                    throw new IllegalStateException(("Unexpected container type " + newContainer).toString());
                }
                return BuildersKt.IrCompositeImpl$default(declaration.getStartOffset(), declaration.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getUnitType(), null, 8, null);
            }
        }, (Object)null);
        Iterator<ExtractedLocalDeclaration> iterator = extractedLocalDeclarations.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<ExtractedLocalDeclaration> iterator2 = iterator;
        while (iterator2.hasNext()) {
            ExtractedLocalDeclaration extractedLocalDeclaration;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            IrDeclaration local = extractedLocalDeclaration.component1();
            IrDeclarationParent newContainer = extractedLocalDeclaration.component2();
            IrStatement extractedUnder = extractedLocalDeclaration.component3();
            IrDeclarationParent irDeclarationParent = newContainer;
            if (irDeclarationParent instanceof IrStatementContainer) {
                int insertIndex;
                int n;
                if (extractedUnder != null) {
                    IrStatement it;
                    boolean bl = false;
                    n = ((IrStatementContainer)((Object)newContainer)).getStatements().indexOf(it);
                } else {
                    n = insertIndex = -1;
                }
                if (insertIndex >= 0) {
                    ((IrStatementContainer)((Object)newContainer)).getStatements().add(insertIndex, local);
                } else {
                    ((IrStatementContainer)((Object)newContainer)).getStatements().add(local);
                }
                IrUtilsKt.setDeclarationsParent((IrElement)local, newContainer);
                continue;
            }
            if (irDeclarationParent instanceof IrDeclarationContainer) {
                IrUtilsKt.addChild((IrDeclarationContainer)newContainer, local);
                continue;
            }
            throw new IllegalStateException(("Unexpected container type " + newContainer).toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean shouldPopUp(@NotNull IrDeclaration declaration, @Nullable ScopeWithIr currentScope) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (AdditionalIrUtilsKt.isOriginallyLocalDeclaration(declaration)) return true;
        if (!(declaration instanceof IrClass)) return false;
        IrClass irClass = (IrClass)declaration;
        if (irClass == null) return false;
        if (!LocalDeclarationsLoweringKt.isLocalNotInner(irClass)) return false;
        return true;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationPopupLowering$ExtractedLocalDeclaration;", "", "local", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "newContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "extractedUnder", "Lorg/jetbrains/kotlin/ir/IrStatement;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;Lorg/jetbrains/kotlin/ir/IrStatement;)V", "getLocal", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getNewContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "getExtractedUnder", "()Lorg/jetbrains/kotlin/ir/IrStatement;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ir.backend.common"})
    private static final class ExtractedLocalDeclaration {
        @NotNull
        private final IrDeclaration local;
        @NotNull
        private final IrDeclarationParent newContainer;
        @Nullable
        private final IrStatement extractedUnder;

        public ExtractedLocalDeclaration(@NotNull IrDeclaration local, @NotNull IrDeclarationParent newContainer, @Nullable IrStatement extractedUnder) {
            Intrinsics.checkNotNullParameter((Object)local, (String)"local");
            Intrinsics.checkNotNullParameter((Object)newContainer, (String)"newContainer");
            this.local = local;
            this.newContainer = newContainer;
            this.extractedUnder = extractedUnder;
        }

        @NotNull
        public final IrDeclaration getLocal() {
            return this.local;
        }

        @NotNull
        public final IrDeclarationParent getNewContainer() {
            return this.newContainer;
        }

        @Nullable
        public final IrStatement getExtractedUnder() {
            return this.extractedUnder;
        }

        @NotNull
        public final IrDeclaration component1() {
            return this.local;
        }

        @NotNull
        public final IrDeclarationParent component2() {
            return this.newContainer;
        }

        @Nullable
        public final IrStatement component3() {
            return this.extractedUnder;
        }

        @NotNull
        public final ExtractedLocalDeclaration copy(@NotNull IrDeclaration local, @NotNull IrDeclarationParent newContainer, @Nullable IrStatement extractedUnder) {
            Intrinsics.checkNotNullParameter((Object)local, (String)"local");
            Intrinsics.checkNotNullParameter((Object)newContainer, (String)"newContainer");
            return new ExtractedLocalDeclaration(local, newContainer, extractedUnder);
        }

        public static /* synthetic */ ExtractedLocalDeclaration copy$default(ExtractedLocalDeclaration extractedLocalDeclaration, IrDeclaration irDeclaration, IrDeclarationParent irDeclarationParent, IrStatement irStatement, int n, Object object) {
            if ((n & 1) != 0) {
                irDeclaration = extractedLocalDeclaration.local;
            }
            if ((n & 2) != 0) {
                irDeclarationParent = extractedLocalDeclaration.newContainer;
            }
            if ((n & 4) != 0) {
                irStatement = extractedLocalDeclaration.extractedUnder;
            }
            return extractedLocalDeclaration.copy(irDeclaration, irDeclarationParent, irStatement);
        }

        @NotNull
        public String toString() {
            return "ExtractedLocalDeclaration(local=" + this.local + ", newContainer=" + this.newContainer + ", extractedUnder=" + this.extractedUnder + ')';
        }

        public int hashCode() {
            int result = this.local.hashCode();
            result = result * 31 + this.newContainer.hashCode();
            result = result * 31 + (this.extractedUnder == null ? 0 : this.extractedUnder.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExtractedLocalDeclaration)) {
                return false;
            }
            ExtractedLocalDeclaration extractedLocalDeclaration = (ExtractedLocalDeclaration)other;
            if (!Intrinsics.areEqual((Object)this.local, (Object)extractedLocalDeclaration.local)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.newContainer, (Object)extractedLocalDeclaration.newContainer)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.extractedUnder, (Object)extractedLocalDeclaration.extractedUnder);
        }
    }
}

