/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.phaser;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ErrorReportingContext;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.phaser.BackendContextHolder;
import org.jetbrains.kotlin.backend.common.phaser.DumperVerifierKt;
import org.jetbrains.kotlin.backend.common.phaser.KotlinBackendIrHolder;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.IrVerificationMode;
import org.jetbrains.kotlin.config.phaser.ActionState;
import org.jetbrains.kotlin.config.phaser.BeforeOrAfter;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.validation.IrValidatorConfig;
import org.jetbrains.kotlin.ir.validation.IrValidatorConfigKt;
import org.jetbrains.kotlin.ir.validation.IrValidatorKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002\u001a\f\u0010\b\u001a\u00020\u0006*\u00020\u0007H\u0002\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u001a)\u0010\f\u001a\u0004\u0018\u00010\u0002\"\u0004\b\u0000\u0010\r\"\u0004\b\u0001\u0010\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\u0006\u0010\u000b\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u0010\u001aF\u0010\u0011\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u00130\u0012j\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\r`\u0014\"\b\b\u0000\u0010\r*\u00020\u0015\"\u0004\b\u0001\u0010\u000e2\u0006\u0010\u0016\u001a\u00020\u0006\u001a>\u0010\u0017\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u00130\u0012j\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\r`\u0014\"\u0004\b\u0000\u0010\u000e\"\b\b\u0001\u0010\r*\u00020\u0015\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"?\u0010\u0018\u001a0\u0012,\u0012*\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00130\u0012j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001a`\u00140\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"elementName", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "getElementName", "(Lorg/jetbrains/kotlin/ir/IrElement;)Ljava/lang/String;", "isDumpNeeded", "", "Lorg/jetbrains/kotlin/config/phaser/ActionState;", "isValidationNeeded", "dumpIrElement", "actionState", "data", "findKotlinBackendIr", "Context", "Data", "context", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/jetbrains/kotlin/ir/IrElement;", "getIrValidator", "Lkotlin/Function3;", "", "Lorg/jetbrains/kotlin/config/phaser/Action;", "Lorg/jetbrains/kotlin/backend/common/ErrorReportingContext;", "checkTypes", "getIrDumper", "DEFAULT_IR_ACTIONS", "", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "getDEFAULT_IR_ACTIONS", "()Ljava/util/Set;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nDumperVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumperVerifier.kt\norg/jetbrains/kotlin/backend/common/phaser/DumperVerifierKt\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n290#2:174\n1#3:175\n*S KotlinDebug\n*F\n+ 1 DumperVerifier.kt\norg/jetbrains/kotlin/backend/common/phaser/DumperVerifierKt\n*L\n121#1:174\n*E\n"})
public final class DumperVerifierKt {
    @NotNull
    private static final Set<Function3<ActionState, IrElement, LoweringContext, Unit>> DEFAULT_IR_ACTIONS;

    private static final String getElementName(IrElement $this$elementName) {
        String string;
        IrElement irElement = $this$elementName;
        if (irElement instanceof IrModuleFragment) {
            String string2 = ((IrModuleFragment)$this$elementName).getName().asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        } else {
            string = irElement instanceof IrFile ? IrDeclarationsKt.getName((IrFile)$this$elementName) : $this$elementName.toString();
        }
        return string;
    }

    private static final boolean isDumpNeeded(ActionState $this$isDumpNeeded) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$isDumpNeeded.getBeforeOrAfter().ordinal()]) {
            case 1: {
                bl = $this$isDumpNeeded.getConfig().shouldDumpStateBefore($this$isDumpNeeded.getPhase());
                break;
            }
            case 2: {
                bl = $this$isDumpNeeded.getConfig().shouldDumpStateAfter($this$isDumpNeeded.getPhase());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final boolean isValidationNeeded(ActionState $this$isValidationNeeded) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$isValidationNeeded.getBeforeOrAfter().ordinal()]) {
            case 1: {
                bl = $this$isValidationNeeded.getConfig().shouldValidateStateBefore($this$isValidationNeeded.getPhase());
                break;
            }
            case 2: {
                bl = $this$isValidationNeeded.getConfig().shouldValidateStateAfter($this$isValidationNeeded.getPhase());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final String dumpIrElement(ActionState actionState, IrElement data) {
        String beforeOrAfterStr = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)actionState.getBeforeOrAfter().name());
        Ref.ObjectRef dumpText = new Ref.ObjectRef();
        dumpText.element = "";
        String elementName = null;
        String dumpStrategy = System.getProperty("org.jetbrains.kotlin.compiler.ir.dump.strategy");
        Function1 dump2 = Intrinsics.areEqual((Object)dumpStrategy, (Object)"KotlinLike") ? (Function1)dumpIrElement.dump.1.INSTANCE : (Function1)dumpIrElement.dump.2.INSTANCE;
        String dumpOnlyFqName = actionState.getConfig().getDumpOnlyFqName();
        if (dumpOnlyFqName != null) {
            elementName = dumpOnlyFqName;
            IrVisitorsKt.acceptVoid(data, new IrVisitorVoid(dumpOnlyFqName, (Ref.ObjectRef<String>)dumpText, (Function1<? super IrElement, String>)dump2){
                final /* synthetic */ String $dumpOnlyFqName;
                final /* synthetic */ Ref.ObjectRef<String> $dumpText;
                final /* synthetic */ Function1<IrElement, String> $dump;
                {
                    this.$dumpOnlyFqName = $dumpOnlyFqName;
                    this.$dumpText = $dumpText;
                    this.$dump = $dump;
                }

                public void visitElement(IrElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    IrVisitorsKt.acceptChildrenVoid(element, this);
                }

                public void visitDeclaration(IrDeclarationBase declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    if (declaration instanceof IrDeclarationWithName && Intrinsics.areEqual((Object)new FqName(this.$dumpOnlyFqName), (Object)IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((Object)declaration)))) {
                        this.$dumpText.element = (String)this.$dumpText.element + (String)this.$dump.invoke((Object)declaration);
                    } else {
                        super.visitDeclaration(declaration);
                    }
                }
            });
        } else {
            elementName = DumperVerifierKt.getElementName(data);
            dumpText.element = dump2.invoke((Object)data);
        }
        String title = "// --- IR for " + elementName + ' ' + beforeOrAfterStr + ' ' + actionState.getPhase().getName() + '\n';
        return title + (String)dumpText.element;
    }

    @Nullable
    public static final <Context, Data> IrElement findKotlinBackendIr(Context context2, Data data) {
        return data instanceof IrElement ? (IrElement)data : (data instanceof KotlinBackendIrHolder ? ((KotlinBackendIrHolder)data).getKotlinIr() : (context2 instanceof KotlinBackendIrHolder ? ((KotlinBackendIrHolder)context2).getKotlinIr() : null));
    }

    @NotNull
    public static final <Context extends ErrorReportingContext, Data> Function3<ActionState, Data, Context, Unit> getIrValidator(boolean checkTypes) {
        return (arg_0, arg_1, arg_2) -> DumperVerifierKt.getIrValidator$lambda$0(checkTypes, arg_0, arg_1, arg_2);
    }

    @NotNull
    public static final <Data, Context extends ErrorReportingContext> Function3<ActionState, Data, Context, Unit> getIrDumper() {
        return DumperVerifierKt::getIrDumper$lambda$0;
    }

    @NotNull
    public static final Set<Function3<ActionState, IrElement, LoweringContext, Unit>> getDEFAULT_IR_ACTIONS() {
        return DEFAULT_IR_ACTIONS;
    }

    /*
     * WARNING - void declaration
     */
    private static final <Data, Context extends ErrorReportingContext> Unit getIrValidator$lambda$0(boolean $checkTypes, ActionState state, Data data, Context context2) {
        IrValidatorConfig irValidatorConfig;
        void $this$applyIf$iv;
        if (!DumperVerifierKt.isValidationNeeded(state)) {
            return Unit.INSTANCE;
        }
        MessageCollector messageCollector = context2.getMessageCollector();
        if (!(context2 instanceof BackendContextHolder)) {
            MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.LOGGING, (String)("Cannot verify IR " + state.getBeforeOrAfter() + ' ' + state.getPhase() + ": insufficient context."), null, (int)4, null);
            return Unit.INSTANCE;
        }
        IrElement element = DumperVerifierKt.findKotlinBackendIr(context2, data);
        if (element == null) {
            MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.LOGGING, (String)("Cannot verify IR " + state.getBeforeOrAfter() + ' ' + state.getPhase() + ": IR not found."), null, (int)4, null);
            return Unit.INSTANCE;
        }
        IrElement irElement = element;
        IrBuiltIns irBuiltIns = ((BackendContextHolder)((Object)context2)).getHeldBackendContext().getIrBuiltIns();
        IrValidatorConfig irValidatorConfig2 = IrValidatorConfigKt.withBasicChecks(new IrValidatorConfig(true, false, null, 6, null));
        boolean if$iv = $checkTypes;
        boolean $i$f$applyIf = false;
        if (if$iv) {
            void $this$getIrValidator_u24lambda_u240_u24lambda_u241;
            void var9_9 = $this$applyIf$iv;
            IrBuiltIns irBuiltIns2 = irBuiltIns;
            IrElement irElement2 = irElement;
            boolean bl = false;
            IrValidatorConfig irValidatorConfig3 = IrValidatorConfigKt.withTypeChecks((IrValidatorConfig)$this$getIrValidator_u24lambda_u240_u24lambda_u241);
            irElement = irElement2;
            irBuiltIns = irBuiltIns2;
            irValidatorConfig = irValidatorConfig3;
        } else {
            irValidatorConfig = $this$applyIf$iv;
        }
        IrValidatorKt.validateIr$default(irElement, irBuiltIns, irValidatorConfig, messageCollector, IrVerificationMode.ERROR, CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)state.getBeforeOrAfter().name()) + ' ' + state.getPhase(), null, 64, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final <Data, Context extends ErrorReportingContext> Unit getIrDumper$lambda$0(ActionState state, Data data, Context context2) {
        block7: {
            String string;
            File directoryFile;
            Object object;
            StringBuilder stringBuilder;
            String dumpDirectory;
            String dumpContent;
            block9: {
                block8: {
                    void it;
                    block6: {
                        if (!DumperVerifierKt.isDumpNeeded(state)) {
                            return Unit.INSTANCE;
                        }
                        IrElement element = DumperVerifierKt.findKotlinBackendIr(context2, data);
                        if (element == null) {
                            MessageCollector.report$default((MessageCollector)context2.getMessageCollector(), (CompilerMessageSeverity)CompilerMessageSeverity.WARNING, (String)("Cannot dump IR " + state.getBeforeOrAfter() + ' ' + state.getPhase() + ": IR not found."), null, (int)4, null);
                            return Unit.INSTANCE;
                        }
                        dumpContent = DumperVerifierKt.dumpIrElement(state, element);
                        dumpDirectory = state.getConfig().getDumpToDirectory();
                        if (dumpDirectory != null) break block6;
                        System.out.println((Object)"\n\n----------------------------------------------");
                        System.out.println((Object)dumpContent);
                        System.out.println();
                        break block7;
                    }
                    stringBuilder = new StringBuilder().append(dumpDirectory);
                    object = data instanceof IrModuleFragment ? (IrModuleFragment)data : null;
                    if (object == null) break block8;
                    IrModuleFragment irModuleFragment = object;
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl = false;
                    StringBuilder stringBuilder3 = new StringBuilder().append('/');
                    String string2 = it.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                    String string3 = stringBuilder3.append(StringsKt.removeSurrounding((String)string2, (CharSequence)"<", (CharSequence)">")).toString();
                    stringBuilder = stringBuilder2;
                    object = string3;
                    if (string3 != null) break block9;
                }
                object = "";
            }
            if (!(directoryFile = new File(string = stringBuilder.append((String)object).toString())).isDirectory() && !directoryFile.mkdirs()) {
                String string4 = "Can't create directory for IR dumps at " + dumpDirectory;
                throw new IllegalStateException(string4.toString());
            }
            String string5 = "%02d";
            Object[] objectArray = new Object[]{state.getPhaseCount()};
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
            String phaseIdFormatted = string6;
            String dumpStrategy = System.getProperty("org.jetbrains.kotlin.compiler.ir.dump.strategy");
            String extPrefix = Intrinsics.areEqual((Object)dumpStrategy, (Object)"KotlinLike") ? "kt." : "";
            String fileName = phaseIdFormatted + '_' + state.getBeforeOrAfter() + '.' + state.getPhase().getName() + '.' + extPrefix + "ir";
            FilesKt.writeText$default((File)new File(directoryFile, fileName), (String)dumpContent, null, (int)2, null);
        }
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new Function3[]{DumperVerifierKt.getIrDumper(), DumperVerifierKt.getIrValidator(false)};
        DEFAULT_IR_ACTIONS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BeforeOrAfter.values().length];
            try {
                nArray[BeforeOrAfter.BEFORE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeforeOrAfter.AFTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

