/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/intentions/MarkdownRemoveColumnIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "<init>", "()V", "getFamilyName", "", "getText", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "intellij.markdown"})
public final class MarkdownRemoveColumnIntention
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        String string = MarkdownBundle.message("markdown.remove.column.intention.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        MarkdownTableCell cell = TableUtils.findCell(element2);
        return cell != null && cell.getParentTable() != null && editor2 != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        MarkdownTable table;
        MarkdownTableCell cell;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        MarkdownTableCell markdownTableCell = cell = TableUtils.findCell(element2);
        MarkdownTable markdownTable = table = markdownTableCell != null ? markdownTableCell.getParentTable() : null;
        if (cell == null || table == null || editor2 == null) {
            return;
        }
        int columnIndex = cell.getColumnIndex();
        TableModificationUtils.INSTANCE.removeColumn(table, columnIndex);
    }
}

