/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.diagnostic.StartUpPerformanceService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemOperationDescriptor;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.DeduplicateVisitorsSupplier;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.WorkspaceDataService;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemSyncActionsCollector;
import com.intellij.openapi.externalSystem.statistics.Phase;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemTelemetryUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.EDT;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class ProjectDataManagerImpl
implements ProjectDataManager {
    private static final Logger LOG = Logger.getInstance(ProjectDataManagerImpl.class);
    private static final Function<ProjectDataService<?, ?>, Key<?>> KEY_MAPPER = ProjectDataService::getTargetDataKey;
    private final Lock myLock = new ReentrantLock();

    public static ProjectDataManagerImpl getInstance() {
        return (ProjectDataManagerImpl)ProjectDataManager.getInstance();
    }

    @NotNull
    public List<WorkspaceDataService<?>> findWorkspaceService(@NotNull Key<?> key) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(0);
        }
        ArrayList result = new ArrayList(WorkspaceDataService.EP_NAME.getByGroupingKey(key, ProjectDataManagerImpl.class, WorkspaceDataService::getTargetDataKey));
        ExternalSystemApiUtil.orderAwareSort(result);
        ArrayList arrayList = result;
        if (arrayList == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public List<ProjectDataService<?, ?>> findService(@NotNull Key<?> key) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(2);
        }
        ArrayList result = new ArrayList(ProjectDataService.EP_NAME.getByGroupingKey(key, ProjectDataManagerImpl.class, KEY_MAPPER));
        ExternalSystemApiUtil.orderAwareSort(result);
        ArrayList arrayList = result;
        if (arrayList == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project) {
        if (node == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(5);
        }
        Application app = ApplicationManager.getApplication();
        if (!EDT.isCurrentThreadEdt() && app.holdsReadLock()) {
            throw new IllegalStateException("importData() must not be called with a global read lock on a background thread. It will deadlock committing project model changes in write action");
        }
        if (EDT.isCurrentThreadEdt()) {
            if (!this.myLock.tryLock()) {
                throw new IllegalStateException("importData() can not wait on write thread for imports on background threads. Consider running importData() on background thread.");
            }
        } else {
            this.myLock.lock();
        }
        try {
            this.importData(node, project, this.createModifiableModelsProvider(project));
        }
        finally {
            this.myLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        ProjectSystemId projectSystemId;
        ProjectData projectData;
        if (node == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(7);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(8);
        }
        if (project.isDisposed()) {
            return;
        }
        MultiMap grouped = ExternalSystemApiUtil.recursiveGroup(Collections.singletonList(node));
        Collection projects = grouped.get((Object)ProjectKeys.PROJECT);
        assert (projects.size() == 1 || projects.isEmpty());
        DataNode projectNode = (DataNode)ContainerUtil.getFirstItem((Collection)projects);
        if (projectNode != null) {
            projectData = (ProjectData)projectNode.getData();
            projectSystemId = ((ProjectData)projectNode.getData()).getOwner();
            ExternalProjectsDataStorage.getInstance(project).saveInclusionSettings((DataNode<ProjectData>)projectNode);
        } else {
            projectData = null;
            DataNode aModuleNode = (DataNode)ContainerUtil.getFirstItem((Collection)grouped.get((Object)ProjectKeys.MODULE));
            ProjectSystemId projectSystemId2 = projectSystemId = aModuleNode != null ? ((ModuleData)aModuleNode.getData()).getOwner() : null;
        }
        if (projectSystemId != null) {
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(project, projectSystemId);
        }
        SmartList onSuccessImportTasks = new SmartList();
        SmartList onFailureImportTasks = new SmartList();
        Collection operationDescriptorNodes = grouped.getOrPut(ExternalSystemOperationDescriptor.OPERATION_DESCRIPTOR_KEY, () -> new DataNode(ExternalSystemOperationDescriptor.OPERATION_DESCRIPTOR_KEY, (Object)new ExternalSystemOperationDescriptor(), null));
        ExternalSystemOperationDescriptor operationDescriptor = (ExternalSystemOperationDescriptor)((DataNode)ContainerUtil.getFirstItem((Collection)operationDescriptorNodes)).getData();
        long allStartTime = System.currentTimeMillis();
        long activityId = operationDescriptor.getActivityId();
        ExternalSystemSyncActionsCollector.logPhaseStarted(project, activityId, Phase.DATA_SERVICES);
        boolean importSucceeded = false;
        int errorsCount = 0;
        String projectPath = (String)ObjectUtils.doIfNotNull((Object)projectData, ProjectData::getLinkedExternalProjectPath);
        ProjectDataImportListener topic = (ProjectDataImportListener)project.getMessageBus().syncPublisher(ProjectDataImportListener.TOPIC);
        topic.onImportStarted(projectPath);
        Span dataServicesSpan = ExternalSystemTelemetryUtil.getTracer(projectSystemId).spanBuilder("ProjectDataServices").startSpan();
        try (Scope ignore = dataServicesSpan.makeCurrent();){
            TreeSet allKeys = new TreeSet(grouped.keySet());
            ProjectDataService.EP_NAME.forEachExtensionSafe(dataService -> allKeys.add(dataService.getTargetDataKey()));
            WorkspaceDataService.EP_NAME.forEachExtensionSafe(dataService -> allKeys.add(dataService.getTargetDataKey()));
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setIndeterminate(false);
            }
            int size = allKeys.size();
            int count = 0;
            SmartList postImportTasks = new SmartList();
            for (Key key : allKeys) {
                if (indicator != null) {
                    String message = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{projectSystemId != null ? projectSystemId.getReadableName() : "", ExternalSystemBundle.message((String)"progress.update.refresh", (Object[])new Object[]{ProjectDataManagerImpl.getReadableText(key)})});
                    indicator.setText(message);
                    indicator.setFraction((double)count++ / (double)size);
                }
                this.doImportData(key, grouped.get((Object)key), projectSystemId, projectData, project, modelsProvider, (List<Runnable>)postImportTasks, (List<Runnable>)onSuccessImportTasks, (List<Runnable>)onFailureImportTasks);
            }
            ExternalSystemTelemetryUtil.runWithSpan(projectSystemId, "postImportTasks", arg_0 -> ProjectDataManagerImpl.lambda$importData$3((List)postImportTasks, arg_0));
            ProjectDataManagerImpl.commit(modelsProvider, project, true, "Imported data", activityId, projectSystemId);
            if (indicator != null) {
                indicator.setIndeterminate(true);
            }
            topic.onImportFinished(projectPath);
            importSucceeded = true;
        }
        catch (Throwable t) {
            dataServicesSpan.recordException(t);
            dataServicesSpan.setStatus(StatusCode.ERROR);
            ++errorsCount;
            topic.onImportFailed(projectPath, t);
            ExternalSystemSyncActionsCollector.logError(null, activityId, t);
            LOG.error(t);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        finally {
            if (importSucceeded) {
                ExternalSystemTelemetryUtil.runWithSpan(projectSystemId, "runFinalTasks", arg_0 -> ProjectDataManagerImpl.lambda$importData$4(project, projectPath, (List)onSuccessImportTasks, arg_0));
            } else {
                ExternalSystemTelemetryUtil.runWithSpan(projectSystemId, "runFinalTasks", arg_0 -> ProjectDataManagerImpl.lambda$importData$5(project, projectPath, (List)onFailureImportTasks, arg_0));
            }
            if (!importSucceeded) {
                ProjectDataManagerImpl.dispose(modelsProvider, project, true);
            }
            long timeMs = System.currentTimeMillis() - allStartTime;
            dataServicesSpan.end();
            ExternalSystemSyncActionsCollector.logPhaseFinished(project, activityId, Phase.DATA_SERVICES, timeMs, errorsCount);
            ExternalSystemSyncActionsCollector.logSyncFinished(project, activityId, importSucceeded);
            Application app = ApplicationManager.getApplication();
            if (!app.isUnitTestMode() && !app.isHeadlessEnvironment()) {
                StartUpPerformanceService.Companion.getInstance().reportStatistics(project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runFinalTasks(@NotNull Project project, @Nullable String projectPath, @NotNull List<? extends Runnable> tasks) {
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(9);
        }
        if (tasks == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(10);
        }
        ProjectDataImportListener topic = (ProjectDataImportListener)project.getMessageBus().syncPublisher(ProjectDataImportListener.TOPIC);
        topic.onFinalTasksStarted(projectPath);
        try {
            ContainerUtil.reverse(tasks).forEach(Runnable::run);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        finally {
            topic.onFinalTasksFinished(projectPath);
        }
    }

    @NotNull
    private static String getReadableText(@NotNull Key<?> key) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(11);
        }
        StringBuilder buffer = new StringBuilder();
        String s = key.toString();
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char currChar = s.charAt(i2);
            if (Character.isUpperCase(currChar)) {
                if (i2 != 0) {
                    buffer.append(' ');
                }
                buffer.append(StringUtil.toLowerCase((char)currChar));
                continue;
            }
            buffer.append(currChar);
        }
        String string = buffer.toString();
        if (string == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    private <T> void doImportData(@NotNull Key<T> key, @NotNull Collection<? extends DataNode<?>> nodes, @Nullable ProjectSystemId projectSystemId, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modifiableModelsProvider, @NotNull List<Runnable> postImportTasks, @NotNull List<Runnable> onSuccessImportTasks, @NotNull List<Runnable> onFailureImportTasks) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(13);
        }
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(14);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(15);
        }
        if (modifiableModelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(16);
        }
        if (postImportTasks == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(17);
        }
        if (onSuccessImportTasks == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(18);
        }
        if (onFailureImportTasks == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(19);
        }
        if (project.isDisposed()) {
            return;
        }
        SmartList toImport = new SmartList();
        SmartList toIgnore = new SmartList();
        for (DataNode<?> node : nodes) {
            if (!key.equals((Object)node.getKey())) continue;
            if (node.isIgnored()) {
                toIgnore.add(node);
                continue;
            }
            toImport.add(node);
        }
        this.ensureTheDataIsReadyToUse((Collection<? extends DataNode<?>>)toImport);
        @NotNull List<ProjectDataService<?, ?>> services = this.findService(key);
        @NotNull List<WorkspaceDataService<?>> workspaceServices = this.findWorkspaceService(key);
        if (services.isEmpty() && workspaceServices.isEmpty()) {
            LOG.debug(String.format("No data service is registered for %s", key));
        } else {
            long importStartTime;
            for (ProjectDataService<?, ?> projectDataService : services) {
                importStartTime = System.currentTimeMillis();
                String dataServiceName = projectDataService.getClass().getSimpleName();
                ExternalSystemTelemetryUtil.runWithSpan(projectSystemId, dataServiceName, arg_0 -> ProjectDataManagerImpl.lambda$doImportData$6(projectDataService, (Collection)toImport, projectData, project, modifiableModelsProvider, arg_0));
                if (LOG.isDebugEnabled()) {
                    long importTimeInMs = System.currentTimeMillis() - importStartTime;
                    LOG.debug(String.format("Service %s imported data in %d ms", dataServiceName, importTimeInMs));
                }
                if (projectData == null) continue;
                this.ensureTheDataIsReadyToUse((Collection<? extends DataNode<?>>)toIgnore);
                long removeStartTime = System.currentTimeMillis();
                Computable orphanIdeDataComputable = projectDataService.computeOrphanData((Collection)toImport, projectData, project, modifiableModelsProvider);
                projectDataService.removeData(orphanIdeDataComputable, (Collection)toIgnore, projectData, project, modifiableModelsProvider);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s computed and removed data in %d ms", dataServiceName, removeTimeInMs));
            }
            for (WorkspaceDataService workspaceDataService : workspaceServices) {
                importStartTime = System.currentTimeMillis();
                if (modifiableModelsProvider instanceof IdeModifiableModelsProviderImpl) {
                    MutableEntityStorage mutableStorage = modifiableModelsProvider.getActualStorageBuilder();
                    workspaceDataService.importData((Collection)toImport, projectData, project, mutableStorage);
                } else {
                    LOG.warn(String.format("MutableEntityStorage missing, models provider is %s", modifiableModelsProvider.getClass().getName()));
                }
                if (!LOG.isDebugEnabled()) continue;
                long importTimeInMs = System.currentTimeMillis() - importStartTime;
                LOG.debug(String.format("Workspace service %s imported data in %d ms", workspaceDataService.getClass().getSimpleName(), importTimeInMs));
            }
        }
        if (!services.isEmpty() && projectData != null) {
            postImportTasks.add(() -> ProjectDataManagerImpl.lambda$doImportData$7(services, (Collection)toImport, projectData, project, modifiableModelsProvider));
            onFailureImportTasks.add(() -> {
                for (ProjectDataService service : services) {
                    long taskStartTime = System.currentTimeMillis();
                    service.onFailureImport(project);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run failure import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
            onSuccessImportTasks.add(() -> ProjectDataManagerImpl.lambda$doImportData$9(project, services, (Collection)toImport, projectData));
        }
    }

    public void ensureTheDataIsReadyToUse(@Nullable DataNode startNode) {
        if (startNode == null || startNode.isReady()) {
            return;
        }
        DeduplicateVisitorsSupplier supplier2 = new DeduplicateVisitorsSupplier();
        startNode.visit(dataNode -> {
            if (dataNode.validateData()) {
                dataNode.visitData(supplier2.getVisitor(dataNode.getKey()));
            }
        });
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(20);
        }
        if (toRemove == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(21);
        }
        if (toIgnore == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(22);
        }
        if (projectData == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(23);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(24);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(25);
        }
        try {
            List<ProjectDataService<?, ?>> services = this.findService(key);
            for (ProjectDataService<?, ?> service : services) {
                long removeStartTime = System.currentTimeMillis();
                service.removeData((Computable)new Computable.PredefinedValueComputable(toRemove), toIgnore, projectData, project, modelsProvider);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
            ProjectDataManagerImpl.commit(modelsProvider, project, synchronous, "Removed data", null, projectData.getOwner());
        }
        catch (Throwable t) {
            ProjectDataManagerImpl.dispose(modelsProvider, project, synchronous);
            ExceptionUtil.rethrow((Throwable)t);
        }
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project, boolean synchronous) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(26);
        }
        if (toRemove == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(27);
        }
        if (toIgnore == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(28);
        }
        if (projectData == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(29);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(30);
        }
        this.removeData(key, toRemove, toIgnore, projectData, project, this.createModifiableModelsProvider(project), synchronous);
    }

    public void updateExternalProjectData(@NotNull Project project, @NotNull ExternalProjectInfo externalProjectInfo) {
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(31);
        }
        if (externalProjectInfo == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(32);
        }
        if (!project.isDisposed()) {
            ExternalProjectsManagerImpl.getInstance(project).updateExternalProjectData(externalProjectInfo);
        }
    }

    @Nullable
    public ExternalProjectInfo getExternalProjectData(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(33);
        }
        if (projectSystemId == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(34);
        }
        if (externalProjectPath == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(35);
        }
        return !project.isDisposed() ? ExternalProjectsDataStorage.getInstance(project).get(projectSystemId, externalProjectPath) : null;
    }

    @NotNull
    public @Unmodifiable Collection<ExternalProjectInfo> getExternalProjectsData(@NotNull Project project, @NotNull ProjectSystemId projectSystemId) {
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(36);
        }
        if (projectSystemId == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(37);
        }
        if (!project.isDisposed()) {
            Collection<ExternalProjectInfo> collection = ExternalProjectsDataStorage.getInstance(project).list(projectSystemId);
            if (collection == null) {
                ProjectDataManagerImpl.$$$reportNull$$$0(38);
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    public IdeModifiableModelsProvider createModifiableModelsProvider(@NotNull Project project) {
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(40);
        }
        return new IdeModifiableModelsProviderImpl(project);
    }

    private void ensureTheDataIsReadyToUse(@NotNull Collection<? extends DataNode<?>> nodes) {
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(41);
        }
        for (DataNode<?> node : nodes) {
            this.ensureTheDataIsReadyToUse(node);
        }
    }

    private static void commit(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project, boolean synchronous, @NotNull String commitDesc, @Nullable Long activityId, @Nullable ProjectSystemId projectSystemId) {
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(42);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(43);
        }
        if (commitDesc == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(44);
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (ComponentManager)project, (Runnable)Context.current().wrap(() -> ExternalSystemTelemetryUtil.runWithSpan(projectSystemId, "WorkspaceModelApply", ignore -> {
            if (activityId != null) {
                ExternalSystemSyncActionsCollector.logPhaseStarted(project, activityId, Phase.WORKSPACE_MODEL_APPLY);
            }
            long startTime = System.currentTimeMillis();
            modelsProvider.commit();
            long timeInMs = System.currentTimeMillis() - startTime;
            if (activityId != null) {
                ExternalSystemSyncActionsCollector.logPhaseFinished(project, activityId, Phase.WORKSPACE_MODEL_APPLY, timeInMs);
            }
            LOG.debug(String.format("%s committed in %d ms", commitDesc, timeInMs));
        })));
    }

    private static void dispose(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project, boolean synchronous) {
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(45);
        }
        if (project == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(46);
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (ComponentManager)project, () -> modelsProvider.dispose());
    }

    private static /* synthetic */ void lambda$doImportData$9(Project project, List services, Collection toImport, ProjectData projectData) {
        IdeModelsProviderImpl modelsProvider = new IdeModelsProviderImpl(project);
        for (ProjectDataService service : services) {
            long taskStartTime = System.currentTimeMillis();
            service.onSuccessImport(toImport, projectData, project, (IdeModelsProvider)modelsProvider);
            if (!LOG.isDebugEnabled()) continue;
            long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
            LOG.debug(String.format("Service %s run success import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
        }
    }

    private static /* synthetic */ void lambda$doImportData$7(List services, Collection toImport, ProjectData projectData, Project project, IdeModifiableModelsProvider modifiableModelsProvider) {
        for (ProjectDataService service : services) {
            long taskStartTime = System.currentTimeMillis();
            service.postProcess(toImport, projectData, project, modifiableModelsProvider);
            if (!LOG.isDebugEnabled()) continue;
            long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
            LOG.debug(String.format("Service %s run post import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
        }
    }

    private static /* synthetic */ void lambda$doImportData$6(ProjectDataService service, Collection toImport, ProjectData projectData, Project project, IdeModifiableModelsProvider modifiableModelsProvider, Span span) {
        service.importData(toImport, projectData, project, modifiableModelsProvider);
    }

    private static /* synthetic */ void lambda$importData$5(Project project, String projectPath, List onFailureImportTasks, Span __) {
        ProjectDataManagerImpl.runFinalTasks(project, projectPath, onFailureImportTasks);
    }

    private static /* synthetic */ void lambda$importData$4(Project project, String projectPath, List onSuccessImportTasks, Span __) {
        ProjectDataManagerImpl.runFinalTasks(project, projectPath, onSuccessImportTasks);
    }

    private static /* synthetic */ void lambda$importData$3(List postImportTasks, Span span) {
        for (Runnable postImportTask : postImportTasks) {
            postImportTask.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 12, 38, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 15: 
            case 24: 
            case 30: 
            case 31: 
            case 33: 
            case 36: 
            case 40: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 25: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 14: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModelsProvider";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postImportTasks";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccessImportTasks";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFailureImportTasks";
                break;
            }
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectInfo";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitDesc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findWorkspaceService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findService";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableText";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectsData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findWorkspaceService";
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 38: 
            case 39: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findService";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runFinalTasks";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getReadableText";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doImportData";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "updateExternalProjectData";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectData";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectsData";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createModifiableModelsProvider";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "ensureTheDataIsReadyToUse";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 12, 38, 39 -> new IllegalStateException(string);
        };
    }
}

