/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.wizard;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalModuleBuilder<S extends ExternalProjectSettings>
extends ModuleBuilder {
    @NotNull
    private final Icon myIcon;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final S myExternalProjectSettings;

    protected AbstractExternalModuleBuilder(@NotNull ProjectSystemId externalSystemId, @NotNull S externalProjectSettings) {
        if (externalSystemId == null) {
            AbstractExternalModuleBuilder.$$$reportNull$$$0(0);
        }
        if (externalProjectSettings == null) {
            AbstractExternalModuleBuilder.$$$reportNull$$$0(1);
        }
        this.myExternalSystemId = externalSystemId;
        this.myExternalProjectSettings = externalProjectSettings;
        externalProjectSettings.setupNewProjectDefault();
        Icon icon = ExternalSystemUiUtil.getUiAware(externalSystemId).getProjectIcon();
        this.myIcon = icon == null ? super.getNodeIcon() : icon;
    }

    @NonNls
    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPresentableName() {
        return this.myExternalSystemId.getReadableName();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getDescription() {
        return ExternalSystemBundle.message((String)"module.type.description", (Object[])new Object[]{this.myExternalSystemId.getReadableName()});
    }

    public Icon getNodeIcon() {
        return this.myIcon;
    }

    @NotNull
    public S getExternalProjectSettings() {
        S s = this.myExternalProjectSettings;
        if (s == null) {
            AbstractExternalModuleBuilder.$$$reportNull$$$0(2);
        }
        return s;
    }

    @Nullable
    public Project createProject(String name, String path) {
        Project project = super.createProject(name, path);
        if (project != null) {
            project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)Boolean.TRUE);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalModuleBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/wizard/AbstractExternalModuleBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

