/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.CrcCache;
import com.intellij.openapi.externalSystem.util.DefaultCrcCalculator;
import com.intellij.openapi.externalSystem.util.ExternalSystemCrcCalculator;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.zip.CRC32;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0006\u001a1\u0010\t\u001a\u00020\u0001\"\b\b\u0000\u0010\n*\u00020\u000b*\u0002H\n2\u0006\u0010\f\u001a\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a1\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0012\u001a\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a-\u0010\u0015\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a%\u0010\u0015\u001a\u0004\u0018\u00010\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\u0017\u001a\u001b\u0010\u0018\u001a\u0004\u0018\u00010\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0019\u001a\u001c\u0010\u001a\u001a\u00020\u001b*\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0002\"\u0013\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"calculateCrc", "", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "findOrCalculateCrc", "T", "Lcom/intellij/openapi/util/UserDataHolder;", "modificationStamp", "calculate", "Lkotlin/Function0;", "(Lcom/intellij/openapi/util/UserDataHolder;JLkotlin/jvm/functions/Function0;)J", "charSequence", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/CharSequence;Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Long;", "getCrcCalculator", "Lcom/intellij/openapi/externalSystem/util/ExternalSystemCrcCalculator;", "doCalculateCrc", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Long;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;)Ljava/lang/Long;", "getCachedCrc", "(Lcom/intellij/openapi/util/UserDataHolder;J)Ljava/lang/Long;", "setCachedCrc", "", "value", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "CRC_CACHE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/externalSystem/util/CrcCache;", "intellij.platform.externalSystem.impl"})
@JvmName(name="CrcUtils")
@SourceDebugExtension(value={"SMAP\nCrcUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrcUtils.kt\ncom/intellij/openapi/externalSystem/util/CrcUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class CrcUtils {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<CrcCache> CRC_CACHE;

    public static final long calculateCrc(@NotNull Document $this$calculateCrc, @NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateCrc, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return CrcUtils.calculateCrc($this$calculateCrc, project, null, file);
    }

    public static final long calculateCrc(@NotNull Document $this$calculateCrc, @NotNull Project project, @Nullable ProjectSystemId systemId, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateCrc, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Long l = CrcUtils.getCachedCrc((UserDataHolder)file, $this$calculateCrc.getModificationStamp());
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            return it;
        }
        return CrcUtils.findOrCalculateCrc((UserDataHolder)$this$calculateCrc, $this$calculateCrc.getModificationStamp(), (Function0<Long>)((Function0)() -> CrcUtils.calculateCrc$lambda$1($this$calculateCrc, project, systemId, file)));
    }

    public static final long calculateCrc(@NotNull VirtualFile $this$calculateCrc, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateCrc, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CrcUtils.calculateCrc($this$calculateCrc, project, null);
    }

    public static final long calculateCrc(@NotNull VirtualFile $this$calculateCrc, @NotNull Project project, @Nullable ProjectSystemId systemId) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateCrc, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CrcUtils.findOrCalculateCrc((UserDataHolder)$this$calculateCrc, $this$calculateCrc.getModificationStamp(), (Function0<Long>)((Function0)() -> CrcUtils.calculateCrc$lambda$2($this$calculateCrc, project, systemId)));
    }

    public static final long calculateCrc(@NotNull VirtualFile $this$calculateCrc) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateCrc, (String)"<this>");
        CRC32 crc32 = new CRC32();
        crc32.update($this$calculateCrc.contentsToByteArray());
        return crc32.getValue();
    }

    private static final <T extends UserDataHolder> long findOrCalculateCrc(T $this$findOrCalculateCrc, long modificationStamp, Function0<Long> calculate) {
        long l;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Long cachedCrc = CrcUtils.getCachedCrc($this$findOrCalculateCrc, modificationStamp);
        if (cachedCrc != null) {
            return cachedCrc;
        }
        try {
            l = ((Number)calculate.invoke()).longValue();
        }
        catch (IOException ex) {
            LOG.warn((Throwable)ex);
            l = 0L;
        }
        long crc = l;
        CrcUtils.setCachedCrc($this$findOrCalculateCrc, crc, modificationStamp);
        return crc;
    }

    private static final Long calculateCrc(Project project, CharSequence charSequence, ProjectSystemId systemId, VirtualFile file) {
        ExternalSystemCrcCalculator crcCalculator = CrcUtils.getCrcCalculator(systemId, file);
        return crcCalculator.calculateCrc(project, file, charSequence);
    }

    private static final ExternalSystemCrcCalculator getCrcCalculator(ProjectSystemId systemId, VirtualFile file) {
        if (systemId != null) {
            ExternalSystemCrcCalculator externalSystemCrcCalculator = ExternalSystemCrcCalculator.Companion.getInstance(systemId, file);
            if (externalSystemCrcCalculator == null) {
                externalSystemCrcCalculator = DefaultCrcCalculator.INSTANCE;
            }
            return externalSystemCrcCalculator;
        }
        return DefaultCrcCalculator.INSTANCE;
    }

    private static final Long doCalculateCrc(Document $this$doCalculateCrc, Project project, ProjectSystemId systemId, VirtualFile file) {
        Long l;
        if (file.getFileType().isBinary()) {
            l = null;
        } else {
            CharSequence charSequence = $this$doCalculateCrc.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
            l = CrcUtils.calculateCrc(project, charSequence, systemId, file);
        }
        return l;
    }

    private static final Long doCalculateCrc(VirtualFile $this$doCalculateCrc, Project project, ProjectSystemId systemId) {
        Long l;
        if ($this$doCalculateCrc.isDirectory()) {
            l = null;
        } else if ($this$doCalculateCrc.getFileType().isBinary()) {
            l = null;
        } else {
            CharSequence charSequence = LoadTextUtil.loadText((VirtualFile)$this$doCalculateCrc);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"loadText(...)");
            l = CrcUtils.calculateCrc(project, charSequence, systemId, $this$doCalculateCrc);
        }
        return l;
    }

    private static final Long getCachedCrc(UserDataHolder $this$getCachedCrc, long modificationStamp) {
        CrcCache crcCache = (CrcCache)$this$getCachedCrc.getUserData(CRC_CACHE);
        if (crcCache == null) {
            return null;
        }
        CrcCache crcCache2 = crcCache;
        long value = crcCache2.component1();
        long stamp = crcCache2.component2();
        if (stamp == modificationStamp) {
            return value;
        }
        return null;
    }

    private static final void setCachedCrc(UserDataHolder $this$setCachedCrc, long value, long modificationStamp) {
        $this$setCachedCrc.putUserData(CRC_CACHE, (Object)new CrcCache(value, modificationStamp));
    }

    private static final long calculateCrc$lambda$1(Document $this_calculateCrc, Project $project, ProjectSystemId $systemId, VirtualFile $file) {
        Long l = CrcUtils.doCalculateCrc($this_calculateCrc, $project, $systemId, $file);
        return l != null ? l : CrcUtils.calculateCrc($file);
    }

    private static final long calculateCrc$lambda$2(VirtualFile $this_calculateCrc, Project $project, ProjectSystemId $systemId) {
        Long l = CrcUtils.doCalculateCrc($this_calculateCrc, $project, $systemId);
        return l != null ? l : CrcUtils.calculateCrc($this_calculateCrc);
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.openapi.externalSystem.util.CRC");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        CRC_CACHE = new Key("com.intellij.openapi.externalSystem.util.CRC_CACHE");
    }
}

