/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractDependencyData;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.dependencies.ComponentDependencies;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyScopeNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.FileCollectionDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencies;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ReferenceNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.UnknownDependencyNode;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ExternalSystemViewContributor;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.TasksNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.pom.Navigatable;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.event.InputEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ExternalSystemViewDefaultContributor
extends ExternalSystemViewContributor {
    private static final Key<?>[] KEYS = new Key[]{ProjectKeys.MODULE, ProjectKeys.DEPENDENCIES_GRAPH, ProjectKeys.MODULE_DEPENDENCY, ProjectKeys.LIBRARY_DEPENDENCY, ProjectKeys.TASK};

    ExternalSystemViewDefaultContributor() {
    }

    @Override
    @NotNull
    public ProjectSystemId getSystemId() {
        ProjectSystemId projectSystemId = ProjectSystemId.IDE;
        if (projectSystemId == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(0);
        }
        return projectSystemId;
    }

    @Override
    @NotNull
    public List<Key<?>> getKeys() {
        List<Key<?>> list = Arrays.asList(KEYS);
        if (list == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<ExternalSystemNode<?>> createNodes(ExternalProjectsView externalProjectsView, MultiMap<Key<?>, DataNode<?>> dataNodes) {
        SmartList result = new SmartList();
        ExternalSystemViewDefaultContributor.addModuleNodes(externalProjectsView, dataNodes, result);
        Collection tasksNodes = dataNodes.get((Object)ProjectKeys.TASK);
        if (!tasksNodes.isEmpty()) {
            TasksNode tasksNode = new TasksNode(externalProjectsView, tasksNodes);
            if (externalProjectsView.useTasksNode()) {
                result.add(tasksNode);
            } else {
                Collections.addAll(result, tasksNode.getChildren());
            }
        }
        ExternalSystemViewDefaultContributor.addDependenciesNode(externalProjectsView, dataNodes, result);
        SmartList smartList = result;
        if (smartList == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @Override
    @NotNull
    public String getDisplayName(@NotNull DataNode node) {
        if (node == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(3);
        }
        return ExternalSystemViewDefaultContributor.getNodeDisplayName(node);
    }

    private static void addDependenciesNode(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> dataNodes, @NotNull List<? super ExternalSystemNode<?>> result) {
        Collection depsGraph;
        if (externalProjectsView == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(4);
        }
        if (dataNodes == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(5);
        }
        if (result == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(6);
        }
        if (!(depsGraph = dataNodes.get((Object)ProjectKeys.DEPENDENCIES_GRAPH)).isEmpty()) {
            MyDependenciesNode depNode = new MyDependenciesNode(externalProjectsView);
            for (DataNode dataNode : depsGraph) {
                Iterator iterator = dataNode.getData();
                if (!(iterator instanceof ProjectDependencies)) continue;
                ProjectDependencies projectDependencies = (ProjectDependencies)iterator;
                for (ComponentDependencies componentDependencies : projectDependencies.getComponentsDependencies()) {
                    depNode.add(new DependencyScopeExternalSystemNode(externalProjectsView, componentDependencies.getCompileDependenciesGraph()));
                    depNode.add(new DependencyScopeExternalSystemNode(externalProjectsView, componentDependencies.getRuntimeDependenciesGraph()));
                }
            }
            if (depNode.hasChildren()) {
                result.add(depNode);
            }
            return;
        }
        Collection moduleDeps = dataNodes.get((Object)ProjectKeys.MODULE_DEPENDENCY);
        Collection libDeps = dataNodes.get((Object)ProjectKeys.LIBRARY_DEPENDENCY);
        if (!moduleDeps.isEmpty() || !libDeps.isEmpty()) {
            ArrayList<DependencyDataExternalSystemNode> depNodeChildren = new ArrayList<DependencyDataExternalSystemNode>();
            for (DataNode dataNode : moduleDeps) {
                if (!(dataNode.getData() instanceof ModuleDependencyData)) continue;
                ModuleDependencyDataExternalSystemNode moduleDependencyDataExternalSystemNode = new ModuleDependencyDataExternalSystemNode(externalProjectsView, (DataNode<ModuleDependencyData>)dataNode);
                if (dataNode.getParent() != null && dataNode.getParent().getData() instanceof AbstractDependencyData) {
                    result.add(moduleDependencyDataExternalSystemNode);
                    continue;
                }
                depNodeChildren.add(moduleDependencyDataExternalSystemNode);
            }
            for (DataNode dataNode : libDeps) {
                if (!(dataNode.getData() instanceof LibraryDependencyData)) continue;
                LibraryDependencyDataExternalSystemNode libraryDependencyDataExternalSystemNode = new LibraryDependencyDataExternalSystemNode(externalProjectsView, (DataNode<LibraryDependencyData>)dataNode);
                if (((LibraryData)((LibraryDependencyData)dataNode.getData()).getTarget()).isUnresolved()) {
                    libraryDependencyDataExternalSystemNode.setErrorLevel(ExternalProjectsStructure.ErrorLevel.ERROR, "Unable to resolve " + ((LibraryData)((LibraryDependencyData)dataNode.getData()).getTarget()).getExternalName());
                } else {
                    libraryDependencyDataExternalSystemNode.setErrorLevel(ExternalProjectsStructure.ErrorLevel.NONE, new String[0]);
                }
                if (dataNode.getParent() != null && dataNode.getParent().getData() instanceof ModuleData) {
                    depNodeChildren.add(libraryDependencyDataExternalSystemNode);
                    continue;
                }
                result.add(libraryDependencyDataExternalSystemNode);
            }
            if (!depNodeChildren.isEmpty()) {
                MyDependenciesNode depNode = new MyDependenciesNode(externalProjectsView);
                depNode.addAll(depNodeChildren);
                result.add(depNode);
            }
        }
    }

    private static void addModuleNodes(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> dataNodes, @NotNull List<? super ExternalSystemNode<?>> result) {
        Collection moduleDataNodes;
        if (externalProjectsView == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(7);
        }
        if (dataNodes == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(8);
        }
        if (result == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(9);
        }
        if (!(moduleDataNodes = dataNodes.get((Object)ProjectKeys.MODULE)).isEmpty()) {
            AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)externalProjectsView.getProject(), (ProjectSystemId)externalProjectsView.getSystemId());
            HashMap<String, ModuleNode> groupToModule = new HashMap<String, ModuleNode>(moduleDataNodes.size());
            ArrayList<ModuleNode> moduleNodes = new ArrayList<ModuleNode>();
            for (DataNode dataNode : moduleDataNodes) {
                ModuleData data = (ModuleData)dataNode.getData();
                ExternalProjectSettings projectSettings = systemSettings.getLinkedProjectSettings(data.getLinkedExternalProjectPath());
                DataNode projectDataNode = ExternalSystemApiUtil.findParent((DataNode)dataNode, (Key)ProjectKeys.PROJECT);
                boolean isRoot = projectSettings != null && data.getLinkedExternalProjectPath().equals(projectSettings.getExternalProjectPath()) && projectDataNode != null && ((ProjectData)projectDataNode.getData()).getInternalName().equals(data.getInternalName());
                ModuleNode moduleNode = new ModuleNode(externalProjectsView, (DataNode<ModuleData>)dataNode, null, isRoot);
                moduleNodes.add(moduleNode);
                String group = moduleNode.getIdeGrouping();
                if (group == null) continue;
                groupToModule.put(group, moduleNode);
            }
            for (ModuleNode moduleNode : moduleNodes) {
                ModuleNode parent;
                moduleNode.setAllModules(moduleNodes);
                String parentGroup = moduleNode.getIdeParentGrouping();
                ModuleNode moduleNode2 = parent = parentGroup != null ? (ModuleNode)groupToModule.get(parentGroup) : null;
                if (parent == null) continue;
                moduleNode.setParent(parent);
            }
            result.addAll(moduleNodes);
        }
    }

    @NotNull
    private static String getNodeDisplayName(@NotNull DataNode<?> node) {
        Object data;
        if (node == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(10);
        }
        if ((data = node.getData()) instanceof LibraryDependencyData) {
            LibraryDependencyData libraryDependencyData = (LibraryDependencyData)data;
            String externalName = libraryDependencyData.getExternalName();
            if (StringUtil.isEmpty((String)externalName)) {
                Set paths = ((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY);
                if (paths.size() == 1) {
                    String relativePathToRoot = null;
                    String path = ExternalSystemApiUtil.toCanonicalPath((String)((String)paths.iterator().next()));
                    DataNode projectDataDataNode = ExternalSystemApiUtil.findParent(node, (Key)ProjectKeys.PROJECT);
                    if (projectDataDataNode != null) {
                        relativePathToRoot = FileUtil.getRelativePath((String)((ProjectData)projectDataDataNode.getData()).getLinkedExternalProjectPath(), (String)path, (char)'/');
                        relativePathToRoot = relativePathToRoot != null && StringUtil.startsWith((CharSequence)relativePathToRoot, (CharSequence)"../../") ? new File(relativePathToRoot).getName() : relativePathToRoot;
                    }
                    String string = (String)ObjectUtils.notNull(relativePathToRoot, (Object)path);
                    if (string == null) {
                        ExternalSystemViewDefaultContributor.$$$reportNull$$$0(11);
                    }
                    return string;
                }
                return "<file set>";
            }
            String string = externalName;
            if (string == null) {
                ExternalSystemViewDefaultContributor.$$$reportNull$$$0(12);
            }
            return string;
        }
        if (data instanceof Named) {
            String string = ((Named)data).getExternalName();
            if (string == null) {
                ExternalSystemViewDefaultContributor.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (data instanceof TaskData) {
            String string = ((TaskData)data).getName();
            if (string == null) {
                ExternalSystemViewDefaultContributor.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)node.toString());
        if (string == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    public ExternalProjectsStructure.ErrorLevel getErrorLevel(DataNode<?> dataNode) {
        if (ProjectKeys.LIBRARY_DEPENDENCY.equals((Object)dataNode.getKey()) && ((LibraryData)((LibraryDependencyData)dataNode.getData()).getTarget()).isUnresolved()) {
            return ExternalProjectsStructure.ErrorLevel.ERROR;
        }
        return super.getErrorLevel(dataNode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNodes";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDependenciesNode";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addModuleNodes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNodeDisplayName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    @Order(value=20)
    private static class MyDependenciesNode
    extends ExternalSystemNode<Object> {
        MyDependenciesNode(ExternalProjectsView externalProjectsView) {
            super(externalProjectsView, null, null);
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                MyDependenciesNode.$$$reportNull$$$0(0);
            }
            super.update(presentation);
            presentation.setIcon(AllIcons.Nodes.PpLibFolder);
        }

        @Override
        public String getName() {
            return "Dependencies";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$MyDependenciesNode", "update"));
        }
    }

    private static final class DependencyScopeExternalSystemNode
    extends ExternalSystemNode<Object> {
        private final DependencyScopeNode myDependenciesGraph;
        private final Long2ObjectMap<DependencyNode> myDependencyNodeMap;

        DependencyScopeExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @NotNull DependencyScopeNode dependenciesGraph) {
            if (externalProjectsView == null) {
                DependencyScopeExternalSystemNode.$$$reportNull$$$0(0);
            }
            if (dependenciesGraph == null) {
                DependencyScopeExternalSystemNode.$$$reportNull$$$0(1);
            }
            super(externalProjectsView, null);
            this.myDependencyNodeMap = new Long2ObjectOpenHashMap();
            this.myDependenciesGraph = dependenciesGraph;
        }

        @Override
        public String getName() {
            return this.myDependenciesGraph.getScope();
        }

        @Override
        @Nullable
        public DependencyNode getDependencyNode() {
            return this.myDependenciesGraph;
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                DependencyScopeExternalSystemNode.$$$reportNull$$$0(2);
            }
            super.update(presentation);
            presentation.setIcon(AllIcons.Nodes.PpLibFolder);
            String description = this.myDependenciesGraph.getDescription();
            if (description != null) {
                this.setNameAndTooltip(presentation, this.getName(), description, (String)null);
            }
        }

        @Override
        @NotNull
        protected List<ExternalSystemNode<?>> doBuildChildren() {
            DependencyScopeExternalSystemNode.buildNodesMap(this.myDependencyNodeMap, (DependencyNode)this.myDependenciesGraph);
            ArrayList myChildNodes = new ArrayList();
            for (DependencyNode dependency : this.myDependenciesGraph.getDependencies()) {
                myChildNodes.add(new DependencyExternalSystemNode(this.getExternalProjectsView(), dependency, this.myDependencyNodeMap));
            }
            ArrayList arrayList = myChildNodes;
            if (arrayList == null) {
                DependencyScopeExternalSystemNode.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        @Override
        public ExternalProjectsStructure.ErrorLevel getChildrenErrorLevel() {
            return DependencyScopeExternalSystemNode.getErrorLevelRecursively((DependencyNode)this.myDependenciesGraph);
        }

        @NotNull
        private static ExternalProjectsStructure.ErrorLevel getErrorLevelRecursively(@NotNull DependencyNode node) {
            if (node == null) {
                DependencyScopeExternalSystemNode.$$$reportNull$$$0(4);
            }
            if (node instanceof UnknownDependencyNode) {
                ExternalProjectsStructure.ErrorLevel errorLevel = ExternalProjectsStructure.ErrorLevel.ERROR;
                if (errorLevel == null) {
                    DependencyScopeExternalSystemNode.$$$reportNull$$$0(5);
                }
                return errorLevel;
            }
            ExternalProjectsStructure.ErrorLevel result = ExternalProjectsStructure.ErrorLevel.NONE;
            for (DependencyNode dependencyNode : node.getDependencies()) {
                ExternalProjectsStructure.ErrorLevel eachLevel = DependencyScopeExternalSystemNode.getErrorLevelRecursively(dependencyNode);
                if (result.compareTo(eachLevel) < 0) {
                    result = eachLevel;
                }
                if (result != ExternalProjectsStructure.ErrorLevel.ERROR) continue;
                break;
            }
            ExternalProjectsStructure.ErrorLevel errorLevel = result;
            if (errorLevel == null) {
                DependencyScopeExternalSystemNode.$$$reportNull$$$0(6);
            }
            return errorLevel;
        }

        private static void buildNodesMap(@NotNull Long2ObjectMap<DependencyNode> dependencyNodeMap, @NotNull DependencyNode node) {
            if (dependencyNodeMap == null) {
                DependencyScopeExternalSystemNode.$$$reportNull$$$0(7);
            }
            if (node == null) {
                DependencyScopeExternalSystemNode.$$$reportNull$$$0(8);
            }
            for (DependencyNode child : node.getDependencies()) {
                if (child instanceof ReferenceNode) continue;
                dependencyNodeMap.put(child.getId(), (Object)child);
                DependencyScopeExternalSystemNode.buildNodesMap(dependencyNodeMap, child);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalProjectsView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependenciesGraph";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyScopeExternalSystemNode";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyNodeMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyScopeExternalSystemNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doBuildChildren";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorLevelRecursively";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorLevelRecursively";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "buildNodesMap";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class ModuleDependencyDataExternalSystemNode
    extends DependencyDataExternalSystemNode<ModuleDependencyData> {
        ModuleDependencyDataExternalSystemNode(ExternalProjectsView externalProjectsView, DataNode<ModuleDependencyData> dataNode) {
            super(externalProjectsView, (ExternalSystemNode)null, dataNode);
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                ModuleDependencyDataExternalSystemNode.$$$reportNull$$$0(0);
            }
            super.update(presentation);
            presentation.setIcon(this.getUiAware().getProjectIcon());
            ModuleDependencyData data = (ModuleDependencyData)this.getData();
            if (data != null) {
                this.setNameAndTooltip(presentation, this.getName(), null, data.getScope().getDisplayName());
            }
        }

        @Override
        @NotNull
        protected List<? extends ExternalSystemNode<?>> doBuildChildren() {
            List list = Collections.emptyList();
            if (list == null) {
                ModuleDependencyDataExternalSystemNode.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        public ExternalProjectsStructure.ErrorLevel getChildrenErrorLevel() {
            return ExternalProjectsStructure.ErrorLevel.NONE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$ModuleDependencyDataExternalSystemNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$ModuleDependencyDataExternalSystemNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doBuildChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class LibraryDependencyDataExternalSystemNode
    extends DependencyDataExternalSystemNode<LibraryDependencyData> {
        LibraryDependencyDataExternalSystemNode(ExternalProjectsView externalProjectsView, DataNode<LibraryDependencyData> dataNode) {
            super(externalProjectsView, (ExternalSystemNode)null, dataNode);
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                LibraryDependencyDataExternalSystemNode.$$$reportNull$$$0(0);
            }
            super.update(presentation);
            presentation.setIcon(AllIcons.Nodes.PpLib);
            LibraryDependencyData data = (LibraryDependencyData)this.getData();
            if (data != null) {
                this.setNameAndTooltip(presentation, this.getName(), null, data.getScope().getDisplayName());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$LibraryDependencyDataExternalSystemNode", "update"));
        }
    }

    private static abstract class DependencyDataExternalSystemNode<T extends DependencyData<?>>
    extends ExternalSystemNode<T> {
        private final Navigatable myNavigatable;

        DependencyDataExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode parent, @Nullable DataNode<T> dataNode) {
            if (externalProjectsView == null) {
                DependencyDataExternalSystemNode.$$$reportNull$$$0(0);
            }
            super(externalProjectsView, parent, dataNode);
            this.myNavigatable = new OrderEntryModuleDependenciesNavigatable(this.getProject(), () -> this.getOrderEntry());
        }

        @Override
        @Nullable
        public Navigatable getNavigatable() {
            return this.myNavigatable;
        }

        @Nullable
        private OrderEntry getOrderEntry() {
            DependencyData data = (DependencyData)this.getData();
            if (data == null) {
                return null;
            }
            Project project = this.getProject();
            if (project == null) {
                return null;
            }
            return new IdeModelsProviderImpl(project).findIdeModuleOrderEntry(data);
        }

        @Override
        public int compareTo(@NotNull ExternalSystemNode<?> node) {
            int order2;
            int order1;
            if (node == null) {
                DependencyDataExternalSystemNode.$$$reportNull$$$0(1);
            }
            DependencyData myData = (DependencyData)this.getData();
            Object thatData = node.getData();
            if (myData instanceof OrderAware && thatData instanceof OrderAware && (order1 = ((OrderAware)myData).getOrder()) != (order2 = ((OrderAware)thatData).getOrder())) {
                return order1 < order2 ? -1 : 1;
            }
            String dependencyName = DependencyDataExternalSystemNode.getDependencySimpleName(this);
            String thatDependencyName = DependencyDataExternalSystemNode.getDependencySimpleName(node);
            return StringUtil.compare((String)dependencyName, (String)thatDependencyName, (boolean)true);
        }

        @NotNull
        private static String getDependencySimpleName(@NotNull ExternalSystemNode<?> node) {
            Set paths;
            LibraryDependencyData dependencyData;
            String externalName;
            Object thatData;
            if (node == null) {
                DependencyDataExternalSystemNode.$$$reportNull$$$0(2);
            }
            if ((thatData = node.getData()) instanceof LibraryDependencyData && StringUtil.isEmpty((String)(externalName = (dependencyData = (LibraryDependencyData)thatData).getExternalName())) && (paths = ((LibraryData)dependencyData.getTarget()).getPaths(LibraryPathType.BINARY)).size() == 1) {
                String string = new File((String)paths.iterator().next()).getName();
                if (string == null) {
                    DependencyDataExternalSystemNode.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = node.getName();
            if (string == null) {
                DependencyDataExternalSystemNode.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalProjectsView";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyDataExternalSystemNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyDataExternalSystemNode";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencySimpleName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependencySimpleName";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }

        private static class OrderEntryModuleDependenciesNavigatable
        implements Navigatable {
            @NotNull
            private final Supplier<? extends OrderEntry> myProvider;
            @Nullable
            private final Project myProject;
            @Nullable
            private OrderEntry myOrderEntry;

            OrderEntryModuleDependenciesNavigatable(@Nullable Project project, @NotNull Supplier<? extends OrderEntry> provider) {
                if (provider == null) {
                    OrderEntryModuleDependenciesNavigatable.$$$reportNull$$$0(0);
                }
                this.myProject = project;
                this.myProvider = provider;
            }

            public void navigate(boolean requestFocus) {
                if (this.myOrderEntry != null && this.myProject != null) {
                    ProjectSettingsService.getInstance((Project)this.myProject).openModuleDependenciesSettings(this.myOrderEntry.getOwnerModule(), this.myOrderEntry);
                }
            }

            public boolean canNavigate() {
                this.myOrderEntry = this.myProvider.get();
                return this.myOrderEntry != null;
            }

            public boolean canNavigateToSource() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyDataExternalSystemNode$OrderEntryModuleDependenciesNavigatable", "<init>"));
            }
        }
    }

    private static final class DependencyExternalSystemNode
    extends ExternalSystemNode<Object> {
        @NotNull
        private final DependencyNode myDependencyNode;
        @NotNull
        private final Long2ObjectMap<DependencyNode> myDependencyNodeMap;
        @Nullable
        private DependencyNode myReferencedNode;
        private final String myName;

        DependencyExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @NotNull DependencyNode dependencyNode, @NotNull Long2ObjectMap<DependencyNode> dependencyNodeMap) {
            if (externalProjectsView == null) {
                DependencyExternalSystemNode.$$$reportNull$$$0(0);
            }
            if (dependencyNode == null) {
                DependencyExternalSystemNode.$$$reportNull$$$0(1);
            }
            if (dependencyNodeMap == null) {
                DependencyExternalSystemNode.$$$reportNull$$$0(2);
            }
            super(externalProjectsView, null);
            this.myDependencyNode = dependencyNode;
            this.myDependencyNodeMap = dependencyNodeMap;
            if (this.myDependencyNode instanceof ReferenceNode) {
                this.myReferencedNode = (DependencyNode)this.myDependencyNodeMap.get(this.myDependencyNode.getId());
            }
            this.myName = this.myReferencedNode != null ? MessageFormat.format("{0}{1}", this.myReferencedNode.getDisplayName(), this.myReferencedNode.getDependencies().isEmpty() ? "" : " (*)") : this.myDependencyNode.getDisplayName();
        }

        @Override
        public String getName() {
            return this.myName;
        }

        @Override
        @Nullable
        protected String getMenuId() {
            return "ExternalSystemView.DependencyMenu";
        }

        @Override
        @NotNull
        public DependencyNode getDependencyNode() {
            DependencyNode dependencyNode = (DependencyNode)ObjectUtils.chooseNotNull((Object)this.myReferencedNode, (Object)this.myDependencyNode);
            if (dependencyNode == null) {
                DependencyExternalSystemNode.$$$reportNull$$$0(3);
            }
            return dependencyNode;
        }

        protected void update(@NotNull PresentationData presentation) {
            String tooltip;
            if (presentation == null) {
                DependencyExternalSystemNode.$$$reportNull$$$0(4);
            }
            super.update(presentation);
            boolean isProjectDependency = this.myDependencyNode instanceof ProjectDependencyNode || this.myReferencedNode instanceof ProjectDependencyNode;
            presentation.setIcon(isProjectDependency ? this.getUiAware().getProjectIcon() : AllIcons.Nodes.PpLib);
            if (this.myReferencedNode != null) {
                tooltip = ExternalSystemBundle.message((String)"external.system.view.nodes.dependency_reference_node_tooltip", (Object[])new Object[0]);
            } else if (this.myDependencyNode instanceof FileCollectionDependencyNode) {
                String path = ((FileCollectionDependencyNode)this.myDependencyNode).getPath();
                tooltip = StringUtil.join((Object[])path.split(File.pathSeparator), s -> Strings.escapeXmlEntities((String)s) + "<br/>", (String)"");
            } else {
                tooltip = null;
            }
            this.setNameAndTooltip(presentation, this.getName(), tooltip, (String)null);
        }

        @Override
        @NotNull
        protected List<ExternalSystemNode<?>> doBuildChildren() {
            if (this.myReferencedNode != null) {
                List<ExternalSystemNode<?>> list = Collections.emptyList();
                if (list == null) {
                    DependencyExternalSystemNode.$$$reportNull$$$0(5);
                }
                return list;
            }
            ArrayList myChildNodes = new ArrayList();
            for (DependencyNode dependency : this.myDependencyNode.getDependencies()) {
                myChildNodes.add(new DependencyExternalSystemNode(this.getExternalProjectsView(), dependency, this.myDependencyNodeMap));
            }
            ArrayList arrayList = myChildNodes;
            if (arrayList == null) {
                DependencyExternalSystemNode.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        @Override
        public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
            if (this.myReferencedNode == null) {
                super.handleDoubleClickOrEnter(tree, inputEvent);
            } else {
                this.selectAndExpandReferencedNode();
            }
        }

        private void selectAndExpandReferencedNode() {
            ExternalProjectsStructure structure = this.getStructure();
            if (structure == null) {
                return;
            }
            DependencyScopeExternalSystemNode scopeNode = this.findParent(DependencyScopeExternalSystemNode.class);
            if (scopeNode == null) {
                return;
            }
            DependencyExternalSystemNode referencedNode = this.findReferencedNode(scopeNode);
            if (referencedNode != null) {
                structure.select(referencedNode);
                structure.expand(referencedNode);
            }
        }

        @Nullable
        private DependencyExternalSystemNode findReferencedNode(ExternalSystemNode<?> node) {
            for (ExternalSystemNode<?> child : node.getChildren()) {
                if (child instanceof DependencyExternalSystemNode && ((DependencyExternalSystemNode)child).myDependencyNode == this.myReferencedNode) {
                    return (DependencyExternalSystemNode)child;
                }
                DependencyExternalSystemNode referencedNode = this.findReferencedNode(child);
                if (referencedNode == null) continue;
                return referencedNode;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalProjectsView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencyNodeMap";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyExternalSystemNode";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyExternalSystemNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencyNode";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doBuildChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

