/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationsNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=40)
public class ModuleNode
extends ExternalSystemNode<ModuleData> {
    private final boolean myIsRoot;
    private final ModuleData myData;
    private Collection<ModuleNode> myAllModules = Collections.emptyList();
    private final RunConfigurationsNode myRunConfigurationsNode;

    public ModuleNode(ExternalProjectsView externalProjectsView, DataNode<ModuleData> dataNode, @Nullable ExternalSystemNode parent, boolean isRoot) {
        super(externalProjectsView, parent, dataNode);
        this.myIsRoot = isRoot;
        this.myData = (ModuleData)dataNode.getData();
        this.myRunConfigurationsNode = new RunConfigurationsNode(externalProjectsView, this);
    }

    public void setAllModules(Collection<ModuleNode> allModules) {
        this.myAllModules = allModules;
    }

    public boolean isRoot() {
        return this.myIsRoot;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            ModuleNode.$$$reportNull$$$0(0);
        }
        super.update(presentation);
        presentation.setIcon(this.getUiAware().getProjectIcon());
        String hint = null;
        if (this.myIsRoot) {
            hint = "root";
        }
        String tooltip = this.myData.toString() + (String)(this.myData.getDescription() != null ? "<br>" + this.myData.getDescription() : "");
        this.setNameAndTooltip(presentation, this.getName(), tooltip, hint);
    }

    @Override
    @NotNull
    protected List<ExternalSystemNode<?>> doBuildChildren() {
        ArrayList myChildNodes = new ArrayList();
        if (this.getExternalProjectsView().getGroupModules()) {
            List childModules = ContainerUtil.findAll(this.myAllModules, module -> module != this && StringUtil.equals((CharSequence)module.getIdeParentGrouping(), (CharSequence)this.getIdeGrouping()));
            myChildNodes.addAll(childModules);
        }
        myChildNodes.addAll(super.doBuildChildren());
        myChildNodes.add(this.myRunConfigurationsNode);
        ArrayList arrayList = myChildNodes;
        if (arrayList == null) {
            ModuleNode.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected String getMenuId() {
        return "ExternalSystemView.ModuleMenu";
    }

    @Override
    public int compareTo(@NotNull ExternalSystemNode<?> node) {
        if (node == null) {
            ModuleNode.$$$reportNull$$$0(2);
        }
        return this.myIsRoot ? -1 : (node instanceof ModuleNode && ((ModuleNode)node).myIsRoot ? 1 : super.compareTo(node));
    }

    public void updateRunConfigurations() {
        this.myRunConfigurationsNode.updateRunConfigurations();
        this.childrenChanged();
        this.getExternalProjectsView().updateUpTo(this);
        this.getExternalProjectsView().updateUpTo(this.myRunConfigurationsNode);
    }

    @Override
    public String getName() {
        if (this.getExternalProjectsView().getGroupModules()) {
            return this.myData.getExternalName();
        }
        return super.getName();
    }

    @Nullable
    public String getIdeGrouping() {
        ModuleData data = (ModuleData)this.getData();
        if (data == null) {
            return null;
        }
        return data.getIdeGrouping();
    }

    @Nullable
    public String getIdeParentGrouping() {
        ModuleData data = (ModuleData)this.getData();
        if (data == null) {
            return null;
        }
        return data.getIdeParentGrouping();
    }

    @Override
    public void mergeWith(@NotNull ExternalSystemNode<ModuleData> node) {
        if (node == null) {
            ModuleNode.$$$reportNull$$$0(3);
        }
        super.mergeWith(node);
        if (node instanceof ModuleNode) {
            ModuleNode moduleNode = (ModuleNode)node;
            this.myAllModules = moduleNode.myAllModules;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ModuleNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ModuleNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mergeWith";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

