/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00052\u0006\u0010\u0012\u001a\u00020\u0013R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/diff/merge/LangSpecificMergeContext;", "", "project", "Lcom/intellij/openapi/project/Project;", "lineFragmentList", "", "Lcom/intellij/diff/fragments/MergeLineFragment;", "fileList", "Lcom/intellij/psi/PsiFile;", "lineOffsetList", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getLineFragmentList", "()Ljava/util/List;", "file", "side", "Lcom/intellij/diff/util/ThreeSide;", "lineRanges", "Lcom/intellij/openapi/util/TextRange;", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nLangSpecificMergeContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LangSpecificMergeContext.kt\ncom/intellij/diff/merge/LangSpecificMergeContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n1586#2:36\n1661#2,3:37\n*S KotlinDebug\n*F\n+ 1 LangSpecificMergeContext.kt\ncom/intellij/diff/merge/LangSpecificMergeContext\n*L\n27#1:36\n27#1:37,3\n*E\n"})
public final class LangSpecificMergeContext {
    @Nullable
    private final Project project;
    @NotNull
    private final List<MergeLineFragment> lineFragmentList;
    @NotNull
    private final List<PsiFile> fileList;
    @NotNull
    private final List<LineOffsets> lineOffsetList;

    public LangSpecificMergeContext(@Nullable Project project, @NotNull List<? extends MergeLineFragment> lineFragmentList, @NotNull List<? extends PsiFile> fileList, @NotNull List<? extends LineOffsets> lineOffsetList) {
        Intrinsics.checkNotNullParameter(lineFragmentList, (String)"lineFragmentList");
        Intrinsics.checkNotNullParameter(fileList, (String)"fileList");
        Intrinsics.checkNotNullParameter(lineOffsetList, (String)"lineOffsetList");
        this.project = project;
        this.lineFragmentList = lineFragmentList;
        this.fileList = fileList;
        this.lineOffsetList = lineOffsetList;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<MergeLineFragment> getLineFragmentList() {
        return this.lineFragmentList;
    }

    @NotNull
    public final PsiFile file(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return this.fileList.get(side.getIndex());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextRange> lineRanges(@NotNull ThreeSide side) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        LineOffsets lineOffsets = this.lineOffsetList.get(side.getIndex());
        Iterable $this$map$iv = this.lineFragmentList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TextRange textRange;
            int endLine;
            void it;
            MergeLineFragment mergeLineFragment = (MergeLineFragment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int startLine = it.getStartLine(side);
            if (startLine == (endLine = it.getEndLine(side))) {
                TextRange textRange2 = TextRange.EMPTY_RANGE;
                textRange = textRange2;
                Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"EMPTY_RANGE");
            } else {
                textRange = new TextRange(lineOffsets.getLineStart(startLine), lineOffsets.getLineEnd(endLine - 1));
            }
            collection.add(textRange);
        }
        return (List)destination$iv$iv;
    }
}

