/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.combined;

import com.intellij.diff.tools.combined.DiffInfoComponent;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\u0011\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010\u001f\u001a\u00020\u001e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010 \u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/diff/tools/combined/MainToolbarLayout;", "Ljava/awt/LayoutManager2;", "left", "Ljavax/swing/JComponent;", "right", "diffInfo", "Lcom/intellij/diff/tools/combined/DiffInfoComponent;", "<init>", "(Ljavax/swing/JComponent;Ljavax/swing/JComponent;Lcom/intellij/diff/tools/combined/DiffInfoComponent;)V", "addLayoutComponent", "", "comp", "Ljava/awt/Component;", "constraints", "", "name", "", "removeLayoutComponent", "preferredLayoutSize", "Ljava/awt/Dimension;", "parent", "Ljava/awt/Container;", "minimumLayoutSize", "maximumLayoutSize", "target", "size", "maxOfHeights", "", "layoutContainer", "getLayoutAlignmentX", "", "getLayoutAlignmentY", "invalidateLayout", "intellij.platform.diff.impl"})
final class MainToolbarLayout
implements LayoutManager2 {
    @NotNull
    private final JComponent left;
    @NotNull
    private final JComponent right;
    @NotNull
    private final DiffInfoComponent diffInfo;

    public MainToolbarLayout(@NotNull JComponent left, @NotNull JComponent right, @NotNull DiffInfoComponent diffInfo) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)diffInfo, (String)"diffInfo");
        this.left = left;
        this.right = right;
        this.diffInfo = diffInfo;
    }

    @Override
    public void addLayoutComponent(@Nullable Component comp, @Nullable Object constraints) {
    }

    @Override
    public void addLayoutComponent(@Nullable String name, @Nullable Component comp) {
    }

    @Override
    public void removeLayoutComponent(@Nullable Component comp) {
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return this.size(parent);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return new Dimension(100, 0);
    }

    @Override
    @NotNull
    public Dimension maximumLayoutSize(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.size(target);
    }

    private final Dimension size(Container parent) {
        int w = parent.getWidth();
        return new Dimension(w, this.maxOfHeights() + parent.getInsets().top + parent.getInsets().bottom);
    }

    private final int maxOfHeights() {
        return Math.max(this.diffInfo.getPanel().getPreferredSize().height, Math.max(this.left.getPreferredSize().height, this.right.getPreferredSize().height));
    }

    @Override
    public void layoutContainer(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Rectangle bounds = parent.getBounds();
        JBInsets.removeFrom((Rectangle)bounds, (Insets)parent.getInsets());
        int h = bounds.height;
        int w = bounds.width;
        Dimension leftSize = this.left.getPreferredSize();
        this.left.setBounds(new Rectangle(bounds.x, bounds.y, leftSize.width, h));
        Dimension rightSize = this.right.getPreferredSize();
        int rightX = bounds.x + w - rightSize.width;
        this.right.setBounds(new Rectangle(rightX, bounds.y, rightSize.width, h));
        Dimension dimension = this.diffInfo.getPanel().getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        Dimension centerSize = dimension;
        int infoX = bounds.x + (w / 2 - this.diffInfo.getCenterX());
        int gap = JBUIScale.scale((int)2);
        if (infoX + centerSize.width >= rightX - gap) {
            infoX = rightX - centerSize.width - gap;
        }
        if (infoX <= bounds.x + this.left.getWidth() + gap) {
            infoX = bounds.x + this.left.getWidth() + gap;
        }
        this.diffInfo.getPanel().setBounds(new Rectangle(infoX, bounds.y, centerSize.width, h));
    }

    @Override
    public float getLayoutAlignmentX(@Nullable Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(@Nullable Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(@Nullable Container target) {
    }
}

