/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/diff/LineStatusMarkerColorScheme;", "", "<init>", "()V", "getColor", "Ljava/awt/Color;", "editor", "Lcom/intellij/openapi/editor/Editor;", "type", "", "getBorderColor", "getErrorStripeColor", "getIgnoredBorderColor", "Companion", "intellij.platform.diff.impl"})
@ApiStatus.Experimental
public class LineStatusMarkerColorScheme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final LineStatusMarkerColorScheme DEFAULT = new LineStatusMarkerColorScheme();

    @Nullable
    public Color getColor(@NotNull Editor editor, byte type) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        byte by = type;
        if (by == 2) {
            color = scheme.getColor(EditorColors.ADDED_LINES_COLOR);
        } else if (by == 3) {
            color = scheme.getColor(EditorColors.DELETED_LINES_COLOR);
        } else if (by == 1) {
            color = scheme.getColor(EditorColors.MODIFIED_LINES_COLOR);
        } else if (by == 0) {
            color = scheme.getColor(EditorColors.WHITESPACES_MODIFIED_LINES_COLOR);
        } else {
            throw new IllegalStateException("Invalid change type".toString());
        }
        return color;
    }

    @Nullable
    public Color getBorderColor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return editor.getColorsScheme().getColor(EditorColors.BORDER_LINES_COLOR);
    }

    @Nullable
    public Color getErrorStripeColor(byte type) {
        TextAttributes textAttributes;
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        byte by = type;
        if (by == 2) {
            textAttributes = scheme.getAttributes(DiffColors.DIFF_INSERTED);
        } else if (by == 3) {
            textAttributes = scheme.getAttributes(DiffColors.DIFF_DELETED);
        } else if (by == 1) {
            textAttributes = scheme.getAttributes(DiffColors.DIFF_MODIFIED);
        } else {
            throw new IllegalStateException("Invalid change type".toString());
        }
        return textAttributes.getErrorStripeColor();
    }

    @Nullable
    public Color getIgnoredBorderColor(@NotNull Editor editor, byte type) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        byte by = type;
        if (by == 2) {
            color = scheme.getColor(EditorColors.IGNORED_ADDED_LINES_BORDER_COLOR);
        } else if (by == 3) {
            color = scheme.getColor(EditorColors.IGNORED_DELETED_LINES_BORDER_COLOR);
        } else if (by == 1 || by == 0) {
            color = scheme.getColor(EditorColors.IGNORED_MODIFIED_LINES_BORDER_COLOR);
        } else {
            throw new IllegalStateException("Invalid change type".toString());
        }
        return color;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/diff/LineStatusMarkerColorScheme$Companion;", "", "<init>", "()V", "DEFAULT", "Lcom/intellij/openapi/diff/LineStatusMarkerColorScheme;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

