/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.frontend.frame;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.platform.debugger.impl.frontend.frame.ImageEditorUIUtil;
import com.intellij.platform.debugger.impl.shared.ShowImagePopupUtil;
import com.intellij.platform.rpc.topics.ProjectRemoteTopic;
import com.intellij.platform.rpc.topics.ProjectRemoteTopicListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/debugger/impl/frontend/frame/ShowImagePopupRemoteTopicListener;", "Lcom/intellij/platform/rpc/topics/ProjectRemoteTopicListener;", "Lcom/intellij/platform/debugger/impl/shared/ShowImagePopupUtil$Request;", "<init>", "()V", "topic", "Lcom/intellij/platform/rpc/topics/ProjectRemoteTopic;", "getTopic", "()Lcom/intellij/platform/rpc/topics/ProjectRemoteTopic;", "handleEvent", "", "project", "Lcom/intellij/openapi/project/Project;", "event", "intellij.platform.debugger.impl.frontend"})
public final class ShowImagePopupRemoteTopicListener
implements ProjectRemoteTopicListener<ShowImagePopupUtil.Request> {
    @NotNull
    private final ProjectRemoteTopic<ShowImagePopupUtil.Request> topic = ShowImagePopupUtil.INSTANCE.getREMOTE_TOPIC();

    @NotNull
    public ProjectRemoteTopic<ShowImagePopupUtil.Request> getTopic() {
        return this.topic;
    }

    public void handleEvent(@NotNull Project project, @NotNull ShowImagePopupUtil.Request event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ActionsKt.runInEdt$default(null, () -> ShowImagePopupRemoteTopicListener.handleEvent$lambda$0(project, event), (int)1, null);
    }

    private static final Unit handleEvent$lambda$0(Project $project, ShowImagePopupUtil.Request $event) {
        JComponent jComponent;
        JFrame frame = WindowManager.getInstance().getFrame($project);
        if (frame == null) {
            return Unit.INSTANCE;
        }
        Dimension popupSize = new Dimension(frame.getSize().width / 2, frame.getSize().height / 2);
        byte[] imageData = $event.getImageData();
        if (imageData != null) {
            jComponent = ImageEditorUIUtil.INSTANCE.createImageEditorUI(imageData);
            if (jComponent == null) {
                return Unit.INSTANCE;
            }
        } else {
            jComponent = new JLabel(CommonBundle.message((String)"label.no.data", (Object[])new Object[0]), 0);
        }
        JComponent content = jComponent;
        JBPopup popup = DebuggerUIUtil.createValuePopup((Project)$project, (JComponent)content, null);
        if (content instanceof Disposable) {
            Disposer.register((Disposable)((Disposable)popup), (Disposable)((Disposable)content));
        }
        popup.setSize(popupSize);
        popup.show(new RelativePoint((Component)frame, new Point(popupSize.width / 2, popupSize.height / 2)));
        return Unit.INSTANCE;
    }
}

