/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.TooltipEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.IconManager;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredComponentWithProgress;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.evaluate.ValueLookupManagerController;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.evaluate.quick.common.XDebuggerPopupPanel;
import com.intellij.xdebugger.impl.evaluate.quick.common.XDebuggerTextPopup;
import com.intellij.xdebugger.impl.evaluate.quick.common.XDebuggerTooltipPopup;
import com.intellij.xdebugger.impl.evaluate.quick.common.XDebuggerTreePopup;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.intellij.xdebugger.impl.ui.tree.nodes.HeadlessValueEvaluationCallbackBase;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractValueHint {
    private static final Logger LOG = Logger.getInstance(AbstractValueHint.class);
    private static final Key<AbstractValueHint> HINT_KEY = Key.create((String)"allows only one value hint per editor");
    private final KeyListener myEditorKeyListener;
    private RangeHighlighter myHighlighter;
    private boolean myCursorSet;
    private final Project myProject;
    @ApiStatus.Internal
    protected final Editor myEditor;
    @ApiStatus.Internal
    protected final ValueHintType myType;
    protected final Point myPoint;
    private EditorMouseEvent myEditorMouseEvent;
    private LightweightHint myCurrentHint;
    private JBPopup myCurrentPopup;
    private volatile boolean myHintHidden;
    private TextRange myCurrentRange;
    private Runnable myHideRunnable;
    HintListener hintListener;
    private static final Key<TextAttributes> HINT_TEXT_ATTRIBUTES = Key.create((String)"HINT_TEXT_ATTRIBUTES");
    @ApiStatus.Internal
    protected boolean myInsideShow;

    public AbstractValueHint(@NotNull Project project, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type, TextRange textRange) {
        if (project == null) {
            AbstractValueHint.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            AbstractValueHint.$$$reportNull$$$0(1);
        }
        if (point == null) {
            AbstractValueHint.$$$reportNull$$$0(2);
        }
        if (type == null) {
            AbstractValueHint.$$$reportNull$$$0(3);
        }
        this.myEditorKeyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (!AbstractValueHint.isAltMask(e.getModifiers())) {
                    ValueLookupManagerController.getInstance(AbstractValueHint.this.myProject).hideHint();
                }
            }
        };
        this.hintListener = new HintListener(){

            public void hintHidden(@NotNull EventObject event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                AbstractValueHint.this.processHintHidden();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint$2", "hintHidden"));
            }
        };
        this.myInsideShow = false;
        this.myPoint = point;
        this.myProject = project;
        this.myEditor = editor;
        this.myType = type;
        this.myCurrentRange = textRange;
    }

    protected abstract void evaluateAndShowHint();

    boolean isInsideCurrentRange(Editor editor, Point point) {
        return this.myCurrentRange != null && this.myCurrentRange.contains(AbstractValueHint.calculateOffset(editor, point));
    }

    public static int calculateOffset(@NotNull Editor editor, @NotNull Point point) {
        if (editor == null) {
            AbstractValueHint.$$$reportNull$$$0(4);
        }
        if (point == null) {
            AbstractValueHint.$$$reportNull$$$0(5);
        }
        return editor.logicalPositionToOffset(editor.xyToLogicalPosition(point));
    }

    public void hideHint() {
        this.myHintHidden = true;
        this.myCurrentRange = null;
        if (this.myCursorSet) {
            this.myCursorSet = false;
            if (this.myEditor instanceof EditorEx) {
                ((EditorEx)this.myEditor).setCustomCursor(AbstractValueHint.class, null);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("restore cursor in editor");
            }
            this.myEditor.getContentComponent().removeKeyListener(this.myEditorKeyListener);
        }
        this.hideCurrentHint();
        this.disposeHighlighter();
    }

    void disposeHighlighter() {
        if (this.myHighlighter != null) {
            this.myHighlighter.dispose();
            this.myHighlighter = null;
        }
    }

    public void invokeHint() {
        this.invokeHint(null);
    }

    public void invokeHint(Runnable hideRunnable) {
        this.myHideRunnable = hideRunnable;
        if (!this.isCurrentRangeValid()) {
            this.hideHint();
            return;
        }
        this.createHighlighter();
        if (this.myType != ValueHintType.MOUSE_ALT_OVER_HINT) {
            WriteIntentReadAction.run(() -> this.evaluateAndShowHint());
        }
    }

    private void setHighlighterAttributes() {
        TextAttributes attributes;
        if (this.myHighlighter != null && (attributes = (TextAttributes)this.myHighlighter.getUserData(HINT_TEXT_ATTRIBUTES)) != null) {
            ((RangeHighlighterEx)this.myHighlighter).setTextAttributes(attributes);
        }
    }

    private void createHighlighter() {
        TextAttributes attributes;
        if (this.myType == ValueHintType.MOUSE_ALT_OVER_HINT) {
            attributes = this.myEditor.getColorsScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR);
            attributes = NavigationUtil.patchAttributesColor((TextAttributes)attributes, (TextRange)this.myCurrentRange, (Editor)this.myEditor);
        } else {
            attributes = new TextAttributes();
        }
        this.disposeHighlighter();
        this.myHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(this.myCurrentRange.getStartOffset(), this.myCurrentRange.getEndOffset(), 6000, attributes, HighlighterTargetArea.EXACT_RANGE);
        if (this.myType == ValueHintType.MOUSE_ALT_OVER_HINT) {
            this.myEditor.getContentComponent().addKeyListener(this.myEditorKeyListener);
            if (this.myEditor instanceof EditorEx) {
                ((EditorEx)this.myEditor).setCustomCursor(AbstractValueHint.class, AbstractValueHint.hintCursor());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("set hint cursor to editor");
            }
            this.myCursorSet = true;
        } else {
            TextAttributesKey attributesKey = DebuggerColors.EVALUATED_EXPRESSION_ATTRIBUTES;
            MarkupModel model = DocumentMarkupModel.forDocument((Document)this.myEditor.getDocument(), (Project)this.myProject, (boolean)false);
            if (model != null && !((MarkupModelEx)model).processRangeHighlightersOverlappingWith(this.myCurrentRange.getStartOffset(), this.myCurrentRange.getEndOffset(), h -> (Boolean)ExecutionPointHighlighter.EXECUTION_POINT_HIGHLIGHTER_TOP_FRAME_KEY.get((UserDataHolder)h, (Object)false) == false)) {
                attributesKey = DebuggerColors.EVALUATED_EXPRESSION_EXECUTION_LINE_ATTRIBUTES;
            }
            this.myHighlighter.putUserData(HINT_TEXT_ATTRIBUTES, (Object)this.myEditor.getColorsScheme().getAttributes(attributesKey));
        }
    }

    private static Cursor hintCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public final Project getProject() {
        return this.myProject;
    }

    @NotNull
    protected final Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            AbstractValueHint.$$$reportNull$$$0(6);
        }
        return editor;
    }

    @ApiStatus.Internal
    public ValueHintType getType() {
        return this.myType;
    }

    protected final void hideCurrentHint() {
        EDT.assertIsEdt();
        if (this.myCurrentHint != null) {
            this.myCurrentHint.hide();
            this.myCurrentHint.removeHintListener(this.hintListener);
            this.myCurrentHint = null;
        }
        if (this.myCurrentPopup != null) {
            this.myCurrentPopup.cancel();
            this.myCurrentPopup = null;
        }
    }

    protected void processHintHidden() {
        if (!this.myInsideShow) {
            if (this.myHideRunnable != null) {
                this.myHideRunnable.run();
            }
            this.myHintHidden = true;
        }
        this.disposeHighlighter();
        if (this.getEditor().getUserData(HINT_KEY) == this) {
            this.getEditor().putUserData(HINT_KEY, null);
        }
        this.onHintHidden();
    }

    private void setCurrentEditorHint() {
        AbstractValueHint prev = (AbstractValueHint)this.getEditor().getUserData(HINT_KEY);
        if (prev != null) {
            prev.hideHint();
        }
        this.getEditor().putUserData(HINT_KEY, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean showHint(JComponent component) {
        this.myInsideShow = true;
        try {
            this.hideCurrentHint();
            BorderLayoutPanel content = JBUI.Panels.simplePanel();
            content.setBackground(component.getBackground());
            content.setBorder(JBUI.Borders.empty((int)10));
            content.addToCenter((Component)component);
            this.myCurrentHint = new LightweightHint((JComponent)content){

                protected boolean canAutoHideOn(TooltipEvent event) {
                    Component comp;
                    InputEvent inputEvent = event.getInputEvent();
                    if (inputEvent instanceof MouseEvent && (comp = inputEvent.getComponent()) instanceof EditorComponentImpl) {
                        EditorImpl editor = ((EditorComponentImpl)comp).getEditor();
                        return !AbstractValueHint.this.isInsideCurrentRange((Editor)editor, ((MouseEvent)inputEvent).getPoint());
                    }
                    return true;
                }
            };
            this.myCurrentHint.setForceShowAsPopup(true);
            this.myCurrentHint.addHintListener(this.hintListener);
            if (this.myEditor.isDisposed()) {
                boolean bl = false;
                return bl;
            }
            AppUIUtil.targetToDevice((Component)this.myCurrentHint.getComponent(), (Component)this.myEditor.getComponent());
            Point p = HintManagerImpl.getHintPosition((LightweightHint)this.myCurrentHint, (Editor)this.myEditor, (LogicalPosition)this.myEditor.xyToLogicalPosition(this.myPoint), (short)2);
            HintHint hint = HintManagerImpl.createHintHint((Editor)this.myEditor, (Point)p, (LightweightHint)this.myCurrentHint, (short)2, (boolean)true);
            hint.setShowImmediately(true);
            HintManagerImpl.getInstanceImpl().showEditorHint(this.myCurrentHint, this.myEditor, p, 42, 0, false, hint);
            if (this.myHighlighter == null && this.isCurrentRangeValid()) {
                this.createHighlighter();
            }
            this.setHighlighterAttributes();
            this.setCurrentEditorHint();
        }
        finally {
            this.myInsideShow = false;
        }
        return true;
    }

    private boolean isCurrentRangeValid() {
        return this.myCurrentRange != null && DocumentUtil.isValidOffset((int)this.myCurrentRange.getEndOffset(), (Document)this.myEditor.getDocument());
    }

    protected void onHintHidden() {
    }

    @ApiStatus.Internal
    public boolean isHintHidden() {
        return this.myHintHidden;
    }

    @ApiStatus.Internal
    protected SimpleColoredComponent fillSimpleColoredComponent(SimpleColoredComponent component, Icon icon, SimpleColoredText text, @Nullable XFullValueEvaluator evaluator) {
        HintUtil.installInformationProperties((Component)component);
        component.setIcon(icon);
        component.setCursor(AbstractValueHint.hintCursor());
        text.appendToComponent((ColoredTextContainer)component);
        this.appendEvaluatorLink(evaluator, component);
        return component;
    }

    protected JComponent createExpandableHintComponent(@Nullable Icon icon, SimpleColoredText text, Runnable expand, @Nullable XFullValueEvaluator evaluator) {
        return this.createExpandableHintComponent(icon, text, expand, evaluator, null);
    }

    @ApiStatus.Internal
    protected SimpleColoredComponent createExpandableHintComponent(@Nullable Icon icon, SimpleColoredText text, final Runnable expand, @Nullable XFullValueEvaluator evaluator, @Nullable XValuePresentation valuePresenter) {
        Icon notNullIcon = icon != null ? IconManager.getInstance().createRowIcon(new Icon[]{UIUtil.getTreeCollapsedIcon(), icon}) : UIUtil.getTreeCollapsedIcon();
        SimpleColoredComponent component = this.fillSimpleColoredComponent(AbstractValueHint.createComponent(valuePresenter), notNullIcon, text, evaluator);
        new ClickListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    Object tag = ((SimpleColoredComponent)e.getSource()).getFragmentTagAt(e.getX());
                    if (tag != null) {
                        if (tag instanceof Consumer) {
                            Consumer consumer = (Consumer)tag;
                            consumer.accept(e);
                        } else {
                            ((Runnable)tag).run();
                        }
                    } else {
                        AbstractValueHint.this.myInsideShow = true;
                        try {
                            AbstractValueHint.this.hideCurrentHint();
                            expand.run();
                        }
                        finally {
                            AbstractValueHint.this.myInsideShow = false;
                        }
                    }
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint$4", "onClick"));
            }
        }.installOn((Component)component);
        return component;
    }

    protected final void appendEvaluatorLink(@Nullable XFullValueEvaluator evaluator, SimpleColoredComponent component) {
        if (evaluator != null) {
            component.append(evaluator.getLinkText(), XDebuggerTreeNodeHyperlink.TEXT_ATTRIBUTES, event -> {
                if (evaluator.isShowValuePopup()) {
                    DebuggerUIUtil.showValuePopup(evaluator, event, this.getProject(), this.getEditor());
                } else {
                    new HeadlessValueEvaluationCallbackBase(this.getProject()).startFetchingValue(evaluator);
                }
            });
        }
    }

    @Nullable
    protected TextRange getCurrentRange() {
        return this.myCurrentRange;
    }

    private static boolean isAltMask(@JdkConstants.InputEventMask int modifiers) {
        return KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)KeymapManager.getInstance().getActiveKeymap(), (int)modifiers, (String)"QuickEvaluateExpression");
    }

    @Nullable
    public static ValueHintType getHintType(EditorMouseEvent e) {
        int modifiers = e.getMouseEvent().getModifiers();
        if (modifiers == 0) {
            return ValueHintType.MOUSE_OVER_HINT;
        }
        if (AbstractValueHint.isAltMask(modifiers)) {
            return ValueHintType.MOUSE_ALT_OVER_HINT;
        }
        return null;
    }

    protected boolean isShowing() {
        return this.myCurrentHint != null || this.myCurrentPopup != null;
    }

    public boolean isInsideHint(Editor editor, Point point) {
        return this.myCurrentHint != null && this.myCurrentHint.isInsideHint(new RelativePoint((Component)editor.getContentComponent(), point));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPopup(Function<Point, @Nullable JBPopup> popupPresenter) {
        EDT.assertIsEdt();
        this.myInsideShow = true;
        try {
            if (this.myEditor.isDisposed() || !this.isCurrentRangeValid()) {
                this.hideHint();
                return;
            }
            this.hideCurrentHint();
            this.createHighlighter();
            this.setHighlighterAttributes();
            Point point = this.myEditor.visualPositionToXY(this.myEditor.xyToVisualPosition(this.myPoint));
            point.translate(0, this.myEditor.getLineHeight());
            JBPopup popup2 = popupPresenter.apply(point);
            if (popup2 != null) {
                this.myCurrentPopup = popup2;
                this.myEditor.getScrollingModel().addVisibleAreaListener(e -> {
                    if (!Objects.equals(e.getOldRectangle(), e.getNewRectangle())) {
                        this.hideCurrentHint();
                    }
                }, (Disposable)popup2);
                this.myEditor.getCaretModel().addCaretListener(new CaretListener(){

                    public void caretPositionChanged(@NotNull CaretEvent event) {
                        if (event == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        AbstractValueHint.this.hideCurrentHint();
                    }

                    public void caretAdded(@NotNull CaretEvent event) {
                        if (event == null) {
                            5.$$$reportNull$$$0(1);
                        }
                        AbstractValueHint.this.hideCurrentHint();
                    }

                    public void caretRemoved(@NotNull CaretEvent event) {
                        if (event == null) {
                            5.$$$reportNull$$$0(2);
                        }
                        AbstractValueHint.this.hideCurrentHint();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "event";
                        objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint$5";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "caretPositionChanged";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "caretAdded";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "caretRemoved";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, (Disposable)popup2);
                popup2.addListener(new JBPopupListener(){

                    public void onClosed(@NotNull LightweightWindowEvent event) {
                        if (event == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        AbstractValueHint.this.processHintHidden();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint$6", "onClosed"));
                    }
                });
                this.setCurrentEditorHint();
            }
        }
        finally {
            this.myInsideShow = false;
        }
    }

    protected <D> void showTreePopup(@NotNull DebuggerTreeCreator<D> creator, @NotNull D descriptor) {
        if (creator == null) {
            AbstractValueHint.$$$reportNull$$$0(7);
        }
        if (descriptor == null) {
            AbstractValueHint.$$$reportNull$$$0(8);
        }
        this.showPopup(point -> new XDebuggerTreePopup<Object>(creator, this.myEditor, (Point)point, this.myProject, null).show(descriptor));
    }

    @ApiStatus.Experimental
    protected void showTextPopup(@NotNull XDebuggerTreeCreator creator, @NotNull Pair<XValue, String> descriptor, @NotNull String initialText, @Nullable XFullValueEvaluator evaluator) {
        if (creator == null) {
            AbstractValueHint.$$$reportNull$$$0(9);
        }
        if (descriptor == null) {
            AbstractValueHint.$$$reportNull$$$0(10);
        }
        if (initialText == null) {
            AbstractValueHint.$$$reportNull$$$0(11);
        }
        this.showPopup(point -> new XDebuggerTextPopup<Pair>(evaluator, (XValue)descriptor.first, creator, (Pair)descriptor, this.myEditor, (Point)point, this.myProject, null).show(initialText));
    }

    protected void showTooltipPopup(JComponent component) {
        this.showPopup(point -> new XDebuggerTooltipPopup(this.myEditor, (Point)point).show(component, this.myEditorMouseEvent));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractValueHint hint = (AbstractValueHint)o;
        if (!this.myProject.equals((Object)hint.myProject)) {
            return false;
        }
        if (!this.myEditor.equals((Object)hint.myEditor)) {
            return false;
        }
        if (this.myType != hint.myType) {
            return false;
        }
        return Objects.equals(this.myCurrentRange, hint.myCurrentRange);
    }

    public int hashCode() {
        return Objects.hash(this.myProject, this.myEditor, this.myType, this.myCurrentRange);
    }

    @ApiStatus.Internal
    public void setEditorMouseEvent(EditorMouseEvent editorMouseEvent) {
        this.myEditorMouseEvent = editorMouseEvent;
    }

    @ApiStatus.Internal
    @Nullable
    protected EditorMouseEvent getEditorMouseEvent() {
        return this.myEditorMouseEvent;
    }

    @ApiStatus.Internal
    protected void resizePopup(int widthDelta, int hightDelta) {
        if (this.myCurrentPopup == null) {
            return;
        }
        Window popupWindow = SwingUtilities.windowForComponent(this.myCurrentPopup.getContent());
        if (popupWindow == null) {
            return;
        }
        Dimension popupSize = this.myCurrentPopup.getSize();
        XDebuggerPopupPanel.updatePopupBounds(popupWindow, popupSize.width + widthDelta, popupSize.height + hightDelta);
    }

    private static SimpleColoredComponent createComponent(@Nullable XValuePresentation valuePresenter) {
        return valuePresenter != null && valuePresenter.isAsync() ? new SimpleColoredComponentWithProgress() : new SimpleColoredComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateOffset";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showTreePopup";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showTextPopup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

