/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SimpleColoredComponent;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ui/PathTextClipping;", "Lcom/intellij/ui/SimpleColoredComponent$FragmentTextClipper;", "<init>", "()V", "clipText", "", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "g2", "Ljava/awt/Graphics2D;", "fragmentIndex", "", "text", "availTextWidth", "Companion", "intellij.platform.ide"})
public final class PathTextClipping
implements SimpleColoredComponent.FragmentTextClipper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final PathTextClipping INSTANCE = new PathTextClipping();

    @Override
    @NotNull
    public String clipText(@NotNull SimpleColoredComponent component, @NotNull Graphics2D g2, int fragmentIndex, @NotNull String text, int availTextWidth) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        FontMetrics fm = component.getFontMetrics(g2.getFont());
        if (fm.stringWidth(text) <= availTextWidth) {
            return text;
        }
        String separator = "/";
        String ellipsis = "...";
        String[] stringArray = new String[]{separator};
        List parts = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        while (!parts.isEmpty() && fm.stringWidth(String.join((CharSequence)separator, parts) + separator + ellipsis) > availTextWidth) {
            parts.remove(0);
        }
        if (!parts.isEmpty()) {
            parts.add(0, ellipsis);
            CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)separator, null, null, (int)0, null, null, (int)62, null);
            String string = String.join((CharSequence)separator, parts);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
            return string;
        }
        return ellipsis;
    }

    @JvmStatic
    @NotNull
    public static final PathTextClipping getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ui/PathTextClipping$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/intellij/ui/PathTextClipping;", "getInstance", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PathTextClipping getInstance() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

