/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.GroupedElementsRenderer;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class GroupedItemsListRenderer<E>
extends GroupedElementsRenderer.List
implements ListCellRenderer<E> {
    protected ListItemDescriptor<E> myDescriptor;
    protected JLabel myNextStepLabel;
    protected int myCurrentIndex;

    public JLabel getNextStepLabel() {
        return this.myNextStepLabel;
    }

    public GroupedItemsListRenderer(ListItemDescriptor<E> descriptor2) {
        this.myDescriptor = descriptor2;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends E> list, E value2, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent jComponent;
        String caption = this.myDescriptor.getCaptionAboveOf(value2);
        boolean hasSeparator = this.hasSeparator(value2, index);
        Icon icon = this.getItemIcon(value2, isSelected);
        JComponent result2 = this.configureComponent(this.myDescriptor.getTextFor(value2), this.myDescriptor.getTooltipFor(value2), icon, icon, isSelected, hasSeparator, caption, -1);
        this.myCurrentIndex = index;
        this.myRendererComponent.setBackground(list.getBackground());
        this.customizeComponent(list, value2, index, isSelected, cellHasFocus);
        if (ExperimentalUI.isNewUI() && (jComponent = this.getItemComponent()) instanceof SelectablePanel) {
            SelectablePanel selectablePanel = (SelectablePanel)jComponent;
            selectablePanel.setSelectionColor(isSelected ? JBUI.CurrentTheme.List.background((boolean)true, (boolean)true) : null);
        }
        return result2;
    }

    @ApiStatus.Internal
    protected boolean hasSeparator(E value2, int index) {
        String caption = this.myDescriptor.getCaptionAboveOf(value2);
        if (index == 0 && StringUtil.isEmptyOrSpaces((String)caption)) {
            return false;
        }
        return this.myDescriptor.hasSeparatorAboveOf(value2);
    }

    @Nullable
    protected Icon getItemIcon(E value2, boolean isSelected) {
        return isSelected ? IconUtil.wrapToSelectionAwareIcon((Icon)this.myDescriptor.getSelectedIconFor(value2)) : this.myDescriptor.getIconFor(value2);
    }

    @Override
    protected JComponent createItemComponent() {
        this.createLabel();
        return this.layoutComponent(this.myTextLabel);
    }

    protected void createLabel() {
        this.myTextLabel = new ErrorLabel();
        this.myTextLabel.setBorder((Border)(ExperimentalUI.isNewUI() ? JBUI.Borders.empty() : JBUI.Borders.emptyBottom((int)1)));
        this.myTextLabel.setOpaque(true);
    }

    protected JComponent layoutComponent(JComponent middleItemComponent) {
        this.myNextStepLabel = new JLabel();
        this.myNextStepLabel.setOpaque(false);
        if (ExperimentalUI.isNewUI()) {
            SelectablePanel result2 = SelectablePanel.wrap(middleItemComponent);
            PopupUtil.configListRendererFlexibleHeight(result2);
            result2.add((Component)this.myNextStepLabel, "East");
            return result2;
        }
        return JBUI.Panels.simplePanel((Component)middleItemComponent).addToRight((Component)this.myNextStepLabel).withBorder(this.getDefaultItemComponentBorder());
    }

    protected void customizeComponent(JList<? extends E> list, E value2, boolean isSelected) {
    }

    protected void customizeComponent(JList<? extends E> list, E value2, int index, boolean isSelected, boolean cellHasFocus) {
        this.customizeComponent(list, value2, isSelected);
    }
}

