/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.impl.JBDefaultTabPainter;
import com.intellij.ui.tabs.impl.themes.EditorTabTheme;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\rH\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ui/tabs/impl/JBEditorTabPainter;", "Lcom/intellij/ui/tabs/impl/JBDefaultTabPainter;", "<init>", "()V", "paintLeftGap", "", "position", "Lcom/intellij/ui/tabs/JBTabsPosition;", "g", "Ljava/awt/Graphics2D;", "rect", "Ljava/awt/Rectangle;", "borderThickness", "", "paintRightGap", "paintTopGap", "paintBottomGap", "underlineRectangle", "thickness", "intellij.platform.ide"})
public final class JBEditorTabPainter
extends JBDefaultTabPainter {
    public JBEditorTabPainter() {
        super(new EditorTabTheme());
    }

    public final void paintLeftGap(@NotNull JBTabsPosition position, @NotNull Graphics2D g, @NotNull Rectangle rect, int borderThickness) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        int maxY = rect.y + rect.height - borderThickness;
        this.paintBorderLine(g, borderThickness, new Point(rect.x, rect.y), new Point(rect.x, maxY));
    }

    public final void paintRightGap(@NotNull JBTabsPosition position, @NotNull Graphics2D g, @NotNull Rectangle rect, int borderThickness) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        int maxX = rect.x + rect.width - borderThickness;
        int maxY = rect.y + rect.height - borderThickness;
        this.paintBorderLine(g, borderThickness, new Point(maxX, rect.y), new Point(maxX, maxY));
    }

    public final void paintTopGap(@NotNull JBTabsPosition position, @NotNull Graphics2D g, @NotNull Rectangle rect, int borderThickness) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        int maxX = rect.x + rect.width;
        this.paintBorderLine(g, borderThickness, new Point(rect.x, rect.y), new Point(maxX, rect.y));
    }

    public final void paintBottomGap(@NotNull JBTabsPosition position, @NotNull Graphics2D g, @NotNull Rectangle rect, int borderThickness) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        int maxX = rect.x + rect.width - borderThickness;
        int maxY = rect.y + rect.height - borderThickness;
        this.paintBorderLine(g, borderThickness, new Point(rect.x, maxY), new Point(maxX, maxY));
    }

    @Override
    @NotNull
    protected Rectangle underlineRectangle(@NotNull JBTabsPosition position, @NotNull Rectangle rect, int thickness) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return switch (WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
            case 1 -> new Rectangle(rect.x, rect.y, rect.width, thickness);
            case 2 -> {
                if (ExperimentalUI.Companion.isNewUI()) {
                    yield new Rectangle(rect.x, rect.y, thickness, rect.height);
                }
                yield new Rectangle(rect.x + rect.width - thickness, rect.y, thickness, rect.height);
            }
            case 3 -> new Rectangle(rect.x, rect.y, thickness, rect.height);
            default -> super.underlineRectangle(position, rect, thickness);
        };
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JBTabsPosition.values().length];
            try {
                nArray[JBTabsPosition.bottom.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JBTabsPosition.left.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JBTabsPosition.right.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

