/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.UIBundle;
import java.io.IOError;
import java.io.UncheckedIOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import org.jetbrains.annotations.NotNull;

public final class IoErrorText {
    @NlsSafe
    @NotNull
    public static String message(@NotNull Throwable t) {
        if (t == null) {
            IoErrorText.$$$reportNull$$$0(0);
        }
        String message = t.getMessage();
        if (t instanceof UncheckedIOException || t instanceof IOError) {
            t = t.getCause();
        }
        if (message == null || message.trim().isEmpty()) {
            String string = UIBundle.message("io.error.unknown", new Object[0]);
            if (string == null) {
                IoErrorText.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (t instanceof AccessDeniedException) {
            AccessDeniedException ade = (AccessDeniedException)t;
            String reason = ade.getReason();
            if (reason != null) {
                String string = UIBundle.message("io.error.access.denied.reason", message, reason);
                if (string == null) {
                    IoErrorText.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = UIBundle.message("io.error.access.denied", message);
            if (string == null) {
                IoErrorText.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (t instanceof DirectoryNotEmptyException) {
            String string = UIBundle.message("io.error.dir.not.empty", message);
            if (string == null) {
                IoErrorText.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (t instanceof FileAlreadyExistsException) {
            String string = UIBundle.message("io.error.already.exists", message);
            if (string == null) {
                IoErrorText.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (t instanceof NoSuchFileException) {
            String string = UIBundle.message("io.error.no.such.file", message);
            if (string == null) {
                IoErrorText.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (t instanceof NotDirectoryException) {
            String string = UIBundle.message("io.error.not.dir", message);
            if (string == null) {
                IoErrorText.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (t instanceof NotLinkException) {
            String string = UIBundle.message("io.error.not.link", message);
            if (string == null) {
                IoErrorText.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (t instanceof FileSystemException && message.equals(((FileSystemException)t).getFile())) {
            String string = t.getClass().getSimpleName() + ": " + message;
            if (string == null) {
                IoErrorText.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = message;
        if (string == null) {
            IoErrorText.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/IoErrorText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/IoErrorText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

