/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.shared.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.vcs.impl.shared.ui.RepositoryColorGenerator;
import com.intellij.platform.vcs.impl.shared.ui.RepositoryColors;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001b*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u001bB7\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0014J6\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00060\u0010\"\u0004\b\u0001\u0010\u00012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0004H\u0002J&\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0004H\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/vcs/impl/shared/ui/RepositoryColorGeneratorImpl;", "RepoID", "Lcom/intellij/platform/vcs/impl/shared/ui/RepositoryColorGenerator;", "repoIds", "", "mainPalette", "Ljava/awt/Color;", "additionalColorSpaces", "", "Lcom/intellij/platform/vcs/impl/shared/ui/RepositoryColorGenerator$AdditionalColorSpace;", "<init>", "(Ljava/util/List;Ljava/util/List;[Lcom/intellij/platform/vcs/impl/shared/ui/RepositoryColorGenerator$AdditionalColorSpace;)V", "ids", "colorSpace2Colors", "", "", "", "getColor", "repoId", "colorSpace", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/awt/Color;", "generateFromPalette", "colors", "generateColorFor", "repoNumber", "", "repoCount", "Companion", "intellij.platform.vcs.impl.shared"})
@SourceDebugExtension(value={"SMAP\nRepositoryColorsApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryColorsApi.kt\ncom/intellij/platform/vcs/impl/shared/ui/RepositoryColorGeneratorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1596#2:137\n1629#2,4:138\n*S KotlinDebug\n*F\n+ 1 RepositoryColorsApi.kt\ncom/intellij/platform/vcs/impl/shared/ui/RepositoryColorGeneratorImpl\n*L\n98#1:137\n98#1:138,4\n*E\n"})
final class RepositoryColorGeneratorImpl<RepoID>
implements RepositoryColorGenerator<RepoID> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<RepoID> ids;
    @NotNull
    private final Map<String, Map<RepoID, Color>> colorSpace2Colors;
    @NotNull
    private static final Logger LOG;

    public RepositoryColorGeneratorImpl(@NotNull List<? extends RepoID> repoIds, @NotNull List<? extends Color> mainPalette, RepositoryColorGenerator.AdditionalColorSpace ... additionalColorSpaces) {
        Intrinsics.checkNotNullParameter(repoIds, (String)"repoIds");
        Intrinsics.checkNotNullParameter(mainPalette, (String)"mainPalette");
        Intrinsics.checkNotNullParameter((Object)additionalColorSpaces, (String)"additionalColorSpaces");
        this.ids = CollectionsKt.toList((Iterable)repoIds);
        this.colorSpace2Colors = new LinkedHashMap();
        this.colorSpace2Colors.put("default", this.generateFromPalette(mainPalette, this.ids));
        for (RepositoryColorGenerator.AdditionalColorSpace colorSpace : additionalColorSpaces) {
            if (Intrinsics.areEqual((Object)colorSpace.getColorKey(), (Object)"default") || colorSpace.getColors().size() != mainPalette.size()) continue;
            Map<RepoID, Color> colors = this.generateFromPalette(new ArrayList(colorSpace.getColors()), this.ids);
            this.colorSpace2Colors.put(colorSpace.getColorKey(), colors);
        }
    }

    @Override
    @NotNull
    public Color getColor(RepoID repoId, @NotNull String colorSpace) {
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        Map<RepoID, Color> map2 = this.colorSpace2Colors.get(colorSpace);
        if (map2 == null && (map2 = this.colorSpace2Colors.get("default")) == null) {
            return RepositoryColors.INSTANCE.getDefaultColor();
        }
        Map<RepoID, Color> repoColors = map2;
        Color color = repoColors.get(repoId);
        if (color != null) {
            return color;
        }
        LOG.error("No color record for repo id " + repoId + ". All colors: " + repoColors);
        return RepositoryColors.INSTANCE.getDefaultColor();
    }

    /*
     * WARNING - void declaration
     */
    private final <RepoID> Map<RepoID, Color> generateFromPalette(List<? extends Color> colors, List<? extends RepoID> ids) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = ids;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void value;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)value, (Object)this.generateColorFor((int)index, ids.size(), colors)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final Color generateColorFor(int repoNumber, int repoCount, List<? extends Color> colors) {
        Color color = null;
        int size = colors.size();
        if (repoNumber >= size) {
            double balance = (double)(repoNumber / size) / (double)(repoCount / size);
            Color color2 = ColorUtil.mix((Color)colors.get(repoNumber % size), (Color)colors.get((repoNumber + 1) % size), (double)balance);
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"mix(...)");
            Color mix = color2;
            int tones = (int)(Math.abs(balance - 0.5) * (double)2 * (double)(repoCount / size) + 1.0);
            if (mix instanceof JBColor) {
                JBColor jBColor = JBColor.lazy(() -> RepositoryColorGeneratorImpl.generateColorFor$lambda$0(mix, tones));
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"lazy(...)");
                color = (Color)jBColor;
            } else {
                color = (Color)new JBColor(ColorUtil.darker((Color)mix, (int)tones), ColorUtil.brighter((Color)mix, (int)(2 * tones)));
            }
        } else {
            color = colors.get(repoNumber);
        }
        return color;
    }

    private static final JBColor generateColorFor$lambda$0(Color $mix, int $tones) {
        return new JBColor(ColorUtil.darker((Color)$mix, (int)$tones), ColorUtil.brighter((Color)$mix, (int)(2 * $tones)));
    }

    static {
        Logger logger = Logger.getInstance(RepositoryColorGenerator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/vcs/impl/shared/ui/RepositoryColorGeneratorImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.impl.shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

