/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtf8Writer;
import io.netty.buffer.ByteBufUtil;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.JsonRpcDomainBean;
import org.jetbrains.io.jsonRpc.JsonRpcServer;
import org.jetbrains.io.jsonRpc.JsonRpcServerKt;
import org.jetbrains.io.jsonRpc.JsonServiceInvocator;
import org.jetbrains.io.jsonRpc.MessageServer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\"\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\"\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ \u0010 \u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J7\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%\u00a2\u0006\u0002\u0010&J;\u0010'\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0016\u0010$\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0%\"\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010(JG\u0010)\u001a\b\u0012\u0004\u0012\u0002H+0*\"\u0004\b\u0000\u0010+2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0016\u0010$\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0%\"\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010,J3\u0010'\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010#\u001a\u00020\n2\u0016\u0010$\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0%\"\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010-JQ\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u0002002\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\f\b\u0002\u0010$\u001a\u0006\u0012\u0002\b\u00030%H\u0002\u00a2\u0006\u0002\u00101JG\u00102\u001a\u00020\u001f2\u0006\u0010/\u001a\u0002002\u0006\u00103\u001a\u00020\u001c2\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\u0010#\u001a\u0004\u0018\u00010\n2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u00104J1\u00105\u001a\u00020\r2\u0006\u00106\u001a\u00020\u001f2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u000e\u00107\u001a\n\u0018\u000108j\u0004\u0018\u0001`9H\u0002\u00a2\u0006\u0002\u0010:R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/io/jsonRpc/JsonRpcServer;", "Lorg/jetbrains/io/jsonRpc/MessageServer;", "clientManager", "Lorg/jetbrains/io/jsonRpc/ClientManager;", "<init>", "(Lorg/jetbrains/io/jsonRpc/ClientManager;)V", "messageIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "testDomain", "Lkotlin/Pair;", "", "", "registerTestDomain", "", "name", "domain", "disposable", "Lcom/intellij/openapi/Disposable;", "messageReceived", "client", "Lorg/jetbrains/io/jsonRpc/Client;", "message", "", "findDomain", "domainName", "processClientError", "error", "messageId", "", "sendResponse", "rawData", "Lio/netty/buffer/ByteBuf;", "sendErrorResponse", "sendWithRawPart", "", "command", "params", "", "(Lorg/jetbrains/io/jsonRpc/Client;Ljava/lang/String;Ljava/lang/String;Lio/netty/buffer/ByteBuf;[Ljava/lang/Object;)Z", "send", "(Lorg/jetbrains/io/jsonRpc/Client;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "call", "Lorg/jetbrains/concurrency/Promise;", "T", "(Lorg/jetbrains/io/jsonRpc/Client;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Lorg/jetbrains/concurrency/Promise;", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "encodeMessage", "byteBufAllocator", "Lio/netty/buffer/ByteBufAllocator;", "(Lio/netty/buffer/ByteBufAllocator;ILjava/lang/String;Ljava/lang/String;Lio/netty/buffer/ByteBuf;[Ljava/lang/Object;)Lio/netty/buffer/ByteBuf;", "doEncodeMessage", "id", "(Lio/netty/buffer/ByteBufAllocator;ILjava/lang/String;Ljava/lang/String;[Ljava/lang/Object;Lio/netty/buffer/ByteBuf;)Lio/netty/buffer/ByteBuf;", "encodeParameters", "buffer", "_sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Lio/netty/buffer/ByteBuf;[Ljava/lang/Object;Ljava/lang/StringBuilder;)V", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nJsonRpcServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonRpcServer.kt\norg/jetbrains/io/jsonRpc/JsonRpcServer\n+ 2 netty.kt\ncom/intellij/util/io/NettyKt\n*L\n1#1,358:1\n219#2,9:359\n*S KotlinDebug\n*F\n+ 1 JsonRpcServer.kt\norg/jetbrains/io/jsonRpc/JsonRpcServer\n*L\n137#1:359,9\n*E\n"})
public final class JsonRpcServer
implements MessageServer {
    @NotNull
    private final ClientManager clientManager;
    @NotNull
    private final AtomicInteger messageIdCounter;
    @TestOnly
    @Nullable
    private Pair<String, ? extends Object> testDomain;

    public JsonRpcServer(@NotNull ClientManager clientManager) {
        Intrinsics.checkNotNullParameter((Object)clientManager, (String)"clientManager");
        this.clientManager = clientManager;
        this.messageIdCounter = new AtomicInteger();
        Map beans = new LinkedHashMap();
        for (JsonRpcDomainBean bean : JsonRpcDomainBean.EP_NAME.getExtensionList()) {
            String string = bean.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            Intrinsics.checkNotNull((Object)((Object)bean));
            JsonRpcDomainBean prev = beans.put(string, bean);
            if (prev == null || prev.overridable) continue;
            throw new IllegalArgumentException(bean.name + " is already registered");
        }
    }

    @TestOnly
    public final void registerTestDomain(@NotNull String name, @NotNull Object domain, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.testDomain = new Pair((Object)name, domain);
        Disposer.register((Disposable)disposable, () -> JsonRpcServer.registerTestDomain$lambda$0(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(@NotNull Client client, @NotNull CharSequence message) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (JsonRpcServerKt.access$getLOG$p().isDebugEnabled()) {
            JsonRpcServerKt.access$getLOG$p().debug("IN " + message);
        }
        JsonReaderEx reader = new JsonReaderEx(message);
        reader.beginArray();
        int messageId = reader.peek() == JsonToken.NUMBER ? reader.nextInt() : -1;
        String domainName = reader.nextString();
        if (domainName.length() == 1) {
            AsyncPromise promise = (AsyncPromise)client.messageCallbackMap.remove(messageId);
            if (domainName.charAt(0) == 'r') {
                if (promise == null) {
                    JsonRpcServerKt.access$getLOG$p().error("Response with id " + messageId + " was already processed");
                    return;
                }
                promise.setResult(JsonUtil.nextAny((JsonReaderEx)reader));
            } else {
                AsyncPromise asyncPromise = promise;
                Intrinsics.checkNotNull((Object)asyncPromise);
                asyncPromise.setError("error");
            }
            return;
        }
        Intrinsics.checkNotNull((Object)domainName);
        Object domain = this.findDomain(domainName);
        if (domain == null) {
            this.processClientError(client, "Cannot find domain " + domainName, messageId);
            return;
        }
        String command = reader.nextString();
        if (domain instanceof JsonServiceInvocator) {
            ((JsonServiceInvocator)domain).invoke(command, client, reader, messageId, message);
            return;
        }
        Object[] parameters = null;
        if (reader.hasNext()) {
            SmartList list = new SmartList();
            JsonUtil.readListBody((JsonReaderEx)reader, (List)((List)list));
            Object object = list.get(0);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)((List)object));
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toObjectArray(...)");
            parameters = objectArray;
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
            parameters = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        boolean isStatic = domain instanceof Class;
        Method[] methods = null;
        if (isStatic) {
            Method[] methodArray = ((Class)domain).getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
            methods = methodArray;
        } else {
            Method[] methodArray = domain.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
            methods = methodArray;
        }
        for (Method method : methods) {
            if (!Intrinsics.areEqual((Object)method.getName(), (Object)command)) continue;
            method.setAccessible(true);
            Object result = method.invoke(isStatic ? null : domain, Arrays.copyOf(parameters, parameters.length));
            if (messageId != -1) {
                if (result instanceof ByteBuf) {
                    ByteBuf $this$releaseIfError$iv = (ByteBuf)result;
                    boolean $i$f$releaseIfError = false;
                    try {
                        boolean bl = false;
                        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
                        Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"getByteBufAllocator(...)");
                        v6 = client.send(JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, null, null, (ByteBuf)result, null, 44, null));
                    }
                    catch (Exception e$iv) {
                        try {
                            $this$releaseIfError$iv.release();
                        }
                        finally {
                            throw e$iv;
                        }
                    }
                } else {
                    Object[] objectArray;
                    ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
                    Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"getByteBufAllocator(...)");
                    if (result == null) {
                        objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
                    } else {
                        Object[] objectArray2 = new Object[]{result};
                        objectArray = objectArray2;
                    }
                    Object[] objectArray3 = objectArray;
                    Intrinsics.checkNotNull((Object)objectArray3);
                    v6 = client.send(JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, null, null, null, objectArray3, 28, null));
                }
            }
            return;
        }
        this.processClientError(client, "Cannot find method " + domain + "." + command, messageId);
    }

    private final Object findDomain(String domainName) {
        Pair<String, ? extends Object> testDomain = this.testDomain;
        if (testDomain != null && Intrinsics.areEqual((Object)testDomain.getFirst(), (Object)domainName)) {
            return testDomain.getSecond();
        }
        JsonRpcDomainBean jsonRpcDomainBean = (JsonRpcDomainBean)((Object)JsonRpcDomainBean.EP_NAME.getByKey((Object)domainName, JsonRpcServer.class, arg_0 -> JsonRpcServer.findDomain$lambda$0((KMutableProperty1)findDomain.1.INSTANCE, arg_0)));
        return jsonRpcDomainBean != null ? jsonRpcDomainBean.getInstance() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processClientError(Client client, @NonNls String error, int messageId) {
        try {
            JsonRpcServerKt.access$getLOG$p().error(error);
        }
        finally {
            if (messageId != -1) {
                this.sendErrorResponse(client, messageId, error);
            }
        }
    }

    public final void sendResponse(@NotNull Client client, int messageId, @Nullable ByteBuf rawData) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"getByteBufAllocator(...)");
        client.send(JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, null, null, rawData, null, 44, null));
    }

    public static /* synthetic */ void sendResponse$default(JsonRpcServer jsonRpcServer, Client client, int n, ByteBuf byteBuf, int n2, Object object) {
        if ((n2 & 4) != 0) {
            byteBuf = null;
        }
        jsonRpcServer.sendResponse(client, n, byteBuf);
    }

    public final void sendErrorResponse(@NotNull Client client, int messageId, @Nullable CharSequence message) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"getByteBufAllocator(...)");
        Object[] objectArray = new CharSequence[]{message};
        client.send(JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, "e", null, null, objectArray, 24, null));
    }

    public final boolean sendWithRawPart(@NotNull Client client, @NotNull String domain, @NotNull String command, @NotNull ByteBuf rawData, @NotNull Object[] params) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"getByteBufAllocator(...)");
        return client.send(this.encodeMessage(byteBufAllocator, -1, domain, command, rawData, params)).cause() == null;
    }

    public final void send(@NotNull Client client, @NotNull String domain, @NotNull String command, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"getByteBufAllocator(...)");
        client.send(JsonRpcServer.encodeMessage$default(this, byteBufAllocator, -1, domain, command, null, params, 16, null));
    }

    @NotNull
    public final <T> Promise<T> call(@NotNull Client client, @NotNull String domain, @NotNull String command, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        int messageId = this.messageIdCounter.getAndIncrement();
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"getByteBufAllocator(...)");
        ByteBuf message = JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, domain, command, null, params, 16, null);
        Promise promise = client.send(messageId, message);
        Intrinsics.checkNotNull(promise);
        return promise;
    }

    public final void send(@NotNull String domain, @NotNull String command, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.clientManager.hasClients()) {
            int messageId = -1;
            ByteBufAllocator byteBufAllocator = ByteBufAllocator.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)byteBufAllocator, (String)"DEFAULT");
            ByteBuf message = JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, domain, command, null, params, 16, null);
            ClientManager.send$default(this.clientManager, messageId, message, null, 4, null);
        }
    }

    private final ByteBuf encodeMessage(ByteBufAllocator byteBufAllocator, int messageId, String domain, String command, ByteBuf rawData, Object[] params) {
        ByteBuf buffer = this.doEncodeMessage(byteBufAllocator, messageId, domain, command, params, rawData);
        if (JsonRpcServerKt.access$getLOG$p().isDebugEnabled()) {
            JsonRpcServerKt.access$getLOG$p().debug("OUT " + buffer.toString(Charsets.UTF_8));
        }
        return buffer;
    }

    static /* synthetic */ ByteBuf encodeMessage$default(JsonRpcServer jsonRpcServer, ByteBufAllocator byteBufAllocator, int n, String string, String string2, ByteBuf byteBuf, Object[] objectArray, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        if ((n2 & 4) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        if ((n2 & 0x10) != 0) {
            byteBuf = null;
        }
        if ((n2 & 0x20) != 0) {
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
            objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        return jsonRpcServer.encodeMessage(byteBufAllocator, n, string, string2, byteBuf, objectArray);
    }

    private final ByteBuf doEncodeMessage(ByteBufAllocator byteBufAllocator, int id, String domain, String command, Object[] params, ByteBuf rawData) {
        ByteBuf byteBuf;
        ByteBuf byteBuf2;
        ByteBuf byteBuf3;
        ByteBuf buffer;
        ByteBuf byteBuf4 = buffer = byteBufAllocator.ioBuffer();
        Intrinsics.checkNotNull((Object)byteBuf4);
        JsonRpcServerKt.access$writeByte(byteBuf4, '[');
        StringBuilder sb = null;
        if (id != -1) {
            sb = new StringBuilder();
            byteBuf3 = buffer;
            Intrinsics.checkNotNull((Object)byteBuf3);
            StringBuilder stringBuilder = sb.append(id);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            JsonRpcServerKt.access$writeAscii(byteBuf3, stringBuilder);
            sb.setLength(0);
        }
        if (domain != null) {
            if (id != -1) {
                byteBuf3 = buffer;
                Intrinsics.checkNotNull((Object)byteBuf3);
                JsonRpcServerKt.access$writeByte(byteBuf3, ',');
            }
            byteBuf2 = buffer;
            Intrinsics.checkNotNull((Object)byteBuf2);
            ByteBuf byteBuf5 = JsonRpcServerKt.access$writeByte(byteBuf2, '\"');
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf5, (String)"access$writeByte(...)");
            JsonRpcServerKt.access$writeByte(JsonRpcServerKt.access$writeAscii(byteBuf5, domain), '\"');
            if (command != null) {
                byteBuf = buffer;
                Intrinsics.checkNotNull((Object)byteBuf);
                ByteBuf byteBuf6 = JsonRpcServerKt.access$writeByte(byteBuf, ',');
                Intrinsics.checkNotNullExpressionValue((Object)byteBuf6, (String)"access$writeByte(...)");
                ByteBuf byteBuf7 = JsonRpcServerKt.access$writeByte(byteBuf6, '\"');
                Intrinsics.checkNotNullExpressionValue((Object)byteBuf7, (String)"access$writeByte(...)");
                JsonRpcServerKt.access$writeByte(JsonRpcServerKt.access$writeAscii(byteBuf7, command), '\"');
            }
        }
        ByteBuf effectiveBuffer = buffer;
        if (!(params.length == 0) || rawData != null) {
            byteBuf = buffer;
            Intrinsics.checkNotNull((Object)byteBuf);
            ByteBuf byteBuf8 = JsonRpcServerKt.access$writeByte(byteBuf, ',');
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf8, (String)"access$writeByte(...)");
            JsonRpcServerKt.access$writeByte(byteBuf8, '[');
            byteBuf2 = buffer;
            Intrinsics.checkNotNull((Object)byteBuf2);
            this.encodeParameters(byteBuf2, params, sb);
            if (rawData != null) {
                if (!(params.length == 0)) {
                    byteBuf2 = buffer;
                    Intrinsics.checkNotNull((Object)byteBuf2);
                    JsonRpcServerKt.access$writeByte(byteBuf2, ',');
                }
                effectiveBuffer = (ByteBuf)byteBufAllocator.compositeBuffer().addComponent(buffer).addComponent(rawData);
                buffer = byteBufAllocator.ioBuffer();
            }
            byteBuf2 = buffer;
            Intrinsics.checkNotNull((Object)byteBuf2);
            JsonRpcServerKt.access$writeByte(byteBuf2, ']');
        }
        byteBuf2 = buffer;
        Intrinsics.checkNotNull((Object)byteBuf2);
        JsonRpcServerKt.access$writeByte(byteBuf2, ']');
        byteBuf2 = effectiveBuffer;
        Intrinsics.checkNotNull((Object)byteBuf2);
        ByteBuf byteBuf9 = byteBuf2;
        byteBuf2 = buffer;
        Intrinsics.checkNotNull((Object)byteBuf2);
        return JsonRpcServerKt.access$addBuffer(byteBuf9, byteBuf2);
    }

    private final void encodeParameters(ByteBuf buffer, Object[] params, StringBuilder _sb) {
        StringBuilder sb = _sb;
        JsonWriter writer = null;
        boolean hasPrev = false;
        for (Object param : params) {
            if (hasPrev) {
                JsonRpcServerKt.access$writeByte(buffer, ',');
            } else {
                hasPrev = true;
            }
            Object object = param;
            if (object instanceof CharSequence) {
                JsonUtil.escape((CharSequence)((CharSequence)param), (ByteBuf)buffer);
                continue;
            }
            if (object == null) {
                JsonRpcServerKt.access$writeAscii(buffer, "null");
                continue;
            }
            if (object instanceof Boolean) {
                JsonRpcServerKt.access$writeAscii(buffer, String.valueOf((Boolean)param));
                continue;
            }
            if (object instanceof Number) {
                Number number;
                if (sb == null) {
                    sb = new StringBuilder();
                }
                StringBuilder stringBuilder = (number = (Number)param) instanceof Integer ? sb.append(((Number)param).intValue()) : (number instanceof Long ? sb.append(((Number)param).longValue()) : (number instanceof Float ? sb.append(((Number)param).floatValue()) : (number instanceof Double ? sb.append(((Number)param).doubleValue()) : sb.append(((Number)param).toString()))));
                JsonRpcServerKt.access$writeAscii(buffer, sb);
                sb.setLength(0);
                continue;
            }
            if (object instanceof Consumer) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                Object object2 = param;
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.util.Consumer<java.lang.StringBuilder>");
                ((Consumer)object2).consume((Object)sb);
                ByteBufUtil.writeUtf8((ByteBuf)buffer, (CharSequence)sb);
                sb.setLength(0);
                continue;
            }
            if (writer == null) {
                writer = new JsonWriter((Writer)new ByteBufUtf8Writer(buffer));
            }
            TypeAdapter typeAdapter = JsonRpcServerKt.access$getGson().getAdapter(param.getClass());
            Intrinsics.checkNotNull((Object)typeAdapter, (String)"null cannot be cast to non-null type com.google.gson.TypeAdapter<kotlin.Any>");
            typeAdapter.write(writer, param);
        }
    }

    private static final void registerTestDomain$lambda$0(JsonRpcServer this$0) {
        this$0.testDomain = null;
    }

    private static final String findDomain$lambda$0(KMutableProperty1 $tmp0, JsonRpcDomainBean p0) {
        return (String)((Function1)$tmp0).invoke((Object)p0);
    }
}

