/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.validation.checkers.context;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000H\u0086\u0002J\n\u0010\u0011\u001a\u00020\u0012H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/validation/checkers/context/OffsetRange;", "", "owner", "Lorg/jetbrains/kotlin/ir/IrElement;", "startOffset", "", "endOffset", "<init>", "(Lorg/jetbrains/kotlin/ir/IrElement;II)V", "getOwner", "()Lorg/jetbrains/kotlin/ir/IrElement;", "getStartOffset", "()I", "getEndOffset", "contains", "", "other", "toString", "", "Companion", "ir.validation"})
public final class OffsetRange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrElement owner;
    private final int startOffset;
    private final int endOffset;

    private OffsetRange(IrElement owner, int startOffset, int endOffset) {
        this.owner = owner;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @NotNull
    public final IrElement getOwner() {
        return this.owner;
    }

    public final int getStartOffset() {
        return this.startOffset;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    public final boolean contains(@NotNull OffsetRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.startOffset <= other.startOffset && this.endOffset >= other.endOffset;
    }

    @NotNull
    public String toString() {
        return "" + '[' + this.startOffset + ':' + this.endOffset + ']';
    }

    public /* synthetic */ OffsetRange(IrElement owner, int startOffset, int endOffset, DefaultConstructorMarker $constructor_marker) {
        this(owner, startOffset, endOffset);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/validation/checkers/context/OffsetRange$Companion;", "", "<init>", "()V", "createIfRealValidOffsets", "Lorg/jetbrains/kotlin/ir/validation/checkers/context/OffsetRange;", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "useOwnOffsetsOfInlinedFunctionBlock", "", "owner", "startOffset", "", "endOffset", "ir.validation"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final OffsetRange createIfRealValidOffsets(@NotNull IrElement element, boolean useOwnOffsetsOfInlinedFunctionBlock) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return useOwnOffsetsOfInlinedFunctionBlock || !(element instanceof IrInlinedFunctionBlock) ? this.createIfRealValidOffsets(element, element.getStartOffset(), element.getEndOffset()) : this.createIfRealValidOffsets(element, ((IrInlinedFunctionBlock)element).getInlinedFunctionStartOffset(), ((IrInlinedFunctionBlock)element).getInlinedFunctionEndOffset());
        }

        private final OffsetRange createIfRealValidOffsets(IrElement owner, int startOffset, int endOffset) {
            return (0 <= startOffset ? startOffset <= endOffset : false) ? new OffsetRange(owner, startOffset, endOffset, null) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

