/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.BadContentTypeFormatException;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueParam;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.http.HttpHeaderValueParserKt;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0010\u0018\u0000 $2\u00020\u0001:\t$%&'()*+,B1\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nB)\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\u000bJ\u001d\u0010\u000e\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0018J\u001a\u0010\u001b\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0096\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\"R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010 \u001a\u0004\b#\u0010\"\u00a8\u0006-"}, d2={"Lio/ktor/http/ContentType;", "Lio/ktor/http/HeaderValueWithParameters;", "", "contentType", "contentSubtype", "existingContent", "", "Lio/ktor/http/HeaderValueParam;", "parameters", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "name", "value", "withParameter", "(Ljava/lang/String;Ljava/lang/String;)Lio/ktor/http/ContentType;", "", "hasParameter", "(Ljava/lang/String;Ljava/lang/String;)Z", "withoutParameters", "()Lio/ktor/http/ContentType;", "pattern", "match", "(Lio/ktor/http/ContentType;)Z", "(Ljava/lang/String;)Z", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/lang/String;", "getContentType", "()Ljava/lang/String;", "getContentSubtype", "Companion", "Application", "Audio", "Image", "Message", "MultiPart", "Text", "Video", "Font", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nContentTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentTypes.kt\nio/ktor/http/ContentType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,438:1\n1#2:439\n1761#3,3:440\n1761#3,3:443\n*S KotlinDebug\n*F\n+ 1 ContentTypes.kt\nio/ktor/http/ContentType\n*L\n49#1:440,3\n89#1:443,3\n*E\n"})
public final class ContentType
extends HeaderValueWithParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String contentType;
    @NotNull
    private final String contentSubtype;
    @NotNull
    private static final ContentType Any = new ContentType("*", "*", null, 4, null);

    private ContentType(String contentType, String contentSubtype, String existingContent, List<HeaderValueParam> parameters) {
        super(existingContent, parameters);
        this.contentType = contentType;
        this.contentSubtype = contentSubtype;
    }

    /* synthetic */ ContentType(String string, String string2, String string3, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, string2, string3, list);
    }

    @NotNull
    public final String getContentType() {
        return this.contentType;
    }

    @NotNull
    public final String getContentSubtype() {
        return this.contentSubtype;
    }

    public ContentType(@NotNull String contentType, @NotNull String contentSubtype, @NotNull List<HeaderValueParam> parameters) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)contentSubtype, (String)"contentSubtype");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        this(contentType, contentSubtype, contentType + '/' + contentSubtype, parameters);
    }

    public /* synthetic */ ContentType(String string, String string2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, string2, list);
    }

    @NotNull
    public final ContentType withParameter(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.hasParameter(name, value)) {
            return this;
        }
        return new ContentType(this.contentType, this.contentSubtype, this.getContent(), CollectionsKt.plus((Collection)this.getParameters(), (Object)new HeaderValueParam(name, value)));
    }

    private final boolean hasParameter(String name, String value) {
        boolean bl;
        block0 : switch (this.getParameters().size()) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                HeaderValueParam it = this.getParameters().get(0);
                boolean bl2 = false;
                if (StringsKt.equals((String)it.getName(), (String)name, (boolean)true) && StringsKt.equals((String)it.getValue(), (String)value, (boolean)true)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                Iterable $this$any$iv = this.getParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                    break;
                }
                for (Object element$iv : $this$any$iv) {
                    HeaderValueParam it = (HeaderValueParam)element$iv;
                    boolean bl3 = false;
                    if (!(StringsKt.equals((String)it.getName(), (String)name, (boolean)true) && StringsKt.equals((String)it.getValue(), (String)value, (boolean)true))) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final ContentType withoutParameters() {
        return this.getParameters().isEmpty() ? this : new ContentType(this.contentType, this.contentSubtype, null, 4, null);
    }

    public final boolean match(@NotNull ContentType pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        if (!Intrinsics.areEqual((Object)pattern.contentType, (Object)"*") && !StringsKt.equals((String)pattern.contentType, (String)this.contentType, (boolean)true)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)pattern.contentSubtype, (Object)"*") && !StringsKt.equals((String)pattern.contentSubtype, (String)this.contentSubtype, (boolean)true)) {
            return false;
        }
        for (HeaderValueParam headerValueParam : pattern.getParameters()) {
            boolean matches;
            boolean bl;
            block10: {
                String patternName = headerValueParam.component1();
                String patternValue = headerValueParam.component2();
                if (Intrinsics.areEqual((Object)patternName, (Object)"*")) {
                    if (Intrinsics.areEqual((Object)patternValue, (Object)"*")) {
                        bl = true;
                    } else {
                        Iterable $this$any$iv = this.getParameters();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                HeaderValueParam p = (HeaderValueParam)element$iv;
                                boolean bl2 = false;
                                if (!StringsKt.equals((String)p.getValue(), (String)patternValue, (boolean)true)) continue;
                                bl = true;
                                break block10;
                            }
                            bl = false;
                        }
                    }
                } else {
                    String value = this.parameter(patternName);
                    bl = Intrinsics.areEqual((Object)patternValue, (Object)"*") ? value != null : StringsKt.equals((String)value, (String)patternValue, (boolean)true);
                }
            }
            if (matches = bl) continue;
            return false;
        }
        return true;
    }

    public final boolean match(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return this.match(Companion.parse(pattern));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ContentType && StringsKt.equals((String)this.contentType, (String)((ContentType)other).contentType, (boolean)true) && StringsKt.equals((String)this.contentSubtype, (String)((ContentType)other).contentSubtype, (boolean)true) && Intrinsics.areEqual(this.getParameters(), ((ContentType)other).getParameters());
    }

    public int hashCode() {
        String string = this.contentType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        int result2 = string.hashCode();
        String string2 = this.contentSubtype.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        result2 += 31 * result2 + string2.hashCode();
        return result2 += 31 * ((Object)this.getParameters()).hashCode();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b3\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0014\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0015\u0010\u0011R\u0017\u0010\u0016\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000f\u001a\u0004\b\u0017\u0010\u0011R\u0017\u0010\u0018\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000f\u001a\u0004\b\u0019\u0010\u0011R\u0017\u0010\u001a\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000f\u001a\u0004\b\u001b\u0010\u0011R\u0017\u0010\u001c\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000f\u001a\u0004\b\u001d\u0010\u0011R\u0017\u0010\u001e\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u000f\u001a\u0004\b\u001f\u0010\u0011R\u0017\u0010 \u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b \u0010\u000f\u001a\u0004\b!\u0010\u0011R\u0017\u0010\"\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010\u000f\u001a\u0004\b#\u0010\u0011R\u0017\u0010$\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b$\u0010\u000f\u001a\u0004\b%\u0010\u0011R\u0017\u0010&\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b&\u0010\u000f\u001a\u0004\b'\u0010\u0011R\u0017\u0010(\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b(\u0010\u000f\u001a\u0004\b)\u0010\u0011R\u0017\u0010*\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b*\u0010\u000f\u001a\u0004\b+\u0010\u0011R\u0017\u0010,\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b,\u0010\u000f\u001a\u0004\b-\u0010\u0011R\u0017\u0010.\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b.\u0010\u000f\u001a\u0004\b/\u0010\u0011R\u0017\u00100\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b0\u0010\u000f\u001a\u0004\b1\u0010\u0011R\u0017\u00102\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b2\u0010\u000f\u001a\u0004\b3\u0010\u0011R\u0017\u00104\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b4\u0010\u000f\u001a\u0004\b5\u0010\u0011R\u0017\u00106\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b6\u0010\u000f\u001a\u0004\b7\u0010\u0011R\u0017\u00108\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b8\u0010\u000f\u001a\u0004\b9\u0010\u0011R\u0017\u0010:\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b:\u0010\u000f\u001a\u0004\b;\u0010\u0011R\u0017\u0010<\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b<\u0010\u000f\u001a\u0004\b=\u0010\u0011\u00a8\u0006>"}, d2={"Lio/ktor/http/ContentType$Application;", "", "<init>", "()V", "", "contentType", "", "contains", "(Ljava/lang/CharSequence;)Z", "Lio/ktor/http/ContentType;", "(Lio/ktor/http/ContentType;)Z", "", "TYPE", "Ljava/lang/String;", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "Atom", "getAtom", "Cbor", "getCbor", "Json", "getJson", "HalJson", "getHalJson", "JavaScript", "getJavaScript", "OctetStream", "getOctetStream", "Rss", "getRss", "Soap", "getSoap", "Xml", "getXml", "Xml_Dtd", "getXml_Dtd", "Yaml", "getYaml", "Zip", "getZip", "GZip", "getGZip", "FormUrlEncoded", "getFormUrlEncoded", "Pdf", "getPdf", "Xlsx", "getXlsx", "Docx", "getDocx", "Pptx", "getPptx", "ProtoBuf", "getProtoBuf", "Wasm", "getWasm", "ProblemJson", "getProblemJson", "ProblemXml", "getProblemXml", "ktor-http"})
    public static final class Application {
        @NotNull
        public static final Application INSTANCE = new Application();
        @NotNull
        public static final String TYPE = "application";
        @NotNull
        private static final ContentType Any = new ContentType("application", "*", null, 4, null);
        @NotNull
        private static final ContentType Atom = new ContentType("application", "atom+xml", null, 4, null);
        @NotNull
        private static final ContentType Cbor = new ContentType("application", "cbor", null, 4, null);
        @NotNull
        private static final ContentType Json = new ContentType("application", "json", null, 4, null);
        @NotNull
        private static final ContentType HalJson = new ContentType("application", "hal+json", null, 4, null);
        @NotNull
        private static final ContentType JavaScript = new ContentType("application", "javascript", null, 4, null);
        @NotNull
        private static final ContentType OctetStream = new ContentType("application", "octet-stream", null, 4, null);
        @NotNull
        private static final ContentType Rss = new ContentType("application", "rss+xml", null, 4, null);
        @NotNull
        private static final ContentType Soap = new ContentType("application", "soap+xml", null, 4, null);
        @NotNull
        private static final ContentType Xml = new ContentType("application", "xml", null, 4, null);
        @NotNull
        private static final ContentType Xml_Dtd = new ContentType("application", "xml-dtd", null, 4, null);
        @NotNull
        private static final ContentType Yaml = new ContentType("application", "yaml", null, 4, null);
        @NotNull
        private static final ContentType Zip = new ContentType("application", "zip", null, 4, null);
        @NotNull
        private static final ContentType GZip = new ContentType("application", "gzip", null, 4, null);
        @NotNull
        private static final ContentType FormUrlEncoded = new ContentType("application", "x-www-form-urlencoded", null, 4, null);
        @NotNull
        private static final ContentType Pdf = new ContentType("application", "pdf", null, 4, null);
        @NotNull
        private static final ContentType Xlsx = new ContentType("application", "vnd.openxmlformats-officedocument.spreadsheetml.sheet", null, 4, null);
        @NotNull
        private static final ContentType Docx = new ContentType("application", "vnd.openxmlformats-officedocument.wordprocessingml.document", null, 4, null);
        @NotNull
        private static final ContentType Pptx = new ContentType("application", "vnd.openxmlformats-officedocument.presentationml.presentation", null, 4, null);
        @NotNull
        private static final ContentType ProtoBuf = new ContentType("application", "protobuf", null, 4, null);
        @NotNull
        private static final ContentType Wasm = new ContentType("application", "wasm", null, 4, null);
        @NotNull
        private static final ContentType ProblemJson = new ContentType("application", "problem+json", null, 4, null);
        @NotNull
        private static final ContentType ProblemXml = new ContentType("application", "problem+xml", null, 4, null);

        private Application() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getAtom() {
            return Atom;
        }

        @NotNull
        public final ContentType getCbor() {
            return Cbor;
        }

        @NotNull
        public final ContentType getJson() {
            return Json;
        }

        @NotNull
        public final ContentType getHalJson() {
            return HalJson;
        }

        @NotNull
        public final ContentType getJavaScript() {
            return JavaScript;
        }

        @NotNull
        public final ContentType getOctetStream() {
            return OctetStream;
        }

        @NotNull
        public final ContentType getRss() {
            return Rss;
        }

        @NotNull
        public final ContentType getSoap() {
            return Soap;
        }

        @NotNull
        public final ContentType getXml() {
            return Xml;
        }

        @NotNull
        public final ContentType getXml_Dtd() {
            return Xml_Dtd;
        }

        @NotNull
        public final ContentType getYaml() {
            return Yaml;
        }

        @NotNull
        public final ContentType getZip() {
            return Zip;
        }

        @NotNull
        public final ContentType getGZip() {
            return GZip;
        }

        @NotNull
        public final ContentType getFormUrlEncoded() {
            return FormUrlEncoded;
        }

        @NotNull
        public final ContentType getPdf() {
            return Pdf;
        }

        @NotNull
        public final ContentType getXlsx() {
            return Xlsx;
        }

        @NotNull
        public final ContentType getDocx() {
            return Docx;
        }

        @NotNull
        public final ContentType getPptx() {
            return Pptx;
        }

        @NotNull
        public final ContentType getProtoBuf() {
            return ProtoBuf;
        }

        @NotNull
        public final ContentType getWasm() {
            return Wasm;
        }

        @NotNull
        public final ContentType getProblemJson() {
            return ProblemJson;
        }

        @NotNull
        public final ContentType getProblemXml() {
            return ProblemXml;
        }

        public final boolean contains(@NotNull CharSequence contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return StringsKt.startsWith((CharSequence)contentType, (CharSequence)"application/", (boolean)true);
        }

        public final boolean contains(@NotNull ContentType contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return contentType.match(Any);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0014\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0015\u0010\u0011R\u0017\u0010\u0016\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000f\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lio/ktor/http/ContentType$Audio;", "", "<init>", "()V", "", "contentType", "", "contains", "(Ljava/lang/CharSequence;)Z", "Lio/ktor/http/ContentType;", "(Lio/ktor/http/ContentType;)Z", "", "TYPE", "Ljava/lang/String;", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "MP4", "getMP4", "MPEG", "getMPEG", "OGG", "getOGG", "ktor-http"})
    public static final class Audio {
        @NotNull
        public static final Audio INSTANCE = new Audio();
        @NotNull
        public static final String TYPE = "audio";
        @NotNull
        private static final ContentType Any = new ContentType("audio", "*", null, 4, null);
        @NotNull
        private static final ContentType MP4 = new ContentType("audio", "mp4", null, 4, null);
        @NotNull
        private static final ContentType MPEG = new ContentType("audio", "mpeg", null, 4, null);
        @NotNull
        private static final ContentType OGG = new ContentType("audio", "ogg", null, 4, null);

        private Audio() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getMP4() {
            return MP4;
        }

        @NotNull
        public final ContentType getMPEG() {
            return MPEG;
        }

        @NotNull
        public final ContentType getOGG() {
            return OGG;
        }

        public final boolean contains(@NotNull CharSequence contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return StringsKt.startsWith((CharSequence)contentType, (CharSequence)"audio/", (boolean)true);
        }

        public final boolean contains(@NotNull ContentType contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return contentType.match(Any);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lio/ktor/http/ContentType$Companion;", "", "<init>", "()V", "", "value", "Lio/ktor/http/ContentType;", "parse", "(Ljava/lang/String;)Lio/ktor/http/ContentType;", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "ktor-http"})
    @SourceDebugExtension(value={"SMAP\nContentTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentTypes.kt\nio/ktor/http/ContentType$Companion\n+ 2 HeaderValueWithParameters.kt\nio/ktor/http/HeaderValueWithParameters$Companion\n*L\n1#1,438:1\n70#2,2:439\n*S KotlinDebug\n*F\n+ 1 ContentTypes.kt\nio/ktor/http/ContentType$Companion\n*L\n138#1:439,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ContentType parse(@NotNull String value) {
            void parameters;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (StringsKt.isBlank((CharSequence)value)) {
                return this.getAny();
            }
            HeaderValueWithParameters.Companion companion = HeaderValueWithParameters.Companion;
            String value$iv = value;
            boolean $i$f$parse = false;
            HeaderValue headerValue$iv = (HeaderValue)CollectionsKt.last(HttpHeaderValueParserKt.parseHeaderValue(value$iv));
            List<HeaderValueParam> list = headerValue$iv.getParams();
            String parts = headerValue$iv.getValue();
            boolean bl = false;
            int slash = StringsKt.indexOf$default((CharSequence)parts, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (slash == -1) {
                if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)parts)).toString(), (Object)"*")) {
                    return Companion.getAny();
                }
                throw new BadContentTypeFormatException(value);
            }
            String string = parts.substring(0, slash);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String type = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (((CharSequence)type).length() == 0) {
                throw new BadContentTypeFormatException(value);
            }
            String string2 = parts.substring(slash + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String subtype = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (StringsKt.contains$default((CharSequence)type, (char)' ', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)subtype, (char)' ', (boolean)false, (int)2, null)) {
                throw new BadContentTypeFormatException(value);
            }
            if (((CharSequence)subtype).length() == 0 || StringsKt.contains$default((CharSequence)subtype, (char)'/', (boolean)false, (int)2, null)) {
                throw new BadContentTypeFormatException(value);
            }
            return new ContentType(type, subtype, (List<HeaderValueParam>)parameters);
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0014\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0015\u0010\u0011R\u0017\u0010\u0016\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000f\u001a\u0004\b\u0017\u0010\u0011R\u0017\u0010\u0018\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000f\u001a\u0004\b\u0019\u0010\u0011R\u0017\u0010\u001a\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000f\u001a\u0004\b\u001b\u0010\u0011R\u0017\u0010\u001c\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000f\u001a\u0004\b\u001d\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lio/ktor/http/ContentType$Font;", "", "<init>", "()V", "", "contentType", "", "contains", "(Ljava/lang/CharSequence;)Z", "Lio/ktor/http/ContentType;", "(Lio/ktor/http/ContentType;)Z", "", "TYPE", "Ljava/lang/String;", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "Collection", "getCollection", "Otf", "getOtf", "Sfnt", "getSfnt", "Ttf", "getTtf", "Woff", "getWoff", "Woff2", "getWoff2", "ktor-http"})
    public static final class Font {
        @NotNull
        public static final Font INSTANCE = new Font();
        @NotNull
        public static final String TYPE = "font";
        @NotNull
        private static final ContentType Any = new ContentType("font", "*", null, 4, null);
        @NotNull
        private static final ContentType Collection = new ContentType("font", "collection", null, 4, null);
        @NotNull
        private static final ContentType Otf = new ContentType("font", "otf", null, 4, null);
        @NotNull
        private static final ContentType Sfnt = new ContentType("font", "sfnt", null, 4, null);
        @NotNull
        private static final ContentType Ttf = new ContentType("font", "ttf", null, 4, null);
        @NotNull
        private static final ContentType Woff = new ContentType("font", "woff", null, 4, null);
        @NotNull
        private static final ContentType Woff2 = new ContentType("font", "woff2", null, 4, null);

        private Font() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getCollection() {
            return Collection;
        }

        @NotNull
        public final ContentType getOtf() {
            return Otf;
        }

        @NotNull
        public final ContentType getSfnt() {
            return Sfnt;
        }

        @NotNull
        public final ContentType getTtf() {
            return Ttf;
        }

        @NotNull
        public final ContentType getWoff() {
            return Woff;
        }

        @NotNull
        public final ContentType getWoff2() {
            return Woff2;
        }

        public final boolean contains(@NotNull CharSequence contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return StringsKt.startsWith((CharSequence)contentType, (CharSequence)"font/", (boolean)true);
        }

        public final boolean contains(@NotNull ContentType contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return contentType.match(Any);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b#\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0014\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0015\u0010\u0011R\u0017\u0010\u0016\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000f\u001a\u0004\b\u0017\u0010\u0011R\u0017\u0010\u0018\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000f\u001a\u0004\b\u0019\u0010\u0011R\u0017\u0010\u001a\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000f\u001a\u0004\b\u001b\u0010\u0011R\u0017\u0010\u001c\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000f\u001a\u0004\b\u001d\u0010\u0011R\u0017\u0010\u001e\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u000f\u001a\u0004\b\u001f\u0010\u0011R\u0017\u0010 \u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b \u0010\u000f\u001a\u0004\b!\u0010\u0011R\u0017\u0010\"\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010\u000f\u001a\u0004\b#\u0010\u0011R\u0017\u0010$\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b$\u0010\u000f\u001a\u0004\b%\u0010\u0011R\u0017\u0010&\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b&\u0010\u000f\u001a\u0004\b'\u0010\u0011R\u0017\u0010(\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b(\u0010\u000f\u001a\u0004\b)\u0010\u0011R\u0017\u0010*\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b*\u0010\u000f\u001a\u0004\b+\u0010\u0011\u00a8\u0006,"}, d2={"Lio/ktor/http/ContentType$Image;", "", "<init>", "()V", "", "contentSubtype", "", "contains", "(Ljava/lang/String;)Z", "Lio/ktor/http/ContentType;", "contentType", "(Lio/ktor/http/ContentType;)Z", "TYPE", "Ljava/lang/String;", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "APNG", "getAPNG", "AVIF", "getAVIF", "BMP", "getBMP", "GIF", "getGIF", "HEIC", "getHEIC", "HEIF", "getHEIF", "JPEG", "getJPEG", "JXL", "getJXL", "PNG", "getPNG", "SVG", "getSVG", "TIFF", "getTIFF", "WEBP", "getWEBP", "XIcon", "getXIcon", "ktor-http"})
    public static final class Image {
        @NotNull
        public static final Image INSTANCE = new Image();
        @NotNull
        public static final String TYPE = "image";
        @NotNull
        private static final ContentType Any = new ContentType("image", "*", null, 4, null);
        @NotNull
        private static final ContentType APNG = new ContentType("image", "apng", null, 4, null);
        @NotNull
        private static final ContentType AVIF = new ContentType("image", "avif", null, 4, null);
        @NotNull
        private static final ContentType BMP = new ContentType("image", "bmp", null, 4, null);
        @NotNull
        private static final ContentType GIF = new ContentType("image", "gif", null, 4, null);
        @NotNull
        private static final ContentType HEIC = new ContentType("image", "heic", null, 4, null);
        @NotNull
        private static final ContentType HEIF = new ContentType("image", "heif", null, 4, null);
        @NotNull
        private static final ContentType JPEG = new ContentType("image", "jpeg", null, 4, null);
        @NotNull
        private static final ContentType JXL = new ContentType("image", "jxl", null, 4, null);
        @NotNull
        private static final ContentType PNG = new ContentType("image", "png", null, 4, null);
        @NotNull
        private static final ContentType SVG = new ContentType("image", "svg+xml", null, 4, null);
        @NotNull
        private static final ContentType TIFF = new ContentType("image", "tiff", null, 4, null);
        @NotNull
        private static final ContentType WEBP = new ContentType("image", "webp", null, 4, null);
        @NotNull
        private static final ContentType XIcon = new ContentType("image", "x-icon", null, 4, null);

        private Image() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getAPNG() {
            return APNG;
        }

        @NotNull
        public final ContentType getAVIF() {
            return AVIF;
        }

        @NotNull
        public final ContentType getBMP() {
            return BMP;
        }

        @NotNull
        public final ContentType getGIF() {
            return GIF;
        }

        @NotNull
        public final ContentType getHEIC() {
            return HEIC;
        }

        @NotNull
        public final ContentType getHEIF() {
            return HEIF;
        }

        @NotNull
        public final ContentType getJPEG() {
            return JPEG;
        }

        @NotNull
        public final ContentType getJXL() {
            return JXL;
        }

        @NotNull
        public final ContentType getPNG() {
            return PNG;
        }

        @NotNull
        public final ContentType getSVG() {
            return SVG;
        }

        @NotNull
        public final ContentType getTIFF() {
            return TIFF;
        }

        @NotNull
        public final ContentType getWEBP() {
            return WEBP;
        }

        @NotNull
        public final ContentType getXIcon() {
            return XIcon;
        }

        public final boolean contains(@NotNull String contentSubtype) {
            Intrinsics.checkNotNullParameter((Object)contentSubtype, (String)"contentSubtype");
            return StringsKt.startsWith((String)contentSubtype, (String)"image/", (boolean)true);
        }

        public final boolean contains(@NotNull ContentType contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return contentType.match(Any);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lio/ktor/http/ContentType$Message;", "", "<init>", "()V", "", "contentSubtype", "", "contains", "(Ljava/lang/String;)Z", "Lio/ktor/http/ContentType;", "contentType", "(Lio/ktor/http/ContentType;)Z", "TYPE", "Ljava/lang/String;", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "Http", "getHttp", "ktor-http"})
    public static final class Message {
        @NotNull
        public static final Message INSTANCE = new Message();
        @NotNull
        public static final String TYPE = "message";
        @NotNull
        private static final ContentType Any = new ContentType("message", "*", null, 4, null);
        @NotNull
        private static final ContentType Http = new ContentType("message", "http", null, 4, null);

        private Message() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getHttp() {
            return Http;
        }

        public final boolean contains(@NotNull String contentSubtype) {
            Intrinsics.checkNotNullParameter((Object)contentSubtype, (String)"contentSubtype");
            return StringsKt.startsWith((String)contentSubtype, (String)"message/", (boolean)true);
        }

        public final boolean contains(@NotNull ContentType contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return contentType.match(Any);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0014\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0015\u0010\u0011R\u0017\u0010\u0016\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000f\u001a\u0004\b\u0017\u0010\u0011R\u0017\u0010\u0018\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000f\u001a\u0004\b\u0019\u0010\u0011R\u0017\u0010\u001a\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000f\u001a\u0004\b\u001b\u0010\u0011R\u0017\u0010\u001c\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000f\u001a\u0004\b\u001d\u0010\u0011R\u0017\u0010\u001e\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u000f\u001a\u0004\b\u001f\u0010\u0011\u00a8\u0006 "}, d2={"Lio/ktor/http/ContentType$MultiPart;", "", "<init>", "()V", "", "contentType", "", "contains", "(Ljava/lang/CharSequence;)Z", "Lio/ktor/http/ContentType;", "(Lio/ktor/http/ContentType;)Z", "", "TYPE", "Ljava/lang/String;", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "Mixed", "getMixed", "Alternative", "getAlternative", "Related", "getRelated", "FormData", "getFormData", "Signed", "getSigned", "Encrypted", "getEncrypted", "ByteRanges", "getByteRanges", "ktor-http"})
    public static final class MultiPart {
        @NotNull
        public static final MultiPart INSTANCE = new MultiPart();
        @NotNull
        public static final String TYPE = "multipart";
        @NotNull
        private static final ContentType Any = new ContentType("multipart", "*", null, 4, null);
        @NotNull
        private static final ContentType Mixed = new ContentType("multipart", "mixed", null, 4, null);
        @NotNull
        private static final ContentType Alternative = new ContentType("multipart", "alternative", null, 4, null);
        @NotNull
        private static final ContentType Related = new ContentType("multipart", "related", null, 4, null);
        @NotNull
        private static final ContentType FormData = new ContentType("multipart", "form-data", null, 4, null);
        @NotNull
        private static final ContentType Signed = new ContentType("multipart", "signed", null, 4, null);
        @NotNull
        private static final ContentType Encrypted = new ContentType("multipart", "encrypted", null, 4, null);
        @NotNull
        private static final ContentType ByteRanges = new ContentType("multipart", "byteranges", null, 4, null);

        private MultiPart() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getMixed() {
            return Mixed;
        }

        @NotNull
        public final ContentType getAlternative() {
            return Alternative;
        }

        @NotNull
        public final ContentType getRelated() {
            return Related;
        }

        @NotNull
        public final ContentType getFormData() {
            return FormData;
        }

        @NotNull
        public final ContentType getSigned() {
            return Signed;
        }

        @NotNull
        public final ContentType getEncrypted() {
            return Encrypted;
        }

        @NotNull
        public final ContentType getByteRanges() {
            return ByteRanges;
        }

        public final boolean contains(@NotNull CharSequence contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return StringsKt.startsWith((CharSequence)contentType, (CharSequence)"multipart/", (boolean)true);
        }

        public final boolean contains(@NotNull ContentType contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return contentType.match(Any);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0017\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0014\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0015\u0010\u0011R\u0017\u0010\u0016\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000f\u001a\u0004\b\u0017\u0010\u0011R\u0017\u0010\u0018\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000f\u001a\u0004\b\u0019\u0010\u0011R\u0017\u0010\u001a\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000f\u001a\u0004\b\u001b\u0010\u0011R\u0017\u0010\u001c\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000f\u001a\u0004\b\u001d\u0010\u0011R\u0017\u0010\u001e\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u000f\u001a\u0004\b\u001f\u0010\u0011R\u0017\u0010 \u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b \u0010\u000f\u001a\u0004\b!\u0010\u0011\u00a8\u0006\""}, d2={"Lio/ktor/http/ContentType$Text;", "", "<init>", "()V", "", "contentType", "", "contains", "(Ljava/lang/CharSequence;)Z", "Lio/ktor/http/ContentType;", "(Lio/ktor/http/ContentType;)Z", "", "TYPE", "Ljava/lang/String;", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "Plain", "getPlain", "CSS", "getCSS", "CSV", "getCSV", "Html", "getHtml", "JavaScript", "getJavaScript", "VCard", "getVCard", "Xml", "getXml", "EventStream", "getEventStream", "ktor-http"})
    public static final class Text {
        @NotNull
        public static final Text INSTANCE = new Text();
        @NotNull
        public static final String TYPE = "text";
        @NotNull
        private static final ContentType Any = new ContentType("text", "*", null, 4, null);
        @NotNull
        private static final ContentType Plain = new ContentType("text", "plain", null, 4, null);
        @NotNull
        private static final ContentType CSS = new ContentType("text", "css", null, 4, null);
        @NotNull
        private static final ContentType CSV = new ContentType("text", "csv", null, 4, null);
        @NotNull
        private static final ContentType Html = new ContentType("text", "html", null, 4, null);
        @NotNull
        private static final ContentType JavaScript = new ContentType("text", "javascript", null, 4, null);
        @NotNull
        private static final ContentType VCard = new ContentType("text", "vcard", null, 4, null);
        @NotNull
        private static final ContentType Xml = new ContentType("text", "xml", null, 4, null);
        @NotNull
        private static final ContentType EventStream = new ContentType("text", "event-stream", null, 4, null);

        private Text() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getPlain() {
            return Plain;
        }

        @NotNull
        public final ContentType getCSS() {
            return CSS;
        }

        @NotNull
        public final ContentType getCSV() {
            return CSV;
        }

        @NotNull
        public final ContentType getHtml() {
            return Html;
        }

        @NotNull
        public final ContentType getJavaScript() {
            return JavaScript;
        }

        @NotNull
        public final ContentType getVCard() {
            return VCard;
        }

        @NotNull
        public final ContentType getXml() {
            return Xml;
        }

        @NotNull
        public final ContentType getEventStream() {
            return EventStream;
        }

        public final boolean contains(@NotNull CharSequence contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return StringsKt.startsWith((CharSequence)contentType, (CharSequence)"text/", (boolean)true);
        }

        public final boolean contains(@NotNull ContentType contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return contentType.match(Any);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0013\u0010\u0011R\u0017\u0010\u0014\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0015\u0010\u0011R\u0017\u0010\u0016\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000f\u001a\u0004\b\u0017\u0010\u0011R\u0017\u0010\u0018\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000f\u001a\u0004\b\u0019\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lio/ktor/http/ContentType$Video;", "", "<init>", "()V", "", "contentType", "", "contains", "(Ljava/lang/CharSequence;)Z", "Lio/ktor/http/ContentType;", "(Lio/ktor/http/ContentType;)Z", "", "TYPE", "Ljava/lang/String;", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "MPEG", "getMPEG", "MP4", "getMP4", "OGG", "getOGG", "QuickTime", "getQuickTime", "ktor-http"})
    public static final class Video {
        @NotNull
        public static final Video INSTANCE = new Video();
        @NotNull
        public static final String TYPE = "video";
        @NotNull
        private static final ContentType Any = new ContentType("video", "*", null, 4, null);
        @NotNull
        private static final ContentType MPEG = new ContentType("video", "mpeg", null, 4, null);
        @NotNull
        private static final ContentType MP4 = new ContentType("video", "mp4", null, 4, null);
        @NotNull
        private static final ContentType OGG = new ContentType("video", "ogg", null, 4, null);
        @NotNull
        private static final ContentType QuickTime = new ContentType("video", "quicktime", null, 4, null);

        private Video() {
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getMPEG() {
            return MPEG;
        }

        @NotNull
        public final ContentType getMP4() {
            return MP4;
        }

        @NotNull
        public final ContentType getOGG() {
            return OGG;
        }

        @NotNull
        public final ContentType getQuickTime() {
            return QuickTime;
        }

        public final boolean contains(@NotNull CharSequence contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return StringsKt.startsWith((CharSequence)contentType, (CharSequence)"video/", (boolean)true);
        }

        public final boolean contains(@NotNull ContentType contentType) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            return contentType.match(Any);
        }
    }
}

