/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.run.actions.ChangePageSizeUtilKt;
import com.intellij.database.run.ui.CustomPageSizeForm;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/run/actions/SetCustomPageSizeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "SetPageSizeDialogWrapper", "intellij.grid.impl"})
public final class SetCustomPageSizeAction
extends DumbAwareAction {
    public SetCustomPageSizeAction() {
        super(ApplicationBundle.messagePointer((String)"custom.option", (Object[])new Object[0]), ApplicationBundle.messagePointer((String)"custom.option.description", (Object[])new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        e.getPresentation().setEnabledAndVisible(grid != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (grid == null) {
            return;
        }
        GridPagingModel gridPagingModel = grid.getDataHookup().getPageModel();
        Intrinsics.checkNotNullExpressionValue((Object)gridPagingModel, (String)"getPageModel(...)");
        GridPagingModel pageModel = gridPagingModel;
        Project project = DumbAwareAction.getEventProject((AnActionEvent)e);
        new SetPageSizeDialogWrapper((GridPagingModel<GridRow, GridColumn>)pageModel, grid, project){
            final /* synthetic */ GridPagingModel<GridRow, GridColumn> $pageModel;
            final /* synthetic */ DataGrid $grid;
            {
                this.$pageModel = $pageModel;
                this.$grid = $grid;
                super($super_call_param$1);
            }

            protected int getPageSize() {
                boolean unlimited = GridUtilCore.isPageSizeUnlimited((int)this.$pageModel.getPageSize());
                return unlimited ? GridUtilCore.getPageSize((DataGridSettings)GridUtil.getSettings(this.$grid)) : this.$pageModel.getPageSize();
            }

            protected boolean isLimitPageSize() {
                return !GridUtilCore.isPageSizeUnlimited((int)this.$pageModel.getPageSize());
            }

            protected void doOKAction() {
                super.doOKAction();
                ChangePageSizeUtilKt.setPageSizeAndReload(this.getMyForm().getPageSize(), this.$grid);
            }
        }.show();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\u0011\u001a\u00020\u0012X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/run/actions/SetCustomPageSizeAction$SetPageSizeDialogWrapper;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myForm", "Lcom/intellij/database/run/ui/CustomPageSizeForm;", "getMyForm", "()Lcom/intellij/database/run/ui/CustomPageSizeForm;", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "initListeners", "", "updateOk", "isOKActionEnabled", "", "pageSize", "", "getPageSize", "()I", "isLimitPageSize", "()Z", "createCenterPanel", "intellij.grid.impl"})
    public static abstract class SetPageSizeDialogWrapper
    extends DialogWrapper {
        @NotNull
        private final CustomPageSizeForm myForm = new CustomPageSizeForm();

        public SetPageSizeDialogWrapper(@Nullable Project project) {
            super(project);
            this.setTitle(DataGridBundle.message((String)"dialog.title.change.page.size", (Object[])new Object[0]));
            this.initListeners();
            this.init();
        }

        @NotNull
        protected final CustomPageSizeForm getMyForm() {
            return this.myForm;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return (JComponent)this.myForm.getResultPageSizeTextField();
        }

        private final void initListeners() {
            this.myForm.getResultPageSizeTextField().getDocument().addDocumentListener(new DocumentListener(this){
                final /* synthetic */ SetPageSizeDialogWrapper this$0;
                {
                    this.this$0 = $receiver;
                }

                public void insertUpdate(DocumentEvent e) {
                    SetPageSizeDialogWrapper.access$updateOk(this.this$0);
                }

                public void removeUpdate(DocumentEvent e) {
                    SetPageSizeDialogWrapper.access$updateOk(this.this$0);
                }

                public void changedUpdate(DocumentEvent e) {
                    SetPageSizeDialogWrapper.access$updateOk(this.this$0);
                }
            });
        }

        private final void updateOk() {
            this.getOKAction().setEnabled(this.isOKActionEnabled());
        }

        public boolean isOKActionEnabled() {
            try {
                this.myForm.getResultPageSizeTextField().validateContent();
                return true;
            }
            catch (ConfigurationException configurationException) {
                return false;
            }
        }

        protected abstract int getPageSize();

        protected abstract boolean isLimitPageSize();

        @NotNull
        protected JComponent createCenterPanel() {
            this.myForm.reset(this.isLimitPageSize(), this.getPageSize());
            JPanel jPanel = this.myForm.getPanel();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getPanel(...)");
            return jPanel;
        }

        public static final /* synthetic */ void access$updateOk(SetPageSizeDialogWrapper $this) {
            $this.updateOk();
        }
    }
}

