/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.codeInsight.hints.presentation.MouseButton;
import com.intellij.codeInsight.hints.presentation.MouseButtonKt;
import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.extensions.ExtractorScripts;
import com.intellij.database.extractors.DataAggregatorFactory;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.ExtractorConfig;
import com.intellij.database.extractors.ExtractorsHelper;
import com.intellij.database.run.ui.AggregateCell;
import com.intellij.database.run.ui.AggregateView;
import com.intellij.database.run.ui.AggregateViewPanelColorsScheme;
import com.intellij.database.run.ui.AggregationResult;
import com.intellij.database.run.ui.Aggregator;
import com.intellij.database.run.ui.CellViewer;
import com.intellij.database.run.ui.UpdateEvent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TableCell;
import com.intellij.ui.TableExpandableItemsHandler;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.AlignKt;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000{\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\r\u0018\u00002\u00020\u00012\u00020\u0002:\u000512345B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0%J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0%J\u0016\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020#J\b\u0010*\u001a\u00020!H\u0016J\u0012\u0010+\u001a\u00020!2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\b\u0010.\u001a\u00020!H\u0002J\u0006\u0010/\u001a\u000200R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001d\u00a8\u00066"}, d2={"Lcom/intellij/database/run/ui/AggregateView;", "Lcom/intellij/database/run/ui/CellViewer;", "Lcom/intellij/openapi/Disposable;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;)V", "disabledAggregators", "Ljava/util/HashSet;", "", "popupGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "table", "com/intellij/database/run/ui/AggregateView$table$1", "Lcom/intellij/database/run/ui/AggregateView$table$1;", "tableScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "actionToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "Lorg/jetbrains/annotations/NotNull;", "mainPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "myResultRenderer", "Lcom/intellij/database/run/ui/AggregateView$AggregateViewCellRenderer;", "myNameRenderer", "Lcom/intellij/database/run/ui/AggregateView$AggregatorNameCellRenderer;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "preferedFocusComponent", "getPreferedFocusComponent", "changeDisplayForAllAggregators", "", "isExpand", "", "getEnabledAggregatorsScripts", "", "getDisabledAggregatorsScripts", "setAggregatorSelection", "name", "selected", "dispose", "update", "event", "Lcom/intellij/database/run/ui/UpdateEvent;", "cleanOldDisabledScripts", "getCurrentModel", "Ljavax/swing/table/TableModel;", "AggregateViewCellRenderer", "AggregatorNameCellRenderer", "AggregatorViewPanel", "ArrowIcon", "AggregatorNamePanel", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nAggregateView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AggregateView.kt\ncom/intellij/database/run/ui/AggregateView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,552:1\n1915#2:553\n1916#2:555\n1021#2,2:556\n363#2,7:558\n1586#2:565\n1661#2,3:566\n1#3:554\n*S KotlinDebug\n*F\n+ 1 AggregateView.kt\ncom/intellij/database/run/ui/AggregateView\n*L\n306#1:553\n306#1:555\n318#1:556,2\n324#1:558,7\n343#1:565\n343#1:566,3\n*E\n"})
public final class AggregateView
implements CellViewer,
Disposable {
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final HashSet<String> disabledAggregators;
    @NotNull
    private final ActionGroup popupGroup;
    @NotNull
    private final table.1 table;
    @NotNull
    private final JBScrollPane tableScrollPane;
    @NotNull
    private final ActionToolbar actionToolbar;
    @NotNull
    private final DialogPanel mainPanel;
    @NotNull
    private final AggregateViewCellRenderer myResultRenderer;
    @NotNull
    private final AggregatorNameCellRenderer myNameRenderer;

    public AggregateView(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.grid = grid;
        this.disabledAggregators = new HashSet();
        AnAction anAction = ActionManager.getInstance().getAction("Console.AggregateView.PopupGroup");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        this.popupGroup = (ActionGroup)anAction;
        this.table = new UiDataProvider(this){
            private final table.myCopyProvider.1 myCopyProvider;
            final /* synthetic */ AggregateView this$0;
            {
                this.this$0 = $receiver;
                this.myCopyProvider = new CopyProvider(this){
                    final /* synthetic */ table.1 this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public ActionUpdateThread getActionUpdateThread() {
                        return ActionUpdateThread.EDT;
                    }

                    public void performCopy(DataContext dataContext) {
                        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                        ArrayList<E> selected = new ArrayList<E>();
                        boolean multipleRows = this.this$0.getSelectedRows().length > 1;
                        int[] nArray = this.this$0.getSelectedRows();
                        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
                        for (int idx : nArray) {
                            Object object = this.this$0.getModel().getValueAt(idx, 1);
                            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.database.run.ui.AggregateCell");
                            AggregateCell cell = (AggregateCell)object;
                            Object object2 = cell.getFuture().getNow(null);
                            if (object2 == null || (object2 = ((AggregationResult)object2).getText()) == null) {
                                String string = DataGridBundle.message((String)"status.bar.grid.aggregator.widget.calculating", (Object[])new Object[0]);
                                object2 = string;
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            }
                            Object result = object2;
                            Object text = multipleRows ? cell.getAggregator().getSimpleName() + ": " + (String)result : result;
                            ContainerUtil.addIfNotNull((Collection)selected, (Object)text);
                        }
                        if (selected.size() > 0) {
                            String string = StringUtil.join((Collection)selected, (String)"\n");
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
                            String text = string;
                            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text));
                        }
                    }

                    public boolean isCopyEnabled(DataContext dataContext) {
                        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                        return table.1.access$getSelectionModel$p$s-1623866647(this.this$0).getSelectedItemsCount() > 0;
                    }

                    public boolean isCopyVisible(DataContext dataContext) {
                        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                        return true;
                    }
                };
            }

            public final table.myCopyProvider.1 getMyCopyProvider() {
                return this.myCopyProvider;
            }

            public void uiDataSnapshot(DataSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                DataKey dataKey = PlatformDataKeys.COPY_PROVIDER;
                Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"COPY_PROVIDER");
                sink.set(dataKey, (Object)this.myCopyProvider);
            }

            public TableCellRenderer getCellRenderer(int row, int column) {
                return column == 0 ? (TableCellRenderer)AggregateView.access$getMyNameRenderer$p(this.this$0) : (TableCellRenderer)AggregateView.access$getMyResultRenderer$p(this.this$0);
            }

            protected ExpandableItemsHandler<TableCell> createExpandableItemsHandler() {
                return (ExpandableItemsHandler)new TableExpandableItemsHandler(this){

                    protected void handleSelectionChange(TableCell selected, boolean processIfUnfocused) {
                        TableCell tableCell = selected;
                        TableCell s = (tableCell != null ? tableCell.column == 0 : false) ? selected : null;
                        super.handleSelectionChange((Object)s, processIfUnfocused);
                    }
                };
            }

            public Dimension getPreferredScrollableViewportSize() {
                Dimension dimension = this.getPreferredSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
                return dimension;
            }

            public static final /* synthetic */ ListSelectionModel access$getSelectionModel$p$s-1623866647(table.1 $this) {
                return $this.selectionModel;
            }
        };
        this.tableScrollPane = new JBScrollPane((Component)((Object)this.table));
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction2 = ActionManager.getInstance().getAction("Console.TableResult.AggregatorViewGroup");
        Intrinsics.checkNotNull((Object)anAction2, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionToolbar actionToolbar2 = actionManager.createActionToolbar("TP", (ActionGroup)anAction2, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"createActionToolbar(...)");
        this.actionToolbar = actionToolbar2;
        this.mainPanel = BuilderKt.panel(arg_0 -> AggregateView.mainPanel$lambda$0(this, arg_0));
        this.actionToolbar.setTargetComponent((JComponent)this.mainPanel);
        this.myResultRenderer = new AggregateViewCellRenderer();
        this.myNameRenderer = new AggregatorNameCellRenderer();
        Object object = GridUtil.getSettings(this.grid);
        this.disabledAggregators.addAll(object != null && (object = object.getDisabledAggregators()) != null ? (Collection)object : (Collection)CollectionsKt.emptyList());
        this.cleanOldDisabledScripts();
        AnAction expandAction2 = new AnAction(this){
            final /* synthetic */ AggregateView this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.changeDisplayForAllAggregators(true);
            }
        };
        AnAction collapseAction2 = new AnAction(this){
            final /* synthetic */ AggregateView this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.changeDisplayForAllAggregators(false);
            }
        };
        File file = ExtractorScripts.getAggregatorScriptsDirectory();
        final String aggregatorDirPath = file != null ? file.getAbsolutePath() : null;
        this.table.setShowGrid(false);
        this.table.setShowColumns(false);
        this.tableScrollPane.setHorizontalScrollBarPolicy(31);
        Shortcut[] shortcutArray = new Shortcut[]{KeyboardShortcut.fromString((String)"RIGHT")};
        expandAction2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)((Object)this.table));
        shortcutArray = new Shortcut[]{KeyboardShortcut.fromString((String)"LEFT")};
        collapseAction2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray), (JComponent)((Object)this.table));
        UiNotifyConnector.Companion.installOn((Component)this.tableScrollPane, new Activatable(){

            public void showNotify() {
                FileDocumentManager.getInstance().saveDocuments(arg_0 -> 1.showNotify$lambda$1(arg_0 -> 1.showNotify$lambda$0(aggregatorDirPath, arg_0), arg_0));
            }

            private static final boolean showNotify$lambda$0(String $aggregatorDirPath, Document document) {
                boolean bl;
                VirtualFile file = FileDocumentManager.getInstance().getFile(document);
                if ($aggregatorDirPath != null && file != null) {
                    String string = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    bl = StringsKt.startsWith$default((String)string, (String)$aggregatorDirPath, (boolean)false, (int)2, null) && FileDocumentManager.getInstance().isDocumentUnsaved(document);
                } else {
                    bl = false;
                }
                return bl;
            }

            private static final boolean showNotify$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        });
        MessageBusConnection messageBusConnection = this.grid.getProject().getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)new BulkFileListener(){

            /*
             * Unable to fully structure code
             */
            public void after(List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                var3_2 = events;
                var4_3 = aggregatorDirPath;
                $i$f$filter = false;
                var6_5 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    event = (VFileEvent)element$iv$iv;
                    $i$a$-filter-AggregateView$2$after$aggregatorsEvents$1 = false;
                    if (var4_3 == null) ** GOTO lbl-1000
                    v0 = event.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getPath(...)");
                    if (StringsKt.startsWith$default((String)v0, (String)var4_3, (boolean)false, (int)2, null)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                aggregatorsEvents = (List)destination$iv$iv;
                if (((Collection)aggregatorsEvents).isEmpty() == false) {
                    ApplicationManager.getApplication().invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, after$lambda$1(com.intellij.database.run.ui.AggregateView ), ()V)((AggregateView)this));
                }
            }

            private static final void after$lambda$1(AggregateView this$0) {
                CellViewer.update$default(this$0, null, 1, null);
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.myResultRenderer);
        MouseListener mouseListener2 = new MouseAdapter(this){
            private boolean isNewPress;
            final /* synthetic */ AggregateView this$0;
            {
                this.this$0 = $receiver;
                this.isNewPress = true;
            }

            public void mouseReleased(MouseEvent e) {
                this.isNewPress = true;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
                Object object = mouseEvent.getSource();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JTable");
                JTable table2 = (JTable)object;
                int index = table2.rowAtPoint(mouseEvent.getPoint());
                if (MouseButtonKt.getMouseButton((MouseEvent)mouseEvent) == MouseButton.Right) {
                    if (index >= 0 && this.isNewPress && !table2.getSelectionModel().isSelectedIndex(index)) {
                        table2.getSelectionModel().clearSelection();
                        table2.getSelectionModel().addSelectionInterval(index, index);
                    }
                    this.isNewPress = false;
                    return;
                }
                if (!UIUtil.isActionClick((MouseEvent)mouseEvent, (int)501)) {
                    this.isNewPress = false;
                    return;
                }
                if (index >= 0) {
                    if (this.isNewPress) {
                        boolean result;
                        this.isNewPress = false;
                        Object currentElement = table2.getModel().getValueAt(index, 1);
                        if (currentElement == null) {
                            return;
                        }
                        AggregatorViewPanel panel2 = AggregateView.access$getMyResultRenderer$p(this.this$0).getTableCellRendererComponent(table2, currentElement, false, false, index, 1);
                        AggregationResult aggregationResult = ((AggregateCell)currentElement).getFuture().getNow(null);
                        if (aggregationResult != null) {
                            Rectangle rectangle = table2.getCellRect(index, 1, false);
                            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getCellRect(...)");
                            v3 = aggregationResult.processMouseClickEvent(mouseEvent, rectangle, panel2);
                        } else {
                            v3 = result = true;
                        }
                        if (result && (!table2.getSelectionModel().isSelectedIndex(index) || table2.hasFocus())) {
                            if ((mouseEvent.getModifiersEx() & 0x180) == 0) {
                                table2.getSelectionModel().clearSelection();
                            }
                            table2.getSelectionModel().addSelectionInterval(index, index);
                        }
                    } else {
                        table2.getSelectionModel().addSelectionInterval(index, index);
                    }
                    table2.requestFocus();
                    table2.updateUI();
                } else {
                    this.isNewPress = false;
                }
            }
        };
        this.table.addMouseListener(mouseListener2);
        this.table.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                if (!Intrinsics.areEqual((Object)popupGroup, (Object)ActionGroup.EMPTY_GROUP)) {
                    ActionManager.getInstance().createActionPopupMenu("EditorPopup", popupGroup).getComponent().show(comp, x, y);
                }
            }
        });
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.mainPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferedFocusComponent() {
        return (JComponent)this.mainPanel;
    }

    public final void changeDisplayForAllAggregators(boolean isExpand) {
        int[] nArray = this.table.getSelectedRows();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
        for (int rowId : nArray) {
            Object object = this.table.getModel().getValueAt(rowId, 1);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.database.run.ui.AggregateCell");
            AggregateCell element = (AggregateCell)object;
            AggregationResult aggregationResult = element.getFuture().getNow(null);
            if (aggregationResult == null) continue;
            aggregationResult.setDecorateState(isExpand);
        }
        this.table.requestFocus();
        this.table.updateUI();
    }

    @NotNull
    public final List<String> getEnabledAggregatorsScripts() {
        List aggregators = new ArrayList();
        int n = this.table.getModel().getRowCount();
        for (int idx = 0; idx < n; ++idx) {
            Object object = this.table.getModel().getValueAt(idx, 1);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.database.run.ui.AggregateCell");
            aggregators.add(((AggregateCell)object).getAggregator());
        }
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)aggregators), arg_0 -> AggregateView.getEnabledAggregatorsScripts$lambda$0(this, arg_0)), AggregateView::getEnabledAggregatorsScripts$lambda$1));
    }

    @NotNull
    public final List<String> getDisabledAggregatorsScripts() {
        return CollectionsKt.toList((Iterable)this.disabledAggregators);
    }

    public final void setAggregatorSelection(@NotNull String name, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean bl = selected ? this.disabledAggregators.remove(name) : this.disabledAggregators.add(name);
    }

    public void dispose() {
    }

    @Override
    public void update(@Nullable UpdateEvent event) {
        DefaultTableModel model2 = new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model2.addColumn("name");
        model2.addColumn("value");
        if (this.grid.getSelectionModel().getSelectedColumnCount() == 0 || this.grid.getSelectionModel().getSelectedRowCount() == 0) {
            this.table.setModel(model2);
            return;
        }
        List oldAggregatorCells = new ArrayList();
        int n = this.table.getModel().getRowCount();
        for (int idx = 0; idx < n; ++idx) {
            Object object = this.table.getModel().getValueAt(idx, 1);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.database.run.ui.AggregateCell");
            oldAggregatorCells.add((AggregateCell)object);
        }
        List list = DataExtractorFactories.getAggregatorScripts((ExtractorsHelper)ExtractorsHelper.getInstance((CoreGrid)this.grid), GridUtil::suggestPlugin);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAggregatorScripts(...)");
        List scripts = list;
        LinkedList<Aggregator> aggregators = new LinkedList<Aggregator>();
        Iterable $this$forEach$iv = scripts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v2;
            DataAggregatorFactory script;
            block12: {
                script = (DataAggregatorFactory)element$iv;
                boolean bl = false;
                Iterable iterable = oldAggregatorCells;
                for (Object t : iterable) {
                    AggregateCell cell = (AggregateCell)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)cell.getAggregator().getName(), (Object)script.getName())) continue;
                    v2 = t;
                    break block12;
                }
                v2 = null;
            }
            AggregateCell findResult = v2;
            if (findResult == null) {
                ExtractorConfig config;
                Intrinsics.checkNotNullExpressionValue((Object)ExtractorsHelper.getInstance((CoreGrid)this.grid).createExtractorConfig((CoreGrid)this.grid, this.grid.getObjectFormatter()), (String)"createExtractorConfig(...)");
                if (script.createAggregator(config) != null) {
                    DataExtractor it;
                    boolean bl = false;
                    String string = script.getSimpleName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
                    String string2 = script.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    aggregators.add(new Aggregator(this.grid, it, string, string2));
                }
                continue;
            }
            aggregators.add(findResult.getAggregator());
        }
        List $this$sortBy$iv = aggregators;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Aggregator sc = (Aggregator)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)sc.getSimpleName());
                    sc = (Aggregator)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)sc.getSimpleName())));
                }
            });
        }
        int idxCounter = 0;
        List selectedList = new ArrayList();
        Iterator iterator = aggregators.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Object> iterator2 = iterator;
        while (iterator2.hasNext()) {
            int n2;
            CompletableFuture<AggregationResult> future;
            Aggregator aggregator;
            block13: {
                Object object = iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
                aggregator = (Aggregator)object;
                if (this.disabledAggregators.contains(aggregator.getName())) continue;
                future = aggregator.update();
                List $this$indexOfFirst$iv = oldAggregatorCells;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    AggregateCell cell = (AggregateCell)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)cell.getAggregator(), (Object)aggregator)) {
                        n2 = index$iv;
                        break block13;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            int idx = n2;
            AggregateCell cell = idx == -1 ? null : (AggregateCell)oldAggregatorCells.get(idx);
            future.thenAccept(arg_0 -> AggregateView.update$lambda$4(arg_0 -> AggregateView.update$lambda$3(cell, arg_0), arg_0));
            if (idx != -1 && this.table.getSelectionModel().isSelectedIndex(idx)) {
                selectedList.add(idx);
            }
            Object[] objectArray = new Object[]{aggregator.getSimpleName(), new AggregateCell(aggregator, future)};
            model2.addRow(objectArray);
            ++idxCounter;
        }
        this.table.setModel(model2);
        this.table.getColumn(this.table.getModel().getColumnName(0)).setMinWidth(120);
        this.table.getColumn(this.table.getModel().getColumnName(0)).setMaxWidth(120);
        iterator2 = selectedList.iterator();
        while (iterator2.hasNext()) {
            int index = ((Number)iterator2.next()).intValue();
            this.table.getSelectionModel().addSelectionInterval(index, index);
        }
        this.table.updateUI();
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanOldDisabledScripts() {
        void $this$mapTo$iv$iv;
        List list = DataExtractorFactories.getAggregatorScripts((ExtractorsHelper)ExtractorsHelper.getInstance((CoreGrid)this.grid), null);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAggregatorScripts(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void script;
            DataAggregatorFactory dataAggregatorFactory = (DataAggregatorFactory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(script.getName());
        }
        List scriptNames = (List)destination$iv$iv;
        this.disabledAggregators.removeIf(arg_0 -> AggregateView.cleanOldDisabledScripts$lambda$2(arg_0 -> AggregateView.cleanOldDisabledScripts$lambda$1(scriptNames, arg_0), arg_0));
    }

    @NotNull
    public final TableModel getCurrentModel() {
        TableModel tableModel = this.table.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)tableModel, (String)"getModel(...)");
        return tableModel;
    }

    private static final Unit mainPanel$lambda$0$0(AggregateView this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.tableScrollPane).align(AlignKt.plus((AlignX)((AlignX)AlignX.FILL.INSTANCE), (AlignY)((AlignY)AlignY.TOP.INSTANCE))).resizableColumn();
        return Unit.INSTANCE;
    }

    private static final Unit mainPanel$lambda$0$1(AggregateView this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JComponent jComponent = this$0.actionToolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        $this$row.cell(jComponent);
        return Unit.INSTANCE;
    }

    private static final Unit mainPanel$lambda$0(AggregateView this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AggregateView.mainPanel$lambda$0$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> AggregateView.mainPanel$lambda$0$1(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final boolean getEnabledAggregatorsScripts$lambda$0(AggregateView this$0, Aggregator aggregator) {
        Intrinsics.checkNotNullParameter((Object)aggregator, (String)"aggregator");
        return !this$0.disabledAggregators.contains(aggregator.getName());
    }

    private static final String getEnabledAggregatorsScripts$lambda$1(Aggregator aggregator) {
        Intrinsics.checkNotNullParameter((Object)aggregator, (String)"aggregator");
        return aggregator.getName();
    }

    private static final Unit update$lambda$3(AggregateCell $cell, AggregationResult result) {
        Object object = $cell;
        result.setFullTextShown(object != null && (object = ((AggregateCell)object).getFuture()) != null && (object = (AggregationResult)((CompletableFuture)object).getNow(null)) != null ? ((AggregationResult)object).isFullTextShown() : false);
        return Unit.INSTANCE;
    }

    private static final void update$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean cleanOldDisabledScripts$lambda$1(List $scriptNames, String name) {
        return !$scriptNames.contains(name);
    }

    private static final boolean cleanOldDisabledScripts$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ AggregatorNameCellRenderer access$getMyNameRenderer$p(AggregateView $this) {
        return $this.myNameRenderer;
    }

    public static final /* synthetic */ AggregateViewCellRenderer access$getMyResultRenderer$p(AggregateView $this) {
        return $this.myResultRenderer;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J:\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/run/ui/AggregateView$AggregateViewCellRenderer;", "Ljavax/swing/table/TableCellRenderer;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "myPanel", "Lcom/intellij/database/run/ui/AggregateView$AggregatorViewPanel;", "getTextColor", "Ljava/awt/Color;", "isThrowable", "", "getTableCellRendererComponent", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "hasFocus", "row", "", "column", "dispose", "", "intellij.grid.impl"})
    public static final class AggregateViewCellRenderer
    implements TableCellRenderer,
    Disposable {
        @NotNull
        private final AggregatorViewPanel myPanel = new AggregatorViewPanel();

        private final Color getTextColor(boolean isThrowable) {
            return isThrowable ? NamedColorUtil.getInactiveTextColor() : UIUtil.getActiveTextColor();
        }

        @Override
        @NotNull
        public AggregatorViewPanel getTableCellRendererComponent(@NotNull JTable table2, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color;
            boolean cellHasFocus;
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.intellij.database.run.ui.AggregateCell");
            CompletableFuture<AggregationResult> future = ((AggregateCell)value).getFuture();
            AggregationResult result = future.getNow(null);
            boolean bl = cellHasFocus = isSelected && table2.hasFocus();
            if (isSelected) {
                color = NamedColorUtil.getListSelectionForeground((boolean)cellHasFocus);
            } else {
                AggregationResult aggregationResult = result;
                color = this.getTextColor(aggregationResult != null ? aggregationResult.isScriptExceptionHappened() : false);
            }
            Color textColor = color;
            int t = TableHoverListener.getHoveredRow((JTable)table2);
            Color selectionColor = null;
            if (t == row && !isSelected) {
                Color color2 = JBUI.CurrentTheme.Table.Hover.background((boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"background(...)");
                selectionColor = color2;
            } else {
                Color color3;
                if (isSelected) {
                    Color color4 = UIUtil.getListSelectionBackground((boolean)cellHasFocus);
                    color3 = color4;
                    Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"getListSelectionBackground(...)");
                } else {
                    Color color5 = UIUtil.getListBackground();
                    color3 = color5;
                    Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"getListBackground(...)");
                }
                selectionColor = color3;
            }
            this.myPanel.setComponentsForeground(textColor);
            this.myPanel.setComponentsBackground(selectionColor);
            Object object = result;
            if (object == null || (object = ((AggregationResult)object).getText()) == null) {
                String string = DataGridBundle.message((String)"status.bar.grid.aggregator.widget.calculating", (Object[])new Object[0]);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            }
            Object text = object;
            this.myPanel.setText((String)text);
            AggregationResult aggregationResult = result;
            this.myPanel.setMultilineState(StringsKt.contains$default((CharSequence)((CharSequence)text), (CharSequence)"\n", (boolean)false, (int)2, null), aggregationResult != null ? aggregationResult.isFullTextShown() : true, isSelected, cellHasFocus);
            AggregationResult aggregationResult2 = result;
            int rowHeight = (aggregationResult2 != null ? aggregationResult2.getRowsCount() : 1) * this.myPanel.getRowHeight() + table2.getRowMargin() + this.myPanel.getBordersHeight();
            if (table2.getRowHeight(row) != rowHeight) {
                table2.setRowHeight(row, rowHeight);
            }
            return this.myPanel;
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myPanel);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/run/ui/AggregateView$AggregatorNameCellRenderer;", "Ljavax/swing/table/TableCellRenderer;", "<init>", "()V", "myPanel", "Lcom/intellij/database/run/ui/AggregateView$AggregatorNamePanel;", "getTableCellRendererComponent", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "intellij.grid.impl"})
    public static final class AggregatorNameCellRenderer
    implements TableCellRenderer {
        @NotNull
        private final AggregatorNamePanel myPanel = new AggregatorNamePanel();

        @Override
        @NotNull
        public AggregatorNamePanel getTableCellRendererComponent(@NotNull JTable table2, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            boolean cellHasFocus = isSelected && table2.hasFocus();
            Color color = isSelected ? UIUtil.getListSelectionBackground((boolean)cellHasFocus) : UIUtil.getListBackground();
            Intrinsics.checkNotNull((Object)color);
            Color selectionColor = color;
            Color nameColor = isSelected ? NamedColorUtil.getListSelectionForeground((boolean)cellHasFocus) : UIUtil.getActiveTextColor();
            this.myPanel.setComponentsForeground(nameColor);
            this.myPanel.setComponentsBackground(selectionColor);
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
            this.myPanel.setText((String)value);
            return this.myPanel;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\u00072\b\b\u0001\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/run/ui/AggregateView$AggregatorNamePanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "myNameLabel", "Ljavax/swing/JLabel;", "setComponentsForeground", "", "textColor", "Ljava/awt/Color;", "setComponentsBackground", "color", "setText", "text", "", "intellij.grid.impl"})
    public static final class AggregatorNamePanel
    extends JPanel {
        @NotNull
        private final JLabel myNameLabel = new JLabel();

        public AggregatorNamePanel() {
            super(new BorderLayout());
            this.myNameLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
            this.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)5, (int)10));
            this.add((Component)this.myNameLabel, "North");
        }

        public final void setComponentsForeground(@Nullable Color textColor) {
            this.myNameLabel.setForeground(textColor);
            this.myNameLabel.updateUI();
        }

        public final void setComponentsBackground(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.setBackground(color);
            this.myNameLabel.setBackground(color);
        }

        public final void setText(@NlsSafe @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.myNameLabel.setText(text);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001aJ\u0006\u0010\u001d\u001a\u00020\u001aJ\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 J&\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000fJ\b\u0010&\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/database/run/ui/AggregateView$AggregatorViewPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "myResultPanel", "myIcon", "Lcom/intellij/ui/components/JBLabel;", "myArrowIcon", "Lcom/intellij/database/run/ui/AggregateView$ArrowIcon;", "myTextPanel", "Lcom/intellij/ui/EditorTextFieldCellRenderer$AbbreviatingRendererComponent;", "colorsScheme", "Lcom/intellij/database/run/ui/AggregateViewPanelColorsScheme;", "isClickOnButton", "", "e", "Ljava/awt/event/MouseEvent;", "rectangle", "Ljava/awt/Rectangle;", "getRowHeight", "", "getBordersHeight", "setComponentsForeground", "", "textColor", "Ljava/awt/Color;", "setComponentsBackground", "color", "getComponentBackground", "setText", "text", "", "setMultilineState", "isMultiline", "showFullText", "isSelected", "hasFocus", "dispose", "intellij.grid.impl"})
    @SourceDebugExtension(value={"SMAP\nAggregateView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AggregateView.kt\ncom/intellij/database/run/ui/AggregateView$AggregatorViewPanel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,552:1\n14060#2,2:553\n*S KotlinDebug\n*F\n+ 1 AggregateView.kt\ncom/intellij/database/run/ui/AggregateView$AggregatorViewPanel\n*L\n426#1:553,2\n*E\n"})
    public static final class AggregatorViewPanel
    extends JPanel
    implements Disposable {
        @NotNull
        private final JPanel myResultPanel = new JPanel(new BorderLayout());
        @NotNull
        private final JBLabel myIcon = new JBLabel();
        @NotNull
        private final ArrowIcon myArrowIcon = new ArrowIcon();
        @NotNull
        private final EditorTextFieldCellRenderer.AbbreviatingRendererComponent myTextPanel = new EditorTextFieldCellRenderer.AbbreviatingRendererComponent(null, null, true, true, true);
        @NotNull
        private final AggregateViewPanelColorsScheme colorsScheme;

        public AggregatorViewPanel() {
            super(new BorderLayout());
            this.myIcon.setVerticalAlignment(1);
            this.myResultPanel.add((Component)this.myTextPanel, "Center");
            this.myResultPanel.add((Component)this.myIcon, "East");
            this.myResultPanel.setOpaque(false);
            this.myTextPanel.setOpaque(false);
            Component[] componentArray = this.myTextPanel.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Object[] $this$forEach$iv = componentArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Component c2 = (Component)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)c2, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                ((JComponent)c2).setOpaque(false);
            }
            this.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)5, (int)10));
            this.add(this.myResultPanel);
            EditorColorsScheme editorColorsScheme = this.myTextPanel.getEditor().getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
            this.colorsScheme = new AggregateViewPanelColorsScheme(editorColorsScheme);
            this.myTextPanel.getEditor().setColorsScheme((EditorColorsScheme)this.colorsScheme);
        }

        public final boolean isClickOnButton(@NotNull MouseEvent e, @NotNull Rectangle rectangle) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
            if (this.myIcon.getIcon() == null) {
                return false;
            }
            int leftBorder = rectangle.x + this.getBorder().getBorderInsets((Component)((Component)this)).left + this.myResultPanel.getWidth() - this.myIcon.getWidth();
            int rightBorder = leftBorder + this.myIcon.getWidth();
            int topBorder = rectangle.y + this.getBorder().getBorderInsets((Component)((Component)this)).top;
            int downBorder = topBorder + this.myIcon.getHeight();
            return e.getX() > leftBorder && e.getY() > topBorder && e.getX() < rightBorder && e.getY() < downBorder;
        }

        public final int getRowHeight() {
            return (int)Math.ceil((float)this.getFontMetrics(this.getFont()).getHeight() * this.colorsScheme.getLineSpacing());
        }

        public final int getBordersHeight() {
            return this.getBorder().getBorderInsets((Component)((Component)this)).top + this.getBorder().getBorderInsets((Component)((Component)this)).bottom;
        }

        public final void setComponentsForeground(@Nullable Color textColor) {
            this.colorsScheme.setForeground(textColor);
        }

        public final void setComponentsBackground(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            this.setBackground(color);
            this.myTextPanel.setBackground(color);
            this.myResultPanel.setBackground(color);
        }

        @NotNull
        public final Color getComponentBackground() {
            Color color = this.myTextPanel.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
            return color;
        }

        public final void setText(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.myTextPanel.setText(text);
        }

        public final void setMultilineState(boolean isMultiline, boolean showFullText, boolean isSelected, boolean hasFocus) {
            if (isMultiline) {
                this.myIcon.setIcon((Icon)this.myArrowIcon);
                this.myArrowIcon.setShowFullText(showFullText);
                this.myIcon.setBorder((Border)JBUI.Borders.empty((int)(showFullText ? 5 : 3), (int)2, (int)0, (int)0));
                this.myArrowIcon.setSelected(isSelected);
                this.myArrowIcon.setHasFocus(hasFocus);
                this.myIcon.setVisible(true);
                this.myTextPanel.setForceSingleLine(!showFullText);
                this.myTextPanel.setAppendEllipsis(!showFullText);
            } else {
                this.myIcon.setIcon(null);
                this.myIcon.setVisible(false);
                this.myTextPanel.setForceSingleLine(true);
                this.myTextPanel.setAppendEllipsis(true);
            }
        }

        public void dispose() {
            Disposer.dispose((Disposable)((Disposable)this.myTextPanel));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0007\"\u0004\b\u000e\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/run/ui/AggregateView$ArrowIcon;", "Ljavax/swing/Icon;", "<init>", "()V", "showFullText", "", "getShowFullText", "()Z", "setShowFullText", "(Z)V", "isSelected", "setSelected", "hasFocus", "getHasFocus", "setHasFocus", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "", "y", "getIconWidth", "getIconHeight", "intellij.grid.impl"})
    private static final class ArrowIcon
    implements Icon {
        private boolean showFullText;
        private boolean isSelected;
        private boolean hasFocus;

        public final boolean getShowFullText() {
            return this.showFullText;
        }

        public final void setShowFullText(boolean bl) {
            this.showFullText = bl;
        }

        public final boolean isSelected() {
            return this.isSelected;
        }

        public final void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        public final boolean getHasFocus() {
            return this.hasFocus;
        }

        public final void setHasFocus(boolean bl) {
            this.hasFocus = bl;
        }

        @Override
        public void paintIcon(@Nullable Component c2, @Nullable Graphics g, int x, int y) {
            double cx = (double)x + (double)this.getIconWidth() / 2.0;
            double cy = (double)y + (double)this.getIconHeight() / 2.0;
            double angle = this.showFullText ? -1.5707963267948966 : 1.5707963267948966;
            Graphics graphics = g;
            Graphics graphics2 = graphics != null ? graphics.create() : null;
            Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D gg = (Graphics2D)graphics2;
            gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            gg.rotate(angle, cx, cy);
            Graphics graphics3 = gg;
            Icon icon = this.isSelected && this.hasFocus ? AllIcons.Icons.Ide.MenuArrowSelected : AllIcons.Icons.Ide.MenuArrow;
            Intrinsics.checkNotNull((Object)icon);
            UIUtil.drawImage((Graphics)graphics3, (Image)IconUtil.toImage$default((Icon)icon, null, (int)2, null), (int)x, (int)y, (ImageObserver)c2);
            gg.dispose();
        }

        @Override
        public int getIconWidth() {
            return AllIcons.Icons.Ide.MenuArrow.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return AllIcons.Icons.Ide.MenuArrow.getIconHeight();
        }
    }
}

