/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"isStringArrayParameter", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "isLoweredSuspendFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "backend.js"})
public final class JsMainFunctionDetectorKt {
    public static final boolean isStringArrayParameter(@NotNull IrValueParameter $this$isStringArrayParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$isStringArrayParameter, (String)"<this>");
        IrType irType = $this$isStringArrayParameter.getType();
        IrSimpleType irSimpleType = irType instanceof IrSimpleType ? (IrSimpleType)irType : null;
        if (irSimpleType == null) {
            return false;
        }
        IrSimpleType type = irSimpleType;
        if (!IrTypePredicatesKt.isArray((IrType)((IrType)type))) {
            return false;
        }
        if (type.getArguments().size() != 1) {
            return false;
        }
        Object object = CollectionsKt.single((List)type.getArguments());
        IrTypeProjection irTypeProjection = object instanceof IrTypeProjection ? (IrTypeProjection)object : null;
        if (irTypeProjection == null) {
            return false;
        }
        IrTypeProjection argument = irTypeProjection;
        if (argument.getVariance() == Variance.IN_VARIANCE) {
            return false;
        }
        return IrTypePredicatesKt.isString((IrType)argument.getType());
    }

    public static final boolean isLoweredSuspendFunction(@NotNull IrFunction $this$isLoweredSuspendFunction, @NotNull JsCommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$isLoweredSuspendFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.lastOrNull((List)$this$isLoweredSuspendFunction.getParameters());
        if (irValueParameter == null) {
            return false;
        }
        IrValueParameter parameter = irValueParameter;
        IrType irType = parameter.getType();
        IrSimpleType irSimpleType = irType instanceof IrSimpleType ? (IrSimpleType)irType : null;
        if (irSimpleType == null) {
            return false;
        }
        IrSimpleType type = irSimpleType;
        return Intrinsics.areEqual((Object)type.getClassifier(), (Object)context.getSymbols().getContinuationClass());
    }
}

