/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.clients.impl;

import com.intellij.mcpserver.clients.McpClient;
import com.intellij.mcpserver.clients.McpClientInfo;
import com.intellij.mcpserver.clients.configs.CodexStreamableHttpConfig;
import com.intellij.mcpserver.clients.configs.ExistingConfig;
import com.intellij.mcpserver.clients.configs.ServerConfig;
import com.intellij.util.io.PathKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\u0016\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000eH\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/mcpserver/clients/impl/CodexClient;", "Lcom/intellij/mcpserver/clients/McpClient;", "scope", "Lcom/intellij/mcpserver/clients/McpClientInfo$Scope;", "configPath", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/mcpserver/clients/McpClientInfo$Scope;Ljava/nio/file/Path;)V", "isConfigured", "", "()Ljava/lang/Boolean;", "getSSEConfig", "Lcom/intellij/mcpserver/clients/configs/ServerConfig;", "readMcpServers", "", "", "Lcom/intellij/mcpserver/clients/configs/ExistingConfig;", "configure", "", "Companion", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\nCodexClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodexClient.kt\ncom/intellij/mcpserver/clients/impl/CodexClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1#2:178\n1915#3,2:179\n*S KotlinDebug\n*F\n+ 1 CodexClient.kt\ncom/intellij/mcpserver/clients/impl/CodexClient\n*L\n36#1:179,2\n*E\n"})
public class CodexClient
extends McpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex SERVER_SECTION_REGEX = new Regex("(?mis)^\\s*\\[mcp_servers\\.([^]]+)]\\s*(.*?)(?=^\\s*\\[|\\z)");

    public CodexClient(@NotNull McpClientInfo.Scope scope, @NotNull Path configPath) {
        Intrinsics.checkNotNullParameter((Object)((Object)scope), (String)"scope");
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        super(new McpClientInfo(McpClientInfo.Name.CODEX, scope), configPath);
    }

    @Override
    @Nullable
    public Boolean isConfigured() {
        Boolean bl = this.isStdIOConfigured();
        if (bl == null) {
            return null;
        }
        boolean stdio = bl;
        Boolean bl2 = this.isSSEConfigured();
        if (bl2 == null) {
            return null;
        }
        boolean sse = bl2;
        return stdio || sse;
    }

    @Override
    @NotNull
    protected ServerConfig getSSEConfig() {
        return new CodexStreamableHttpConfig(this.getStreamableHttpUrl());
    }

    @Override
    @Nullable
    protected Map<String, ExistingConfig> readMcpServers() {
        Object object;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(this.getConfigPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        Object object2 = this;
        try {
            CodexClient $this$readMcpServers_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)CodexClient.Companion.parseCodexServers(PathsKt.readText$default((Path)$this$readMcpServers_u24lambda_u240.getConfigPath(), null, (int)1, null)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Map)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @Override
    public void configure() {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        String existingContent = Files.exists(this.getConfigPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? PathsKt.readText$default((Path)this.getConfigPath(), null, (int)1, null) : "";
        String productServerKey = McpClient.Companion.productSpecificServerKey();
        String updatedContent = null;
        updatedContent = existingContent;
        Iterable $this$forEach$iv = McpClient.Companion.getLEGACY_SERVER_KEYS();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String legacyKey = (String)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)legacyKey, (Object)productServerKey)) continue;
            updatedContent = CodexClient.Companion.removeCodexSection(updatedContent, legacyKey);
        }
        updatedContent = CodexClient.Companion.updateCodexConfig(updatedContent, productServerKey, this.getStreamableHttpUrl());
        Path path = this.getConfigPath().getParent();
        if (path != null) {
            PathKt.createParentDirectories((Path)path);
        }
        PathsKt.writeText$default((Path)this.getConfigPath(), (CharSequence)updatedContent, null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\bH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0002J \u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0002J&\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0002J \u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/mcpserver/clients/impl/CodexClient$Companion;", "", "<init>", "()V", "SERVER_SECTION_REGEX", "Lkotlin/text/Regex;", "parseCodexServers", "", "", "Lcom/intellij/mcpserver/clients/configs/ExistingConfig;", "content", "extractTomlString", "body", "key", "extractTomlStringArray", "", "extractTomlInlineTable", "unescapeTomlString", "value", "escapeTomlString", "removeCodexSection", "existing", "serverKey", "updateCodexConfig", "url", "codexSectionRegex", "buildCodexSection", "intellij.mcpserver"})
    @SourceDebugExtension(value={"SMAP\nCodexClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodexClient.kt\ncom/intellij/mcpserver/clients/impl/CodexClient$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,177:1\n1342#2,2:178\n672#2:181\n756#2,4:182\n1#3:180\n1198#4,2:186\n*S KotlinDebug\n*F\n+ 1 CodexClient.kt\ncom/intellij/mcpserver/clients/impl/CodexClient$Companion\n*L\n53#1:178,2\n92#1:181\n92#1:182,4\n124#1:186,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<String, ExistingConfig> parseCodexServers(String content) {
            Map servers = new LinkedHashMap();
            Sequence $this$forEach$iv = Regex.findAll$default((Regex)SERVER_SECTION_REGEX, (CharSequence)content, (int)0, (int)2, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                String type;
                MatchResult matchResult = (MatchResult)element$iv;
                boolean bl = false;
                String serverName = ((Object)StringsKt.trim((CharSequence)((String)matchResult.getGroupValues().get(1)))).toString();
                String body = (String)matchResult.getGroupValues().get(2);
                String command = Companion.extractTomlString(body, "command");
                String string2 = Companion.extractTomlString(body, "type");
                if (string2 == null) {
                    string2 = type = Companion.extractTomlString(body, "transport");
                }
                if ((string = Companion.extractTomlString(body, "url")) == null) {
                    string = Companion.extractTomlString(body, "serverUrl");
                }
                String url = string;
                List<String> args = Companion.extractTomlStringArray(body, "args");
                Map<String, String> env = Companion.extractTomlInlineTable(body, "env");
                servers.put(serverName, new ExistingConfig(command, args, env, url, type));
            }
            return servers;
        }

        private final String extractTomlString(String body, String key) {
            Regex regex = new Regex("(?mis)^\\s*" + Regex.Companion.escape(key) + "\\s*=\\s*\"((?:\\\\.|[^\"])*)\"");
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)body, (int)0, (int)2, null);
            if (matchResult == null) {
                return null;
            }
            MatchResult match = matchResult;
            return this.unescapeTomlString((String)match.getGroupValues().get(1));
        }

        private final List<String> extractTomlStringArray(String body, String key) {
            Collection collection;
            Regex regex = new Regex("(?mis)^\\s*" + Regex.Companion.escape(key) + "\\s*=\\s*\\[(.*?)]");
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)body, (int)0, (int)2, null);
            if (matchResult == null) {
                return null;
            }
            MatchResult match = matchResult;
            String inner = (String)match.getGroupValues().get(1);
            Sequence valueMatches = Regex.findAll$default((Regex)new Regex("\"((?:\\\\.|[^\"])*)\""), (CharSequence)inner, (int)0, (int)2, null);
            List values = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)valueMatches, Companion::extractTomlStringArray$lambda$0));
            Collection collection2 = values;
            if (collection2.isEmpty()) {
                boolean bl = false;
                collection = null;
            } else {
                collection = collection2;
            }
            return (List)collection;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, String> extractTomlInlineTable(String body, String key) {
            Map map;
            void $this$associateTo$iv$iv;
            Sequence pairs;
            Regex regex = new Regex("(?mis)^\\s*" + Regex.Companion.escape(key) + "\\s*=\\s*\\{(.*?)}");
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)body, (int)0, (int)2, null);
            if (matchResult == null) {
                return null;
            }
            MatchResult match = matchResult;
            String inner = (String)match.getGroupValues().get(1);
            Sequence $this$associate$iv = pairs = Regex.findAll$default((Regex)new Regex("([A-Za-z0-9_.\\-]+)\\s*=\\s*\"((?:\\\\.|[^\"])*)\""), (CharSequence)inner, (int)0, (int)2, null);
            boolean $i$f$associate = false;
            Sequence sequence = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                MatchResult it = (MatchResult)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to(it.getGroupValues().get(1), (Object)Companion.unescapeTomlString((String)it.getGroupValues().get(2)));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map map3 = destination$iv$iv;
            Map map4 = map3;
            if (map4.isEmpty()) {
                boolean bl = false;
                map = null;
            } else {
                map = map4;
            }
            return map;
        }

        private final String unescapeTomlString(String value) {
            StringBuilder result = new StringBuilder();
            int index = 0;
            while (index < value.length()) {
                char ch = value.charAt(index);
                if (ch == '\\' && index + 1 < value.length()) {
                    char next = value.charAt(index + 1);
                    switch (next) {
                        case '\\': {
                            StringBuilder stringBuilder = result.append('\\');
                            break;
                        }
                        case '\"': {
                            StringBuilder stringBuilder = result.append('\"');
                            break;
                        }
                        case 'n': {
                            StringBuilder stringBuilder = result.append('\n');
                            break;
                        }
                        case 'r': {
                            StringBuilder stringBuilder = result.append('\r');
                            break;
                        }
                        case 't': {
                            StringBuilder stringBuilder = result.append('\t');
                            break;
                        }
                        case 'b': {
                            StringBuilder stringBuilder = result.append('\b');
                            break;
                        }
                        default: {
                            StringBuilder stringBuilder = result.append(next);
                        }
                    }
                    index += 2;
                    continue;
                }
                result.append(ch);
                ++index;
            }
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String escapeTomlString(String value) {
            StringBuilder result = new StringBuilder();
            CharSequence $this$forEach$iv = value;
            boolean $i$f$forEach = false;
            for (int i = 0; i < $this$forEach$iv.length(); ++i) {
                char element$iv;
                char ch = element$iv = $this$forEach$iv.charAt(i);
                boolean bl = false;
                switch (ch) {
                    case '\\': {
                        StringBuilder stringBuilder = result.append("\\\\");
                        break;
                    }
                    case '\"': {
                        StringBuilder stringBuilder = result.append("\\\"");
                        break;
                    }
                    case '\n': {
                        StringBuilder stringBuilder = result.append("\\n");
                        break;
                    }
                    case '\r': {
                        StringBuilder stringBuilder = result.append("\\r");
                        break;
                    }
                    case '\t': {
                        StringBuilder stringBuilder = result.append("\\t");
                        break;
                    }
                    case '\b': {
                        StringBuilder stringBuilder = result.append("\\b");
                        break;
                    }
                    default: {
                        StringBuilder stringBuilder = result.append(ch);
                    }
                }
            }
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String removeCodexSection(String existing, String serverKey) {
            Regex sectionRegex = this.codexSectionRegex(serverKey);
            return sectionRegex.replace((CharSequence)existing, "");
        }

        private final String updateCodexConfig(String existing, String serverKey, String url) {
            boolean endsWithDoubleNewline;
            Regex sectionRegex = this.codexSectionRegex(serverKey);
            String newSection = this.buildCodexSection(serverKey, url);
            if (sectionRegex.containsMatchIn((CharSequence)existing)) {
                return sectionRegex.replace((CharSequence)existing, newSection);
            }
            if (StringsKt.isBlank((CharSequence)existing)) {
                return newSection;
            }
            StringBuilder builder = new StringBuilder(existing);
            boolean endsWithSingleNewline = StringsKt.endsWith$default((String)existing, (String)"\n", (boolean)false, (int)2, null);
            boolean bl = endsWithDoubleNewline = StringsKt.endsWith$default((String)existing, (String)"\n\n", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)existing, (String)"\r\n\r\n", (boolean)false, (int)2, null);
            if (!endsWithSingleNewline) {
                builder.append('\n');
            }
            if (!endsWithDoubleNewline) {
                builder.append('\n');
            }
            builder.append(newSection);
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final Regex codexSectionRegex(String serverKey) {
            String escapedHeader = Regex.Companion.escape("mcp_servers." + serverKey);
            return new Regex("(?mis)^\\s*\\[" + escapedHeader + "]\\s*(.*?)(?=^\\s*\\[|\\z)");
        }

        private final String buildCodexSection(String serverKey, String url) {
            return "[mcp_servers." + serverKey + "]\nurl = \"" + this.escapeTomlString(url) + "\"\n\n";
        }

        private static final String extractTomlStringArray$lambda$0(MatchResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.unescapeTomlString((String)it.getGroupValues().get(1));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

