/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.initScript.listener;

import com.intellij.gradle.toolingExtension.impl.initScript.listener.RunAppTaskActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.JavaExec;

public class ManifestTaskActionListener
extends RunAppTaskActionListener {
    public ManifestTaskActionListener(String taskName) {
        super(taskName);
    }

    @Override
    public File patchTaskClasspath(JavaExec task) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        String classpathFiles = task.getClasspath().getFiles().stream().map(it -> {
            try {
                return it.toURI().toURL().toString();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.joining(" "));
        attributes.putValue("Class-Path", classpathFiles);
        File file = File.createTempFile("generated-", "-manifest");
        try (FileOutputStream fos = new FileOutputStream(file);
             JarOutputStream jos = new JarOutputStream((OutputStream)fos, manifest);){
            jos.putNextEntry(new ZipEntry("META-INF/"));
        }
        task.setClasspath((FileCollection)task.getProject().files(new Object[]{file.getAbsolutePath()}));
        return file;
    }
}

