/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.modelAction;

import com.intellij.gradle.toolingExtension.impl.modelAction.GradleModelHolderState;
import com.intellij.gradle.toolingExtension.impl.modelAction.GradleModelId;
import com.intellij.gradle.toolingExtension.impl.modelSerialization.ToolingSerializerConverter;
import com.intellij.gradle.toolingExtension.impl.util.GradleExecutorServiceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.DefaultBuildController;
import org.jetbrains.plugins.gradle.model.DefaultGradleLightBuild;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;

@ApiStatus.Internal
public class GradleDaemonModelHolder {
    @NotNull
    private final ToolingSerializerConverter mySerializer;
    @NotNull
    private final GradleBuild myRootGradleBuild;
    @NotNull
    private final Collection<? extends GradleBuild> myNestedGradleBuilds;
    @NotNull
    private final GradleVersion myGradleVersion;
    @NotNull
    private final BlockingQueue<Future<List<DefaultGradleLightBuild>>> myConvertedBuilds;
    @NotNull
    private final BlockingQueue<Future<ConvertedModel>> myConvertedModelQueue;

    public GradleDaemonModelHolder(@NotNull ExecutorService converterExecutor, @NotNull ToolingSerializerConverter serializer, @NotNull GradleBuild rootGradleBuild, @NotNull Collection<? extends GradleBuild> nestedGradleBuilds, @NotNull GradleVersion gradleVersion) {
        if (converterExecutor == null) {
            GradleDaemonModelHolder.$$$reportNull$$$0(0);
        }
        if (serializer == null) {
            GradleDaemonModelHolder.$$$reportNull$$$0(1);
        }
        if (rootGradleBuild == null) {
            GradleDaemonModelHolder.$$$reportNull$$$0(2);
        }
        if (nestedGradleBuilds == null) {
            GradleDaemonModelHolder.$$$reportNull$$$0(3);
        }
        if (gradleVersion == null) {
            GradleDaemonModelHolder.$$$reportNull$$$0(4);
        }
        this.myConvertedBuilds = new LinkedBlockingQueue<Future<List<DefaultGradleLightBuild>>>();
        this.myConvertedModelQueue = new LinkedBlockingQueue<Future<ConvertedModel>>();
        this.mySerializer = serializer;
        this.myRootGradleBuild = rootGradleBuild;
        this.myNestedGradleBuilds = nestedGradleBuilds;
        this.myGradleVersion = gradleVersion;
        GradleExecutorServiceUtil.submitTask(converterExecutor, this.myConvertedBuilds, () -> {
            ArrayList<Object> gradleBuilds = new ArrayList<Object>();
            gradleBuilds.add(this.myRootGradleBuild);
            gradleBuilds.addAll(this.myNestedGradleBuilds);
            return DefaultGradleLightBuild.convertGradleBuilds(gradleBuilds, this.myGradleVersion);
        });
    }

    @NotNull
    public Collection<? extends GradleBuild> getGradleBuilds() {
        ArrayList<Object> gradleBuilds = new ArrayList<Object>();
        gradleBuilds.add(this.myRootGradleBuild);
        gradleBuilds.addAll(this.myNestedGradleBuilds);
        ArrayList<Object> arrayList = gradleBuilds;
        if (arrayList == null) {
            GradleDaemonModelHolder.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public BuildController createBuildController(@NotNull BuildController parentController) {
        if (parentController == null) {
            GradleDaemonModelHolder.$$$reportNull$$$0(6);
        }
        return new DefaultBuildController(parentController, this.myRootGradleBuild, this.myGradleVersion);
    }

    @NotNull
    public ProjectImportModelProvider.GradleModelConsumer createModelConsumer(final @NotNull ExecutorService converterExecutor) {
        if (converterExecutor == null) {
            GradleDaemonModelHolder.$$$reportNull$$$0(7);
        }
        return new ProjectImportModelProvider.GradleModelConsumer(){

            public void consumeBuildModel(@NotNull BuildModel buildModel, @NotNull Object object, @NotNull Class<?> clazz) {
                if (buildModel == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (object == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (clazz == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.consumeModel(object, GradleModelId.createBuildModelId(buildModel, clazz));
            }

            public void consumeProjectModel(@NotNull BasicGradleProject projectModel, @NotNull Object object, @NotNull Class<?> clazz) {
                if (projectModel == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (object == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (clazz == null) {
                    1.$$$reportNull$$$0(5);
                }
                this.consumeModel(object, GradleModelId.createProjectModelId((ProjectModel)projectModel, clazz));
            }

            private void consumeModel(@NotNull Object model, @NotNull GradleModelId modelId) {
                if (model == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (modelId == null) {
                    1.$$$reportNull$$$0(7);
                }
                GradleExecutorServiceUtil.submitTask(converterExecutor, GradleDaemonModelHolder.this.myConvertedModelQueue, () -> {
                    Object convertedModel = GradleDaemonModelHolder.this.mySerializer.convert(model);
                    return new ConvertedModel(modelId, convertedModel);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "buildModel";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "clazz";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectModel";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "model";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modelId";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/modelAction/GradleDaemonModelHolder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "consumeBuildModel";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "consumeProjectModel";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "consumeModel";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public GradleModelHolderState pollPendingState() {
        List<DefaultGradleLightBuild> builds = this.pollPendingConvertedNestedBuilds();
        DefaultGradleLightBuild rootBuild = builds.isEmpty() ? null : builds.get(0);
        List nestedBuilds = builds.size() > 1 ? builds.subList(1, builds.size()) : Collections.emptyList();
        Map<GradleModelId, Object> models = this.pollAllPendingConvertedModels();
        return new GradleModelHolderState(rootBuild, new ArrayList<DefaultGradleLightBuild>(nestedBuilds), models);
    }

    @NotNull
    private List<DefaultGradleLightBuild> pollPendingConvertedNestedBuilds() {
        List builds = (List)GradleExecutorServiceUtil.firstOrNull(this.myConvertedBuilds);
        List list = builds == null ? Collections.emptyList() : builds;
        if (list == null) {
            GradleDaemonModelHolder.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private Map<GradleModelId, Object> pollAllPendingConvertedModels() {
        List<ConvertedModel> models = GradleExecutorServiceUtil.pollAllPendingResults(this.myConvertedModelQueue);
        LinkedHashMap<GradleModelId, Object> modelMap = new LinkedHashMap<GradleModelId, Object>();
        for (ConvertedModel convertedModel : models) {
            modelMap.put(convertedModel.myId, convertedModel.myModel);
        }
        LinkedHashMap<GradleModelId, Object> linkedHashMap = modelMap;
        if (linkedHashMap == null) {
            GradleDaemonModelHolder.$$$reportNull$$$0(9);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converterExecutor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGradleBuild";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedGradleBuilds";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/modelAction/GradleDaemonModelHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/modelAction/GradleDaemonModelHolder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleBuilds";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "pollPendingConvertedNestedBuilds";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "pollAllPendingConvertedModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createBuildController";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createModelConsumer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConvertedModel {
        @NotNull
        private final GradleModelId myId;
        @NotNull
        private final Object myModel;

        private ConvertedModel(@NotNull GradleModelId id, @NotNull Object model) {
            if (id == null) {
                ConvertedModel.$$$reportNull$$$0(0);
            }
            if (model == null) {
                ConvertedModel.$$$reportNull$$$0(1);
            }
            this.myId = id;
            this.myModel = model;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
            }
            objectArray[1] = "com/intellij/gradle/toolingExtension/impl/modelAction/GradleDaemonModelHolder$ConvertedModel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

