/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.spellcheck;

import ai.grazie.nlp.langs.LanguageISO;
import ai.grazie.spell.suggestion.ranker.AsciiRanker;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.spellcheck.GrazieTextLevelSpellCheckingExtension;
import com.intellij.grazie.spellcheck.SpellCheckingResult;
import com.intellij.grazie.spellcheck.TypoProblem;
import com.intellij.grazie.spellcheck.engine.GrazieSpellCheckerEngine;
import com.intellij.grazie.text.CheckerRunner;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.SpellCheckerSeveritiesProvider;
import com.intellij.spellchecker.inspections.SpellCheckingInspection;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.SuppressibleSpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.util.Consumer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringSearcher;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GrazieSpellCheckingInspection
extends SpellCheckingInspection {
    public boolean processCode = true;
    public boolean processLiterals = true;
    public boolean processComments = true;

    public SuppressQuickFix @NotNull [] getBatchSuppressActions(@Nullable PsiElement element) {
        SpellcheckingStrategy strategy;
        if (element != null && (strategy = SpellcheckingStrategy.getSpellcheckingStrategy((PsiElement)element)) instanceof SuppressibleSpellcheckingStrategy) {
            SuppressQuickFix[] suppressQuickFixArray = ((SuppressibleSpellcheckingStrategy)strategy).getSuppressActions(element, this.getShortName());
            if (suppressQuickFixArray == null) {
                GrazieSpellCheckingInspection.$$$reportNull$$$0(0);
            }
            return suppressQuickFixArray;
        }
        SuppressQuickFix[] suppressQuickFixArray = super.getBatchSuppressActions(element);
        if (suppressQuickFixArray == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(1);
        }
        return suppressQuickFixArray;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        SpellcheckingStrategy strategy;
        if (element == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(2);
        }
        if ((strategy = SpellcheckingStrategy.getSpellcheckingStrategy((PsiElement)element)) instanceof SuppressibleSpellcheckingStrategy) {
            return ((SuppressibleSpellcheckingStrategy)strategy).isSuppressedFor(element, this.getShortName());
        }
        return super.isSuppressedFor(element);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "SpellCheckingInspection";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(3);
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(4);
        }
        return psiElementVisitor;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = Objects.requireNonNull(HighlightDisplayLevel.find((HighlightSeverity)SpellCheckerSeveritiesProvider.TYPO));
        if (highlightDisplayLevel == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(5);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, final @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(6);
        }
        if (session == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(7);
        }
        if (!Registry.is((String)"spellchecker.inspection.enabled", (boolean)true) || InspectionProfileManager.hasTooLowSeverity((LocalInspectionToolSession)session, (LocalInspectionTool)this) || InjectedLanguageManager.getInstance((Project)holder.getProject()).isFrankensteinInjection((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                GrazieSpellCheckingInspection.$$$reportNull$$$0(8);
            }
            return psiElementVisitor;
        }
        final Set<SpellCheckingInspection.SpellCheckingScope> scopes = this.buildAllowedScopes();
        final SpellCheckerManager manager = SpellCheckerManager.getInstance((Project)holder.getProject());
        return new PsiElementVisitor(this){

            public void visitWhiteSpace(@NotNull PsiWhiteSpace space) {
                if (space == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (holder.getResultCount() > 1000 || element.getNode() == null) {
                    return;
                }
                SpellcheckingStrategy strategy = SpellcheckingStrategy.getSpellcheckingStrategy((PsiElement)element);
                if (strategy == null || !strategy.elementFitsScope(element, scopes) || GrazieSpellCheckingInspection.isCopyrightComment(strategy, element)) {
                    return;
                }
                SpellCheckingResult result = GrazieTextLevelSpellCheckingExtension.INSTANCE.spellcheck(element, strategy, session, typo -> {
                    if (GrazieSpellCheckingInspection.hasSameNamedReferenceInFile(typo.getWord(), element, strategy)) {
                        return;
                    }
                    GrazieSpellCheckingInspection.registerProblem(typo, holder);
                });
                if (result == SpellCheckingResult.Checked) {
                    return;
                }
                SpellCheckingInspection.tokenize((SpellcheckingStrategy)strategy, (PsiElement)element, (TokenConsumer)new MyTokenConsumer(manager, strategy, holder, LanguageNamesValidation.INSTANCE.forLanguage(element.getLanguage())), (Set)scopes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "space";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/grazie/spellcheck/GrazieSpellCheckingInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitWhiteSpace";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private Set<SpellCheckingInspection.SpellCheckingScope> buildAllowedScopes() {
        HashSet<SpellCheckingInspection.SpellCheckingScope> result = new HashSet<SpellCheckingInspection.SpellCheckingScope>();
        if (this.processLiterals) {
            result.add(SpellCheckingInspection.SpellCheckingScope.Literals);
        }
        if (this.processComments) {
            result.add(SpellCheckingInspection.SpellCheckingScope.Comments);
        }
        if (this.processCode) {
            result.add(SpellCheckingInspection.SpellCheckingScope.Code);
        }
        return result;
    }

    private static void addBatchDescriptor(@NotNull PsiElement element, @NotNull TextRange textRange, @NotNull String word, @NotNull ProblemsHolder holder) {
        if (element == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(9);
        }
        if (textRange == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(10);
        }
        if (word == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(11);
        }
        if (holder == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(12);
        }
        LocalQuickFix[] fixes = SpellcheckingStrategy.getDefaultBatchFixes((PsiElement)element, (TextRange)textRange, (String)word);
        ProblemDescriptor problemDescriptor = GrazieSpellCheckingInspection.createProblemDescriptor(element, textRange, fixes, false);
        holder.registerProblem(problemDescriptor);
    }

    private static void registerProblem(@NotNull TypoProblem typo, @NotNull ProblemsHolder holder) {
        if (typo == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(13);
        }
        if (holder == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(14);
        }
        PsiElement element = typo.getText().getCommonParent();
        SpellcheckingStrategy strategy = SpellcheckingStrategy.getSpellcheckingStrategy((PsiElement)element);
        CheckerRunner.fileHighlightRanges(typo).stream().reduce(TextRange::union).map(range -> range.shiftLeft(element.getTextRange().getStartOffset())).ifPresent(typoRange -> {
            if (!holder.isOnTheFly()) {
                GrazieSpellCheckingInspection.addBatchDescriptor(element, typoRange, typo.getWord(), holder);
                return;
            }
            Set<String> suggestions = typo.isCloud() ? typo.getFixes() : null;
            LocalQuickFix[] fixes = strategy != null ? strategy.getRegularFixes(element, typoRange, false, typo.getWord(), suggestions) : SpellcheckingStrategy.getDefaultRegularFixes((boolean)false, (String)typo.getWord(), (PsiElement)element, (TextRange)typoRange, suggestions);
            ProblemDescriptor problemDescriptor = GrazieSpellCheckingInspection.createProblemDescriptor(element, typoRange, fixes, true);
            holder.registerProblem(problemDescriptor);
        });
    }

    private static void addRegularDescriptor(@NotNull PsiElement element, @NotNull TextRange textRange, @NotNull ProblemsHolder holder, boolean useRename, String wordWithTypo) {
        SpellcheckingStrategy strategy;
        if (element == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(15);
        }
        if (textRange == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(16);
        }
        if (holder == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(17);
        }
        LocalQuickFix[] fixes = (strategy = SpellcheckingStrategy.getSpellcheckingStrategy((PsiElement)element)) != null ? strategy.getRegularFixes(element, textRange, useRename, wordWithTypo, null) : SpellcheckingStrategy.getDefaultRegularFixes((boolean)useRename, (String)wordWithTypo, (PsiElement)element, (TextRange)textRange, null);
        ProblemDescriptor problemDescriptor = GrazieSpellCheckingInspection.createProblemDescriptor(element, textRange, fixes, true);
        holder.registerProblem(problemDescriptor);
    }

    private static ProblemDescriptor createProblemDescriptor(PsiElement element, TextRange textRange, LocalQuickFix[] fixes, boolean onTheFly) {
        String description = SpellCheckerBundle.message((String)"typo.in.word.ref", (Object[])new Object[0]);
        return new ProblemDescriptorBase(element, element, description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, textRange, onTheFly, onTheFly);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"processCode", (String)SpellCheckerBundle.message((String)"process.code", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"processLiterals", (String)SpellCheckerBundle.message((String)"process.literals", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"processComments", (String)SpellCheckerBundle.message((String)"process.comments", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(18);
        }
        return optPane;
    }

    private static boolean hasSameNamedReferenceInFile(String word, PsiElement element, SpellcheckingStrategy strategy) {
        if (!strategy.elementFitsScope(element, Set.of(SpellCheckingInspection.SpellCheckingScope.Comments))) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        Map references = (Map)CachedValuesManager.getProjectPsiDependentCache((PsiElement)file, psi -> new ConcurrentHashMap());
        return references.computeIfAbsent(word, key -> GrazieSpellCheckingInspection.hasSameNamedReferencesInFile(key, file));
    }

    private static boolean hasSameNamedReferencesInFile(String word, PsiFile file) {
        int[] occurrences = new StringSearcher(word, true, true).findAllOccurrences((CharSequence)file.getText());
        if (occurrences.length <= 1) {
            return false;
        }
        if (DumbService.isDumb((Project)file.getProject())) {
            for (int occurrence : occurrences) {
                SpellcheckingStrategy strategy;
                PsiElement element = file.findElementAt(occurrence);
                if (element == null || (strategy = SpellcheckingStrategy.getSpellcheckingStrategy((PsiElement)element)) == null || strategy.elementFitsScope(element, Set.of(SpellCheckingInspection.SpellCheckingScope.Comments))) continue;
                return true;
            }
            return false;
        }
        for (int occurrence : occurrences) {
            PsiElement resolvedReference;
            PsiReference reference = file.findReferenceAt(occurrence);
            PsiElement psiElement = resolvedReference = reference != null ? reference.resolve() : null;
            if (reference == null || resolvedReference == null || reference.getElement() == resolvedReference) continue;
            return true;
        }
        return false;
    }

    private static boolean isCopyrightComment(SpellcheckingStrategy strategy, PsiElement psi) {
        return strategy.elementFitsScope(psi, Set.of(SpellCheckingInspection.SpellCheckingScope.Comments)) && StringUtil.containsIgnoreCase((String)psi.getText(), (String)"Copyright") && GrazieSpellCheckingInspection.isAtFileStart(psi);
    }

    private static boolean isAtFileStart(PsiElement psi) {
        PsiFile file = psi.getContainingFile();
        int textStart = psi.getTextRange().getStartOffset();
        return file.getViewProvider().getContents().subSequence(0, textStart).chars().noneMatch(Character::isLetterOrDigit);
    }

    private static void registerProblem(@NotNull ProblemsHolder holder, @NotNull PsiElement element, @NotNull TextRange range, boolean useRename, String word) {
        if (holder == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(19);
        }
        if (element == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(20);
        }
        if (range == null) {
            GrazieSpellCheckingInspection.$$$reportNull$$$0(21);
        }
        if (holder.isOnTheFly()) {
            GrazieSpellCheckingInspection.addRegularDescriptor(element, range, holder, useRename, word);
        } else {
            GrazieSpellCheckingInspection.addBatchDescriptor(element, range, word, holder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/spellcheck/GrazieSpellCheckingInspection";
                break;
            }
            case 2: 
            case 9: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typo";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/spellcheck/GrazieSpellCheckingInspection";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addBatchDescriptor";
                break;
            }
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addRegularDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 6, 7, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyTokenConsumer
    extends TokenConsumer
    implements Consumer<TextRange> {
        private static final Pattern NON_ENGLISH_LETTERS = Pattern.compile(".*[^a-zA-Z].*");
        private final Set<String> myAlreadyChecked = CollectionFactory.createSmallMemoryFootprintSet();
        private final SpellCheckerManager myManager;
        private final ProblemsHolder myHolder;
        private final NamesValidator myNamesValidator;
        private final SpellcheckingStrategy myStrategy;
        private boolean myCodeLike;
        private PsiElement myElement;
        private String myText;
        private boolean myUseRename;
        private int myOffset;

        MyTokenConsumer(SpellCheckerManager manager, SpellcheckingStrategy strategy, ProblemsHolder holder, NamesValidator namesValidator) {
            this.myManager = manager;
            this.myStrategy = strategy;
            this.myHolder = holder;
            this.myNamesValidator = namesValidator;
        }

        public void consumeToken(PsiElement element, String text, boolean useRename, int offset, TextRange rangeToCheck, Splitter splitter) {
            this.myElement = element;
            this.myText = text;
            this.myUseRename = useRename;
            this.myOffset = offset;
            this.myCodeLike = this.myStrategy.elementFitsScope(this.myElement, Set.of(SpellCheckingInspection.SpellCheckingScope.Code));
            splitter.split(text, rangeToCheck, (Consumer)this);
        }

        public void consume(TextRange range) {
            ProgressManager.checkCanceled();
            String word = range.substring(this.myText);
            if (!this.myHolder.isOnTheFly() && this.myAlreadyChecked.contains(word)) {
                return;
            }
            boolean keyword = this.myNamesValidator.isKeyword(word, this.myElement.getProject());
            if (keyword || !this.hasProblem(word, range) || GrazieSpellCheckingInspection.hasSameNamedReferenceInFile(word, this.myElement, this.myStrategy)) {
                return;
            }
            range = this.myStrategy.getTokenizer(this.myElement).getHighlightingRange(this.myElement, this.myOffset, range);
            assert (range.getStartOffset() >= 0);
            if (!this.myHolder.isOnTheFly()) {
                this.myAlreadyChecked.add(word);
            }
            GrazieSpellCheckingInspection.registerProblem(this.myHolder, this.myElement, range, this.myUseRename, word);
        }

        private boolean hasCamelCaseMatch(String word, TextRange range) {
            Set camelCaseWords = this.myManager.getUserCamelCaseWords().stream().filter(camelCaseWord -> camelCaseWord.contains(word)).collect(Collectors.toSet());
            if (camelCaseWords.isEmpty()) {
                return false;
            }
            String text = this.myElement.getText();
            for (String camelCaseWord2 : camelCaseWords) {
                int[] indexes;
                ProgressManager.checkCanceled();
                for (int index : indexes = new StringSearcher(camelCaseWord2, false, true).findAllOccurrences((CharSequence)text)) {
                    TextRange hitRange = new TextRange(index, index + camelCaseWord2.length());
                    if (!range.intersectsStrict(hitRange)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean hasProblem(String word, TextRange range) {
            if (!this.myManager.hasProblem(word)) {
                return false;
            }
            if (this.hasCamelCaseMatch(word, range)) {
                return false;
            }
            if (MyTokenConsumer.isOnlyEnglishDictionaryEnabled(this.myElement.getProject())) {
                return true;
            }
            if (!this.myCodeLike || NON_ENGLISH_LETTERS.matcher(word).matches()) {
                return true;
            }
            Project project = this.myElement.getProject();
            return SpellCheckerManager.getInstance((Project)project).getSuggestions(word).stream().filter(suggestion -> RenameUtil.isValidName((Project)project, (PsiElement)this.myElement, (String)suggestion)).noneMatch(suggestion -> AsciiRanker.equalsIgnoringDiacritics((String)word, (String)suggestion));
        }

        private static boolean isOnlyEnglishDictionaryEnabled(Project project) {
            Set languages2 = GrazieConfig.Companion.get().getEnabledLanguages().stream().map(it -> it.getIso()).collect(Collectors.toSet());
            if (languages2.size() != 1 || !languages2.contains(LanguageISO.EN)) {
                return false;
            }
            List paths = SpellCheckerSettings.getInstance((Project)project).getCustomDictionariesPaths();
            if (paths != null && !paths.isEmpty()) {
                GrazieSpellCheckerEngine engine = GrazieSpellCheckerEngine.getInstance(project);
                return !ContainerUtil.exists((Iterable)paths, dictionaryName -> engine.isDictionaryLoad((String)dictionaryName));
            }
            return true;
        }
    }
}

