/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.concurrency.ChildContext;
import com.intellij.util.concurrency.ContextCallable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/util/concurrency/CancellationFutureTask;", "V", "Ljava/util/concurrent/FutureTask;", "job", "Lkotlinx/coroutines/Job;", "callable", "Lcom/intellij/util/concurrency/ContextCallable;", "executionTracker", "Ljava/util/concurrent/atomic/AtomicBoolean;", "context", "Lcom/intellij/util/concurrency/ChildContext;", "<init>", "(Lkotlinx/coroutines/Job;Lcom/intellij/util/concurrency/ContextCallable;Ljava/util/concurrent/atomic/AtomicBoolean;Lcom/intellij/util/concurrency/ChildContext;)V", "getExecutionTracker", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "getContext", "()Lcom/intellij/util/concurrency/ChildContext;", "cancel", "", "mayInterruptIfRunning", "intellij.platform.util"})
public final class CancellationFutureTask<V>
extends FutureTask<V> {
    @NotNull
    private final Job job;
    @NotNull
    private final AtomicBoolean executionTracker;
    @NotNull
    private final ChildContext context;

    public CancellationFutureTask(@NotNull Job job2, @NotNull ContextCallable<V> callable, @NotNull AtomicBoolean executionTracker, @NotNull ChildContext context) {
        Intrinsics.checkNotNullParameter(job2, "job");
        Intrinsics.checkNotNullParameter(callable, "callable");
        Intrinsics.checkNotNullParameter(executionTracker, "executionTracker");
        Intrinsics.checkNotNullParameter(context, "context");
        super(callable);
        this.job = job2;
        this.executionTracker = executionTracker;
        this.context = context;
        this.job.invokeOnCompletion(true, true, arg_0 -> CancellationFutureTask._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final AtomicBoolean getExecutionTracker() {
        return this.executionTracker;
    }

    @NotNull
    public final ChildContext getContext() {
        return this.context;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean isCurrentlyRunning = this.executionTracker.getAndSet(true);
        boolean result = super.cancel(mayInterruptIfRunning);
        this.job.cancel(null);
        if (!isCurrentlyRunning) {
            this.context.cancelAllIntelliJElements();
        }
        return result;
    }

    private static final Unit _init_$lambda$0(CancellationFutureTask this$0, Throwable it) {
        if (it instanceof CancellationException) {
            this$0.cancel(false);
        }
        return Unit.INSTANCE;
    }
}

