/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution.cmd;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleDocumentationBundle;

public final class GradleCommandLineOptionsProvider {
    public static final Options OPTIONS;
    public static final OptionGroup DEBUGGING_OPTIONS;
    public static final OptionGroup PERFORMANCE_OPTIONS;
    public static final OptionGroup LOGGING_OPTIONS;
    public static final OptionGroup EXECUTION_OPTIONS;
    public static final OptionGroup ENVIRONMENT_OPTIONS;
    public static final OptionGroup EXECUTING_TASKS_OPTIONS;
    public static final OptionGroup VERIFICATION_OPTIONS;
    public static final Options UNSUPPORTED_OPTIONS;
    public static final Options TASK_OPTIONS;
    public static final OptionGroup TEST_TASK_OPTIONS;
    public static final OptionGroup BUILT_IN_TASK_OPTIONS;
    public static final OptionGroup COMPOSE_HOT_RELOAD_RUN_TASK_OPTIONS;

    public static Options getSupportedOptions() {
        return OPTIONS;
    }

    public static List<String> getShortOptionsNames(@NotNull Collection<Option> options) {
        if (options == null) {
            GradleCommandLineOptionsProvider.$$$reportNull$$$0(0);
        }
        return options.stream().map(it -> it.getOpt()).filter(it -> it != null).map(it -> "-" + it).collect(Collectors.toList());
    }

    public static List<String> getLongOptionsNames(@NotNull Collection<Option> options) {
        if (options == null) {
            GradleCommandLineOptionsProvider.$$$reportNull$$$0(1);
        }
        return options.stream().map(it -> it.getLongOpt()).filter(it -> it != null).map(it -> "--" + it).collect(Collectors.toList());
    }

    public static List<String> getAllOptionsNames(@NotNull Collection<Option> options) {
        if (options == null) {
            GradleCommandLineOptionsProvider.$$$reportNull$$$0(2);
        }
        return ContainerUtil.concat(GradleCommandLineOptionsProvider.getShortOptionsNames(options), GradleCommandLineOptionsProvider.getLongOptionsNames(options));
    }

    static {
        UNSUPPORTED_OPTIONS = new Options().addOption(Option.builder((String)"h").longOpt("help").desc(GradleDocumentationBundle.message("gradle.cmd.option.help", new Object[0])).build()).addOption(Option.builder((String)"v").longOpt("version").desc(GradleDocumentationBundle.message("gradle.cmd.option.version", new Object[0])).build()).addOption(Option.builder().longOpt("daemon").desc(GradleDocumentationBundle.message("gradle.cmd.option.daemon", new Object[0])).build()).addOption(Option.builder().longOpt("no-daemon").desc(GradleDocumentationBundle.message("gradle.cmd.option.no.daemon", new Object[0])).build()).addOption(Option.builder().longOpt("status").desc(GradleDocumentationBundle.message("gradle.cmd.option.status", new Object[0])).build()).addOption(Option.builder().longOpt("stop").desc(GradleDocumentationBundle.message("gradle.cmd.option.stop", new Object[0])).build()).addOption(Option.builder().longOpt("foreground").desc(GradleDocumentationBundle.message("gradle.cmd.option.stop", new Object[0])).build()).addOption(Option.builder((String)"b").longOpt("build-file").desc(GradleDocumentationBundle.message("gradle.cmd.option.build.file", new Object[0])).hasArg().build()).addOption(Option.builder((String)"c").longOpt("settings-file").desc(GradleDocumentationBundle.message("gradle.cmd.option.settings.file", new Object[0])).hasArg().build());
        DEBUGGING_OPTIONS = new OptionGroup().addOption(Option.builder((String)"S").longOpt("full-stacktrace").desc(GradleDocumentationBundle.message("gradle.cmd.option.full.stacktrace", new Object[0])).build()).addOption(Option.builder((String)"s").longOpt("stacktrace").desc(GradleDocumentationBundle.message("gradle.cmd.option.stacktrace", new Object[0])).build()).addOption(Option.builder().longOpt("scan").desc(GradleDocumentationBundle.message("gradle.cmd.option.scan", new Object[0])).build()).addOption(Option.builder().longOpt("no-scan").desc(GradleDocumentationBundle.message("gradle.cmd.option.no.scan", new Object[0])).build());
        PERFORMANCE_OPTIONS = new OptionGroup().addOption(Option.builder().longOpt("build-cache").desc(GradleDocumentationBundle.message("gradle.cmd.option.build.cache", new Object[0])).build()).addOption(Option.builder().longOpt("no-build-cache").desc(GradleDocumentationBundle.message("gradle.cmd.option.no.build.cache", new Object[0])).build()).addOption(Option.builder().longOpt("configuration-cache").desc(GradleDocumentationBundle.message("gradle.cmd.option.configuration.cache", new Object[0])).build()).addOption(Option.builder().longOpt("no-configuration-cache").desc(GradleDocumentationBundle.message("gradle.cmd.option.no.configuration.cache", new Object[0])).build()).addOption(Option.builder().longOpt("configuration-cache-problems").desc(GradleDocumentationBundle.message("gradle.cmd.option.configuration.cache.problems", new Object[0])).hasArg().build()).addOption(Option.builder().longOpt("configure-on-demand").desc(GradleDocumentationBundle.message("gradle.cmd.option.configure.on.demand", new Object[0])).build()).addOption(Option.builder().longOpt("no-configure-on-demand").desc(GradleDocumentationBundle.message("gradle.cmd.option.no.configure.on.demand", new Object[0])).build()).addOption(Option.builder().longOpt("max-workers").desc(GradleDocumentationBundle.message("gradle.cmd.option.max.workers", new Object[0])).hasArg().build()).addOption(Option.builder().longOpt("parallel").desc(GradleDocumentationBundle.message("gradle.cmd.option.parallel", new Object[0])).build()).addOption(Option.builder().longOpt("no-parallel").desc(GradleDocumentationBundle.message("gradle.cmd.option.no.parallel", new Object[0])).build()).addOption(Option.builder().longOpt("priority").desc(GradleDocumentationBundle.message("gradle.cmd.option.priority", new Object[0])).hasArg().build()).addOption(Option.builder().longOpt("profile").desc(GradleDocumentationBundle.message("gradle.cmd.option.profile", new Object[0])).build()).addOption(Option.builder().longOpt("watch-fs").desc(GradleDocumentationBundle.message("gradle.cmd.option.watch.fs", new Object[0])).build()).addOption(Option.builder().longOpt("no-watch-fs").desc(GradleDocumentationBundle.message("gradle.cmd.option.no.watch.fs", new Object[0])).build());
        LOGGING_OPTIONS = new OptionGroup().addOption(Option.builder((String)"q").longOpt("quiet").desc(GradleDocumentationBundle.message("gradle.cmd.option.quiet", new Object[0])).build()).addOption(Option.builder((String)"w").longOpt("warn").desc(GradleDocumentationBundle.message("gradle.cmd.option.warn", new Object[0])).build()).addOption(Option.builder((String)"i").longOpt("info").desc(GradleDocumentationBundle.message("gradle.cmd.option.info", new Object[0])).build()).addOption(Option.builder((String)"d").longOpt("debug").desc(GradleDocumentationBundle.message("gradle.cmd.option.debug", new Object[0])).build()).addOption(Option.builder().longOpt("console").desc(GradleDocumentationBundle.message("gradle.cmd.option.console", new Object[0])).hasArg().build()).addOption(Option.builder().longOpt("warning-mode").desc(GradleDocumentationBundle.message("gradle.cmd.option.warning.mode", new Object[0])).hasArg().build());
        EXECUTION_OPTIONS = new OptionGroup().addOption(Option.builder().longOpt("include-build").desc(GradleDocumentationBundle.message("gradle.cmd.option.include.build", new Object[0])).hasArg().build()).addOption(Option.builder().longOpt("offline").desc(GradleDocumentationBundle.message("gradle.cmd.option.offline", new Object[0])).build()).addOption(Option.builder().longOpt("refresh-dependencies").desc(GradleDocumentationBundle.message("gradle.cmd.option.refresh.dependencies", new Object[0])).build()).addOption(Option.builder((String)"m").longOpt("dry-run").desc(GradleDocumentationBundle.message("gradle.cmd.option.dry.run", new Object[0])).build()).addOption(Option.builder().longOpt("write-locks").desc(GradleDocumentationBundle.message("gradle.cmd.option.write.locks", new Object[0])).build()).addOption(Option.builder().longOpt("update-locks").desc(GradleDocumentationBundle.message("gradle.cmd.option.update.locks", new Object[0])).hasArg().build()).addOption(Option.builder((String)"a").longOpt("no-rebuild").desc(GradleDocumentationBundle.message("gradle.cmd.option.no.rebuild", new Object[0])).build());
        ENVIRONMENT_OPTIONS = new OptionGroup().addOption(Option.builder((String)"g").longOpt("gradle-user-home").desc(GradleDocumentationBundle.message("gradle.cmd.option.gradle.user.home", new Object[0])).hasArg().build()).addOption(Option.builder((String)"p").longOpt("project-dir").desc(GradleDocumentationBundle.message("gradle.cmd.option.project.dir", new Object[0])).hasArg().build()).addOption(Option.builder().longOpt("project-cache-dir").desc(GradleDocumentationBundle.message("gradle.cmd.option.project.cache.dir", new Object[0])).hasArg().build()).addOption(Option.builder((String)"D").longOpt("system-prop").desc(GradleDocumentationBundle.message("gradle.cmd.option.system.prop", new Object[0])).hasArg().build()).addOption(Option.builder((String)"I").longOpt("init-script").desc(GradleDocumentationBundle.message("gradle.cmd.option.init.script", new Object[0])).hasArg().build()).addOption(Option.builder((String)"P").longOpt("project-prop").desc(GradleDocumentationBundle.message("gradle.cmd.option.project.prop", new Object[0])).hasArg().build());
        EXECUTING_TASKS_OPTIONS = new OptionGroup().addOption(Option.builder((String)"x").longOpt("exclude-task").desc(GradleDocumentationBundle.message("gradle.cmd.option.exclude.task", new Object[0])).hasArg().build()).addOption(Option.builder().longOpt("rerun-tasks").desc(GradleDocumentationBundle.message("gradle.cmd.option.rerun.tasks", new Object[0])).build()).addOption(Option.builder().longOpt("continue").desc(GradleDocumentationBundle.message("gradle.cmd.option.continue", new Object[0])).build()).addOption(Option.builder((String)"t").longOpt("continuous").desc(GradleDocumentationBundle.message("gradle.cmd.option.continuous", new Object[0])).build());
        VERIFICATION_OPTIONS = new OptionGroup().addOption(Option.builder().longOpt("export-keys").desc(GradleDocumentationBundle.message("gradle.cmd.option.export.keys", new Object[0])).build()).addOption(Option.builder().longOpt("refresh-keys").desc(GradleDocumentationBundle.message("gradle.cmd.option.export.keys", new Object[0])).build()).addOption(Option.builder((String)"F").longOpt("dependency-verification").desc(GradleDocumentationBundle.message("gradle.cmd.option.dependency.verification", new Object[0])).hasArg().build()).addOption(Option.builder((String)"M").longOpt("write-verification-metadata").desc(GradleDocumentationBundle.message("gradle.cmd.option.write.verification.metadata", new Object[0])).hasArg().build());
        OPTIONS = new Options().addOptionGroup(DEBUGGING_OPTIONS).addOptionGroup(PERFORMANCE_OPTIONS).addOptionGroup(LOGGING_OPTIONS).addOptionGroup(EXECUTION_OPTIONS).addOptionGroup(ENVIRONMENT_OPTIONS).addOptionGroup(EXECUTING_TASKS_OPTIONS).addOptionGroup(VERIFICATION_OPTIONS);
        TEST_TASK_OPTIONS = new OptionGroup().addOption(Option.builder().longOpt("tests").hasArg().build());
        BUILT_IN_TASK_OPTIONS = new OptionGroup().addOption(Option.builder().longOpt("rerun").desc(GradleDocumentationBundle.message("gradle.cmd.option.rerun", new Object[0])).build());
        COMPOSE_HOT_RELOAD_RUN_TASK_OPTIONS = new OptionGroup().addOption(Option.builder().longOpt("mainClass").hasArg().build()).addOption(Option.builder().longOpt("className").hasArg().build()).addOption(Option.builder().longOpt("funName").hasArg().build());
        TASK_OPTIONS = new Options().addOptionGroup(TEST_TASK_OPTIONS).addOptionGroup(BUILT_IN_TASK_OPTIONS).addOptionGroup(COMPOSE_HOT_RELOAD_RUN_TASK_OPTIONS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "options";
        objectArray2[1] = "org/jetbrains/plugins/gradle/service/execution/cmd/GradleCommandLineOptionsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getShortOptionsNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLongOptionsNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllOptionsNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

