/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.util.io.PathPrefixTree;
import com.intellij.util.containers.prefixTree.set.MutablePrefixTreeSet;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\t\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0007J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0007J \u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/gradle/service/project/GradleContentRootIndex;", "", "<init>", "()V", "contentRootWeightMap", "Ljava/util/HashMap;", "Ljava/nio/file/Path;", "", "Lkotlin/collections/HashMap;", "addSourceRoots", "", "sourceSet", "Lorg/jetbrains/plugins/gradle/model/ExternalSourceSet;", "sourceSetNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "sourceRoots", "", "resolveContentRoots", "", "externalProject", "Lorg/jetbrains/plugins/gradle/model/ExternalProject;", "", "resolveContentRoot", "projectRootPath", "buildRootPath", "sourceRootPath", "resolveParentPaths", "", "path", "getSourceRoots", "getContentRoots", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleContentRootIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleContentRootIndex.kt\norg/jetbrains/plugins/gradle/service/project/GradleContentRootIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1661#2,3:120\n1391#2:123\n1480#2,2:124\n1586#2:126\n1661#2,3:127\n1482#2,3:130\n1586#2:133\n1661#2,3:134\n1586#2:137\n1661#2,3:138\n*S KotlinDebug\n*F\n+ 1 GradleContentRootIndex.kt\norg/jetbrains/plugins/gradle/service/project/GradleContentRootIndex\n*L\n57#1:120,3\n100#1:123\n100#1:124,2\n100#1:126\n100#1:127,3\n100#1:130,3\n110#1:133\n110#1:134,3\n117#1:137\n117#1:138,3\n*E\n"})
public final class GradleContentRootIndex {
    @NotNull
    private final HashMap<Path, Integer> contentRootWeightMap = new HashMap();

    public final void addSourceRoots(@NotNull ExternalSourceSet sourceSet) {
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        Collection<Path> sourceRoots = this.getSourceRoots(sourceSet);
        this.addSourceRoots(sourceRoots);
    }

    public final void addSourceRoots(@NotNull DataNode<GradleSourceSetData> sourceSetNode) {
        Intrinsics.checkNotNullParameter(sourceSetNode, (String)"sourceSetNode");
        Collection<Path> sourceRoots = this.getSourceRoots(sourceSetNode);
        Collection<Path> contentRoots = this.getContentRoots(sourceSetNode);
        this.addSourceRoots(CollectionsKt.plus(sourceRoots, (Iterable)contentRoots));
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public final void addSourceRoots(@NotNull Collection<? extends Path> sourceRoots) {
        Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
        HashSet contentRoots = new HashSet();
        for (Path path : sourceRoots) {
            contentRoots.addAll(this.resolveParentPaths(path));
        }
        Iterator iterator = contentRoots.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Path> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Path path;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            Integer n = this.contentRootWeightMap.getOrDefault(path, 0);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
            int contentRootWeight = ((Number)n).intValue();
            ((Map)this.contentRootWeightMap).put(path, contentRootWeight + 1);
        }
    }

    @NotNull
    public final Set<Path> resolveContentRoots(@NotNull ExternalProject externalProject, @NotNull ExternalSourceSet sourceSet) {
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        Collection<Path> sourceRoots = this.getSourceRoots(sourceSet);
        return this.resolveContentRoots(externalProject, sourceRoots);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> resolveContentRoots(@NotNull ExternalProject externalProject, @NotNull DataNode<GradleSourceSetData> sourceSetNode) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        Intrinsics.checkNotNullParameter(sourceSetNode, (String)"sourceSetNode");
        Collection<Path> sourceRoots = this.getSourceRoots(sourceSetNode);
        Collection<Path> contentRoots = this.getContentRoots(sourceSetNode);
        Iterable iterable = this.resolveContentRoots(externalProject, CollectionsKt.plus(sourceRoots, (Iterable)contentRoots));
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Path path = (Path)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(NioPathUtil.toCanonicalPath((Path)it));
        }
        return (Set)destination$iv;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public final Set<Path> resolveContentRoots(@NotNull ExternalProject externalProject, @NotNull Collection<? extends Path> sourceRoots) {
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
        Path projectRootPath = externalProject.getProjectDir().toPath();
        Path buildRootPath = externalProject.getBuildDir().toPath();
        MutablePrefixTreeSet contentRoots = PathPrefixTree.INSTANCE.createSet();
        for (Path path : sourceRoots) {
            Intrinsics.checkNotNull((Object)projectRootPath);
            Intrinsics.checkNotNull((Object)buildRootPath);
            Path contentRootPath = this.resolveContentRoot(projectRootPath, buildRootPath, path);
            contentRoots.add((Object)contentRootPath);
        }
        return contentRoots.getRoots();
    }

    private final Path resolveContentRoot(Path projectRootPath, Path buildRootPath, Path sourceRootPath) {
        if (sourceRootPath.startsWith(buildRootPath)) {
            return sourceRootPath;
        }
        Path contentRootPath = sourceRootPath.getParent();
        if (contentRootPath == null || Intrinsics.areEqual((Object)contentRootPath, (Object)projectRootPath)) {
            return sourceRootPath;
        }
        Integer contentRootWeight = this.contentRootWeightMap.get(contentRootPath);
        if (contentRootWeight == null || contentRootWeight > 1) {
            return sourceRootPath;
        }
        return contentRootPath;
    }

    private final List<Path> resolveParentPaths(Path path) {
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path parentPath = path; parentPath != null; parentPath = parentPath.getParent()) {
            result.add(parentPath);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Path> getSourceRoots(ExternalSourceSet sourceSet) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = sourceSet.getSources().values();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            ExternalSourceDirectorySet it = (ExternalSourceDirectorySet)element$iv$iv;
            boolean bl = false;
            Set set = it.getSrcDirs();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getSrcDirs(...)");
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(p0.toPath());
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Path> getSourceRoots(DataNode<GradleSourceSetData> sourceSetNode) {
        void $this$mapTo$iv$iv;
        HashSet sourceRoots = new HashSet();
        for (DataNode contentRootNode : ExternalSystemApiUtil.findAll(sourceSetNode, (Key)ProjectKeys.CONTENT_ROOT)) {
            for (ExternalSystemSourceType sourceRootType : EntriesMappings.entries$0) {
                sourceRoots.addAll(((ContentRootData)contentRootNode.getData()).getPaths(sourceRootType));
            }
        }
        Iterable $this$map$iv = sourceRoots;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void sourceRoot;
            ContentRootData.SourceRoot sourceRoot2 = (ContentRootData.SourceRoot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Path.of(FileUtil.toSystemDependentName((String)sourceRoot.getPath()), new String[0]));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Path> getContentRoots(DataNode<GradleSourceSetData> sourceSetNode) {
        void $this$mapTo$iv$iv;
        Collection collection = ExternalSystemApiUtil.findAll(sourceSetNode, (Key)ProjectKeys.CONTENT_ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findAll(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataNode dataNode = (DataNode)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(Path.of(FileUtil.toSystemDependentName((String)((ContentRootData)it.getData()).getRootPath()), new String[0]));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<ExternalSystemSourceType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])ExternalSystemSourceType.values()));
        }
    }
}

