/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.annotation.FloatRange;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.SuspendAnimationKt;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.ScrollScope;
import androidx.compose.foundation.gestures.snapping.SnapPosition;
import androidx.compose.foundation.lazy.layout.LazyLayoutScrollScope;
import androidx.compose.foundation.pager.DefaultPagerState;
import androidx.compose.foundation.pager.PagerLayoutInfo;
import androidx.compose.foundation.pager.PagerMeasureResult;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.foundation.pager.PagerStateKt;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.saveable.RememberSaveableKt;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.ui.layout.AlignmentLine;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.unit.ConstraintsKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000k\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0018\u001a/\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u0007\u00a2\u0006\u0002\u0010\b\u001a(\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0003\u0010\u000b\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u0001H\u0080@\u00a2\u0006\u0002\u0010\u000e\u001a\u0012\u0010\u000f\u001a\u00020\r*\u00020\u0001H\u0080@\u00a2\u0006\u0002\u0010\u000e\u001a\u0017\u0010\u001e\u001a\u00020\r2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0007H\u0082\b\u001a\u0014\u0010!\u001a\u00020\"*\u00020#2\u0006\u0010\u0006\u001a\u00020\u0003H\u0000\u001a\u0014\u0010$\u001a\u00020\"*\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001aO\u0010%\u001a\u00020\r*\u00020&2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00052\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050*2\u001d\u0010+\u001a\u0019\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0,\u00a2\u0006\u0002\b.H\u0082@\u00a2\u0006\u0002\u0010/\"\u0016\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\"\u000e\u0010\u0015\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019\"\u0014\u0010\u001a\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00060"}, d2={"rememberPagerState", "Landroidx/compose/foundation/pager/PagerState;", "initialPage", "", "initialPageOffsetFraction", "", "pageCount", "Lkotlin/Function0;", "(IFLkotlin/jvm/functions/Function0;Landroidx/compose/runtime/Composer;II)Landroidx/compose/foundation/pager/PagerState;", "PagerState", "currentPage", "currentPageOffsetFraction", "animateToNextPage", "", "(Landroidx/compose/foundation/pager/PagerState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "animateToPreviousPage", "DefaultPositionThreshold", "Landroidx/compose/ui/unit/Dp;", "getDefaultPositionThreshold", "()F", "F", "MaxPagesForAnimateScroll", "PagesToPrefetch", "UnitDensity", "androidx/compose/foundation/pager/PagerStateKt$UnitDensity$1", "Landroidx/compose/foundation/pager/PagerStateKt$UnitDensity$1;", "EmptyLayoutInfo", "Landroidx/compose/foundation/pager/PagerMeasureResult;", "getEmptyLayoutInfo", "()Landroidx/compose/foundation/pager/PagerMeasureResult;", "debugLog", "generateMsg", "", "calculateNewMaxScrollOffset", "", "Landroidx/compose/foundation/pager/PagerLayoutInfo;", "calculateNewMinScrollOffset", "animateScrollToPage", "Landroidx/compose/foundation/lazy/layout/LazyLayoutScrollScope;", "targetPage", "targetPageOffsetToSnappedPosition", "animationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "updateTargetPage", "Lkotlin/Function2;", "Landroidx/compose/foundation/gestures/ScrollScope;", "Lkotlin/ExtensionFunctionType;", "(Landroidx/compose/foundation/lazy/layout/LazyLayoutScrollScope;IFLandroidx/compose/animation/core/AnimationSpec;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "foundation"})
@SourceDebugExtension(value={"SMAP\nPagerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerState.kt\nandroidx/compose/foundation/pager/PagerStateKt\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 5 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 6 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,1069:1\n972#1,4:1081\n972#1,4:1089\n972#1,4:1093\n972#1,4:1097\n1128#2,6:1070\n1#3:1076\n54#4:1077\n59#4:1079\n54#4:1085\n59#4:1087\n85#5:1078\n90#5:1080\n85#5:1086\n90#5:1088\n122#6:1101\n*S KotlinDebug\n*F\n+ 1 PagerState.kt\nandroidx/compose/foundation/pager/PagerStateKt\n*L\n1003#1:1081,4\n1049#1:1089,4\n1060#1:1093,4\n1065#1:1097,4\n95#1:1070,6\n983#1:1077\n983#1:1079\n1013#1:1085\n1013#1:1087\n983#1:1078\n983#1:1080\n1013#1:1086\n1013#1:1088\n927#1:1101\n*E\n"})
public final class PagerStateKt {
    private static final float DefaultPositionThreshold;
    private static final int MaxPagesForAnimateScroll = 3;
    public static final int PagesToPrefetch = 1;
    @NotNull
    private static final UnitDensity.1 UnitDensity;
    @NotNull
    private static final PagerMeasureResult EmptyLayoutInfo;

    /*
     * WARNING - void declaration
     */
    @Composable
    @NotNull
    public static final PagerState rememberPagerState(int initialPage, @FloatRange(from=-0.5, to=0.5) float initialPageOffsetFraction, @NotNull Function0<Integer> pageCount, @Nullable Composer $composer, int $changed, int n) {
        Object object;
        void $this$cache$iv;
        Intrinsics.checkNotNullParameter(pageCount, (String)"pageCount");
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)-1210768637, (String)"C(rememberPagerState)N(initialPage,initialPageOffsetFraction,pageCount)94@4368L92,94@4318L142:PagerState.kt#g6yjnt");
        if ((n & 1) != 0) {
            initialPage = 0;
        }
        if ((n & 2) != 0) {
            initialPageOffsetFraction = 0.0f;
        }
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-1210768637, (int)$changed, (int)-1, (String)"androidx.compose.foundation.pager.rememberPagerState (PagerState.kt:93)");
        }
        Object[] objectArray = new Object[]{};
        Saver<DefaultPagerState, ?> saver = DefaultPagerState.Companion.getSaver();
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)387484543, (String)"CC(remember):PagerState.kt#9igjgp");
        Composer composer = $composer;
        boolean invalid$iv = (($changed & 0xE ^ 6) > 4 && $composer.changed(initialPage) || ($changed & 6) == 4) | (($changed & 0x70 ^ 0x30) > 32 && $composer.changed(initialPageOffsetFraction) || ($changed & 0x30) == 32) | (($changed & 0x380 ^ 0x180) > 256 && $composer.changed(pageCount) || ($changed & 0x180) == 256);
        boolean $i$f$cache = false;
        Object it$iv = $this$cache$iv.rememberedValue();
        boolean bl = false;
        if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
            Saver<DefaultPagerState, ?> saver2 = saver;
            Object[] objectArray2 = objectArray;
            boolean bl2 = false;
            Function0 function0 = () -> PagerStateKt.rememberPagerState$lambda$0$0(initialPage, initialPageOffsetFraction, pageCount);
            objectArray = objectArray2;
            saver = saver2;
            Function0 value$iv = function0;
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object = value$iv;
        } else {
            object = it$iv;
        }
        Object object2 = (Function0)object;
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        object2 = RememberSaveableKt.rememberSaveable((Object[])objectArray, saver, (Function0)object2, (Composer)$composer, (int)0);
        DefaultPagerState $this$rememberPagerState_u24lambda_u241 = (DefaultPagerState)object2;
        boolean bl3 = false;
        $this$rememberPagerState_u24lambda_u241.getPageCountState().setValue(pageCount);
        DefaultPagerState defaultPagerState = (DefaultPagerState)object2;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        return defaultPagerState;
    }

    @NotNull
    public static final PagerState PagerState(int currentPage, @FloatRange(from=-0.5, to=0.5) float currentPageOffsetFraction, @NotNull Function0<Integer> pageCount) {
        Intrinsics.checkNotNullParameter(pageCount, (String)"pageCount");
        return new DefaultPagerState(currentPage, currentPageOffsetFraction, pageCount);
    }

    public static /* synthetic */ PagerState PagerState$default(int n, float f, Function0 function0, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        return PagerStateKt.PagerState(n, f, (Function0<Integer>)function0);
    }

    @Nullable
    public static final Object animateToNextPage(@NotNull PagerState $this$animateToNextPage, @NotNull Continuation<? super Unit> $completion) {
        if ($this$animateToNextPage.getCurrentPage() + 1 < $this$animateToNextPage.getPageCount()) {
            Object object = PagerState.animateScrollToPage$default($this$animateToNextPage, $this$animateToNextPage.getCurrentPage() + 1, 0.0f, null, $completion, 6, null);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final Object animateToPreviousPage(@NotNull PagerState $this$animateToPreviousPage, @NotNull Continuation<? super Unit> $completion) {
        if ($this$animateToPreviousPage.getCurrentPage() - 1 >= 0) {
            Object object = PagerState.animateScrollToPage$default($this$animateToPreviousPage, $this$animateToPreviousPage.getCurrentPage() - 1, 0.0f, null, $completion, 6, null);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    public static final float getDefaultPositionThreshold() {
        return DefaultPositionThreshold;
    }

    @NotNull
    public static final PagerMeasureResult getEmptyLayoutInfo() {
        return EmptyLayoutInfo;
    }

    private static final void debugLog(Function0<String> generateMsg) {
        boolean $i$f$debugLog = false;
    }

    public static final long calculateNewMaxScrollOffset(@NotNull PagerLayoutInfo $this$calculateNewMaxScrollOffset, int pageCount) {
        int n;
        long value$iv$iv;
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$calculateNewMaxScrollOffset, (String)"<this>");
        int pageSizeWithSpacing = $this$calculateNewMaxScrollOffset.getPageSpacing() + $this$calculateNewMaxScrollOffset.getPageSize();
        long maxScrollPossible = (long)pageCount * (long)pageSizeWithSpacing + (long)$this$calculateNewMaxScrollOffset.getBeforeContentPadding() + (long)$this$calculateNewMaxScrollOffset.getAfterContentPadding() - (long)$this$calculateNewMaxScrollOffset.getPageSpacing();
        if ($this$calculateNewMaxScrollOffset.getOrientation() == Orientation.Horizontal) {
            l = $this$calculateNewMaxScrollOffset.getViewportSize-YbymL2g();
            boolean bl = false;
            value$iv$iv = l;
            boolean $i$f$unpackInt1 = false;
            n = (int)(value$iv$iv >> 32);
        } else {
            l = $this$calculateNewMaxScrollOffset.getViewportSize-YbymL2g();
            boolean bl = false;
            value$iv$iv = l;
            boolean $i$f$unpackInt2 = false;
            n = (int)(value$iv$iv & 0xFFFFFFFFL);
        }
        int layoutSize = n;
        SnapPosition snapPosition = $this$calculateNewMaxScrollOffset.getSnapPosition();
        int n2 = $this$calculateNewMaxScrollOffset.getPageSize();
        int n3 = pageCount - 1;
        int n4 = $this$calculateNewMaxScrollOffset.getBeforeContentPadding();
        int n5 = $this$calculateNewMaxScrollOffset.getAfterContentPadding();
        int snapPositionDiscount = layoutSize - RangesKt.coerceIn((int)snapPosition.position(layoutSize, n2, n4, n5, n3, pageCount), (int)0, (int)layoutSize);
        boolean $i$f$debugLog = false;
        return RangesKt.coerceAtLeast((long)(maxScrollPossible - (long)snapPositionDiscount), (long)0L);
    }

    private static final long calculateNewMinScrollOffset(PagerMeasureResult $this$calculateNewMinScrollOffset, int pageCount) {
        int n;
        long value$iv$iv;
        long l;
        if ($this$calculateNewMinScrollOffset.getOrientation() == Orientation.Horizontal) {
            l = $this$calculateNewMinScrollOffset.getViewportSize-YbymL2g();
            boolean bl = false;
            value$iv$iv = l;
            boolean $i$f$unpackInt1 = false;
            n = (int)(value$iv$iv >> 32);
        } else {
            l = $this$calculateNewMinScrollOffset.getViewportSize-YbymL2g();
            boolean bl = false;
            value$iv$iv = l;
            boolean $i$f$unpackInt2 = false;
            n = (int)(value$iv$iv & 0xFFFFFFFFL);
        }
        int layoutSize = n;
        SnapPosition snapPosition = $this$calculateNewMinScrollOffset.getSnapPosition();
        int n2 = $this$calculateNewMinScrollOffset.getPageSize();
        int n3 = $this$calculateNewMinScrollOffset.getBeforeContentPadding();
        int n4 = $this$calculateNewMinScrollOffset.getAfterContentPadding();
        return RangesKt.coerceIn((int)snapPosition.position(layoutSize, n2, n3, n4, 0, pageCount), (int)0, (int)layoutSize);
    }

    private static final Object animateScrollToPage(LazyLayoutScrollScope $this$animateScrollToPage, int targetPage, float targetPageOffsetToSnappedPosition, AnimationSpec<Float> animationSpec2, Function2<? super ScrollScope, ? super Integer, Unit> updateTargetPage, Continuation<? super Unit> $completion) {
        boolean $i$f$debugLog;
        updateTargetPage.invoke((Object)$this$animateScrollToPage, (Object)Boxing.boxInt((int)targetPage));
        boolean forward = targetPage > $this$animateScrollToPage.getFirstVisibleItemIndex();
        int visiblePages = $this$animateScrollToPage.getLastVisibleItemIndex() - $this$animateScrollToPage.getFirstVisibleItemIndex() + 1;
        if ((forward && targetPage > $this$animateScrollToPage.getLastVisibleItemIndex() || !forward && targetPage < $this$animateScrollToPage.getFirstVisibleItemIndex()) && Math.abs(targetPage - $this$animateScrollToPage.getFirstVisibleItemIndex()) >= 3) {
            int preJumpPosition = forward ? RangesKt.coerceAtLeast((int)(targetPage - visiblePages), (int)$this$animateScrollToPage.getFirstVisibleItemIndex()) : RangesKt.coerceAtMost((int)(targetPage + visiblePages), (int)$this$animateScrollToPage.getFirstVisibleItemIndex());
            $i$f$debugLog = false;
            $this$animateScrollToPage.snapToItem(preJumpPosition, 0);
        }
        float displacement = (float)LazyLayoutScrollScope.calculateDistanceTo$default($this$animateScrollToPage, targetPage, 0, 2, null) + targetPageOffsetToSnappedPosition;
        $i$f$debugLog = false;
        Ref.FloatRef previousValue = new Ref.FloatRef();
        Object object = SuspendAnimationKt.animate$default(0.0f, displacement, 0.0f, animationSpec2, (arg_0, arg_1) -> PagerStateKt.animateScrollToPage$lambda$2(previousValue, $this$animateScrollToPage, arg_0, arg_1), $completion, 4, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final DefaultPagerState rememberPagerState$lambda$0$0(int $initialPage, float $initialPageOffsetFraction, Function0 $pageCount) {
        return new DefaultPagerState($initialPage, $initialPageOffsetFraction, (Function0<Integer>)$pageCount);
    }

    private static final Unit animateScrollToPage$lambda$2(Ref.FloatRef $previousValue, LazyLayoutScrollScope $this_animateScrollToPage, float currentValue, float f) {
        float delta = currentValue - $previousValue.element;
        float consumed = $this_animateScrollToPage.scrollBy(delta);
        boolean $i$f$debugLog = false;
        $previousValue.element += consumed;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ UnitDensity.1 access$getUnitDensity$p() {
        return UnitDensity;
    }

    public static final /* synthetic */ Object access$animateScrollToPage(LazyLayoutScrollScope $receiver, int targetPage, float targetPageOffsetToSnappedPosition, AnimationSpec animationSpec2, Function2 updateTargetPage, Continuation $completion) {
        return PagerStateKt.animateScrollToPage($receiver, targetPage, targetPageOffsetToSnappedPosition, animationSpec2, (Function2<? super ScrollScope, ? super Integer, Unit>)updateTargetPage, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ long access$calculateNewMinScrollOffset(PagerMeasureResult $receiver, int pageCount) {
        return PagerStateKt.calculateNewMinScrollOffset($receiver, pageCount);
    }

    static {
        int $this$dp$iv = 56;
        boolean $i$f$getDp = false;
        DefaultPositionThreshold = Dp.constructor-impl($this$dp$iv);
        UnitDensity = new Density(){
            private final float density;
            private final float fontScale;
            {
                this.density = 1.0f;
                this.fontScale = 1.0f;
            }

            public float getDensity() {
                return this.density;
            }

            public float getFontScale() {
                return this.fontScale;
            }
        };
        List list = CollectionsKt.emptyList();
        Orientation orientation = Orientation.Horizontal;
        SnapPosition.Start start = SnapPosition.Start.INSTANCE;
        MeasureResult measureResult = new MeasureResult(){
            private final int width;
            private final int height;
            private final Map<AlignmentLine, Integer> alignmentLines;
            {
                this.alignmentLines = MapsKt.emptyMap();
            }

            public int getWidth() {
                return this.width;
            }

            public int getHeight() {
                return this.height;
            }

            public Map<AlignmentLine, Integer> getAlignmentLines() {
                return this.alignmentLines;
            }

            public static /* synthetic */ void getAlignmentLines$annotations() {
            }

            public void placeChildren() {
            }
        };
        CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)EmptyCoroutineContext.INSTANCE));
        UnitDensity.1 var5_7 = UnitDensity;
        long l = ConstraintsKt.Constraints$default(0, 0, 0, 0, 15, null);
        EmptyLayoutInfo = new PagerMeasureResult(list, 0, 0, 0, orientation, 0, 0, false, 0, null, null, 0.0f, 0, false, start, measureResult, false, null, null, coroutineScope, var5_7, l, 393216, null);
    }
}

