/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency.virtualThreads;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.concurrent.Executor;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public final class IntelliJVirtualThreads {
    private static final MethodHandle virtualThreadBuilderConstructor;

    private IntelliJVirtualThreads() {
    }

    private static Thread.Builder getVirtualBuilder() {
        if (virtualThreadBuilderConstructor == null) {
            return Thread.ofVirtual();
        }
        try {
            Executor executor = ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getDefault());
            return virtualThreadBuilderConstructor.invoke(executor);
        }
        catch (Throwable e) {
            return Thread.ofVirtual();
        }
    }

    public static Thread.Builder ofVirtual() {
        return IntelliJVirtualThreads.getVirtualBuilder();
    }

    static {
        MethodHandle handle;
        try {
            Class<?> clazz = Class.forName("java.lang.ThreadBuilders$VirtualThreadBuilder");
            Constructor<?> ctor = clazz.getDeclaredConstructor(Executor.class);
            ctor.setAccessible(true);
            handle = MethodHandles.lookup().unreflectConstructor(ctor);
        }
        catch (Throwable e) {
            handle = null;
        }
        virtualThreadBuilderConstructor = handle;
    }
}

