/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.RuntimeFlagsKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import com.intellij.util.messages.impl.MessageBusImpl;
import com.intellij.util.messages.impl.MessageDeliveryListener;
import com.intellij.util.messages.impl.MessageQueue;
import com.intellij.util.messages.impl.MethodHandleCache;
import com.intellij.util.messages.impl.PluginListenerDescriptor;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a$\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0002\u001aa\u0010\u0010\u001a\u0004\u0018\u00010\f2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00162\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\u0010\u001a\u001a#\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001e\u001a7\u0010\u001f\u001a\u00020\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010 \u001a\u00020!2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\"\u001a&\u0010#\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0(H\u0002\u001a]\u0010)\u001a\u0004\u0018\u00010\f2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00022\u0010\u0010\u0015\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00162\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010-\u001a\u00020\u00062\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u00101\u001a\u001a\u00102\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u00103\u001a\u00020\fH\u0002\u001a/\u00104\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u00062\u0010\u0010\u0015\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00162\u0006\u0010*\u001a\u00020+H\u0002\u00a2\u0006\u0002\u00105\u001a\u0010\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\fH\u0000\" \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"EMPTY_MAP", "Ljava/util/HashMap;", "", "", "Lcom/intellij/util/messages/impl/PluginListenerDescriptor;", "NA", "", "pumpWaiting", "", "jobQueue", "Lcom/intellij/util/messages/impl/MessageQueue;", "deliverMessage", "", "job", "Lcom/intellij/util/messages/impl/Message;", "prevError", "executeOrAddToQueue", "topic", "Lcom/intellij/util/messages/Topic;", "method", "Ljava/lang/reflect/Method;", "args", "", "handlers", "bus", "Lcom/intellij/util/messages/impl/MessageBusImpl;", "(Lcom/intellij/util/messages/Topic;Ljava/lang/reflect/Method;[Ljava/lang/Object;[Ljava/lang/Object;Lcom/intellij/util/messages/impl/MessageQueue;Ljava/lang/Throwable;Lcom/intellij/util/messages/impl/MessageBusImpl;)Ljava/lang/Throwable;", "clearSubscriberCacheOnConnectionTerminated", "", "topicAndHandlerPairs", "([Ljava/lang/Object;Lcom/intellij/util/messages/impl/MessageBusImpl;)Z", "removeDisposedHandlers", "index", "", "([Ljava/lang/Object;ILcom/intellij/util/messages/Topic;Lcom/intellij/util/messages/impl/MessageBusImpl;)V", "deliverImmediately", "", "connection", "Lcom/intellij/util/messages/impl/MessageBusConnectionImpl;", "jobs", "Ljava/util/Deque;", "invokeListener", "methodHandle", "Ljava/lang/invoke/MethodHandle;", "methodName", "handler", "messageDeliveryListeners", "", "Lcom/intellij/util/messages/impl/MessageDeliveryListener;", "(Ljava/lang/invoke/MethodHandle;Ljava/lang/String;[Ljava/lang/Object;Lcom/intellij/util/messages/Topic;Ljava/lang/Object;Ljava/util/Set;Ljava/lang/Throwable;)Ljava/lang/Throwable;", "mergeErrors", "newError", "invokeMethod", "(Ljava/lang/Object;[Ljava/lang/Object;Ljava/lang/invoke/MethodHandle;)V", "throwError", "error", "intellij.platform.core"})
@SourceDebugExtension(value={"SMAP\nMessageBusImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageBusImpl.kt\ncom/intellij/util/messages/impl/MessageBusImplKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,842:1\n1#2:843\n37#3,2:844\n1401#4,2:846\n*S KotlinDebug\n*F\n+ 1 MessageBusImpl.kt\ncom/intellij/util/messages/impl/MessageBusImplKt\n*L\n736#1:844,2\n829#1:846,2\n*E\n"})
public final class MessageBusImplKt {
    @NotNull
    private static final HashMap<String, List<PluginListenerDescriptor>> EMPTY_MAP = new HashMap();
    @NotNull
    private static final Object NA = new Object();

    private static final void pumpWaiting(MessageQueue jobQueue) {
        block4: {
            Throwable error = null;
            Message job = jobQueue.current;
            if (job != null) {
                if (job.bus.isDisposed()) {
                    MessageBusImpl.LOG.error("Accessing disposed message bus " + job.bus + " (job=" + job + ')');
                } else {
                    error = MessageBusImplKt.deliverMessage(job, jobQueue, null);
                }
            }
            while (jobQueue.queue.pollFirst() != null) {
                if (job.bus.isDisposed()) continue;
                error = MessageBusImplKt.deliverMessage(job, jobQueue, error);
            }
            Throwable throwable = error;
            if (throwable == null) break block4;
            Throwable p0 = throwable;
            boolean bl = false;
            MessageBusImplKt.throwError(p0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Throwable deliverMessage(Message job, MessageQueue jobQueue, Throwable prevError) {
        AutoCloseable autoCloseable = (AutoCloseable)ClientId.Companion.withExplicitClientId(job.clientId);
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            jobQueue.current = job;
            Object[] handlers2 = job.handlers;
            Throwable error = prevError;
            int index = job.currentHandlerIndex;
            int size = handlers2.length;
            int lastIndex = size - 1;
            while (index < size) {
                if (index == lastIndex) {
                    jobQueue.current = null;
                }
                int n = job.currentHandlerIndex;
                job.currentHandlerIndex = n + 1;
                Object handler = handlers2[index];
                if (handler != null) {
                    error = MessageBusImplKt.invokeListener(job.method, job.methodName, job.args, job.topic, handler, job.bus.messageDeliveryListeners, error);
                }
                if (++index == job.currentHandlerIndex) continue;
                Throwable throwable2 = error;
                return throwable2;
            }
            Throwable throwable3 = error;
            return throwable3;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Nullable
    public static final Throwable executeOrAddToQueue(@NotNull Topic<?> topic, @NotNull Method method, @Nullable Object[] args, @NotNull Object[] handlers2, @Nullable MessageQueue jobQueue, @Nullable Throwable prevError, @NotNull MessageBusImpl bus) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)handlers2, (String)"handlers");
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        MethodHandle methodHandle = MethodHandleCache.compute(method, args);
        Intrinsics.checkNotNullExpressionValue((Object)methodHandle, (String)"compute(...)");
        MethodHandle methodHandle2 = methodHandle;
        if (jobQueue == null) {
            Throwable error = prevError;
            for (Object handler : handlers2) {
                String string = method.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                Object object = handler;
                if (object == null) continue;
                error = MessageBusImplKt.invokeListener(methodHandle2, string, args, topic, object, bus.messageDeliveryListeners, error);
            }
            return error;
        }
        ArrayDeque<Message> arrayDeque = jobQueue.queue;
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        arrayDeque.offerLast(new Message(topic, methodHandle2, string, args, handlers2, bus));
        return prevError;
    }

    private static final boolean clearSubscriberCacheOnConnectionTerminated(Object[] topicAndHandlerPairs, MessageBusImpl bus) {
        boolean isChildClearingNeeded = false;
        int i = 0;
        while (i < topicAndHandlerPairs.length) {
            Topic.BroadcastDirection direction;
            Object object = topicAndHandlerPairs[i];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.util.messages.Topic<*>");
            Topic topic = (Topic)object;
            MessageBusImplKt.removeDisposedHandlers(topicAndHandlerPairs, i, topic, bus);
            Intrinsics.checkNotNullExpressionValue((Object)topic.getBroadcastDirection(), (String)"getBroadcastDirection(...)");
            if (direction != Topic.BroadcastDirection.TO_CHILDREN) {
                i += 2;
                continue;
            }
            MessageBusImpl parentBus = bus;
            while (true) {
                CompositeMessageBus compositeMessageBus = parentBus.parentBus;
                if (compositeMessageBus == null) {
                    break;
                }
                parentBus = compositeMessageBus;
                MessageBusImplKt.removeDisposedHandlers(topicAndHandlerPairs, i, topic, parentBus);
            }
            if (bus.hasChildren$intellij_platform_core()) {
                isChildClearingNeeded = true;
            }
            i += 2;
        }
        return isChildClearingNeeded;
    }

    private static final void removeDisposedHandlers(Object[] topicAndHandlerPairs, int index, Topic<?> topic, MessageBusImpl bus) {
        Object[] objectArray = (Object[])bus.subscriberCache.remove(topic);
        if (objectArray == null) {
            return;
        }
        Object[] cachedHandlers = objectArray;
        Object handler = topicAndHandlerPairs[index + 1];
        if (topic.isImmediateDelivery()) {
            int length = cachedHandlers.length;
            for (int i = 0; i < length; ++i) {
                if (cachedHandlers[i] != handler) continue;
                cachedHandlers[i] = null;
            }
        }
        bus.rootBus.removeDisposedHandlers(topic, handler);
    }

    private static final List<Message> deliverImmediately(MessageBusConnectionImpl connection, Deque<Message> jobs) {
        List newJobs = null;
        Iterator<Message> iterator = jobs.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Message> jobIterator = iterator;
        while (jobIterator.hasNext()) {
            Message job = jobIterator.next();
            List handlers2 = null;
            Object[] allHandlers = job.handlers;
            int length = allHandlers.length;
            for (int i = 0; i < length; ++i) {
                Object handler = allHandlers[i];
                if (handler == null || connection.bus != job.bus || !connection.isMyHandler(job.topic, handler)) continue;
                allHandlers[i] = null;
                if (handlers2 == null) {
                    handlers2 = new ArrayList();
                }
                handlers2.add(handler);
            }
            if (handlers2 == null) continue;
            if (allHandlers.length == handlers2.size()) {
                jobIterator.remove();
            }
            Collection $this$toTypedArray$iv = handlers2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Message filteredJob = new Message(job.topic, job.method, job.methodName, job.args, thisCollection$iv.toArray(new Object[0]), job.bus);
            if (newJobs == null) {
                newJobs = new ArrayList();
            }
            newJobs.add(filteredJob);
        }
        return newJobs;
    }

    private static final Throwable invokeListener(MethodHandle methodHandle, String methodName, Object[] args, Topic<?> topic, Object handler, Set<? extends MessageDeliveryListener> messageDeliveryListeners, Throwable prevError) {
        try {
            if (handler instanceof MessageHandler) {
                MessageHandler messageHandler = (MessageHandler)handler;
                Object[] objectArray = args;
                if (args == null) {
                    objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
                }
                Object[] objectArray2 = objectArray;
                messageHandler.handle(methodHandle, Arrays.copyOf(objectArray2, objectArray2.length));
            } else if (messageDeliveryListeners.isEmpty()) {
                MessageBusImplKt.invokeMethod(handler, args, methodHandle);
            } else {
                long startTime = System.nanoTime();
                MessageBusImplKt.invokeMethod(handler, args, methodHandle);
                for (MessageDeliveryListener messageDeliveryListener : messageDeliveryListeners) {
                    messageDeliveryListener.messageDelivered(topic, methodName, handler, System.nanoTime() - startTime);
                }
            }
            return prevError;
        }
        catch (AbstractMethodError abstractMethodError) {
            return prevError;
        }
        catch (CancellationException e) {
            if (RuntimeFlagsKt.isMessageBusErrorPropagationEnabled()) {
                return MessageBusImplKt.mergeErrors(prevError, e);
            }
            return prevError;
        }
        catch (Throwable e) {
            Throwable detailedError;
            Throwable throwable = detailedError = e instanceof AssertionError ? e : (Throwable)new RuntimeException("Cannot invoke (class=" + handler.getClass().getSimpleName() + ", method=" + methodName + ", topic=" + topic.getDisplayName() + ')', e);
            if (RuntimeFlagsKt.isMessageBusErrorPropagationEnabled()) {
                return MessageBusImplKt.mergeErrors(prevError, detailedError);
            }
            MessageBusImpl.LOG.error(e);
            return prevError;
        }
    }

    private static final Throwable mergeErrors(Throwable prevError, Throwable newError) {
        if (prevError == null) {
            return newError;
        }
        ExceptionsKt.addSuppressed((Throwable)prevError, (Throwable)newError);
        return prevError;
    }

    private static final void invokeMethod(Object handler, Object[] args, MethodHandle methodHandle) {
        if (args == null) {
            methodHandle.invoke(handler);
        } else {
            methodHandle.bindTo(handler).invokeExact(args);
        }
    }

    public static final void throwError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        MessageBusImpl.LOG.assertTrue(RuntimeFlagsKt.isMessageBusErrorPropagationEnabled());
        Throwable[] suppressed = error.getSuppressed();
        if (suppressed.length > 1) {
            Throwable throwable;
            block3: {
                Throwable throwable2;
                Intrinsics.checkNotNull((Object)suppressed);
                Throwable[] $this$firstOrNull$iv = suppressed;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    Throwable element$iv;
                    Throwable it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!(it instanceof ProcessCanceledException || it instanceof CancellationException)) continue;
                    throwable2 = element$iv;
                    break block3;
                }
                throwable2 = throwable = null;
            }
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                throw it;
            }
        }
        throw error;
    }

    public static final /* synthetic */ HashMap access$getEMPTY_MAP$p() {
        return EMPTY_MAP;
    }

    public static final /* synthetic */ boolean access$clearSubscriberCacheOnConnectionTerminated(Object[] topicAndHandlerPairs, MessageBusImpl bus) {
        return MessageBusImplKt.clearSubscriberCacheOnConnectionTerminated(topicAndHandlerPairs, bus);
    }

    public static final /* synthetic */ List access$deliverImmediately(MessageBusConnectionImpl connection, Deque jobs) {
        return MessageBusImplKt.deliverImmediately(connection, jobs);
    }

    public static final /* synthetic */ Throwable access$deliverMessage(Message job, MessageQueue jobQueue, Throwable prevError) {
        return MessageBusImplKt.deliverMessage(job, jobQueue, prevError);
    }

    public static final /* synthetic */ Object access$getNA$p() {
        return NA;
    }

    public static final /* synthetic */ void access$pumpWaiting(MessageQueue jobQueue) {
        MessageBusImplKt.pumpWaiting(jobQueue);
    }
}

