/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.configuration;

import com.jetbrains.fus.reporting.FusHttpClient;
import com.jetbrains.fus.reporting.HttpResponse;
import com.jetbrains.fus.reporting.configuration.RequestResult;
import com.jetbrains.fus.reporting.configuration.ResponseProcessor;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u000b0\n\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/fus/reporting/configuration/HttpClientProcessor;", "", "()V", "CAN_RETRY_CODES", "", "", "MAX_RETRIES", "RETRY_INTERVAL", "SUCCESS_CODE", "send", "Lcom/jetbrains/fus/reporting/configuration/RequestResult;", "T", "httpClient", "Lcom/jetbrains/fus/reporting/FusHttpClient;", "url", "", "processor", "Lcom/jetbrains/fus/reporting/configuration/ResponseProcessor;", "trySend", "Lcom/jetbrains/fus/reporting/HttpResponse;", "configuration"})
public final class HttpClientProcessor {
    @NotNull
    public static final HttpClientProcessor INSTANCE = new HttpClientProcessor();
    private static final int SUCCESS_CODE = 200;
    @NotNull
    private static final List<Integer> CAN_RETRY_CODES;
    private static final int MAX_RETRIES = 10;
    private static final int RETRY_INTERVAL = 500;

    private HttpClientProcessor() {
    }

    @NotNull
    public final <T> RequestResult<T> send(@NotNull FusHttpClient httpClient, @NotNull String url, @NotNull ResponseProcessor<T> processor2) throws IOException, InterruptedException, SecurityException {
        Integer code;
        HttpResponse response;
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        HttpResponse httpResponse = response = this.trySend(httpClient, url);
        Integer n = code = httpResponse != null ? Integer.valueOf(httpResponse.getStatusCode()) : null;
        int n2 = 200;
        if (n != null && n == n2) {
            T result = processor2.onSucceed(response);
            return RequestResult.Companion.succeed(result);
        }
        return RequestResult.Companion.error(code);
    }

    private final HttpResponse trySend(FusHttpClient httpClient, String url) throws IOException, InterruptedException, SecurityException {
        int retryCounter = 0;
        while (retryCounter < 10) {
            HttpResponse httpResponse;
            try {
                httpResponse = httpClient.get(url);
            }
            catch (Exception exception) {
                httpResponse = null;
            }
            HttpResponse response = httpResponse;
            if ((response == null || CAN_RETRY_CODES.contains(response.getStatusCode())) && ++retryCounter != 9) {
                Thread.sleep(500L);
                continue;
            }
            return response;
        }
        return null;
    }

    static {
        Object[] objectArray = new Integer[]{408, 429, 500, 502, 503, 504, 598};
        CAN_RETRY_CODES = CollectionsKt.mutableListOf((Object[])objectArray);
    }
}

