/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.fixes;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/fixes/RemoveElementWithoutFormatterFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "familyName", "", "<init>", "(Ljava/lang/String;)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.groovy.psi"})
public final class RemoveElementWithoutFormatterFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final String familyName;

    public RemoveElementWithoutFormatterFix(@IntentionFamilyName @NotNull String familyName) {
        Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
        this.familyName = familyName;
    }

    @NotNull
    public String getFamilyName() {
        return this.familyName;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        TextRange textRange = element.getTextRange();
        element.getContainingFile().getViewProvider().getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
    }
}

