/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.repo.GitRepository;
import icons.DvcsImplIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class GitResolveConflictsAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            GitResolveConflictsAction.$$$reportNull$$$0(0);
        }
        Project project = Objects.requireNonNull(event.getProject());
        GitVcs vcs = GitVcs.getInstance(project);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        TreeSet<VirtualFile> conflictedFiles = new TreeSet<VirtualFile>(Comparator.comparing(VirtualFile::getPresentableUrl));
        for (Change change : ChangeListManager.getInstance((Project)project).getAllChanges()) {
            VirtualFile file;
            if (change.getFileStatus() != FileStatus.MERGED_WITH_CONFLICTS) continue;
            ContentRevision before = change.getBeforeRevision();
            ContentRevision after = change.getAfterRevision();
            if (before != null && (file = before.getFile().getVirtualFile()) != null && vcs.equals(vcsManager.getVcsFor(file))) {
                conflictedFiles.add(file);
            }
            if (after == null || (file = after.getFile().getVirtualFile()) == null || !vcs.equals(vcsManager.getVcsFor(file))) continue;
            conflictedFiles.add(file);
        }
        AbstractVcsHelper.getInstance((Project)project).showMergeDialog(new ArrayList<VirtualFile>(conflictedFiles), vcs.getMergeProvider());
    }

    static boolean isEnabled(@NotNull Project project) {
        if (project == null) {
            GitResolveConflictsAction.$$$reportNull$$$0(1);
        }
        GitVcs gitVcs = GitVcs.getInstance(project);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        if (!vcsManager.checkVcsIsActive((AbstractVcs)gitVcs)) {
            return false;
        }
        Collection changes = ChangeListManager.getInstance((Project)project).getAllChanges();
        return ContainerUtil.exists((Iterable)changes, it -> it.getFileStatus() == FileStatus.MERGED_WITH_CONFLICTS && gitVcs.equals(ChangesUtil.getVcsForChange((Change)it, (Project)project)));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GitResolveConflictsAction.$$$reportNull$$$0(2);
        }
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDisposed()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setEnabledAndVisible(GitResolveConflictsAction.isEnabled(project));
        if (presentation.isVisible() && e.getPlace().equals("GitMergeRebaseWidgetPlace")) {
            presentation.setIcon(DvcsImplIcons.ResolveContinue);
            Collection<GitRepository> rebasingRepositories = GitUtil.getRepositoriesInStates(project, Repository.State.REBASING);
            if (!rebasingRepositories.isEmpty()) {
                presentation.setEnabledAndVisible(false);
            }
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GitResolveConflictsAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitResolveConflictsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitResolveConflictsAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

