/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.Ksuid;
import git4idea.DialogManager;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandOutputPrinter;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitHandlerRebaseEditorManager;
import git4idea.rebase.GitSimpleEditorHandler;
import git4idea.rebase.GitUnstructuredEditor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitImplBase
implements Git {
    private static final Logger LOG = Logger.getInstance(GitImplBase.class);
    private static final Pattern PROGRESS_PATTERN = Pattern.compile(".*:\\s*\\d{1,3}% \\(\\d+/\\d+\\).*");
    @NonNls
    private static final String REMOTE_PROGRESS_PREFIX = "remote: ";
    @NonNls
    private static final String[] SUPPRESSED_PROGRESS_INDICATORS = new String[]{"Counting objects: ", "Enumerating objects: ", "Compressing objects: ", "Writing objects: ", "Receiving objects: ", "Resolving deltas: ", "Finding sources: ", "Updating files: ", "Checking out files: ", "Expanding reachable commits in commit graph: ", "Delta compression using up to "};
    @NonNls
    public static final String[] ERROR_INDICATORS = new String[]{"warning:", "error:", "fatal:", "remote: error", "Cannot", "Could not", "Interactive rebase already started", "refusing to pull", "cannot rebase:", "conflict", "unable", "The file will have its original", "runnerw:"};

    @Override
    @NotNull
    public GitCommandResult runCommand(@NotNull GitLineHandler handler) {
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(0);
        }
        return GitImplBase.run(handler, GitImplBase.getCollectingCollector());
    }

    @Override
    @NotNull
    public GitCommandResult runCommand(@NotNull Computable<? extends GitLineHandler> handlerConstructor) {
        if (handlerConstructor == null) {
            GitImplBase.$$$reportNull$$$0(1);
        }
        return GitImplBase.run(handlerConstructor, (Computable<? extends OutputCollector>)((Computable)GitImplBase::getCollectingCollector));
    }

    @NotNull
    private static OutputCollector getCollectingCollector() {
        return new OutputCollector(){

            @Override
            public void outputLineReceived(@NotNull String line) {
                if (line == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.addOutputLine(line);
            }

            @Override
            public void errorLineReceived(@NotNull String line) {
                if (line == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (Registry.is((String)"git.allow.stderr.to.stdout.mixing") && !GitImplBase.looksLikeError(line)) {
                    this.addOutputLine(line);
                } else {
                    this.addErrorLine(line);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "line";
                objectArray2[1] = "git4idea/commands/GitImplBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "outputLineReceived";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorLineReceived";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    @NotNull
    public GitCommandResult runCommandWithoutCollectingOutput(@NotNull GitLineHandler handler) {
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(2);
        }
        return GitImplBase.run(handler, new OutputCollector(this){

            @Override
            protected void outputLineReceived(@NotNull String line) {
                if (line == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            @Override
            protected void errorLineReceived(@NotNull String line) {
                if (line == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.addErrorLine(line);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "line";
                objectArray2[1] = "git4idea/commands/GitImplBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "outputLineReceived";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorLineReceived";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private static GitCommandResult run(@NotNull Computable<? extends GitLineHandler> handlerConstructor, @NotNull Computable<? extends OutputCollector> outputCollectorConstructor) {
        GitCommandResult result2;
        if (handlerConstructor == null) {
            GitImplBase.$$$reportNull$$$0(3);
        }
        if (outputCollectorConstructor == null) {
            GitImplBase.$$$reportNull$$$0(4);
        }
        int authAttempt = 0;
        do {
            GitLineHandler handler = (GitLineHandler)handlerConstructor.compute();
            OutputCollector outputCollector = (OutputCollector)outputCollectorConstructor.compute();
            boolean isCredHelperUsed = GitVcsApplicationSettings.getInstance().isUseCredentialHelper();
            result2 = GitImplBase.run(handler, outputCollector);
            if (isCredHelperUsed != GitVcsApplicationSettings.getInstance().isUseCredentialHelper()) continue;
            ++authAttempt;
        } while (result2.isAuthenticationFailed() && authAttempt < 2);
        GitCommandResult gitCommandResult = result2;
        if (gitCommandResult == null) {
            GitImplBase.$$$reportNull$$$0(5);
        }
        return gitCommandResult;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private static GitCommandResult run(@NotNull GitLineHandler handler, @NotNull OutputCollector outputCollector) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 16[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private static GitHandlerRebaseEditorManager prepareGeneralPurposeEditor(@NotNull Project project, @NotNull GitLineHandler handler) {
        if (project == null) {
            GitImplBase.$$$reportNull$$$0(11);
        }
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(12);
        }
        GitHandlerRebaseEditorManager gitHandlerRebaseEditorManager = GitHandlerRebaseEditorManager.prepareEditor(handler, new GitSimpleEditorHandler(project));
        if (gitHandlerRebaseEditorManager == null) {
            GitImplBase.$$$reportNull$$$0(13);
        }
        return gitHandlerRebaseEditorManager;
    }

    @NotNull
    private static GitCommandResult doRun(@NotNull GitLineHandler handler, @NotNull GitVersion version, @NotNull OutputCollector outputCollector) {
        boolean canSuppressOptionalLocks;
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(14);
        }
        if (version == null) {
            GitImplBase.$$$reportNull$$$0(15);
        }
        if (outputCollector == null) {
            GitImplBase.$$$reportNull$$$0(16);
        }
        GitImplBase.getGitTraceEnvironmentVariables(version).forEach(handler::addCustomEnvironmentVariable);
        boolean bl = canSuppressOptionalLocks = Registry.is((String)"git.use.no.optional.locks") && GitVersionSpecialty.ENV_GIT_OPTIONAL_LOCKS_ALLOWED.existsIn(version);
        if (canSuppressOptionalLocks) {
            handler.addCustomEnvironmentVariable("GIT_OPTIONAL_LOCKS", "0");
        }
        GitCommandResultListener resultListener = new GitCommandResultListener(outputCollector);
        handler.addLineListener(resultListener);
        try (AccessToken ignored = GitImplBase.lock(handler, canSuppressOptionalLocks);){
            GitImplBase.writeOutputToConsole(handler);
            handler.runInCurrentThread();
        }
        catch (IOException e) {
            GitCommandResult gitCommandResult = GitCommandResult.error(GitBundle.message("git.error.cant.process.output", e.getLocalizedMessage()));
            if (gitCommandResult == null) {
                GitImplBase.$$$reportNull$$$0(17);
            }
            return gitCommandResult;
        }
        String rootName = GitImplBase.getPresentableRootName(handler);
        return new GitCommandResult(resultListener.myStartFailed, resultListener.myExitCode, outputCollector.myErrorOutput, outputCollector.myOutput, rootName);
    }

    @Nullable
    @Nls
    private static String getPresentableRootName(@NotNull GitLineHandler handler) {
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(18);
        }
        if (GitHandler.shouldSuppressReadLocks()) {
            return null;
        }
        if (handler.getCommand().equals(GitCommand.VERSION)) {
            return null;
        }
        VirtualFile root = handler.getExecutableContext().getRoot();
        if (root == null) {
            return null;
        }
        Project project = handler.project();
        if (project == null) {
            return root.getName();
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        VirtualFile vcsRoot = vcsManager.getVcsRootFor(root);
        if (root.equals(vcsRoot)) {
            if (vcsManager.getRootsUnderVcs((AbstractVcs)GitVcs.getInstance(project)).length == 1) {
                return null;
            }
            return ProjectLevelVcsManager.getInstance((Project)project).getShortNameForVcsRoot(root);
        }
        return root.getName();
    }

    @NotNull
    private static Map<String, String> getGitTraceEnvironmentVariables(@NotNull GitVersion version) {
        if (version == null) {
            GitImplBase.$$$reportNull$$$0(19);
        }
        HashMap<@NonNls String, @NonNls String> environment = new HashMap<String, String>(5);
        int logLevel = Registry.intValue((String)"git.execution.trace");
        if (logLevel == 0) {
            environment.put("GIT_TRACE", "0");
            if (GitVersionSpecialty.ENV_GIT_TRACE_PACK_ACCESS_ALLOWED.existsIn(version)) {
                environment.put("GIT_TRACE_PACK_ACCESS", "");
            }
            environment.put("GIT_TRACE_PACKET", "");
            environment.put("GIT_TRACE_PERFORMANCE", "0");
            environment.put("GIT_TRACE_SETUP", "0");
        } else {
            String logFile = PathManager.getLogPath() + "/gittrace.log";
            if ((logLevel & 1) == 1) {
                environment.put("GIT_TRACE", logFile);
            }
            if ((logLevel & 2) == 2) {
                environment.put("GIT_TRACE_PACK_ACCESS", logFile);
            }
            if ((logLevel & 4) == 4) {
                environment.put("GIT_TRACE_PACKET", logFile);
            }
            if ((logLevel & 8) == 8) {
                environment.put("GIT_TRACE_PERFORMANCE", logFile);
            }
            if ((logLevel & 0x10) == 16) {
                environment.put("GIT_TRACE_SETUP", logFile);
            }
        }
        HashMap<String, String> hashMap = environment;
        if (hashMap == null) {
            GitImplBase.$$$reportNull$$$0(20);
        }
        return hashMap;
    }

    @RequiresBackgroundThread
    public static boolean loadFileAndShowInSimpleEditor(@NotNull Project project, @Nullable VirtualFile root, @NotNull File file, @NlsContexts.DialogTitle @NotNull String dialogTitle, @NlsContexts.Button @NotNull String okButtonText) throws IOException {
        if (project == null) {
            GitImplBase.$$$reportNull$$$0(21);
        }
        if (file == null) {
            GitImplBase.$$$reportNull$$$0(22);
        }
        if (dialogTitle == null) {
            GitImplBase.$$$reportNull$$$0(23);
        }
        if (okButtonText == null) {
            GitImplBase.$$$reportNull$$$0(24);
        }
        ThreadingAssertions.assertBackgroundThread();
        Charset encoding = root == null ? StandardCharsets.UTF_8 : GitConfigUtil.getCommitEncodingCharset(project, root);
        String initialText = StringUtil.trimLeading((String)GitImplBase.ignoreComments(FileUtil.loadFile((File)file, (Charset)encoding)));
        String newText = GitImplBase.showUnstructuredEditorAndWait(project, root, initialText, dialogTitle, okButtonText);
        if (newText == null) {
            return false;
        }
        FileUtil.writeToFile((File)file, (byte[])newText.getBytes(encoding));
        return true;
    }

    @Nullable
    private static String showUnstructuredEditorAndWait(@NotNull Project project, @Nullable VirtualFile root, @NotNull @NlsSafe String initialText, @NlsContexts.DialogTitle @NotNull String dialogTitle, @NlsContexts.Button @NotNull String okButtonText) {
        if (project == null) {
            GitImplBase.$$$reportNull$$$0(25);
        }
        if (initialText == null) {
            GitImplBase.$$$reportNull$$$0(26);
        }
        if (dialogTitle == null) {
            GitImplBase.$$$reportNull$$$0(27);
        }
        if (okButtonText == null) {
            GitImplBase.$$$reportNull$$$0(28);
        }
        Ref newText = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            GitUnstructuredEditor editor = new GitUnstructuredEditor(project, root, initialText, dialogTitle, okButtonText);
            DialogManager.show(editor);
            if (editor.isOK()) {
                newText.set((Object)editor.getText());
            }
        });
        return (String)newText.get();
    }

    @NotNull
    private static String ignoreComments(@NotNull String text2) {
        if (text2 == null) {
            GitImplBase.$$$reportNull$$$0(29);
        }
        Object[] lines = StringUtil.splitByLinesKeepSeparators((String)text2);
        String string = ((StreamEx)StreamEx.of((Object[])lines).filter(line -> !line.startsWith("\u0001"))).joining();
        if (string == null) {
            GitImplBase.$$$reportNull$$$0(30);
        }
        return string;
    }

    private static void writeOutputToConsole(@NotNull GitLineHandler handler) {
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(31);
        }
        if (handler.isSilent()) {
            return;
        }
        Project project = handler.project();
        if (project != null && !project.isDefault()) {
            handler.addLineListener(new GitCommandOutputLogger(project, handler));
        }
    }

    @NotNull
    private static AccessToken lock(@NotNull GitLineHandler handler, boolean canSuppressOptionalLocks) {
        if (handler == null) {
            GitImplBase.$$$reportNull$$$0(32);
        }
        Project project = handler.project();
        GitCommand.LockingPolicy lockingPolicy = handler.getCommand().lockingPolicy();
        if (project == null || project.isDefault() || lockingPolicy == GitCommand.LockingPolicy.READ) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                GitImplBase.$$$reportNull$$$0(33);
            }
            return accessToken;
        }
        ReadWriteLock executionLock = GitVcs.getInstance(project).getCommandLock();
        final Lock lock = lockingPolicy == GitCommand.LockingPolicy.READ_OPTIONAL_LOCKING && canSuppressOptionalLocks ? executionLock.readLock() : executionLock.writeLock();
        ProgressIndicatorUtils.awaitWithCheckCanceled((Lock)lock);
        return new AccessToken(){

            public void finish() {
                lock.unlock();
            }
        };
    }

    public static boolean looksLikeProgress(@NotNull String line) {
        if (line == null) {
            GitImplBase.$$$reportNull$$$0(34);
        }
        if (PROGRESS_PATTERN.matcher(line).matches()) {
            return true;
        }
        return ContainerUtil.exists((Object[])SUPPRESSED_PROGRESS_INDICATORS, prefix -> {
            if (StringUtil.startsWith((CharSequence)line, (CharSequence)prefix)) {
                return true;
            }
            if (StringUtil.startsWith((CharSequence)line, (CharSequence)REMOTE_PROGRESS_PREFIX)) {
                return StringUtil.startsWith((CharSequence)line, (int)REMOTE_PROGRESS_PREFIX.length(), (CharSequence)prefix);
            }
            return false;
        });
    }

    private static boolean looksLikeError(@NotNull @NonNls String text2) {
        if (text2 == null) {
            GitImplBase.$$$reportNull$$$0(35);
        }
        return ContainerUtil.exists((Object[])ERROR_INDICATORS, indicator -> StringUtil.startsWithIgnoreCase((String)text2.trim(), (String)indicator));
    }

    @NotNull
    static String stringifyWorkingDir(@Nullable String basePath, @Nullable Path workingDir) {
        if (basePath != null) {
            Path path = Path.of(basePath, new String[0]);
            if (workingDir != null) {
                path = path.resolve(workingDir);
            }
            String string = path.toString();
            if (string == null) {
                GitImplBase.$$$reportNull$$$0(36);
            }
            return string;
        }
        if (workingDir != null) {
            String string = workingDir.toString();
            if (string == null) {
                GitImplBase.$$$reportNull$$$0(37);
            }
            return string;
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 9, 10, 13, 17, 20, 30, 33, 36, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerConstructor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputCollectorConstructor";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 30: 
            case 33: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitImplBase";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputCollector";
                break;
            }
            case 11: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitle";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okButtonText";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialText";
                break;
            }
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitImplBase";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "run";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareGeneralPurposeEditor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getGitTraceEnvironmentVariables";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "ignoreComments";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "lock";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyWorkingDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runCommand";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runCommandWithoutCollectingOutput";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 30: 
            case 33: 
            case 36: 
            case 37: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareGeneralPurposeEditor";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableRootName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getGitTraceEnvironmentVariables";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "loadFileAndShowInSimpleEditor";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "showUnstructuredEditorAndWait";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "ignoreComments";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "writeOutputToConsole";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lock";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "looksLikeProgress";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "looksLikeError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 9, 10, 13, 17, 20, 30, 33, 36, 37 -> new IllegalStateException(string);
        };
    }

    private static abstract class OutputCollector {
        final List<String> myOutput = new ArrayList<String>();
        final List<String> myErrorOutput = new ArrayList<String>();

        private OutputCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addOutputLine(@NotNull String line) {
            if (line == null) {
                OutputCollector.$$$reportNull$$$0(0);
            }
            List<String> list = this.myOutput;
            synchronized (list) {
                this.myOutput.add(line);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void addErrorLine(@NotNull String line) {
            if (line == null) {
                OutputCollector.$$$reportNull$$$0(1);
            }
            List<String> list = this.myErrorOutput;
            synchronized (list) {
                this.myErrorOutput.add(line);
            }
        }

        abstract void outputLineReceived(@NotNull String var1);

        abstract void errorLineReceived(@NotNull String var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "line";
            objectArray2[1] = "git4idea/commands/GitImplBase$OutputCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addOutputLine";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addErrorLine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GitCommandResultListener
    implements GitLineHandlerListener {
        private final OutputCollector myOutputCollector;
        private int myExitCode = 0;
        private boolean myStartFailed = false;

        GitCommandResultListener(OutputCollector outputCollector) {
            this.myOutputCollector = outputCollector;
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (outputType == ProcessOutputTypes.STDOUT) {
                this.myOutputCollector.outputLineReceived(line);
            } else if (outputType == ProcessOutputTypes.STDERR && !GitImplBase.looksLikeProgress(line)) {
                this.myOutputCollector.errorLineReceived(line);
            }
        }

        public void processTerminated(int code) {
            this.myExitCode = code;
        }

        public void startFailed(@NotNull Throwable t) {
            if (t == null) {
                GitCommandResultListener.$$$reportNull$$$0(0);
            }
            this.myStartFailed = true;
            this.myOutputCollector.errorLineReceived(GitBundle.message("git.executable.unknown.error.message", t.getLocalizedMessage()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "git4idea/commands/GitImplBase$GitCommandResultListener", "startFailed"));
        }
    }

    private static class GitCommandOutputLogger
    implements GitLineHandlerListener {
        @NotNull
        private final GitHandler myHandler;
        private final String processId;
        private final Path myWorkingDir;
        private final GitCommandOutputPrinter myOutputPrinter;

        GitCommandOutputLogger(@NotNull Project project, @NotNull GitLineHandler handler) {
            if (project == null) {
                GitCommandOutputLogger.$$$reportNull$$$0(0);
            }
            if (handler == null) {
                GitCommandOutputLogger.$$$reportNull$$$0(1);
            }
            this.processId = Ksuid.generate();
            this.myHandler = handler;
            this.myWorkingDir = this.myHandler.getWorkingDirectory();
            this.myOutputPrinter = GitCommandOutputPrinter.getInstance(project);
        }

        public void processStarted() {
            this.myOutputPrinter.showCommandStart(this.processId, this.myWorkingDir, this.myHandler.printableCommandLine());
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            try {
                if (StringUtil.isEmptyOrSpaces((String)line)) {
                    return;
                }
                if (outputType == ProcessOutputTypes.SYSTEM) {
                    return;
                }
                if (outputType == ProcessOutputTypes.STDOUT && this.myHandler.isStdoutSuppressed()) {
                    return;
                }
                if (outputType == ProcessOutputTypes.STDERR && this.myHandler.isStderrSuppressed()) {
                    return;
                }
                this.myOutputPrinter.showCommandOutput(this.processId, this.myWorkingDir, outputType, line);
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Exception e) {
                throw new RuntimeException("Logging error for " + String.valueOf(this.myHandler), e);
            }
        }

        public void processTerminated(int exitCode) {
            this.myOutputPrinter.showCommandFinished(this.processId, this.myWorkingDir, exitCode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "handler";
                    break;
                }
            }
            objectArray[1] = "git4idea/commands/GitImplBase$GitCommandOutputLogger";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

